/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audio;

import com.sun.j3d.audio.AudioContainerInputStream;
import com.sun.j3d.audio.AudioMidiInputStream;
import com.sun.j3d.audio.AudioRmfInputStream;
import com.sun.j3d.audio.ContinuousAudioDataStream;
import com.sun.j3d.audio.HaeAudioStream;
import com.sun.j3d.audio.HaeDevice;
import com.sun.j3d.audio.HaeException;
import com.sun.j3d.audio.HaeMidiSong;
import com.sun.j3d.audio.HaeMixer;
import com.sun.j3d.audio.HaeNoise;
import com.sun.j3d.audio.HaeRmfSong;
import com.sun.j3d.audio.InvalidAudioFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class AudioDevice {
    private boolean DEBUG = false;
    private Hashtable clipStreams = new Hashtable();
    private boolean playing = false;
    private HaeMixer mixer = null;
    private int rate = 44;
    private int interpMode = 1;
    private int renderFlags = 3;
    public static final AudioDevice device = new AudioDevice();

    private AudioDevice() {
    }

    public synchronized void close() {
        if (this.DEBUG) {
            System.err.println("Closing device.");
        }
        if (this.playing) {
            this.mixer.disengageAudio();
        }
        this.playing = false;
        this.notify();
    }

    public synchronized void closeChannel(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        HaeNoise haeNoise = (HaeNoise)this.clipStreams.remove(inputStream);
        if (haeNoise != null) {
            if (this.DEBUG) {
                System.out.println("AudioDevice.closeChannel(): retrieved and closing stream:\n\t" + inputStream);
            }
            haeNoise.close();
        } else if (this.DEBUG) {
            System.out.println("AudioDevice.closeChannel(): could not retrieve stream(" + inputStream + ")");
        }
        this.notify();
    }

    public synchronized void closeStreams() {
        if (this.DEBUG) {
            System.err.println("AudioDevice: Closing all streams.");
        }
        Enumeration enumeration = this.clipStreams.elements();
        Enumeration enumeration2 = this.clipStreams.keys();
        while (enumeration.hasMoreElements()) {
            ((HaeNoise)enumeration.nextElement()).close();
        }
        if (this.DEBUG) {
            System.err.println("Audio Device: Streams all closed.");
        }
        this.clipStreams = new Hashtable();
    }

    public synchronized void open() {
        if (this.DEBUG) {
            System.out.println("AudioDevice.open(), playing = " + this.playing);
        }
        try {
            if (this.mixer == null) {
                this.mixer = HaeDevice.getSystemMixer();
            }
            this.mixer.reengageAudio();
            this.playing = true;
        }
        catch (HaeException haeException) {
            if (this.DEBUG) {
                System.out.println("Failed to open audio device.");
            }
            if (this.DEBUG) {
                System.out.println("HaeException opening device: " + haeException);
                haeException.printStackTrace();
            }
            this.closeStreams();
            this.playing = false;
        }
    }

    public synchronized void openChannel(InputStream inputStream) {
        block15: {
            AudioContainerInputStream audioContainerInputStream;
            if (this.clipStreams.get(inputStream) != null) {
                if (this.DEBUG) {
                    System.err.println("AudioDevice.openChannel(" + inputStream + "): channel already open");
                }
                return;
            }
            try {
                audioContainerInputStream = AudioContainerInputStream.getStream(inputStream);
            }
            catch (IOException iOException) {
                if (this.DEBUG) {
                    System.err.println("AudioDevice.openChannel(" + inputStream + "): could not create stream");
                }
                return;
            }
            try {
                HaeNoise haeNoise;
                if (audioContainerInputStream instanceof AudioRmfInputStream || audioContainerInputStream instanceof AudioMidiInputStream) {
                    HaeMidiSong haeMidiSong = audioContainerInputStream instanceof AudioRmfInputStream ? new HaeRmfSong(this.mixer) : new HaeMidiSong(this.mixer);
                    haeMidiSong.open(audioContainerInputStream.getBytes());
                    haeMidiSong.setLoopFlag(inputStream instanceof ContinuousAudioDataStream);
                    if (this.DEBUG) {
                        String string = inputStream instanceof ContinuousAudioDataStream ? "Will" : "Will not";
                        System.err.println(String.valueOf(string) + " loop this song.");
                    }
                    haeNoise = haeMidiSong;
                    if (this.clipStreams.size() == 0) {
                        this.rate = 22;
                    }
                } else {
                    try {
                        haeNoise = new HaeAudioStream(audioContainerInputStream, inputStream.toString());
                    }
                    catch (InvalidAudioFormatException invalidAudioFormatException) {
                        if (this.DEBUG) {
                            System.err.println("AudioDevice.openChannel(" + inputStream + "): could not create stream");
                        }
                        return;
                    }
                }
                this.open();
                if (this.playing) {
                    haeNoise.start();
                    this.clipStreams.put(inputStream, haeNoise);
                }
            }
            catch (HaeException haeException) {
                if (!this.DEBUG) break block15;
                System.err.println("AudioDevice: Problem opening an new stream: " + haeException);
            }
        }
        this.notify();
    }

    public int openChannels() {
        return this.clipStreams.size();
    }

    public void play() {
        while (this.playing) {
            try {
                this.waitForData();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.DEBUG) {
            System.out.println("exiting play()");
        }
    }

    void setVerbose(boolean bl) {
        this.DEBUG = bl;
    }

    private synchronized boolean waitForData() throws InterruptedException {
        if (this.clipStreams.size() == 0) {
            this.close();
            do {
                if (this.DEBUG) {
                    System.err.println("Waiting for updates.");
                }
                this.wait();
            } while (this.clipStreams.size() == 0);
            this.open();
            return true;
        }
        this.wait();
        return false;
    }
}

