/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import uk.ac.sanger.jcon.protocol.Protocol;
import uk.ac.sanger.util.CommandLineDoc;

public class JSubmit {
    public static final String PROTOCOL_PROPS = "/protocol.properties";
    public static final String HELP_KEY = "help";
    public static final String OWNER_KEY = "owner";
    public static final String PROTOCOL_KEY = "protocol";
    public static final String CONFIG_KEY = "config";
    public static final String QUEUE_KEY = "queue";
    public static final int GETOPT_CODE = 1;
    public static final int LOCATION_CODE = 10;
    public static final int INSTANTIATION_CODE = 20;
    public static final int EXECUTION_CODE = 30;
    private static Properties protocolProps = JSubmit.loadProperties();
    static /* synthetic */ Class class$uk$ac$sanger$jcon$JSubmit;

    public static void main(String[] argv) {
        String className;
        CommandLineDoc doc = new CommandLineDoc();
        doc.loadResources((class$uk$ac$sanger$jcon$JSubmit == null ? (class$uk$ac$sanger$jcon$JSubmit = JSubmit.class$("uk.ac.sanger.jcon.JSubmit")) : class$uk$ac$sanger$jcon$JSubmit).getName());
        LongOpt[] longopts = new LongOpt[]{new LongOpt(CONFIG_KEY, 1, null, 99), new LongOpt(HELP_KEY, 0, null, 104), new LongOpt(OWNER_KEY, 1, null, 111), new LongOpt(PROTOCOL_KEY, 1, null, 112), new LongOpt(QUEUE_KEY, 1, null, 113)};
        Getopt g = new Getopt("JSubmit", argv, "c:ho:p:q:", longopts);
        String owner = null;
        String protocol = null;
        String queue = null;
        String fileName = null;
        HashMap<String, String> config = new HashMap<String, String>();
        int c = 0;
        block12: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 99: {
                    fileName = g.getOptarg();
                    protocol = "UserProtocol";
                    continue block12;
                }
                case 104: {
                    doc.printShortUsage(System.err);
                    System.exit(0);
                    continue block12;
                }
                case 111: {
                    owner = g.getOptarg();
                    continue block12;
                }
                case 112: {
                    protocol = g.getOptarg();
                    config.put(PROTOCOL_KEY, protocol);
                    continue block12;
                }
                case 113: {
                    queue = g.getOptarg();
                    config.put(QUEUE_KEY, queue);
                    continue block12;
                }
            }
            System.err.println("Failed to recognise option '" + c + "'");
            doc.printLongUsage(System.err);
            System.exit(1);
        }
        if (owner == null) {
            System.err.println("Owner was not defined");
            doc.printLongUsage(System.err);
            System.exit(1);
        }
        if (fileName == null && protocol == null) {
            System.err.println("Protocol was not defined");
            doc.printLongUsage(System.err);
            System.exit(1);
        }
        if (fileName != null && !protocol.equals("UserProtocol")) {
            System.err.println("Both a user configuration and a Protocol were defined");
            doc.printLongUsage(System.err);
            System.exit(1);
        }
        if (queue == null) {
            System.err.println("Batch queue was not defined");
            doc.printLongUsage(System.err);
            System.exit(1);
        }
        if ((className = protocolProps.getProperty(protocol)) == null) {
            System.err.println("Unknown protocol. Known protocols are:");
            Enumeration<?> enumeration = protocolProps.propertyNames();
            while (enumeration.hasMoreElements()) {
                System.err.println(enumeration.nextElement());
            }
            System.exit(20);
        }
        Protocol p = null;
        try {
            p = (Protocol)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("Failed to find protocol");
            cnfe.printStackTrace();
            System.exit(10);
        }
        catch (Exception e) {
            System.err.println("Failed to create protocol");
            e.printStackTrace();
            System.exit(20);
        }
        int protocolArgCount = argv.length - g.getOptind();
        String[] protocolArgs = new String[protocolArgCount];
        System.arraycopy(argv, g.getOptind(), protocolArgs, 0, protocolArgCount);
        config.put(CONFIG_KEY, fileName);
        config.put(QUEUE_KEY, queue);
        try {
            p.apply(owner, config, protocolArgs);
        }
        catch (Exception e) {
            System.err.println("Failed to execute protocol");
            e.printStackTrace();
            System.exit(30);
        }
        System.exit(0);
    }

    private static Properties loadProperties() {
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = (class$uk$ac$sanger$jcon$JSubmit == null ? (class$uk$ac$sanger$jcon$JSubmit = JSubmit.class$("uk.ac.sanger.jcon.JSubmit")) : class$uk$ac$sanger$jcon$JSubmit).getResourceAsStream(PROTOCOL_PROPS);
            if (is == null) {
                throw new IOException("Failed to find resource '/protocol.properties'");
            }
            props.load(is);
        }
        catch (IOException ioe1) {
            System.err.println("Failed to load resource '/protocol.properties'");
            try {
                is.close();
                throw ioe1;
            }
            catch (IOException ioe2) {
                System.err.println("Failed to close '/protocol.properties'");
            }
        }
        return props;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

