/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.sql.DataSource;
import org.apache.log4j.Category;
import uk.ac.sanger.jcon.JobControlException;
import uk.ac.sanger.jcon.dao.ExecutableSQLDAO;
import uk.ac.sanger.jcon.dao.JobSQLDAO;
import uk.ac.sanger.jcon.dao.OwnerSQLDAO;
import uk.ac.sanger.jcon.dao.SQLDAOBaseImpl;
import uk.ac.sanger.jcon.dao.TaskDAO;
import uk.ac.sanger.jcon.job.Job;
import uk.ac.sanger.jcon.job.Owner;
import uk.ac.sanger.jcon.job.Task;
import uk.ac.sanger.jcon.job.TaskDefaultImpl;

public class TaskSQLDAO
extends SQLDAOBaseImpl
implements TaskDAO {
    static Category cat = Category.getInstance((String)(class$uk$ac$sanger$jcon$dao$TaskSQLDAO == null ? (class$uk$ac$sanger$jcon$dao$TaskSQLDAO = TaskSQLDAO.class$("uk.ac.sanger.jcon.dao.TaskSQLDAO")) : class$uk$ac$sanger$jcon$dao$TaskSQLDAO).getName());
    static ResourceBundle sqlStatements = ResourceBundle.getBundle((class$uk$ac$sanger$jcon$dao$TaskSQLDAO == null ? (class$uk$ac$sanger$jcon$dao$TaskSQLDAO = TaskSQLDAO.class$("uk.ac.sanger.jcon.dao.TaskSQLDAO")) : class$uk$ac$sanger$jcon$dao$TaskSQLDAO).getName());
    private OwnerSQLDAO ownerSQLDAO = new OwnerSQLDAO();
    private ExecutableSQLDAO executableSQLDAO;
    private JobSQLDAO jobSQLDAO = new JobSQLDAO();
    static /* synthetic */ Class class$uk$ac$sanger$jcon$dao$TaskSQLDAO;

    public TaskSQLDAO() {
    }

    public TaskSQLDAO(DataSource datasource) {
        super(datasource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int createTask(Task task) throws Exception {
        String sql = sqlStatements.getString("createTask");
        Connection c = this.getManagedConnection();
        this.jobSQLDAO.setConnection(c);
        PreparedStatement ps = null;
        int newId = 0;
        boolean rollback = false;
        try {
            try {
                newId = this.createNewTaskId();
                this.setObjectIntField(task, "id", newId);
                cat.debug((Object)("Preparing SQL: " + sql));
                ps = c.prepareStatement(sql);
                ps.setInt(1, task.getId());
                ps.setString(2, task.getName());
                ps.setString(3, task.getDescription());
                ps.setInt(4, task.getOwner().getId());
                ps.setInt(5, task.getPriority());
                ps.setInt(6, 0);
                ps.setNull(7, 93);
                cat.debug((Object)("Executing SQL: " + ps));
                ps.executeUpdate();
                Job[] rootJobs = task.getJobs();
                int low = 0;
                int high = 0;
                for (int i = 0; i < rootJobs.length; ++i) {
                    high = this.jobSQLDAO.createJob(rootJobs[i], task.getId(), low);
                    low = ++high;
                }
                Object var12_12 = null;
            }
            catch (Exception e) {
                cat.error((Object)"Caught Exception; rolling back transaction", (Throwable)e);
                rollback = true;
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            this.cSupport.close(ps);
            if (rollback) {
                this.cSupport.rollback(c);
            } else {
                this.cSupport.commit(c);
            }
            if (!this.isManagingConnections()) throw throwable;
            this.cSupport.close(c);
            throw throwable;
        }
        this.cSupport.close((Statement)ps);
        if (rollback) {
            this.cSupport.rollback(c);
        } else {
            this.cSupport.commit(c);
        }
        if (!this.isManagingConnections()) return newId;
        this.cSupport.close(c);
        return newId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Task readTaskById(int taskId, int treeOperation) throws SQLException, JobControlException {
        String sql = sqlStatements.getString("readTaskById");
        Connection c = this.getManagedConnection();
        PreparedStatement ps = null;
        ResultSet r = null;
        Task task = null;
        try {
            block9: {
                block8: {
                    cat.debug((Object)("Preparing SQL: " + sql));
                    ps = c.prepareStatement(sql);
                    ps.setInt(1, taskId);
                    cat.debug((Object)("Executing SQL: " + ps));
                    r = ps.executeQuery();
                    if (!r.next()) break block8;
                    switch (treeOperation) {
                        case 0: {
                            task = this.populateTask(r);
                            break block9;
                        }
                        case 1: {
                            task = this.populateTaskLite(r);
                            break block9;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid job treeOperation flag " + treeOperation);
                        }
                    }
                }
                throw new JobControlException("Requested a non-existent Task with ID '" + taskId + "'");
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.cSupport.close(r);
            this.cSupport.close(ps);
            if (this.isManagingConnections()) {
                this.cSupport.close(c);
            }
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close((Statement)ps);
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection readAllTasks(int treeOperation) throws Exception {
        String sql = sqlStatements.getString("readAllTasks");
        Connection c = this.getManagedConnection();
        PreparedStatement ps = null;
        List tasks = null;
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            tasks = this.processCollectionQuery(ps, treeOperation);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.cSupport.close(ps);
            if (this.isManagingConnections()) {
                this.cSupport.close(c);
            }
            throw throwable;
        }
        this.cSupport.close((Statement)ps);
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection readSubmittedTasks(int treeOperation) throws Exception {
        String sql = sqlStatements.getString("readSubmittedTasks");
        Connection c = this.getManagedConnection();
        PreparedStatement ps = null;
        List tasks = null;
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            tasks = this.processCollectionQuery(ps, treeOperation);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.cSupport.close(ps);
            if (this.isManagingConnections()) {
                this.cSupport.close(c);
            }
            throw throwable;
        }
        this.cSupport.close((Statement)ps);
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection readTasksByOwner(Owner owner) throws Exception {
        String sql = sqlStatements.getString("readTasksByOwner");
        Connection c = this.getManagedConnection();
        PreparedStatement ps = null;
        List tasks = null;
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ps.setInt(1, owner.getId());
            tasks = this.processCollectionQuery(ps, 0);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.cSupport.close(ps);
            if (this.isManagingConnections()) {
                this.cSupport.close(c);
            }
            throw throwable;
        }
        this.cSupport.close((Statement)ps);
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection readTasksByName(String name) throws Exception {
        String sql = sqlStatements.getString("readTasksByName");
        Connection c = this.getManagedConnection();
        PreparedStatement ps = null;
        List tasks = null;
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ps.setString(1, name);
            tasks = this.processCollectionQuery(ps, 0);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.cSupport.close(ps);
            if (this.isManagingConnections()) {
                this.cSupport.close(c);
            }
            throw throwable;
        }
        this.cSupport.close((Statement)ps);
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection readTasksByPriority(int priority) throws Exception {
        String sql = sqlStatements.getString("readTasksByPriority");
        Connection c = this.getManagedConnection();
        PreparedStatement ps = null;
        List tasks = null;
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ps.setInt(1, priority);
            tasks = this.processCollectionQuery(ps, 0);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.cSupport.close(ps);
            if (this.isManagingConnections()) {
                this.cSupport.close(c);
            }
            throw throwable;
        }
        this.cSupport.close((Statement)ps);
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection readTasksSubmittedBefore(Timestamp time) throws Exception {
        String sql = sqlStatements.getString("readTasksSubmittedBefore");
        Connection c = this.getManagedConnection();
        PreparedStatement ps = null;
        List tasks = null;
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ps.setTimestamp(1, time);
            tasks = this.processCollectionQuery(ps, 0);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.cSupport.close(ps);
            if (this.isManagingConnections()) {
                this.cSupport.close(c);
            }
            throw throwable;
        }
        this.cSupport.close((Statement)ps);
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection readTasksSubmittedAfter(Timestamp time) throws Exception {
        String sql = sqlStatements.getString("readTasksSubmittedAfter");
        Connection c = this.getManagedConnection();
        PreparedStatement ps = null;
        List tasks = null;
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ps.setTimestamp(1, time);
            tasks = this.processCollectionQuery(ps, 0);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.cSupport.close(ps);
            if (this.isManagingConnections()) {
                this.cSupport.close(c);
            }
            throw throwable;
        }
        this.cSupport.close((Statement)ps);
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection readTasksSubmittedBetween(Timestamp earliest, Timestamp latest) throws Exception {
        String sql = sqlStatements.getString("readTasksSubmittedBetween");
        Connection c = this.getManagedConnection();
        PreparedStatement ps = null;
        List tasks = null;
        try {
            cat.debug((Object)("Preparing SQL: " + sql));
            ps = c.prepareStatement(sql);
            ps.setTimestamp(1, earliest);
            ps.setTimestamp(2, latest);
            tasks = this.processCollectionQuery(ps, 0);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.cSupport.close(ps);
            if (this.isManagingConnections()) {
                this.cSupport.close(c);
            }
            throw throwable;
        }
        this.cSupport.close((Statement)ps);
        if (this.isManagingConnections()) {
            this.cSupport.close(c);
        }
        return tasks;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void updateTask(Task task) throws Exception {
        int taskId = task.getId();
        String description = task.getDescription();
        int priority = task.getPriority();
        String sql = sqlStatements.getString("updateTaskById");
        Connection c = this.getManagedConnection();
        PreparedStatement us = null;
        boolean rollback = false;
        try {
            try {
                this.lockTask(taskId);
                cat.debug((Object)("Preparing SQL: " + sql));
                us = c.prepareStatement(sql);
                us.setString(1, description);
                us.setInt(2, priority);
                us.setInt(3, taskId);
                cat.debug((Object)("Executing SQL: " + us));
                us.executeUpdate();
            }
            catch (Exception e) {
                cat.error((Object)"Caught Exception; rolling back transaction", (Throwable)e);
                rollback = true;
                throw e;
            }
            Object var11_9 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            this.cSupport.close(us);
            if (rollback) {
                this.cSupport.rollback(c);
            } else {
                this.cSupport.commit(c);
            }
            if (!this.isManagingConnections()) throw throwable;
            this.cSupport.close(c);
            throw throwable;
        }
        this.cSupport.close((Statement)us);
        if (rollback) {
            this.cSupport.rollback(c);
        } else {
            this.cSupport.commit(c);
        }
        if (!this.isManagingConnections()) return;
        this.cSupport.close(c);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void updateTaskSubmitted(int taskId) throws SQLException, JobControlException {
        String sql = sqlStatements.getString("updateTaskSubmittedById");
        Connection c = this.getManagedConnection();
        this.jobSQLDAO.setConnection(c);
        PreparedStatement ps = null;
        boolean rollback = false;
        try {
            try {
                int submitted = this.lockTask(taskId);
                if (submitted == -1) {
                    throw new JobControlException("Failed to submit task [" + taskId + "] as its current submission " + "status could not be determined");
                }
                if (submitted == 1) {
                    throw new JobControlException("Failed to submit task [" + taskId + "] as it has already been submitted");
                }
                Task task = this._readTaskById(taskId, 1);
                cat.debug((Object)("Preparing SQL: " + sql));
                ps = c.prepareStatement(sql);
                ps.setInt(1, taskId);
                cat.debug((Object)("Executing SQL: " + ps));
                ps.executeUpdate();
                this.cSupport.close((Statement)ps);
                Job[] rootJobs = task.getJobs();
                int lastIndex = rootJobs.length - 1;
                this.jobSQLDAO.updateLeafJobsReady(rootJobs[lastIndex], taskId);
            }
            catch (SQLException se) {
                cat.error((Object)"Caught Exception; rolling back transaction", (Throwable)se);
                rollback = true;
                throw se;
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.cSupport.close(ps);
            if (rollback) {
                this.cSupport.rollback(c);
            } else {
                this.cSupport.commit(c);
            }
            if (!this.isManagingConnections()) throw throwable;
            this.cSupport.close(c);
            throw throwable;
        }
        this.cSupport.close((Statement)ps);
        if (rollback) {
            this.cSupport.rollback(c);
        } else {
            this.cSupport.commit(c);
        }
        if (!this.isManagingConnections()) return;
        this.cSupport.close(c);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void updateTaskRestored(int taskId) throws Exception {
        Connection c;
        block10: {
            block8: {
                c = this.getManagedConnection();
                this.jobSQLDAO.setConnection(c);
                Object ps = null;
                boolean rollback = false;
                try {
                    try {
                        this.lockTask(taskId);
                        Task task = this._readTaskById(taskId, 1);
                        Job[] jobs = task.getJobs();
                        int i = jobs.length;
                        while (--i >= 0) {
                            this.jobSQLDAO.updateJobRestore(jobs[i]);
                        }
                        Object var9_9 = null;
                        if (!rollback) break block8;
                    }
                    catch (SQLException se) {
                        cat.error((Object)"Caught Exception; rolling back transaction", (Throwable)se);
                        rollback = true;
                        throw se;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    if (rollback) {
                        this.cSupport.rollback(c);
                    } else {
                        this.cSupport.commit(c);
                    }
                    if (!this.isManagingConnections()) throw throwable;
                    this.cSupport.close(c);
                    throw throwable;
                }
                this.cSupport.rollback(c);
                break block10;
            }
            this.cSupport.commit(c);
        }
        if (!this.isManagingConnections()) return;
        this.cSupport.close(c);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void updateTaskCancelled(int taskId) throws Exception {
        Connection c;
        block10: {
            block8: {
                c = this.getManagedConnection();
                this.jobSQLDAO.setConnection(c);
                Object ps = null;
                boolean rollback = false;
                try {
                    try {
                        this.lockTask(taskId);
                        Task task = this._readTaskById(taskId, 1);
                        Job[] jobs = task.getJobs();
                        int i = jobs.length;
                        while (--i >= 0) {
                            this.jobSQLDAO.updateJobCancelled(jobs[i]);
                        }
                        Object var9_9 = null;
                        if (!rollback) break block8;
                    }
                    catch (SQLException se) {
                        cat.error((Object)"Caught Exception; rolling back transaction", (Throwable)se);
                        rollback = true;
                        throw se;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    if (rollback) {
                        this.cSupport.rollback(c);
                    } else {
                        this.cSupport.commit(c);
                    }
                    if (!this.isManagingConnections()) throw throwable;
                    this.cSupport.close(c);
                    throw throwable;
                }
                this.cSupport.rollback(c);
                break block10;
            }
            this.cSupport.commit(c);
        }
        if (!this.isManagingConnections()) return;
        this.cSupport.close(c);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void deleteTask(int taskId) throws Exception {
        String sql = sqlStatements.getString("deleteTask");
        Connection c = this.getManagedConnection();
        this.jobSQLDAO.setConnection(c);
        PreparedStatement ps = null;
        boolean rollback = false;
        try {
            try {
                this.lockTask(taskId);
                Task task = this._readTaskById(taskId, 1);
                Job[] jobs = task.getJobs();
                int i = jobs.length;
                while (--i >= 0) {
                    this.jobSQLDAO.deleteJob(jobs[i].getId(), taskId);
                }
                cat.debug((Object)("Preparing SQL: " + sql));
                ps = c.prepareStatement(sql);
                ps.setInt(1, task.getId());
                ps.executeUpdate();
            }
            catch (SQLException se) {
                cat.error((Object)"Caught Exception; rolling back transaction", (Throwable)se);
                rollback = true;
                throw se;
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.cSupport.close(ps);
            if (rollback) {
                this.cSupport.rollback(c);
            } else {
                this.cSupport.commit(c);
            }
            if (!this.isManagingConnections()) throw throwable;
            this.cSupport.close(c);
            throw throwable;
        }
        this.cSupport.close((Statement)ps);
        if (rollback) {
            this.cSupport.rollback(c);
        } else {
            this.cSupport.commit(c);
        }
        if (!this.isManagingConnections()) return;
        this.cSupport.close(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List processCollectionQuery(PreparedStatement ps, int treeOperation) throws Exception {
        ResultSet r = null;
        ArrayList<Task> tasks = new ArrayList<Task>();
        try {
            cat.debug((Object)("Executing SQL: " + ps));
            r = ps.executeQuery();
            switch (treeOperation) {
                case 0: {
                    while (r.next()) {
                        tasks.add(this.populateTask(r));
                    }
                    break;
                }
                case 1: {
                    while (r.next()) {
                        tasks.add(this.populateTaskLite(r));
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid job treeOperation flag " + treeOperation);
                }
            }
        }
        catch (Throwable throwable) {
            this.cSupport.close(r);
            throw throwable;
        }
        this.cSupport.close(r);
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int lockTask(int taskId) throws SQLException, JobControlException {
        String sql = sqlStatements.getString("selectTaskForUpdateById");
        Connection c = this.getConnection();
        PreparedStatement ls = null;
        ResultSet r = null;
        int submitted = -1;
        try {
            ls = c.prepareStatement(sql);
            ls.setInt(1, taskId);
            cat.debug((Object)("Executing SQL: " + ls));
            r = ls.executeQuery();
            if (!r.next()) {
                throw new JobControlException("Failed to find Task [" + taskId + "] for update");
            }
            submitted = r.getInt("submitted");
        }
        catch (Throwable throwable) {
            this.cSupport.close(r);
            this.cSupport.close((Statement)ls);
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close((Statement)ls);
        return submitted;
    }

    private Task populateTask(ResultSet r) throws SQLException, JobControlException {
        int taskId = r.getInt("task_id");
        String name = r.getString("name");
        String description = r.getString("description");
        int ownerId = r.getInt("owner_id");
        int priority = r.getInt("priority");
        Timestamp submissionTime = r.getTimestamp("submission_time");
        Connection c = this.getConnection();
        this.ownerSQLDAO.setConnection(c);
        this.jobSQLDAO.setConnection(c);
        Owner owner = this.ownerSQLDAO.readOwnerById(ownerId);
        Job[] jobs = this.jobSQLDAO.populateJobTrees(taskId);
        cat.debug((Object)("Creating Task object with ID:" + taskId + " name:" + name + " desc: " + description + " owner: " + owner + " # root jobs: " + jobs.length));
        TaskDefaultImpl task = new TaskDefaultImpl(name, description, owner, jobs);
        task.setPriority(priority);
        task.setSubmissionTime(submissionTime);
        this.setObjectIntField(task, "id", taskId);
        return task;
    }

    private Task populateTaskLite(ResultSet r) throws SQLException, JobControlException {
        int taskId = r.getInt("task_id");
        String name = r.getString("name");
        String description = r.getString("description");
        int ownerId = r.getInt("owner_id");
        int priority = r.getInt("priority");
        Timestamp submissionTime = r.getTimestamp("submission_time");
        Connection c = this.getConnection();
        this.ownerSQLDAO.setConnection(c);
        this.jobSQLDAO.setConnection(c);
        Owner owner = this.ownerSQLDAO.readOwnerById(ownerId);
        Job[] jobs = this.jobSQLDAO.readRootJobsByTaskId(taskId);
        cat.debug((Object)("Creating Task with ID: " + taskId + " name:" + name + " desc: " + description + " owner: " + owner + " # root jobs: " + jobs.length));
        TaskDefaultImpl task = new TaskDefaultImpl(name, description, owner, jobs);
        task.setPriority(priority);
        task.setSubmissionTime(submissionTime);
        this.setObjectIntField(task, "id", taskId);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createNewTaskId() throws Exception {
        String sql = sqlStatements.getString("createNewTaskId");
        Connection c = this.getConnection();
        Statement s = null;
        ResultSet r = null;
        int id = 0;
        try {
            s = c.createStatement();
            cat.debug((Object)("Executing SQL: " + s));
            r = s.executeQuery(sql);
            if (!r.next()) {
                throw new Exception("Failed to retrieve a new Task ID");
            }
            id = r.getInt("task_id");
        }
        catch (Throwable throwable) {
            this.cSupport.close(r);
            this.cSupport.close(s);
            throw throwable;
        }
        this.cSupport.close(r);
        this.cSupport.close(s);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task _readTaskById(int taskId, int treeOperation) throws SQLException, JobControlException {
        Task task;
        ResultSet r;
        PreparedStatement ps;
        block7: {
            String sql = sqlStatements.getString("readTaskById");
            Connection c = this.getConnection();
            ps = null;
            r = null;
            task = null;
            try {
                cat.debug((Object)("Preparing SQL: " + sql));
                ps = c.prepareStatement(sql);
                ps.setInt(1, taskId);
                cat.debug((Object)("Executing SQL: " + ps));
                r = ps.executeQuery();
                if (r.next()) {
                    switch (treeOperation) {
                        case 0: {
                            task = this.populateTask(r);
                            break block7;
                        }
                        case 1: {
                            task = this.populateTaskLite(r);
                            break block7;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid job treeOperation flag " + treeOperation);
                        }
                    }
                }
                cat.warn((Object)("Requested a non-existent Task with ID '" + taskId + "'"));
            }
            catch (Throwable throwable) {
                this.cSupport.close(r);
                this.cSupport.close(ps);
                throw throwable;
            }
        }
        this.cSupport.close(r);
        this.cSupport.close((Statement)ps);
        return task;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

