/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.gui;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import uk.ac.sanger.jcon.JobControl;
import uk.ac.sanger.jcon.JobControlException;
import uk.ac.sanger.jcon.dao.StatusSQLDAO;
import uk.ac.sanger.jcon.dao.TaskSQLDAO;
import uk.ac.sanger.jcon.dao.TaskStatisticSQLDAO;
import uk.ac.sanger.jcon.job.Task;
import uk.ac.sanger.jcon.job.TaskState;

public class TaskViewer
extends JPanel
implements Runnable {
    private final int SLEEP_TIME;
    private HashMap progressbars = new HashMap();
    private HashMap labels = new HashMap();
    private DataSource datasource = null;
    private boolean finishFlag = false;

    public TaskViewer(int[] ids) throws JobControlException {
        ResourceBundle bundle = JobControl.getConfiguration();
        String val = bundle.getString("jobcontrol.gui.task_viewer.update_time");
        try {
            this.SLEEP_TIME = 1000 * Integer.parseInt(val);
        }
        catch (NumberFormatException nfe) {
            throw new Error("Number format error (" + val + ") in " + "configuration ResourceBundle: " + nfe.getMessage());
        }
        try {
            InitialContext context = new InitialContext();
            this.datasource = (DataSource)context.lookup("jdbc/JobControl");
            this.makeComponents(ids, this.datasource);
        }
        catch (NamingException e) {
            throw new Error("NamingException: " + e.getMessage());
        }
        new Thread(this).start();
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        try {
            statusDAO = new StatusSQLDAO(this.datasource);
            taskSQLDAO = new TaskSQLDAO(this.datasource);
            taskStatDAO = new TaskStatisticSQLDAO(this.datasource);
            completed = statusDAO.readStatusById(4);
            failed = statusDAO.readStatusById(5);
            while (true) lbl-1000:
            // 3 sources

            {
                if (this.finishFlag) {
                    return;
                }
                try {
                    tStats = taskStatDAO.readSubmittedTaskState();
                    statMap = this.createTaskStatMap(tStats);
                    swi = this.progressbars.keySet().iterator();
                    while (swi.hasNext()) {
                        id = (Integer)swi.next();
                        tStat = (TaskState)statMap.get(id);
                        progressBar = (JProgressBar)this.progressbars.get(id);
                        label = (JLabel)this.labels.get(id);
                        if (tStat == null) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    progressBar.setValue(progressBar.getMaximum());
                                    label.setText(TaskViewer.this.getLabelText(id, progressBar.getMaximum(), progressBar.getMaximum()));
                                }
                            });
                            continue;
                        }
                        compCount = tStat.getJobCount(completed);
                        failCount = tStat.getJobCount(failed);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                progressBar.setValue(compCount + failCount);
                                label.setText(TaskViewer.this.getLabelText(id, tStat.getTotalJobCount(), compCount + failCount));
                            }
                        });
                    }
                    Thread.sleep(this.SLEEP_TIME);
                }
                catch (IllegalStateException e) {
                    throw new Error("IllegalStateException: " + e.getMessage());
                }
                catch (InterruptedException _) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("Exception: " + e.getMessage());
        }
        ** GOTO lbl-1000
    }

    public void makeComponents(int[] ids, DataSource datasource) {
        try {
            TaskSQLDAO taskSQLDAO = new TaskSQLDAO(datasource);
            TaskStatisticSQLDAO taskStatDAO = new TaskStatisticSQLDAO(datasource);
            BoxLayout layout = new BoxLayout(this, 1);
            this.setLayout(layout);
            Collection tStats = taskStatDAO.readSubmittedTaskState();
            Map statMap = this.createTaskStatMap(tStats);
            for (int i = 0; i < ids.length; ++i) {
                Integer id = new Integer(ids[i]);
                Task task = taskSQLDAO.readTaskById(ids[i], 1);
                TaskState tStat = (TaskState)statMap.get(id);
                if (tStat == null) continue;
                JLabel label1 = new JLabel(task.getDescription());
                JLabel label2 = new JLabel(this.getLabelText(id, tStat.getTotalJobCount(), 0));
                JProgressBar progressBar = new JProgressBar(0, tStat.getTotalJobCount());
                progressBar.setStringPainted(true);
                this.add(label1);
                this.add(label2);
                this.add(progressBar);
                this.progressbars.put(id, progressBar);
                this.labels.put(id, label2);
            }
        }
        catch (NamingException e) {
            throw new Error("TaskViewer initialisation failed because of a NamingException: " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("Exception: " + e);
        }
    }

    private Map createTaskStatMap(Collection tStats) {
        HashMap<Integer, TaskState> statMap = new HashMap<Integer, TaskState>();
        Iterator i = tStats.iterator();
        while (i.hasNext()) {
            TaskState tStat = (TaskState)i.next();
            statMap.put(new Integer(tStat.getTaskId()), tStat);
        }
        return statMap;
    }

    private String getLabelText(int id, int totalJobs, int completedJobs) {
        if (totalJobs == completedJobs) {
            return "(task #" + id + ") completed " + totalJobs;
        }
        return "(task #" + id + ") completed " + completedJobs + "/" + totalJobs;
    }
}

