/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.protocol;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Map;
import org.apache.log4j.Category;
import org.apache.velocity.VelocityContext;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.io.SeqIOTools;
import uk.ac.sanger.jcon.JobControlException;
import uk.ac.sanger.jcon.job.BatchJob;
import uk.ac.sanger.jcon.job.Job;
import uk.ac.sanger.jcon.job.Owner;
import uk.ac.sanger.jcon.job.TaskDefaultImpl;
import uk.ac.sanger.jcon.protocol.ConfigurableProtocol;
import uk.ac.sanger.jcon.util.Configuration;

public class DdiscoideumPeptideAnalysis
extends ConfigurableProtocol {
    static Category cat = Category.getInstance((String)(class$uk$ac$sanger$jcon$protocol$DdiscoideumPeptideAnalysis == null ? (class$uk$ac$sanger$jcon$protocol$DdiscoideumPeptideAnalysis = DdiscoideumPeptideAnalysis.class$("uk.ac.sanger.jcon.protocol.DdiscoideumPeptideAnalysis")) : class$uk$ac$sanger$jcon$protocol$DdiscoideumPeptideAnalysis).getName());
    static /* synthetic */ Class class$uk$ac$sanger$jcon$protocol$DdiscoideumPeptideAnalysis;

    public void apply(String ownerName, Map config, String[] data) throws Exception {
        if (ownerName == null) {
            throw new IllegalArgumentException("ownerName was null");
        }
        Owner owner = this.admin.getOwnerByUserName(ownerName);
        for (int i = 0; i < data.length; ++i) {
            try {
                this.applySingle(owner, data[i]);
                continue;
            }
            catch (Exception e) {
                System.err.println("Exception while processing '" + data[i] + "'. Skipping this element");
                e.printStackTrace();
            }
        }
    }

    private void applySingle(Owner owner, String arg) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader(arg));
        SequenceIterator seqI = SeqIOTools.readFastaProtein((BufferedReader)br);
        String aaSuffix = this.config.getString(Configuration.FASTA_AA_EXTENSION_KEY);
        String tabSuffix = this.config.getString(Configuration.FTABLE_EXTENSION_KEY);
        String inpSuffix = this.config.getString(Configuration.INPUT_EXTENSION_KEY);
        String outSuffix = this.config.getString(Configuration.OUTPUT_EXTENSION_KEY);
        String errSuffix = this.config.getString(Configuration.ERROR_EXTENSION_KEY);
        String queue = this.config.getString(Configuration.EXEC_QUEUE_KEY);
        String workDirectory = System.getProperty("user.dir");
        String swallLogName = "blastp_swall.log";
        String blast2tabLogName = "blast2tab.log";
        String pepfeaturemapLogName = "pepfeaturemap.log";
        BatchJob rootJob = this.createEmptyBatchJob(queue);
        rootJob.setWorkDirectoryName(workDirectory);
        while (seqI.hasNext()) {
            Sequence seq = seqI.nextSequence();
            String name = seq.getName();
            if (name.equals("")) {
                throw new JobControlException("Sequence used empty string as identifier");
            }
            String aaFileName = name + "." + aaSuffix;
            File aaFile = new File(workDirectory, aaFileName);
            if (!aaFile.exists()) {
                this.writeFasta(seq, aaFile);
            }
            VelocityContext context = new VelocityContext();
            context.put("executable", (Object)"<Error: this should not have been expanded>");
            String swallOutName = name + ".swall.blp." + outSuffix;
            context.put("output_name", (Object)swallOutName);
            Job swallRun = this.createJob(new String[]{aaFileName, swallLogName, null}, context, "d_discoideum", "blastp_v_swall");
            swallRun.setWorkDirectoryName(workDirectory);
            context.put("output_name", (Object)(swallOutName + "." + tabSuffix));
            context.put("ident_filter", (Object)"0");
            context.put("score_filter", (Object)"0");
            context.put("eval_filter", (Object)"10e-5");
            context.put("feature_key", (Object)"BLASTCDS");
            Job swallParse = this.createJob(new String[]{swallOutName, blast2tabLogName, null}, context, "d_discoideum", "blast2tab");
            swallParse.setWorkDirectoryName(workDirectory);
            swallParse.add(swallRun);
            rootJob.add(swallParse);
        }
        TaskDefaultImpl task = new TaskDefaultImpl("d_discoideum_pepanalysis", "D. discoideum peptide analysis", owner);
        task.setJobs(new Job[]{rootJob});
        int taskId = this.manager.createTask(task);
        this.manager.submitTask(taskId);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

