/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.run;

import java.text.DateFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Category;
import uk.ac.sanger.jcon.JobControlException;
import uk.ac.sanger.jcon.dao.TaskDAO;
import uk.ac.sanger.jcon.job.Job;
import uk.ac.sanger.jcon.job.Task;
import uk.ac.sanger.jcon.run.Coordinator;
import uk.ac.sanger.jcon.run.Policy;
import uk.ac.sanger.jcon.run.TaskScheduler;
import uk.ac.sanger.jcon.util.Mailer;

public abstract class AbstractTaskScheduler
implements TaskScheduler {
    static Category cat = Category.getInstance((String)(class$uk$ac$sanger$jcon$run$AbstractTaskScheduler == null ? (class$uk$ac$sanger$jcon$run$AbstractTaskScheduler = AbstractTaskScheduler.class$("uk.ac.sanger.jcon.run.AbstractTaskScheduler")) : class$uk$ac$sanger$jcon$run$AbstractTaskScheduler).getName());
    protected TaskDAO taskDAO;
    protected boolean isScheduling;
    protected Policy policy;
    protected Coordinator coordinator;
    protected int policyPollInterval;
    protected Map taskCache;
    protected boolean sendMail;
    protected String mailFrom;
    protected DateFormat df;
    static /* synthetic */ Class class$uk$ac$sanger$jcon$run$AbstractTaskScheduler;

    public AbstractTaskScheduler(TaskDAO taskDAO, Coordinator coordinator) {
        this.taskDAO = taskDAO;
        this.coordinator = coordinator;
        this.taskCache = new HashMap();
        this.df = DateFormat.getDateTimeInstance();
        this.sendMail = true;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public boolean getSendMail() {
        return this.sendMail;
    }

    public void setSendMail(boolean sendMail) {
        this.sendMail = sendMail;
    }

    public void setPolicy(Policy policy) throws IllegalStateException {
        if (this.isScheduling) {
            throw new IllegalStateException("Failed to set Policy as  the TaskScheduler is running");
        }
        this.policy = policy;
    }

    public abstract void startScheduling();

    public abstract void stopScheduling();

    protected void schedule() {
        int currentTaskId = -1;
        while (this.isScheduling) {
            try {
                int newTaskId = this.policy.selectTaskId();
                cat.debug((Object)("Current Task ID: " + currentTaskId + ", new Task ID: " + newTaskId));
                if (newTaskId == -1) {
                    cat.debug((Object)"No Tasks available");
                    if (currentTaskId > 0) {
                        this.taskUpdate(currentTaskId);
                        currentTaskId = -1;
                    }
                } else if (newTaskId != currentTaskId) {
                    if (currentTaskId > 0) {
                        this.taskUpdate(currentTaskId);
                    }
                    this.taskUpdate(newTaskId);
                    currentTaskId = newTaskId;
                    cat.debug((Object)("Scheduler selected Task [" + currentTaskId + "]"));
                    Task taskLite = this.taskDAO.readTaskById(currentTaskId, 1);
                    this.coordinator.setTask(taskLite);
                }
                this.waitFor(this.policyPollInterval);
            }
            catch (Exception e) {
                cat.error((Object)"Caught Exception while scheduling.", (Throwable)e);
            }
        }
    }

    protected void taskUpdate(int taskId) throws Exception {
        Integer key = new Integer(taskId);
        Task current = this.taskDAO.readTaskById(taskId, 1);
        Job[] currJobs = current.getJobs();
        String description = currJobs[0].getStatus().getDescription();
        if (this.taskCache.containsKey(key)) {
            cat.debug((Object)("Task cache contains: " + current));
            Task previous = (Task)this.taskCache.get(key);
            Job[] prevJobs = previous.getJobs();
            if (prevJobs.length != currJobs.length) {
                throw new JobControlException("The number of root Jobs in Task [" + taskId + "] has changed while running");
            }
            int i = currJobs.length;
            while (--i >= 0) {
                int prevStatId;
                int currStatId = currJobs[i].getStatus().getId();
                if (currStatId == (prevStatId = prevJobs[i].getStatus().getId())) continue;
                boolean mailableEventFlag = false;
                switch (currStatId) {
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 4: {
                        if (i != 0) break;
                        mailableEventFlag = true;
                        this.taskCache.remove(key);
                        break;
                    }
                    case 5: {
                        mailableEventFlag = true;
                        this.taskCache.remove(key);
                        break;
                    }
                    case 6: {
                        mailableEventFlag = true;
                        this.taskCache.remove(key);
                        break;
                    }
                    case 7: {
                        mailableEventFlag = true;
                        this.taskCache.remove(key);
                        break;
                    }
                    default: {
                        this.taskCache.remove(key);
                        throw new JobControlException("Task [" + taskId + "] was updated to an unexpected Status [" + currStatId + "]");
                    }
                }
                if (!mailableEventFlag || !this.sendMail) continue;
                this.sendUpdateMail(current, description);
            }
        } else {
            cat.debug((Object)("Adding to Task cache: " + current));
            this.taskCache.put(key, current);
            if (this.sendMail) {
                this.sendUpdateMail(current, "STARTED");
            }
        }
    }

    protected void sendUpdateMail(Task task, String label) throws Exception {
        String address = task.getOwner().getEMail();
        StringBuffer sb = new StringBuffer();
        sb.append("Task [");
        sb.append(task.getId());
        sb.append("] ");
        sb.append(task.getName());
        sb.append(" updated to ");
        sb.append(label);
        String subject = sb.substring(0);
        sb.setLength(0);
        sb.append(task.getDescription());
        sb.append("\n\nSubmitted at ");
        sb.append(this.df.format(task.getSubmissionTime()));
        sb.append(" was updated to ");
        sb.append(label);
        Mailer.sendMessage(new String[]{address}, this.mailFrom, subject, sb.substring(0));
    }

    protected synchronized void waitFor(int milliSeconds) {
        try {
            cat.info((Object)("Waiting for " + milliSeconds + " ms"));
            this.wait(milliSeconds);
        }
        catch (InterruptedException ie) {
            cat.error((Object)"Caught Exception", (Throwable)ie);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

