/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.run;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.log4j.Category;
import uk.ac.sanger.jcon.dao.TaskStatisticDAO;
import uk.ac.sanger.jcon.run.Policy;

public final class PolicyRoundRobinImpl
implements Policy {
    static Category cat = Category.getInstance((String)(class$uk$ac$sanger$jcon$run$PolicyRoundRobinImpl == null ? (class$uk$ac$sanger$jcon$run$PolicyRoundRobinImpl = PolicyRoundRobinImpl.class$("uk.ac.sanger.jcon.run.PolicyRoundRobinImpl")) : class$uk$ac$sanger$jcon$run$PolicyRoundRobinImpl).getName());
    private TaskStatisticDAO taskStatisticDAO;
    private LinkedList idQueue;
    private Set queuedIds;
    static /* synthetic */ Class class$uk$ac$sanger$jcon$run$PolicyRoundRobinImpl;

    public PolicyRoundRobinImpl(TaskStatisticDAO taskStatisticDAO) {
        this.taskStatisticDAO = taskStatisticDAO;
        this.idQueue = new LinkedList();
        this.queuedIds = new HashSet();
    }

    /*
     * WARNING - void declaration
     */
    public int selectTaskId() {
        int taskId = -1;
        if (this.queuedIds.size() != this.idQueue.size()) {
            cat.warn((Object)("Task ID queue '" + this.idQueue + " does not contain the " + "same elements as Task ID set '" + this.queuedIds));
        }
        try {
            cat.debug((Object)"Reading Task statistics");
            int[] taskIds = this.taskStatisticDAO.readSubmittedTaskId();
            cat.debug((Object)("Found " + taskIds.length + " submitted Task(s)"));
            Arrays.sort(taskIds);
            for (int i = 0; i < taskIds.length; ++i) {
                Integer id = new Integer(taskIds[i]);
                if (this.queuedIds.contains(id)) continue;
                cat.debug((Object)("Found new submitted Task with ID '" + id + "'"));
                this.queuedIds.add(id);
                this.idQueue.add(id);
            }
        }
        catch (Exception e) {
            cat.error((Object)"Caught Exception while fetching Task IDs", (Throwable)e);
            return -1;
        }
        while (this.idQueue.size() > 0) {
            void var1_2;
            Integer id = (Integer)this.idQueue.removeFirst();
            this.queuedIds.remove(id);
            cat.debug((Object)("Examining Task [" + id + "] ..."));
            if (Arrays.binarySearch((int[])var1_2, id) < 0) {
                cat.debug((Object)("Task [" + id + "] is no longer running"));
                continue;
            }
            cat.debug((Object)("Task [" + id + "] has been selected"));
            taskId = id;
            break;
        }
        return taskId;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

