/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.run;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.apache.log4j.Category;
import uk.ac.sanger.jcon.dao.StatusDAO;
import uk.ac.sanger.jcon.run.AbstractProcessor;
import uk.ac.sanger.jcon.run.BufferedStreamEmptier;
import uk.ac.sanger.jcon.run.CommandLineFactory;
import uk.ac.sanger.jcon.run.Processor;
import uk.ac.sanger.jcon.run.ProcessorFactory;

public class ProcessorDefaultImpl
extends AbstractProcessor {
    static Category cat = Category.getInstance((String)(class$uk$ac$sanger$jcon$run$ProcessorDefaultImpl == null ? (class$uk$ac$sanger$jcon$run$ProcessorDefaultImpl = ProcessorDefaultImpl.class$("uk.ac.sanger.jcon.run.ProcessorDefaultImpl")) : class$uk$ac$sanger$jcon$run$ProcessorDefaultImpl).getName());
    public static final ProcessorFactory FACTORY = new ProcessorFactory(){

        public Processor createProcessor(CommandLineFactory clFactory, StatusDAO statusDAO) {
            return new ProcessorDefaultImpl(clFactory, statusDAO);
        }
    };
    private int jobId;
    private String inputName;
    private String outputName;
    private String errorName;
    private String workDirectory;
    private String environment;
    private String command;
    static /* synthetic */ Class class$uk$ac$sanger$jcon$run$ProcessorDefaultImpl;

    public ProcessorDefaultImpl(CommandLineFactory clFactory, StatusDAO statusDAO) {
        super(clFactory, statusDAO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.jobId = this.job.getId();
            this.inputName = this.job.getInputName();
            this.outputName = this.job.getOutputName();
            this.errorName = this.job.getErrorName();
            this.workDirectory = this.job.getWorkDirectoryName();
            this.environment = this.job.getEnvironment();
            File dir = null;
            if (this.workDirectory != null) {
                dir = new File(this.workDirectory);
            }
            String[] env = null;
            if (this.environment != null) {
                env = this.stringTokenise(this.environment);
            }
            this.command = this.clFactory.createCommandLine(this.job);
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(this.command, env, dir);
            this.job.setStatus(this.statusDAO.readStatusById(3));
            cat.info((Object)("Running Job [" + this.jobId + "] command '" + this.command + "'"));
            Thread inEmptier = null;
            Thread outEmptier = null;
            Thread errEmptier = null;
            if (this.inputName != null) {
                File stdinFile = null;
                stdinFile = dir != null ? new File(dir, this.inputName) : new File(this.inputName);
                FileInputStream stdinFileStream = new FileInputStream(stdinFile);
                inEmptier = new BufferedStreamEmptier(stdinFileStream, process.getOutputStream());
                inEmptier.start();
            }
            if (this.outputName != null) {
                File stdoutFile = null;
                stdoutFile = dir != null ? new File(dir, this.outputName) : new File(this.outputName);
                FileOutputStream stdoutFileStream = new FileOutputStream(stdoutFile);
                outEmptier = new BufferedStreamEmptier(process.getInputStream(), stdoutFileStream);
                outEmptier.start();
            }
            if (this.errorName != null) {
                File stderrFile = null;
                stderrFile = dir != null ? new File(dir, this.errorName) : new File(this.errorName);
                FileOutputStream stderrFileStream = new FileOutputStream(stderrFile);
                errEmptier = new BufferedStreamEmptier(process.getErrorStream(), stderrFileStream);
                errEmptier.start();
            }
            int exitValue = process.waitFor();
            if (inEmptier != null) {
                inEmptier.join();
            }
            if (outEmptier != null) {
                outEmptier.join();
            }
            if (errEmptier != null) {
                errEmptier.join();
            }
            this.job.setExitValue(exitValue);
            if (exitValue == 0) {
                this.job.setStatus(this.statusDAO.readStatusById(4));
            } else {
                this.job.setStatus(this.statusDAO.readStatusById(5));
            }
            cat.info((Object)("Completed Job [" + this.jobId + "] command '" + this.command + "' with exit value " + exitValue));
        }
        catch (Exception e1) {
            cat.error((Object)"Caught Exception while running", (Throwable)e1);
            try {
                if (this.job != null) {
                    this.job.setStatus(this.statusDAO.readStatusById(5));
                }
            }
            catch (Exception e2) {
                cat.error((Object)"Caught Exception while failing Job", (Throwable)e2);
            }
        }
        finally {
            Object process = null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

