/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.jcon.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TreeMap;
import uk.ac.sanger.jcon.JobControlException;

public class UserConfiguration {
    public static final String PROTOCOL_NAME_KEY = "protocol.name";
    public static final String PROTOCOL_DESC_KEY = "protocol.description";
    public static final String JOB_DEF_KEY = "job";
    public static final int MAX_PROTOCOL_NAME_LEN = 32;
    public static final int MAX_PROTOCOL_DESC_LEN = 255;
    private ResourceBundle bundle;
    private Map jobDefs;

    public UserConfiguration(ResourceBundle bundle) throws JobControlException {
        this.bundle = bundle;
        this.jobDefs = this.initConfiguration();
    }

    public String getProtocolName() throws JobControlException {
        String name = null;
        try {
            name = this.bundle.getString(PROTOCOL_NAME_KEY);
            if (name.length() > 32) {
                throw new JobControlException("Protocol name '" + name + "' exceeds maximum permitted length of " + 32 + " characters");
            }
            for (int i = 0; i < name.length(); ++i) {
                if (name.charAt(i) == '_' || name.charAt(i) == '-' || Character.isLetterOrDigit(name.charAt(i))) continue;
                throw new JobControlException("Protocol name '" + name + "' contained an illegal character '" + name.charAt(i) + "'");
            }
        }
        catch (MissingResourceException mre) {
            throw new JobControlException("Protocol name under key 'protocol.name' missing from user configuration");
        }
        return name;
    }

    public String getProtocolDescription() throws JobControlException {
        String desc = null;
        try {
            desc = this.bundle.getString(PROTOCOL_DESC_KEY);
            if (desc.length() > 255) {
                throw new JobControlException("Protocol description '" + desc + "' exceeds maximum permitted length of " + 255 + " characters");
            }
        }
        catch (MissingResourceException mre) {
            throw new JobControlException("Protocol description under key 'protocol.description' missing from user configuration");
        }
        return desc;
    }

    public List getJobPrecedenceList() {
        ArrayList precedence = new ArrayList(this.jobDefs.size());
        precedence.addAll(this.jobDefs.keySet());
        return precedence;
    }

    public int getExecutableId(int jobDefIndex) {
        boolean id = false;
        Integer i = new Integer(jobDefIndex);
        if (!this.jobDefs.containsKey(i)) {
            throw new IllegalArgumentException("There is no job definition '" + jobDefIndex + "' in this user configuration.");
        }
        return ((JobDef)this.jobDefs.get(i)).getExecutableId();
    }

    public int getMaxRetryCount(int jobDefIndex) {
        boolean count = false;
        Integer i = new Integer(jobDefIndex);
        if (!this.jobDefs.containsKey(i)) {
            throw new IllegalArgumentException("There is no job definition '" + jobDefIndex + "' in this user configuration.");
        }
        return ((JobDef)this.jobDefs.get(i)).getMaxRetryCount();
    }

    public String getTemplate(int jobDefIndex) {
        String template = "";
        Integer i = new Integer(jobDefIndex);
        if (!this.jobDefs.containsKey(i)) {
            throw new IllegalArgumentException("There is no job definition '" + jobDefIndex + "' in this user configuration.");
        }
        return ((JobDef)this.jobDefs.get(i)).getTemplate();
    }

    private Map initConfiguration() throws JobControlException {
        TreeMap<Integer, JobDef> jobDefs = new TreeMap<Integer, JobDef>();
        Enumeration<String> keys = this.bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (!key.startsWith(JOB_DEF_KEY)) continue;
            String val = null;
            try {
                val = this.bundle.getString(key);
            }
            catch (MissingResourceException mre) {
                throw new JobControlException("Definition of job '" + key + "' missing from user configuration");
            }
            int keyDelim = key.indexOf(".");
            if (keyDelim == -1) {
                throw new JobControlException("Definition of job '" + key + "' contains a syntax error");
            }
            String precedenceKey = key.substring(keyDelim + 1);
            StringTokenizer st = new StringTokenizer(val, ":");
            int tokenCount = st.countTokens();
            if (tokenCount < 2 || tokenCount > 3) {
                throw new JobControlException("Definition of job '" + key + "' contains a syntax error");
            }
            int jobPrecedence = 0;
            int executableId = 0;
            int maxRetryCount = 0;
            StringBuffer template = new StringBuffer("$executable");
            String[] tokens = new String[tokenCount];
            for (int i = 0; i < tokenCount; ++i) {
                tokens[i] = st.nextToken().trim();
            }
            try {
                jobPrecedence = Integer.parseInt(precedenceKey);
                executableId = Integer.parseInt(tokens[0]);
                maxRetryCount = Integer.parseInt(tokens[1]);
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
                throw new JobControlException("Definition of job '" + key + "' contains a syntax error");
            }
            if (tokenCount == 3) {
                template.append(" ");
                template.append(tokens[2]);
            }
            jobDefs.put(new Integer(jobPrecedence), new JobDef(executableId, maxRetryCount, template.substring(0)));
        }
        return jobDefs;
    }

    private static class JobDef {
        int execId;
        int maxRetryCount;
        String template;

        JobDef(int execId, int maxRetryCount, String template) {
            this.execId = execId;
            this.maxRetryCount = maxRetryCount;
            this.template = template;
        }

        int getExecutableId() {
            return this.execId;
        }

        int getMaxRetryCount() {
            return this.maxRetryCount;
        }

        String getTemplate() {
            return this.template;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("<Job def: ");
            sb.append("execId ");
            sb.append(this.execId);
            sb.append("; maxRetryCount ");
            sb.append(this.maxRetryCount);
            sb.append("; template ");
            sb.append(this.template);
            sb.append(">");
            return sb.substring(0);
        }
    }
}

