/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.statistics;

import JSci.maths.SpecialMath;
import JSci.maths.statistics.OutOfRangeException;
import JSci.maths.statistics.ProbabilityDistribution;

public final class TDistribution
extends ProbabilityDistribution {
    private int dgrFreedom;
    private double logPdfFreedom;

    public TDistribution(int n) {
        if (n <= 0) {
            throw new OutOfRangeException("The degrees of freedom must be greater than zero.");
        }
        this.dgrFreedom = n;
        this.logPdfFreedom = -SpecialMath.logBeta((double)(0.5 * (double)this.dgrFreedom), (double)0.5) - 0.5 * Math.log(this.dgrFreedom);
    }

    public int getDegreesOfFreedom() {
        return this.dgrFreedom;
    }

    public double probability(double d) {
        double d2 = this.logPdfFreedom;
        return Math.exp(d2 -= 0.5 * (double)(this.dgrFreedom + 1) * Math.log(1.0 + d * d / (double)this.dgrFreedom));
    }

    public double cumulative(double d) {
        double d2 = 0.5 * SpecialMath.incompleteBeta((double)((double)this.dgrFreedom / ((double)this.dgrFreedom + d * d)), (double)(0.5 * (double)this.dgrFreedom), (double)0.5);
        return d > 0.0 ? 1.0 - d2 : d2;
    }

    public double inverse(double d) {
        this.checkRange(d);
        if (d == 0.0) {
            return -1.7976931348623157E308;
        }
        if (d == 1.0) {
            return Double.MAX_VALUE;
        }
        if (d == 0.5) {
            return 0.0;
        }
        return this.findRoot(d, 0.0, -8.988465674311579E307, 8.988465674311579E307);
    }
}

