/*
 * Decompiled with CFR 0.152.
 */
package Jama.test;

import Jama.CholeskyDecomposition;
import Jama.EigenvalueDecomposition;
import Jama.LUDecomposition;
import Jama.Matrix;
import Jama.QRDecomposition;
import Jama.SingularValueDecomposition;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

public class TestMatrix {
    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        Matrix matrix;
        Matrix matrix2;
        double d;
        Matrix matrix3;
        double[][] dArrayArray;
        int n = 0;
        int n2 = 0;
        double[] dArray = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0};
        double[] dArray2 = new double[]{1.0, 4.0, 7.0, 10.0, 2.0, 5.0, 8.0, 11.0, 3.0, 6.0, 9.0, 12.0};
        double[][] dArrayArray2 = dArrayArray = new double[][]{{1.0, 4.0, 7.0, 10.0}, {2.0, 5.0, 8.0, 11.0}, {3.0, 6.0, 9.0, 12.0}};
        double[][] dArrayArray3 = new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}, {7.0, 8.0, 9.0}, {10.0, 11.0, 12.0}};
        double[][] dArrayArray4 = new double[][]{{5.0, 8.0, 11.0}, {6.0, 9.0, 12.0}};
        double[][] dArrayArray5 = new double[][]{{1.0, 4.0, 7.0}, {2.0, 5.0, 8.0, 11.0}, {3.0, 6.0, 9.0, 12.0}};
        double[][] dArrayArray6 = new double[][]{{1.0, 1.0, 1.0}, {1.0, 2.0, 3.0}, {1.0, 3.0, 6.0}};
        double[][] dArrayArray7 = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}};
        double[][] dArrayArray8 = new double[][]{{0.0, 1.0, 0.0, 0.0}, {1.0, 0.0, 2.0E-7, 0.0}, {0.0, -2.0E-7, 0.0, 1.0}, {0.0, 0.0, 1.0, 0.0}};
        double[][] dArrayArray9 = new double[][]{{166.0, 188.0, 210.0}, {188.0, 214.0, 240.0}, {210.0, 240.0, 270.0}};
        double[][] dArrayArray10 = new double[][]{{13.0}, {15.0}};
        double[][] dArrayArray11 = new double[][]{{1.0, 3.0}, {7.0, 9.0}};
        int n3 = 3;
        int n4 = 4;
        int n5 = 5;
        int n6 = 0;
        int n7 = 4;
        int n8 = 3;
        int n9 = 4;
        int n10 = 1;
        int n11 = 2;
        int n12 = 1;
        int n13 = 3;
        int[] nArray = new int[]{1, 2};
        int[] nArray2 = new int[]{1, 3};
        int[] nArray3 = new int[]{1, 2, 3};
        int[] nArray4 = new int[]{1, 2, 4};
        double d2 = 33.0;
        double d3 = 30.0;
        double d4 = 15.0;
        double d5 = 650.0;
        TestMatrix.print("\nTesting constructors and constructor-like methods...\n");
        try {
            matrix3 = new Matrix(dArray, n5);
            n = TestMatrix.try_failure(n, "Catch invalid length in packed constructor... ", "exception not thrown for invalid input");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TestMatrix.try_success("Catch invalid length in packed constructor... ", illegalArgumentException.getMessage());
        }
        try {
            matrix3 = new Matrix(dArrayArray5);
            d = matrix3.get(n6, n7);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TestMatrix.try_success("Catch ragged input to default constructor... ", illegalArgumentException.getMessage());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            n = TestMatrix.try_failure(n, "Catch ragged input to constructor... ", "exception not thrown in construction...ArrayIndexOutOfBoundsException thrown later");
        }
        try {
            matrix3 = Matrix.constructWithCopy(dArrayArray5);
            d = matrix3.get(n6, n7);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TestMatrix.try_success("Catch ragged input to constructWithCopy... ", illegalArgumentException.getMessage());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            n = TestMatrix.try_failure(n, "Catch ragged input to constructWithCopy... ", "exception not thrown in construction...ArrayIndexOutOfBoundsException thrown later");
        }
        matrix3 = new Matrix(dArray, n8);
        Matrix matrix4 = new Matrix(dArrayArray);
        d = matrix4.get(0, 0);
        dArrayArray[0][0] = 0.0;
        Matrix matrix5 = matrix4.minus(matrix3);
        dArrayArray[0][0] = d;
        matrix4 = Matrix.constructWithCopy(dArrayArray);
        d = matrix4.get(0, 0);
        dArrayArray[0][0] = 0.0;
        if (d - matrix4.get(0, 0) != 0.0) {
            n = TestMatrix.try_failure(n, "constructWithCopy... ", "copy not effected... data visible outside");
        } else {
            TestMatrix.try_success("constructWithCopy... ", "");
        }
        dArrayArray[0][0] = dArray[0];
        Matrix matrix6 = new Matrix(dArrayArray7);
        try {
            TestMatrix.check(matrix6, Matrix.identity(3, 4));
            TestMatrix.try_success("identity... ", "");
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "identity... ", "identity Matrix not successfully created");
        }
        TestMatrix.print("\nTesting access methods...\n");
        matrix4 = new Matrix(dArrayArray);
        if (matrix4.getRowDimension() != n3) {
            n = TestMatrix.try_failure(n, "getRowDimension... ", "");
        } else {
            TestMatrix.try_success("getRowDimension... ", "");
        }
        if (matrix4.getColumnDimension() != n4) {
            n = TestMatrix.try_failure(n, "getColumnDimension... ", "");
        } else {
            TestMatrix.try_success("getColumnDimension... ", "");
        }
        matrix4 = new Matrix(dArrayArray);
        double[][] dArray3 = matrix4.getArray();
        if (dArray3 != dArrayArray) {
            n = TestMatrix.try_failure(n, "getArray... ", "");
        } else {
            TestMatrix.try_success("getArray... ", "");
        }
        dArray3 = matrix4.getArrayCopy();
        if (dArray3 == dArrayArray) {
            n = TestMatrix.try_failure(n, "getArrayCopy... ", "data not (deep) copied");
        }
        try {
            TestMatrix.check(dArray3, dArrayArray);
            TestMatrix.try_success("getArrayCopy... ", "");
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "getArrayCopy... ", "data not successfully (deep) copied");
        }
        double[] dArray4 = matrix4.getColumnPackedCopy();
        try {
            TestMatrix.check(dArray4, dArray);
            TestMatrix.try_success("getColumnPackedCopy... ", "");
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "getColumnPackedCopy... ", "data not successfully (deep) copied by columns");
        }
        dArray4 = matrix4.getRowPackedCopy();
        try {
            TestMatrix.check(dArray4, dArray2);
            TestMatrix.try_success("getRowPackedCopy... ", "");
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "getRowPackedCopy... ", "data not successfully (deep) copied by rows");
        }
        try {
            d = matrix4.get(matrix4.getRowDimension(), matrix4.getColumnDimension() - 1);
            n = TestMatrix.try_failure(n, "get(int,int)... ", "OutOfBoundsException expected but not thrown");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            try {
                d = matrix4.get(matrix4.getRowDimension() - 1, matrix4.getColumnDimension());
                n = TestMatrix.try_failure(n, "get(int,int)... ", "OutOfBoundsException expected but not thrown");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2) {
                TestMatrix.try_success("get(int,int)... OutofBoundsException... ", "");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            n = TestMatrix.try_failure(n, "get(int,int)... ", "OutOfBoundsException expected but not thrown");
        }
        try {
            if (matrix4.get(matrix4.getRowDimension() - 1, matrix4.getColumnDimension() - 1) != dArrayArray[matrix4.getRowDimension() - 1][matrix4.getColumnDimension() - 1]) {
                n = TestMatrix.try_failure(n, "get(int,int)... ", "Matrix entry (i,j) not successfully retreived");
            } else {
                TestMatrix.try_success("get(int,int)... ", "");
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            n = TestMatrix.try_failure(n, "get(int,int)... ", "Unexpected ArrayIndexOutOfBoundsException");
        }
        Matrix matrix7 = new Matrix(dArrayArray4);
        try {
            matrix2 = matrix4.getMatrix(n10, n11 + matrix4.getRowDimension() + 1, n12, n13);
            n = TestMatrix.try_failure(n, "getMatrix(int,int,int,int)... ", "ArrayIndexOutOfBoundsException expected but not thrown");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            try {
                matrix2 = matrix4.getMatrix(n10, n11, n12, n13 + matrix4.getColumnDimension() + 1);
                n = TestMatrix.try_failure(n, "getMatrix(int,int,int,int)... ", "ArrayIndexOutOfBoundsException expected but not thrown");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException3) {
                TestMatrix.try_success("getMatrix(int,int,int,int)... ArrayIndexOutOfBoundsException... ", "");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            n = TestMatrix.try_failure(n, "getMatrix(int,int,int,int)... ", "ArrayIndexOutOfBoundsException expected but not thrown");
        }
        try {
            matrix2 = matrix4.getMatrix(n10, n11, n12, n13);
            try {
                TestMatrix.check(matrix7, matrix2);
                TestMatrix.try_success("getMatrix(int,int,int,int)... ", "");
            }
            catch (RuntimeException runtimeException) {
                n = TestMatrix.try_failure(n, "getMatrix(int,int,int,int)... ", "submatrix not successfully retreived");
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            n = TestMatrix.try_failure(n, "getMatrix(int,int,int,int)... ", "Unexpected ArrayIndexOutOfBoundsException");
        }
        try {
            matrix2 = matrix4.getMatrix(n10, n11, nArray4);
            n = TestMatrix.try_failure(n, "getMatrix(int,int,int[])... ", "ArrayIndexOutOfBoundsException expected but not thrown");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            try {
                matrix2 = matrix4.getMatrix(n10, n11 + matrix4.getRowDimension() + 1, nArray3);
                n = TestMatrix.try_failure(n, "getMatrix(int,int,int[])... ", "ArrayIndexOutOfBoundsException expected but not thrown");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException4) {
                TestMatrix.try_success("getMatrix(int,int,int[])... ArrayIndexOutOfBoundsException... ", "");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            n = TestMatrix.try_failure(n, "getMatrix(int,int,int[])... ", "ArrayIndexOutOfBoundsException expected but not thrown");
        }
        try {
            matrix2 = matrix4.getMatrix(n10, n11, nArray3);
            try {
                TestMatrix.check(matrix7, matrix2);
                TestMatrix.try_success("getMatrix(int,int,int[])... ", "");
            }
            catch (RuntimeException runtimeException) {
                n = TestMatrix.try_failure(n, "getMatrix(int,int,int[])... ", "submatrix not successfully retreived");
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            n = TestMatrix.try_failure(n, "getMatrix(int,int,int[])... ", "Unexpected ArrayIndexOutOfBoundsException");
        }
        try {
            matrix2 = matrix4.getMatrix(nArray2, n12, n13);
            n = TestMatrix.try_failure(n, "getMatrix(int[],int,int)... ", "ArrayIndexOutOfBoundsException expected but not thrown");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            try {
                matrix2 = matrix4.getMatrix(nArray, n12, n13 + matrix4.getColumnDimension() + 1);
                n = TestMatrix.try_failure(n, "getMatrix(int[],int,int)... ", "ArrayIndexOutOfBoundsException expected but not thrown");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException5) {
                TestMatrix.try_success("getMatrix(int[],int,int)... ArrayIndexOutOfBoundsException... ", "");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            n = TestMatrix.try_failure(n, "getMatrix(int[],int,int)... ", "ArrayIndexOutOfBoundsException expected but not thrown");
        }
        try {
            matrix2 = matrix4.getMatrix(nArray, n12, n13);
            try {
                TestMatrix.check(matrix7, matrix2);
                TestMatrix.try_success("getMatrix(int[],int,int)... ", "");
            }
            catch (RuntimeException runtimeException) {
                n = TestMatrix.try_failure(n, "getMatrix(int[],int,int)... ", "submatrix not successfully retreived");
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            n = TestMatrix.try_failure(n, "getMatrix(int[],int,int)... ", "Unexpected ArrayIndexOutOfBoundsException");
        }
        try {
            matrix2 = matrix4.getMatrix(nArray2, nArray3);
            n = TestMatrix.try_failure(n, "getMatrix(int[],int[])... ", "ArrayIndexOutOfBoundsException expected but not thrown");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            try {
                matrix2 = matrix4.getMatrix(nArray, nArray4);
                n = TestMatrix.try_failure(n, "getMatrix(int[],int[])... ", "ArrayIndexOutOfBoundsException expected but not thrown");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException6) {
                TestMatrix.try_success("getMatrix(int[],int[])... ArrayIndexOutOfBoundsException... ", "");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            n = TestMatrix.try_failure(n, "getMatrix(int[],int[])... ", "ArrayIndexOutOfBoundsException expected but not thrown");
        }
        try {
            matrix2 = matrix4.getMatrix(nArray, nArray3);
            try {
                TestMatrix.check(matrix7, matrix2);
                TestMatrix.try_success("getMatrix(int[],int[])... ", "");
            }
            catch (RuntimeException runtimeException) {
                n = TestMatrix.try_failure(n, "getMatrix(int[],int[])... ", "submatrix not successfully retreived");
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            n = TestMatrix.try_failure(n, "getMatrix(int[],int[])... ", "Unexpected ArrayIndexOutOfBoundsException");
        }
        try {
            matrix4.set(matrix4.getRowDimension(), matrix4.getColumnDimension() - 1, 0.0);
            n = TestMatrix.try_failure(n, "set(int,int,double)... ", "OutOfBoundsException expected but not thrown");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            try {
                matrix4.set(matrix4.getRowDimension() - 1, matrix4.getColumnDimension(), 0.0);
                n = TestMatrix.try_failure(n, "set(int,int,double)... ", "OutOfBoundsException expected but not thrown");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException7) {
                TestMatrix.try_success("set(int,int,double)... OutofBoundsException... ", "");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            n = TestMatrix.try_failure(n, "set(int,int,double)... ", "OutOfBoundsException expected but not thrown");
        }
        try {
            matrix4.set(n10, n12, 0.0);
            d = matrix4.get(n10, n12);
            try {
                TestMatrix.check(d, 0.0);
                TestMatrix.try_success("set(int,int,double)... ", "");
            }
            catch (RuntimeException runtimeException) {
                n = TestMatrix.try_failure(n, "set(int,int,double)... ", "Matrix element not successfully set");
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            n = TestMatrix.try_failure(n, "set(int,int,double)... ", "Unexpected ArrayIndexOutOfBoundsException");
        }
        matrix2 = new Matrix(2, 3, 0.0);
        try {
            matrix4.setMatrix(n10, n11 + matrix4.getRowDimension() + 1, n12, n13, matrix2);
            n = TestMatrix.try_failure(n, "setMatrix(int,int,int,int,Matrix)... ", "ArrayIndexOutOfBoundsException expected but not thrown");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            try {
                matrix4.setMatrix(n10, n11, n12, n13 + matrix4.getColumnDimension() + 1, matrix2);
                n = TestMatrix.try_failure(n, "setMatrix(int,int,int,int,Matrix)... ", "ArrayIndexOutOfBoundsException expected but not thrown");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException8) {
                TestMatrix.try_success("setMatrix(int,int,int,int,Matrix)... ArrayIndexOutOfBoundsException... ", "");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            n = TestMatrix.try_failure(n, "setMatrix(int,int,int,int,Matrix)... ", "ArrayIndexOutOfBoundsException expected but not thrown");
        }
        try {
            matrix4.setMatrix(n10, n11, n12, n13, matrix2);
            try {
                TestMatrix.check(matrix2.minus(matrix4.getMatrix(n10, n11, n12, n13)), matrix2);
                TestMatrix.try_success("setMatrix(int,int,int,int,Matrix)... ", "");
            }
            catch (RuntimeException runtimeException) {
                n = TestMatrix.try_failure(n, "setMatrix(int,int,int,int,Matrix)... ", "submatrix not successfully set");
            }
            matrix4.setMatrix(n10, n11, n12, n13, matrix7);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            n = TestMatrix.try_failure(n, "setMatrix(int,int,int,int,Matrix)... ", "Unexpected ArrayIndexOutOfBoundsException");
        }
        try {
            matrix4.setMatrix(n10, n11 + matrix4.getRowDimension() + 1, nArray3, matrix2);
            n = TestMatrix.try_failure(n, "setMatrix(int,int,int[],Matrix)... ", "ArrayIndexOutOfBoundsException expected but not thrown");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            try {
                matrix4.setMatrix(n10, n11, nArray4, matrix2);
                n = TestMatrix.try_failure(n, "setMatrix(int,int,int[],Matrix)... ", "ArrayIndexOutOfBoundsException expected but not thrown");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException9) {
                TestMatrix.try_success("setMatrix(int,int,int[],Matrix)... ArrayIndexOutOfBoundsException... ", "");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            n = TestMatrix.try_failure(n, "setMatrix(int,int,int[],Matrix)... ", "ArrayIndexOutOfBoundsException expected but not thrown");
        }
        try {
            matrix4.setMatrix(n10, n11, nArray3, matrix2);
            try {
                TestMatrix.check(matrix2.minus(matrix4.getMatrix(n10, n11, nArray3)), matrix2);
                TestMatrix.try_success("setMatrix(int,int,int[],Matrix)... ", "");
            }
            catch (RuntimeException runtimeException) {
                n = TestMatrix.try_failure(n, "setMatrix(int,int,int[],Matrix)... ", "submatrix not successfully set");
            }
            matrix4.setMatrix(n10, n11, n12, n13, matrix7);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            n = TestMatrix.try_failure(n, "setMatrix(int,int,int[],Matrix)... ", "Unexpected ArrayIndexOutOfBoundsException");
        }
        try {
            matrix4.setMatrix(nArray, n12, n13 + matrix4.getColumnDimension() + 1, matrix2);
            n = TestMatrix.try_failure(n, "setMatrix(int[],int,int,Matrix)... ", "ArrayIndexOutOfBoundsException expected but not thrown");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            try {
                matrix4.setMatrix(nArray2, n12, n13, matrix2);
                n = TestMatrix.try_failure(n, "setMatrix(int[],int,int,Matrix)... ", "ArrayIndexOutOfBoundsException expected but not thrown");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException10) {
                TestMatrix.try_success("setMatrix(int[],int,int,Matrix)... ArrayIndexOutOfBoundsException... ", "");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            n = TestMatrix.try_failure(n, "setMatrix(int[],int,int,Matrix)... ", "ArrayIndexOutOfBoundsException expected but not thrown");
        }
        try {
            matrix4.setMatrix(nArray, n12, n13, matrix2);
            try {
                TestMatrix.check(matrix2.minus(matrix4.getMatrix(nArray, n12, n13)), matrix2);
                TestMatrix.try_success("setMatrix(int[],int,int,Matrix)... ", "");
            }
            catch (RuntimeException runtimeException) {
                n = TestMatrix.try_failure(n, "setMatrix(int[],int,int,Matrix)... ", "submatrix not successfully set");
            }
            matrix4.setMatrix(n10, n11, n12, n13, matrix7);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            n = TestMatrix.try_failure(n, "setMatrix(int[],int,int,Matrix)... ", "Unexpected ArrayIndexOutOfBoundsException");
        }
        try {
            matrix4.setMatrix(nArray, nArray4, matrix2);
            n = TestMatrix.try_failure(n, "setMatrix(int[],int[],Matrix)... ", "ArrayIndexOutOfBoundsException expected but not thrown");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            try {
                matrix4.setMatrix(nArray2, nArray3, matrix2);
                n = TestMatrix.try_failure(n, "setMatrix(int[],int[],Matrix)... ", "ArrayIndexOutOfBoundsException expected but not thrown");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException11) {
                TestMatrix.try_success("setMatrix(int[],int[],Matrix)... ArrayIndexOutOfBoundsException... ", "");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            n = TestMatrix.try_failure(n, "setMatrix(int[],int[],Matrix)... ", "ArrayIndexOutOfBoundsException expected but not thrown");
        }
        try {
            matrix4.setMatrix(nArray, nArray3, matrix2);
            try {
                TestMatrix.check(matrix2.minus(matrix4.getMatrix(nArray, nArray3)), matrix2);
                TestMatrix.try_success("setMatrix(int[],int[],Matrix)... ", "");
            }
            catch (RuntimeException runtimeException) {
                n = TestMatrix.try_failure(n, "setMatrix(int[],int[],Matrix)... ", "submatrix not successfully set");
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            n = TestMatrix.try_failure(n, "setMatrix(int[],int[],Matrix)... ", "Unexpected ArrayIndexOutOfBoundsException");
        }
        TestMatrix.print("\nTesting array-like methods...\n");
        Matrix matrix8 = new Matrix(dArray, n9);
        matrix3 = matrix = Matrix.random(matrix3.getRowDimension(), matrix3.getColumnDimension());
        try {
            matrix8 = matrix3.minus(matrix8);
            n = TestMatrix.try_failure(n, "minus conformance check... ", "nonconformance not raised");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TestMatrix.try_success("minus conformance check... ", "");
        }
        if (matrix3.minus(matrix).norm1() != 0.0) {
            n = TestMatrix.try_failure(n, "minus... ", "(difference of identical Matrices is nonzero,\nSubsequent use of minus should be suspect)");
        } else {
            TestMatrix.try_success("minus... ", "");
        }
        matrix3 = matrix.copy();
        matrix3.minusEquals(matrix);
        Matrix matrix9 = new Matrix(matrix3.getRowDimension(), matrix3.getColumnDimension());
        try {
            matrix3.minusEquals(matrix8);
            n = TestMatrix.try_failure(n, "minusEquals conformance check... ", "nonconformance not raised");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TestMatrix.try_success("minusEquals conformance check... ", "");
        }
        if (matrix3.minus(matrix9).norm1() != 0.0) {
            n = TestMatrix.try_failure(n, "minusEquals... ", "(difference of identical Matrices is nonzero,\nSubsequent use of minus should be suspect)");
        } else {
            TestMatrix.try_success("minusEquals... ", "");
        }
        matrix3 = matrix.copy();
        matrix4 = Matrix.random(matrix3.getRowDimension(), matrix3.getColumnDimension());
        matrix5 = matrix3.minus(matrix4);
        try {
            matrix8 = matrix3.plus(matrix8);
            n = TestMatrix.try_failure(n, "plus conformance check... ", "nonconformance not raised");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TestMatrix.try_success("plus conformance check... ", "");
        }
        try {
            TestMatrix.check(matrix5.plus(matrix4), matrix3);
            TestMatrix.try_success("plus... ", "");
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "plus... ", "(C = A - B, but C + B != A)");
        }
        matrix5 = matrix3.minus(matrix4);
        matrix5.plusEquals(matrix4);
        try {
            matrix3.plusEquals(matrix8);
            n = TestMatrix.try_failure(n, "plusEquals conformance check... ", "nonconformance not raised");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TestMatrix.try_success("plusEquals conformance check... ", "");
        }
        try {
            TestMatrix.check(matrix5, matrix3);
            TestMatrix.try_success("plusEquals... ", "");
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "plusEquals... ", "(C = A - B, but C = C + B != A)");
        }
        matrix3 = matrix.uminus();
        try {
            TestMatrix.check(matrix3.plus(matrix), matrix9);
            TestMatrix.try_success("uminus... ", "");
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "uminus... ", "(-A + A != zeros)");
        }
        matrix3 = matrix.copy();
        Matrix matrix10 = new Matrix(matrix3.getRowDimension(), matrix3.getColumnDimension(), 1.0);
        matrix5 = matrix3.arrayLeftDivide(matrix);
        try {
            matrix8 = matrix3.arrayLeftDivide(matrix8);
            n = TestMatrix.try_failure(n, "arrayLeftDivide conformance check... ", "nonconformance not raised");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TestMatrix.try_success("arrayLeftDivide conformance check... ", "");
        }
        try {
            TestMatrix.check(matrix5, matrix10);
            TestMatrix.try_success("arrayLeftDivide... ", "");
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "arrayLeftDivide... ", "(M.\\M != ones)");
        }
        try {
            matrix3.arrayLeftDivideEquals(matrix8);
            n = TestMatrix.try_failure(n, "arrayLeftDivideEquals conformance check... ", "nonconformance not raised");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TestMatrix.try_success("arrayLeftDivideEquals conformance check... ", "");
        }
        matrix3.arrayLeftDivideEquals(matrix);
        try {
            TestMatrix.check(matrix3, matrix10);
            TestMatrix.try_success("arrayLeftDivideEquals... ", "");
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "arrayLeftDivideEquals... ", "(M.\\M != ones)");
        }
        matrix3 = matrix.copy();
        try {
            matrix3.arrayRightDivide(matrix8);
            n = TestMatrix.try_failure(n, "arrayRightDivide conformance check... ", "nonconformance not raised");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TestMatrix.try_success("arrayRightDivide conformance check... ", "");
        }
        matrix5 = matrix3.arrayRightDivide(matrix);
        try {
            TestMatrix.check(matrix5, matrix10);
            TestMatrix.try_success("arrayRightDivide... ", "");
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "arrayRightDivide... ", "(M./M != ones)");
        }
        try {
            matrix3.arrayRightDivideEquals(matrix8);
            n = TestMatrix.try_failure(n, "arrayRightDivideEquals conformance check... ", "nonconformance not raised");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TestMatrix.try_success("arrayRightDivideEquals conformance check... ", "");
        }
        matrix3.arrayRightDivideEquals(matrix);
        try {
            TestMatrix.check(matrix3, matrix10);
            TestMatrix.try_success("arrayRightDivideEquals... ", "");
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "arrayRightDivideEquals... ", "(M./M != ones)");
        }
        matrix3 = matrix.copy();
        matrix4 = Matrix.random(matrix3.getRowDimension(), matrix3.getColumnDimension());
        try {
            matrix8 = matrix3.arrayTimes(matrix8);
            n = TestMatrix.try_failure(n, "arrayTimes conformance check... ", "nonconformance not raised");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TestMatrix.try_success("arrayTimes conformance check... ", "");
        }
        matrix5 = matrix3.arrayTimes(matrix4);
        try {
            TestMatrix.check(matrix5.arrayRightDivideEquals(matrix4), matrix3);
            TestMatrix.try_success("arrayTimes... ", "");
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "arrayTimes... ", "(A = R, C = A.*B, but C./B != A)");
        }
        try {
            matrix3.arrayTimesEquals(matrix8);
            n = TestMatrix.try_failure(n, "arrayTimesEquals conformance check... ", "nonconformance not raised");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TestMatrix.try_success("arrayTimesEquals conformance check... ", "");
        }
        matrix3.arrayTimesEquals(matrix4);
        try {
            TestMatrix.check(matrix3.arrayRightDivideEquals(matrix4), matrix);
            TestMatrix.try_success("arrayTimesEquals... ", "");
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "arrayTimesEquals... ", "(A = R, A = A.*B, but A./B != R)");
        }
        TestMatrix.print("\nTesting I/O methods...\n");
        try {
            object3 = new DecimalFormat("0.0000E00");
            ((DecimalFormat)object3).setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
            object2 = new PrintWriter(new FileOutputStream("JamaTestMatrix.out"));
            matrix3.print((PrintWriter)object2, (NumberFormat)object3, 10);
            ((PrintWriter)object2).close();
            matrix = Matrix.read(new BufferedReader(new FileReader("JamaTestMatrix.out")));
            if (matrix3.minus(matrix).norm1() < 0.001) {
                TestMatrix.try_success("print()/read()...", "");
            } else {
                n = TestMatrix.try_failure(n, "print()/read()...", "Matrix read from file does not match Matrix printed to file");
            }
        }
        catch (IOException iOException) {
            n2 = TestMatrix.try_warning(n2, "print()/read()...", "unexpected I/O error, unable to run print/read test;  check write permission in current directory and retry");
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace(System.out);
                n2 = TestMatrix.try_warning(n2, "print()/read()...", "Formatting error... will try JDK1.1 reformulation...");
                object2 = new DecimalFormat("0.0000");
                object = new PrintWriter(new FileOutputStream("JamaTestMatrix.out"));
                matrix3.print((PrintWriter)object, (NumberFormat)object2, 10);
                ((PrintWriter)object).close();
                matrix = Matrix.read(new BufferedReader(new FileReader("JamaTestMatrix.out")));
                if (matrix3.minus(matrix).norm1() < 0.001) {
                    TestMatrix.try_success("print()/read()...", "");
                } else {
                    n = TestMatrix.try_failure(n, "print()/read() (2nd attempt) ...", "Matrix read from file does not match Matrix printed to file");
                }
            }
            catch (IOException iOException) {
                n2 = TestMatrix.try_warning(n2, "print()/read()...", "unexpected I/O error, unable to run print/read test;  check write permission in current directory and retry");
            }
        }
        matrix = Matrix.random(matrix3.getRowDimension(), matrix3.getColumnDimension());
        object3 = "TMPMATRIX.serial";
        try {
            object2 = new ObjectOutputStream(new FileOutputStream((String)object3));
            ((ObjectOutputStream)object2).writeObject(matrix);
            object = new ObjectInputStream(new FileInputStream((String)object3));
            matrix3 = (Matrix)((ObjectInputStream)object).readObject();
            try {
                TestMatrix.check(matrix3, matrix);
                TestMatrix.try_success("writeObject(Matrix)/readObject(Matrix)...", "");
            }
            catch (RuntimeException runtimeException) {
                n = TestMatrix.try_failure(n, "writeObject(Matrix)/readObject(Matrix)...", "Matrix not serialized correctly");
            }
        }
        catch (IOException iOException) {
            n2 = TestMatrix.try_warning(n2, "writeObject()/readObject()...", "unexpected I/O error, unable to run serialization test;  check write permission in current directory and retry");
        }
        catch (Exception exception) {
            n = TestMatrix.try_failure(n, "writeObject(Matrix)/readObject(Matrix)...", "unexpected error in serialization test");
        }
        TestMatrix.print("\nTesting linear algebra methods...\n");
        matrix3 = new Matrix(dArray, 3);
        Matrix matrix11 = new Matrix(dArrayArray3);
        matrix11 = matrix3.transpose();
        try {
            TestMatrix.check(matrix3.transpose(), matrix11);
            TestMatrix.try_success("transpose...", "");
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "transpose()...", "transpose unsuccessful");
        }
        matrix3.transpose();
        try {
            TestMatrix.check(matrix3.norm1(), d2);
            TestMatrix.try_success("norm1...", "");
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "norm1()...", "incorrect norm calculation");
        }
        try {
            TestMatrix.check(matrix3.normInf(), d3);
            TestMatrix.try_success("normInf()...", "");
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "normInf()...", "incorrect norm calculation");
        }
        try {
            TestMatrix.check(matrix3.normF(), Math.sqrt(d5));
            TestMatrix.try_success("normF...", "");
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "normF()...", "incorrect norm calculation");
        }
        try {
            TestMatrix.check(matrix3.trace(), d4);
            TestMatrix.try_success("trace()...", "");
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "trace()...", "incorrect trace calculation");
        }
        try {
            TestMatrix.check(matrix3.getMatrix(0, matrix3.getRowDimension() - 1, 0, matrix3.getRowDimension() - 1).det(), 0.0);
            TestMatrix.try_success("det()...", "");
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "det()...", "incorrect determinant calculation");
        }
        Matrix matrix12 = new Matrix(dArrayArray9);
        try {
            TestMatrix.check(matrix3.times(matrix3.transpose()), matrix12);
            TestMatrix.try_success("times(Matrix)...", "");
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "times(Matrix)...", "incorrect Matrix-Matrix product calculation");
        }
        try {
            TestMatrix.check(matrix3.times(0.0), matrix9);
            TestMatrix.try_success("times(double)...", "");
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "times(double)...", "incorrect Matrix-scalar product calculation");
        }
        matrix3 = new Matrix(dArray, 4);
        object2 = matrix3.qr();
        matrix = ((QRDecomposition)object2).getR();
        try {
            TestMatrix.check(matrix3, ((QRDecomposition)object2).getQ().times(matrix));
            TestMatrix.try_success("QRDecomposition...", "");
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "QRDecomposition...", "incorrect QR decomposition calculation");
        }
        object = matrix3.svd();
        try {
            TestMatrix.check(matrix3, ((SingularValueDecomposition)object).getU().times(((SingularValueDecomposition)object).getS().times(((SingularValueDecomposition)object).getV().transpose())));
            TestMatrix.try_success("SingularValueDecomposition...", "");
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "SingularValueDecomposition...", "incorrect singular value decomposition calculation");
        }
        Matrix matrix13 = new Matrix(dArrayArray2);
        try {
            TestMatrix.check(matrix13.rank(), Math.min(matrix13.getRowDimension(), matrix13.getColumnDimension()) - 1);
            TestMatrix.try_success("rank()...", "");
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "rank()...", "incorrect rank calculation");
        }
        matrix4 = new Matrix(dArrayArray11);
        object = matrix4.svd();
        double[] dArray5 = ((SingularValueDecomposition)object).getSingularValues();
        try {
            TestMatrix.check(matrix4.cond(), dArray5[0] / dArray5[Math.min(matrix4.getRowDimension(), matrix4.getColumnDimension()) - 1]);
            TestMatrix.try_success("cond()...", "");
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "cond()...", "incorrect condition number calculation");
        }
        int n14 = matrix3.getColumnDimension();
        matrix3 = matrix3.getMatrix(0, n14 - 1, 0, n14 - 1);
        matrix3.set(0, 0, 0.0);
        LUDecomposition lUDecomposition = matrix3.lu();
        try {
            TestMatrix.check(matrix3.getMatrix(lUDecomposition.getPivot(), 0, n14 - 1), lUDecomposition.getL().times(lUDecomposition.getU()));
            TestMatrix.try_success("LUDecomposition...", "");
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "LUDecomposition...", "incorrect LU decomposition calculation");
        }
        Matrix matrix14 = matrix3.inverse();
        try {
            TestMatrix.check(matrix3.times(matrix14), Matrix.identity(3, 3));
            TestMatrix.try_success("inverse()...", "");
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "inverse()...", "incorrect inverse calculation");
        }
        matrix10 = new Matrix(matrix7.getRowDimension(), 1, 1.0);
        Matrix matrix15 = new Matrix(dArrayArray10);
        matrix12 = matrix7.getMatrix(0, matrix7.getRowDimension() - 1, 0, matrix7.getRowDimension() - 1);
        try {
            TestMatrix.check(matrix12.solve(matrix15), matrix10);
            TestMatrix.try_success("solve()...", "");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            n = TestMatrix.try_failure(n, "solve()...", illegalArgumentException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "solve()...", runtimeException.getMessage());
        }
        matrix3 = new Matrix(dArrayArray6);
        CholeskyDecomposition choleskyDecomposition = matrix3.chol();
        Matrix matrix16 = choleskyDecomposition.getL();
        try {
            TestMatrix.check(matrix3, matrix16.times(matrix16.transpose()));
            TestMatrix.try_success("CholeskyDecomposition...", "");
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "CholeskyDecomposition...", "incorrect Cholesky decomposition calculation");
        }
        matrix14 = choleskyDecomposition.solve(Matrix.identity(3, 3));
        try {
            TestMatrix.check(matrix3.times(matrix14), Matrix.identity(3, 3));
            TestMatrix.try_success("CholeskyDecomposition solve()...", "");
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "CholeskyDecomposition solve()...", "incorrect Choleskydecomposition solve calculation");
        }
        EigenvalueDecomposition eigenvalueDecomposition = matrix3.eig();
        Matrix matrix17 = eigenvalueDecomposition.getD();
        Matrix matrix18 = eigenvalueDecomposition.getV();
        try {
            TestMatrix.check(matrix3.times(matrix18), matrix18.times(matrix17));
            TestMatrix.try_success("EigenvalueDecomposition (symmetric)...", "");
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "EigenvalueDecomposition (symmetric)...", "incorrect symmetric Eigenvalue decomposition calculation");
        }
        matrix3 = new Matrix(dArrayArray8);
        eigenvalueDecomposition = matrix3.eig();
        matrix17 = eigenvalueDecomposition.getD();
        matrix18 = eigenvalueDecomposition.getV();
        try {
            TestMatrix.check(matrix3.times(matrix18), matrix18.times(matrix17));
            TestMatrix.try_success("EigenvalueDecomposition (nonsymmetric)...", "");
        }
        catch (RuntimeException runtimeException) {
            n = TestMatrix.try_failure(n, "EigenvalueDecomposition (nonsymmetric)...", "incorrect nonsymmetric Eigenvalue decomposition calculation");
        }
        TestMatrix.print("\nTestMatrix completed.\n");
        TestMatrix.print("Total errors reported: " + Integer.toString(n) + "\n");
        TestMatrix.print("Total warnings reported: " + Integer.toString(n2) + "\n");
    }

    private static void check(double d, double d2) {
        double d3 = Math.pow(2.0, -52.0);
        if (d == 0.0 & Math.abs(d2) < 10.0 * d3) {
            return;
        }
        if (d2 == 0.0 & Math.abs(d) < 10.0 * d3) {
            return;
        }
        if (Math.abs(d - d2) > 10.0 * d3 * Math.max(Math.abs(d), Math.abs(d2))) {
            throw new RuntimeException("The difference x-y is too large: x = " + Double.toString(d) + "  y = " + Double.toString(d2));
        }
    }

    private static void check(double[] dArray, double[] dArray2) {
        if (dArray.length == dArray2.length) {
            for (int i = 0; i < dArray.length; ++i) {
                TestMatrix.check(dArray[i], dArray2[i]);
            }
        } else {
            throw new RuntimeException("Attempt to compare vectors of different lengths");
        }
    }

    private static void check(double[][] dArray, double[][] dArray2) {
        Matrix matrix = new Matrix(dArray);
        Matrix matrix2 = new Matrix(dArray2);
        TestMatrix.check(matrix, matrix2);
    }

    private static void check(Matrix matrix, Matrix matrix2) {
        double d = Math.pow(2.0, -52.0);
        if (matrix.norm1() == 0.0 & matrix2.norm1() < 10.0 * d) {
            return;
        }
        if (matrix2.norm1() == 0.0 & matrix.norm1() < 10.0 * d) {
            return;
        }
        if (matrix.minus(matrix2).norm1() > 1000.0 * d * Math.max(matrix.norm1(), matrix2.norm1())) {
            throw new RuntimeException("The norm of (X-Y) is too large: " + Double.toString(matrix.minus(matrix2).norm1()));
        }
    }

    private static void print(String string) {
        System.out.print(string);
    }

    private static void try_success(String string, String string2) {
        TestMatrix.print(">    " + string + "success\n");
        if (string2 != "") {
            TestMatrix.print(">      Message: " + string2 + "\n");
        }
    }

    private static int try_failure(int n, String string, String string2) {
        TestMatrix.print(">    " + string + "*** failure ***\n>      Message: " + string2 + "\n");
        return ++n;
    }

    private static int try_warning(int n, String string, String string2) {
        TestMatrix.print(">    " + string + "*** warning ***\n>      Message: " + string2 + "\n");
        return ++n;
    }

    private static void print(double[] dArray, int n, int n2) {
        System.out.print("\n");
        new Matrix(dArray, 1).print(n, n2);
        TestMatrix.print("\n");
    }
}

