/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.client;

import ca.ucalgary.bluejay.client.BluejayClient;
import ca.ucalgary.bluejay.client.NewClient;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class PingThread
extends Thread {
    private PropertyChangeListener changeListener;
    private int pollingIntervalSeconds;
    private BluejayClient client;
    private Boolean wasConnected;
    private Boolean isConnected;
    private boolean continueRunning = true;

    public PingThread(PropertyChangeListener propertyChangeListener, int n) {
        this.changeListener = propertyChangeListener;
        this.pollingIntervalSeconds = n;
        this.wasConnected = Boolean.TRUE;
        this.isConnected = Boolean.TRUE;
    }

    public void run() {
        Boolean bl = Boolean.FALSE;
        boolean bl2 = true;
        while (this.continueRunning) {
            try {
                bl = this.pingSuccessful() ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (Exception exception) {
                System.err.println("Exception while pinging server: " + exception);
            }
            if (this.changeListener != null && !bl.equals(this.isConnected)) {
                if (!bl2) {
                    PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "server_connection", this.isConnected, bl);
                    this.changeListener.propertyChange(propertyChangeEvent);
                } else {
                    bl = Boolean.TRUE;
                }
            }
            this.wasConnected = this.isConnected;
            this.isConnected = bl;
            bl = null;
            try {
                if (bl2) {
                    PingThread.sleep(10000L);
                } else {
                    PingThread.sleep(this.pollingIntervalSeconds * 1000);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            bl2 = false;
        }
    }

    private boolean pingSuccessful() {
        boolean bl = false;
        try {
            if (((NewClient)this.changeListener).noOP().equals(NewClient.CONNECTION_STRING)) {
                bl = true;
            } else {
                System.err.println("Ping scores! No response from server.");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public void stopPing() {
        this.continueRunning = false;
    }
}

