/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.client.impl;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.client.DTDElementInstanceFactory;
import ca.ucalgary.bluejay.client.DTDMarkupSpecifier;
import ca.ucalgary.bluejay.client.EventCoordinator;
import ca.ucalgary.bluejay.client.impl.BluejayDTDElementInstance;
import ca.ucalgary.bluejay.client.impl.BluejayEntityResolver;
import ca.ucalgary.bluejay.client.impl.BluejayParser;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.comparison.ComparisonPool;
import ca.ucalgary.bluejay.gui.comparison.Genome;
import ca.ucalgary.bluejay.gui.menu.ComparisonMenuManager;
import ca.ucalgary.bluejay.gui.painter.BluejayContainerElementPainter;
import ca.ucalgary.bluejay.gui.util.CheckNode;
import ca.ucalgary.bluejay.gui.util.DataObject;
import com.simonstl.sax.xlink.XPointerLocator;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.helpers.AttributesImpl;

public class BluejayContentHandler
implements ContentHandler,
ErrorHandler,
DeclHandler {
    private static Logger logger = Logger.getLogger(BluejayContentHandler.class);
    protected DTDMarkupSpecifier[] markups;
    protected BluejayDObjectList dlist;
    protected int approxLocInFile = 0;
    protected Locator docLocator;
    protected EventCoordinator ecoord;
    protected boolean preserve_whitespace;
    protected boolean new_doc;
    protected String default_markup_name;
    protected XPointerLocator xpLoc;
    protected DOMImplementation domImpl;
    protected DefaultTreeModel contextTree;
    protected DTDElementInstance rootDEI;
    protected DTDElementInstance currentDEI;
    protected DTDElementInstance contextDEI;
    protected boolean comment;
    protected String extractFragment;
    protected BluejayParser extractorParser;
    protected boolean isParsingFullDoc;
    protected String topFragmentElementXPtr;
    protected boolean parsingNewData;
    protected boolean isEmbedByReplacing;
    protected int maxCharContentLength;
    protected String embedContext;
    protected static final String NO_NAMESPACE = "";
    protected static final boolean DO_NOT_DRAW = false;
    protected static final boolean PLEASE_DRAW = true;
    protected static final boolean EMBED_BY_REPLACING = true;
    protected static final boolean EMBED_BY_APPENDING = false;
    private static final String XPTR_BEFORE_FRAGMENT = "BEFORE_BEFORE";
    private static final String XPTR_AFTER_FRAGMENT = "AFTER_AFTER";
    private double lenRatio;

    public BluejayContentHandler(BluejayDObjectList bluejayDObjectList, EventCoordinator eventCoordinator, DTDMarkupSpecifier[] dTDMarkupSpecifierArray, DefaultTreeModel defaultTreeModel, boolean bl) {
        this.dlist = bluejayDObjectList;
        this.ecoord = eventCoordinator;
        this.markups = dTDMarkupSpecifierArray;
        this.preserve_whitespace = true;
        this.contextTree = defaultTreeModel;
        this.parsingNewData = bl;
        this.isParsingFullDoc = true;
        this.comment = false;
        this.topFragmentElementXPtr = XPTR_BEFORE_FRAGMENT;
        this.isEmbedByReplacing = true;
        this.maxCharContentLength = Integer.MAX_VALUE;
        this.lenRatio = 1.0;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new BluejayEntityResolver(dTDMarkupSpecifierArray));
            this.domImpl = documentBuilder == null ? GenericDOMImplementation.getDOMImplementation() : documentBuilder.getDOMImplementation();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            logger.warn("No default XML parser available: " + parserConfigurationException);
        }
    }

    public void setExtractionFragment(String string) {
        this.extractFragment = string;
        if (this.extractFragment != null && !NO_NAMESPACE.equals(this.extractFragment)) {
            this.isParsingFullDoc = false;
        }
    }

    public void setExtractionParser(BluejayParser bluejayParser) {
        this.extractorParser = bluejayParser;
    }

    public void clear() {
        this.comment = false;
        if (this.isParsingFullDoc) {
            if (this.parsingNewData && this.contextDEI == null) {
                this.contextTree.setRoot(CheckNode.EMPTY_XML_CHECK_NODE);
            }
            this.dlist.setClear(true);
        }
    }

    public void setContextDTDElementInstance(DTDElementInstance dTDElementInstance) {
        this.contextDEI = dTDElementInstance;
    }

    public DTDElementInstance getContextDTDElementInstance() {
        return this.contextDEI;
    }

    public BluejayDObjectList getDrawingSurface() {
        return this.dlist;
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.currentDEI == null) {
            return;
        }
        DTDElementInstance dTDElementInstance = this.currentDEI;
        int n3 = dTDElementInstance.getCharContentLength();
        if (n3 <= this.maxCharContentLength) {
            Text text = this.dlist.getDocument().createTextNode(new String(cArray, n, n2));
            dTDElementInstance.setCharContentLength(n3 += text.getData().length());
            if (n3 <= this.maxCharContentLength) {
                dTDElementInstance.appendChild(text);
            } else {
                Node node = dTDElementInstance.getFirstChild();
                while (node != null) {
                    if (node instanceof Text) {
                        Text text2 = (Text)node;
                        node = text2.getNextSibling();
                        dTDElementInstance.removeChild(text2);
                        continue;
                    }
                    node = node.getNextSibling();
                }
            }
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        if (this.preserve_whitespace) {
            this.characters(cArray, n, n2);
        }
    }

    public void endDocument() {
        if (this.contextDEI == null) {
            if (this.isParsingFullDoc) {
                this.dlist.setRoot(this.rootDEI);
            } else {
                this.extractorParser.setExtractedNode(this.rootDEI.getFirstChild());
            }
        } else {
            try {
                if (this.isEmbedByReplacing) {
                    Node node = this.contextDEI.getParentNode();
                    node.replaceChild(this.rootDEI.getFirstChild(), this.contextDEI);
                } else {
                    this.contextDEI.appendChild(this.rootDEI.getFirstChild());
                }
            }
            catch (Exception exception) {
                logger.warn(exception.getMessage());
                exception.printStackTrace();
            }
        }
        if (this.isParsingFullDoc && this.parsingNewData || this.contextDEI != null) {
            this.contextTree.setRoot((CheckNode)this.contextTree.getRoot());
        }
        this.rootDEI = null;
        this.currentDEI = null;
        this.contextDEI = null;
        this.xpLoc.endDocument();
        if (this.ecoord != null) {
            logger.info("Finishing BluejayContentHandler");
            this.ecoord.notify(1);
        }
    }

    public void endElement(String string, String string2, String string3) {
        String string4;
        if (this.isParsingFullDoc || this.contextDEI != null) {
            this.approxLocInFile += 100;
            if (this.approxLocInFile % 5000 == 0 && this.dlist.getProgressBar() != null) {
                this.dlist.getProgressBar().setValue(this.approxLocInFile);
            }
        }
        boolean bl = string2 == null || string2.equals(NO_NAMESPACE);
        String string5 = string4 = bl ? string3 : string2;
        if (string2.indexOf("!--") != 0) {
            if (this.currentDEI != null) {
                this.currentDEI.endContent();
            }
            if (this.comment) {
                this.comment = false;
            } else if (this.currentDEI != null) {
                this.currentDEI = (DTDElementInstance)this.currentDEI.getParentNode();
            }
        }
        this.xpLoc.endElement();
    }

    public void preserveWhitespace(boolean bl) {
        this.preserve_whitespace = bl;
    }

    public void processingInstruction(String string, String string2) {
    }

    public void setDocumentLocator(Locator locator) {
        this.docLocator = locator;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        logger.warn("Parsing warning at " + this.whereInDoc() + " in document - " + sAXParseException.getMessage());
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        logger.warn("Parsing error at " + this.whereInDoc() + " in document - " + sAXParseException.getMessage());
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        logger.fatal("Fatal parsing error at " + this.whereInDoc() + " in document - " + sAXParseException.getMessage());
    }

    protected String whereInDoc() {
        String string = this.docLocator == null ? NO_NAMESPACE : "[" + this.docLocator.getLineNumber() + "," + this.docLocator.getColumnNumber() + "] ";
        return string;
    }

    protected void initTree() {
        BluejayContainerElementPainter bluejayContainerElementPainter = new BluejayContainerElementPainter();
        this.rootDEI = new BluejayDTDElementInstance(NO_NAMESPACE, "All", this.dlist.getDocument(), bluejayContainerElementPainter, false, 0, 1.0);
        if (this.isParsingFullDoc) {
            if (this.contextDEI == null) {
                DataObject dataObject = null;
                if (this.parsingNewData) {
                    dataObject = new DataObject(this.rootDEI);
                    CheckNode checkNode = new CheckNode(dataObject);
                    checkNode.setSelected(true);
                    this.contextTree.setRoot(checkNode);
                } else {
                    dataObject = (DataObject)((CheckNode)this.contextTree.getRoot()).getUserObject();
                }
                this.rootDEI.setModelObject(dataObject);
            }
            this.currentDEI = this.rootDEI;
        }
    }

    public void startDocument() {
        if (this.dlist.getProgressBar() != null) {
            this.approxLocInFile = 0;
            this.dlist.getProgressBar().setValue(0);
        }
        if (this.ecoord != null) {
            this.ecoord.notify(0);
        }
        if (this.isParsingFullDoc && this.contextDEI == null) {
            Document document = this.domImpl.createDocument(null, "bluejay_document", null);
            this.dlist.setDocument(document);
        }
        this.initTree();
        this.new_doc = true;
        this.xpLoc = new XPointerLocator();
        logger.debug("### BluejayContentHandler.startDocument(), contextDEI=" + (this.contextDEI == null ? "null" : this.contextDEI.getLabelName() + "@" + this.contextDEI.getXPointer()) + ", isParsingFullDoc=" + this.isParsingFullDoc);
    }

    public void startPrefixMapping(String string, String string2) {
    }

    public void endPrefixMapping(String string) {
    }

    public void skippedEntity(String string) {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        Object object;
        Object object2;
        boolean bl = string2 == null || string2.equals(NO_NAMESPACE);
        String string4 = bl ? string3 : string2;
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        if (ComparisonMenuManager.isComparison && this.dlist.getComparisonPool().getPoolSize() > 1 && string4.equals("contig")) {
            object2 = this.dlist.getComparisonPool();
            object = ((ComparisonPool)object2).getSeqsFromPool().lastElement();
            Genome genome = ((ComparisonPool)object2).getSeqsFromPool().firstElement();
            int n = new Integer(attributes.getValue("length"));
            if (n < 0) {
                ((Genome)object).setCompleteSequence(false);
                n = Math.abs(n);
            }
            this.lenRatio = (double)n / (double)genome.getGenomeLen();
            ((Genome)object).setGenomeLen(n);
            ((Genome)object).setLenRatio(this.lenRatio);
        }
        this.xpLoc.startElement();
        if (string4.indexOf("!--") == 0) {
            this.comment = true;
            return;
        }
        if (string4.indexOf("!DOCTYPE") == 0) {
            logger.debug("Root element of DOCTYPE is " + string4);
            return;
        }
        if (this.new_doc) {
            this.new_doc = false;
            this.default_markup_name = string4;
        }
        object2 = this.xpLoc.getXPointer();
        if (this.isParsingFullDoc || this.isWithinFragment((String)object2, attributes)) {
            object = this.createDTDElementInstance(string, string4, attributesImpl);
            object.setXPointer((String)(this.contextDEI == null ? object2 : this.getXPointerInContext((String)object2)));
            if (this.currentDEI == null) {
                this.currentDEI = this.rootDEI;
            }
            this.currentDEI.appendChild((Node)object);
            this.currentDEI = object;
            if ((this.isParsingFullDoc || this.contextDEI != null) & !ComparisonMenuManager.isComparison) {
                this.setContextTreeElement((DTDElementInstance)object);
            }
        } else {
            this.currentDEI = null;
        }
    }

    protected String getXPointerInContext(String string) {
        if (this.isEmbedByReplacing) {
            int n = string.indexOf("/", 1);
            string = n < 0 ? NO_NAMESPACE : string.substring(n);
        }
        return this.contextDEI.getXPointer() + string;
    }

    protected boolean isWithinFragment(String string, Attributes attributes) {
        boolean bl = false;
        if (XPTR_BEFORE_FRAGMENT.equals(this.topFragmentElementXPtr)) {
            if (string.equals(this.extractFragment) || this.isMatchingFragmentID(attributes)) {
                this.topFragmentElementXPtr = string;
                bl = true;
            }
        } else if (XPTR_AFTER_FRAGMENT.equals(this.topFragmentElementXPtr)) {
            bl = false;
        } else if (string.startsWith(this.topFragmentElementXPtr + "/")) {
            bl = true;
        } else {
            this.topFragmentElementXPtr = XPTR_AFTER_FRAGMENT;
            bl = false;
        }
        return bl;
    }

    protected boolean isMatchingFragmentID(Attributes attributes) {
        boolean bl = false;
        if (attributes != null) {
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                if (!attributes.getLocalName(i).toLowerCase().equals("id") || !attributes.getValue(i).equals(this.extractFragment) || attributes.getURI(i) != null && !NO_NAMESPACE.equals(attributes.getURI(i))) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    protected DTDElementInstance createDTDElementInstance(String string, String string2, Attributes attributes) {
        DTDElementInstance dTDElementInstance = null;
        for (int i = 0; i < this.markups.length && dTDElementInstance == null; ++i) {
            boolean bl;
            boolean bl2 = bl = (string == null || string.length() == 0) && this.markups[i].getMarkupName().equals(this.default_markup_name) || this.markups[i].getNamespaceURI().equals(string);
            if (!bl) continue;
            DTDElementInstanceFactory[] dTDElementInstanceFactoryArray = this.markups[i].getDTDElementInstanceFactories();
            for (int j = 0; j < dTDElementInstanceFactoryArray.length; ++j) {
                if (!dTDElementInstanceFactoryArray[j].getLocalName().equals(string2)) continue;
                if (ComparisonMenuManager.isComparison && this.dlist.getComparisonPool().getPoolSize() > 1) {
                    ComparisonPool comparisonPool = this.dlist.getComparisonPool();
                    int n = comparisonPool.getPoolSize() - 1;
                    dTDElementInstance = dTDElementInstanceFactoryArray[j].createDTDElementInstance(attributes, this.dlist.getDocument(), n, this.lenRatio);
                    break;
                }
                dTDElementInstance = dTDElementInstanceFactoryArray[j].createDTDElementInstance(attributes, this.dlist.getDocument(), 0, 1.0);
                break;
            }
            if (dTDElementInstance != null) continue;
            if (ComparisonMenuManager.isComparison && this.dlist.getComparisonPool().getPoolSize() > 1) {
                ComparisonPool comparisonPool = this.dlist.getComparisonPool();
                int n = comparisonPool.getPoolSize() - 1;
                dTDElementInstance = this.markups[i].getGenericDTDElementInstanceFactory().createDTDElementInstance(string, string2, attributes, this.dlist.getDocument(), n, this.lenRatio);
                continue;
            }
            dTDElementInstance = this.markups[i].getGenericDTDElementInstanceFactory().createDTDElementInstance(string, string2, attributes, this.dlist.getDocument(), 0, 1.0);
        }
        if (dTDElementInstance == null) {
            logger.warn("Found element with unknown namespace \"" + string + "\", name=\"" + string2 + "\"");
            BluejayContainerElementPainter bluejayContainerElementPainter = new BluejayContainerElementPainter();
            dTDElementInstance = new BluejayDTDElementInstance(string, string2, attributes, this.dlist.getDocument(), bluejayContainerElementPainter, false, 0, 1.0);
        }
        return dTDElementInstance;
    }

    protected void setContextTreeElement(DTDElementInstance dTDElementInstance) {
        try {
            Vector<DTDElementInstance> vector = new Vector<DTDElementInstance>();
            Object object = this.currentDEI;
            while (object instanceof DTDElementInstance) {
                vector.add(0, (DTDElementInstance)object);
                object = object.getParentNode();
                if (this.contextDEI == null || object != this.rootDEI) continue;
                object = this.isEmbedByReplacing ? this.contextDEI.getParentNode() : this.contextDEI;
            }
            object = (CheckNode)this.contextTree.getRoot();
            if (((CheckNode)object).isLeaf()) {
                if (!this.parsingNewData) {
                    new Exception("Cannot re-use an empty model tree").printStackTrace();
                    logger.warn("Cannot re-use an empty model tree");
                    return;
                }
                DataObject dataObject = new DataObject(dTDElementInstance);
                dTDElementInstance.setModelObject(dataObject);
                CheckNode checkNode = new CheckNode(dataObject);
                checkNode.setSelected(true);
                ((DefaultMutableTreeNode)object).add(checkNode);
            } else {
                boolean bl = false;
                CheckNode checkNode = null;
                DTDElementInstance dTDElementInstance2 = null;
                int n = 1;
                while (n < vector.size()) {
                    Object object2;
                    dTDElementInstance2 = (DTDElementInstance)vector.elementAt(n);
                    bl = false;
                    checkNode = null;
                    Object object3 = ((DefaultMutableTreeNode)object).children();
                    while (object3.hasMoreElements()) {
                        checkNode = (CheckNode)object3.nextElement();
                        object2 = (DataObject)checkNode.getUserObject();
                        String string = dTDElementInstance2.getNamespaceURI();
                        String string2 = ((DataObject)object2).getNamespaceURI();
                        if (!dTDElementInstance2.getLabelName().equals(((DataObject)object2).getLabelName()) || (string != null || string2 != null) && (string == null || !string.equals(string2))) continue;
                        object = checkNode;
                        bl = true;
                        ++n;
                        break;
                    }
                    if (!bl) {
                        if (!this.parsingNewData) {
                            new Exception("Cannot match element " + dTDElementInstance2.getLocalName() + " to existing model tree").printStackTrace();
                            logger.warn("Cannot match element " + dTDElementInstance2.getLocalName() + " to existing model tree");
                            return;
                        }
                        if (n == vector.size() - 1) {
                            object3 = new DataObject(dTDElementInstance);
                            dTDElementInstance.setModelObject((DataObject)object3);
                            object2 = new CheckNode(object3);
                            ((CheckNode)object2).setSelected(true);
                            ((DefaultMutableTreeNode)object).add((MutableTreeNode)object2);
                            return;
                        }
                        logger.error("ATTEMPTED TO DRAW AN UNDRAWABLE - stuck in the middle of the tree");
                        continue;
                    }
                    if (n != vector.size()) continue;
                    dTDElementInstance.setModelObject((DataObject)checkNode.getUserObject());
                }
            }
            return;
        }
        catch (NullPointerException nullPointerException) {
            logger.warn("setContextTreeElement: NULL ( dei=" + dTDElementInstance + ")");
            nullPointerException.printStackTrace();
            throw nullPointerException;
        }
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
    }

    public void elementDecl(String string, String string2) throws SAXException {
    }

    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
    }

    public void internalEntityDecl(String string, String string2) throws SAXException {
    }

    public void setMaxCharContentLength(int n) {
        this.maxCharContentLength = n;
    }
}

