/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.client.impl;

import ca.ucalgary.bluejay.client.EventCoordinator;
import ca.ucalgary.bluejay.client.IOController;
import ca.ucalgary.bluejay.client.URLDecoder;
import ca.ucalgary.bluejay.gui.menu.ComparisonMenuManager;
import ca.ucalgary.bluejay.gui.util.Debug;
import ca.ucalgary.bluejay.proxy.Converter;
import ca.ucalgary.bluejay.proxy.XSLTransformer;
import com.opensymphony.oscache.base.persistence.CachePersistenceException;
import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.JarURLConnection;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class BluejayIOController
implements IOController {
    private GeneralCacheAdministrator cAdmin;
    private boolean diskCaching = true;
    private String error = "";
    private InetAddress proxy = null;
    private int proxyport = 80;
    private EventCoordinator ecoord = null;
    private String browser_name = "BluejayIOController";
    private long filesize = -1L;
    private Hashtable record_start_stop;
    private boolean caching = false;
    private Hashtable fileNameCache;
    private int totalCacheLength;
    private boolean isSkeletonizing = false;
    private static Logger logger = Logger.getLogger(BluejayIOController.class);

    public BluejayIOController() {
        if (Debug.localCache) {
            this.cAdmin = new GeneralCacheAdministrator();
        }
        this.fileNameCache = new Hashtable();
        this.totalCacheLength = 0;
    }

    public boolean isCaching() {
        return this.caching;
    }

    public boolean isDiskCaching() {
        return this.diskCaching;
    }

    public void setCaching(boolean bl) {
        this.caching = bl;
        if (!this.caching) {
            this.clearCache();
        }
    }

    public void setDiskCaching(boolean bl) {
        this.diskCaching = bl;
    }

    public void clearCache() {
        Enumeration enumeration = this.fileNameCache.keys();
        while (enumeration.hasMoreElements()) {
            File file = (File)this.fileNameCache.get(enumeration.nextElement());
            try {
                file.delete();
            }
            catch (SecurityException securityException) {
                logger.warn("Warning: The Web cache file " + file + " could not be deleted: " + securityException);
            }
        }
        this.fileNameCache.clear();
        this.totalCacheLength = 0;
    }

    public void showCacheGUI(Frame frame) {
        if (!this.caching) {
            int n = JOptionPane.showConfirmDialog(frame, "Re-enable web disk cache? (Recommended to improve browsing speed)", "Web Cache on Disk", 0);
            if (n == 0) {
                this.setCaching(true);
            }
        } else {
            String string = "There are " + this.fileNameCache.size() + " files in the Web cache, occupying approximately " + Math.round(this.totalCacheLength) + "MB of disk space.";
            Object[] objectArray = new String[]{"Clear the cache", "Disable cache (not recommended)", "Cancel"};
            int n = JOptionPane.showOptionDialog(frame, string, "Web Cache on Disk", 1, 1, null, objectArray, objectArray[2]);
            if (n == 0) {
                this.clearCache();
            } else if (n == 1) {
                this.setCaching(false);
            }
        }
    }

    private float getDirSize(File file) {
        float f = 0.0f;
        if (file.exists()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isFile()) {
                    f += (float)fileArray[i].length();
                    continue;
                }
                if (!fileArray[i].isDirectory()) continue;
                f += this.getDirSize(fileArray[i]);
            }
        }
        return f /= 1000.0f;
    }

    public void showDiskCacheGui(Frame frame) {
        if (Debug.localCache) {
            if (!this.diskCaching) {
                int n = JOptionPane.showConfirmDialog(frame, "Re-enable disk cache? (Recommended for offline browsing of bookmarks)", "Disk Cache", 0);
                if (n == 0) {
                    this.setDiskCaching(true);
                }
            } else {
                String string = "The current cache folder size is about " + (int)this.getDirSize(new File(this.cAdmin.getProperty("cache.path"))) + " MB.";
                Object[] objectArray = new String[]{"Clear the cache", "Disable cache (not recommended)", "Cancel"};
                int n = JOptionPane.showOptionDialog(frame, string, "Cache on Disk", 1, 1, null, objectArray, objectArray[2]);
                if (n == 0) {
                    try {
                        this.cAdmin.getCache().getPersistenceListener().clear();
                    }
                    catch (CachePersistenceException cachePersistenceException) {
                        logger.warn("CAHE PERSISTENCE EXCEPTION WHEN DELETING CACHE");
                    }
                } else if (n == 1) {
                    this.setDiskCaching(false);
                }
            }
        }
    }

    public void showProxyGUI(Frame frame) {
    }

    private Reader storeDataToCache(URL uRL, Reader reader) {
        File file = null;
        Object var4_4 = null;
        try {
            file = File.createTempFile("bluejay", ".xml");
            logger.debug("Writing Web data to cache file " + file);
            file.deleteOnExit();
            FileWriter fileWriter = new FileWriter(file);
            char[] cArray = new char[50000];
            int n = reader.read(cArray);
            while (n != -1) {
                fileWriter.write(cArray, 0, n);
                n = reader.read(cArray);
            }
            fileWriter.close();
            this.fileNameCache.put(uRL, file);
            this.totalCacheLength = (int)((double)this.totalCacheLength + (double)file.length() / 1000000.0);
            return this.urlToReader(uRL);
        }
        catch (IOException iOException) {
            logger.warn("ERROR: Could not write temporary file " + file + " (for caching of " + uRL + "): " + iOException);
            return null;
        }
    }

    public Reader urlToReader(URL uRL) {
        File file = (File)this.fileNameCache.get(uRL);
        logger.debug("PG: Checking for cached version of " + uRL + ", found " + file);
        if (file == null) {
            return null;
        }
        try {
            FileReader fileReader = new FileReader(file);
            this.filesize = file.length();
            return fileReader;
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.warn("Error: the cache database seems to be corrupt, the file " + file + " (cached version of " + uRL + ") could not be found: " + fileNotFoundException);
            this.fileNameCache.remove(uRL);
            return null;
        }
    }

    public long getFileSize() {
        return this.filesize;
    }

    public void setBrowserName(String string) {
        this.browser_name = string;
    }

    public boolean putContents(URL uRL, InputStream inputStream) {
        this.error = "The method 'putContents' is unimplemented in this version";
        return false;
    }

    public InputStream getByteContents(URL uRL, String[] stringArray) {
        InputStreamReader inputStreamReader = null;
        InputStream inputStream = null;
        if (!uRL.getProtocol().equals("http") && !uRL.getProtocol().equals("file")) {
            this.error = "The protocol '" + uRL.getProtocol() + "' is not supported in this implementation, only http and file are available";
            return null;
        }
        try {
            int n;
            Object object;
            Socket socket;
            this.ecoord.notify(4);
            if (uRL.getProtocol().equals("file")) {
                return new FileInputStream(URLDecoder.decode(uRL.getFile()));
            }
            int n2 = -1;
            this.ecoord.notify(5, "Connecting to host");
            if (this.proxy == null) {
                socket = new Socket(uRL.getHost(), uRL.getPort());
                object = new OutputStreamWriter(socket.getOutputStream());
                inputStream = socket.getInputStream();
                inputStreamReader = new InputStreamReader(inputStream);
                ((Writer)object).write("GET " + URLDecoder.decode(uRL.getFile()) + " HTTP/1.0\n" + "User-Agent: " + this.browser_name + "\n");
                if (stringArray != null) {
                    for (n = 0; n < stringArray.length; ++n) {
                        ((Writer)object).write("Accept: " + stringArray[n] + "\n");
                    }
                }
                ((Writer)object).write("\n");
                ((Writer)object).flush();
            } else {
                socket = new Socket(this.proxy, 80);
                object = new OutputStreamWriter(socket.getOutputStream());
                inputStreamReader = new InputStreamReader(socket.getInputStream());
                ((Writer)object).write("GET " + uRL.toString() + " HTTP/1.0\n" + "User-Agent: " + this.browser_name + "\n");
                if (stringArray != null) {
                    for (n = 0; n < stringArray.length; ++n) {
                        ((Writer)object).write("Accept: " + stringArray[n] + "\n");
                    }
                }
                ((Writer)object).write("\n");
                ((Writer)object).flush();
            }
            this.ecoord.notify(5, "Request sent, waiting for reply");
            n2 = ((Reader)inputStreamReader).read();
            while (n2 != 32) {
                n2 = ((Reader)inputStreamReader).read();
            }
            int n3 = 0;
            n2 = ((Reader)inputStreamReader).read();
            while (n2 != 32) {
                n3 = n3 * 10 + (n2 - 48);
                n2 = ((Reader)inputStreamReader).read();
            }
            object = "";
            n2 = ((Reader)inputStreamReader).read();
            while (n2 != 10) {
                if (n2 != 13) {
                    object = (String)object + (char)n2;
                }
                n2 = ((Reader)inputStreamReader).read();
            }
            this.ecoord.notify(5, "Receiving response");
            if (n3 > 299 || n3 < 200) {
                this.ecoord.notify(6, "HTTP error: " + n3 + " " + (String)object);
                System.err.println("HTTP error:" + n3 + " " + (String)object);
                return null;
            }
            object = "chet";
            n2 = ((Reader)inputStreamReader).read();
            while (n2 != 10 || !((String)object).equals("")) {
                if (n2 == 10) {
                    object = "";
                } else if (n2 != 13) {
                    object = (String)object + (char)n2;
                }
                n2 = ((Reader)inputStreamReader).read();
            }
            this.ecoord.notify(7, "Loading done");
        }
        catch (IOException iOException) {
            logger.warn(iOException.getMessage());
            this.ecoord.notify(6, "I/O Exception:" + iOException);
            iOException.printStackTrace();
        }
        catch (SecurityException securityException) {
            logger.warn(securityException.getMessage());
            this.ecoord.notify(6, "Security Exception:" + securityException);
            securityException.printStackTrace();
            return null;
        }
        return inputStream;
    }

    public Reader getCharContents(URL uRL, String[] stringArray) throws FileNotFoundException {
        Reader reader = null;
        if (this.caching && (reader = this.urlToReader(uRL)) != null) {
            return reader;
        }
        String string = uRL.getFile();
        logger.debug("\n\n\n ### BluejayIOController.getCharContents(" + uRL + ", mimetypes) :: " + "\n\n\n ### filename=" + string + "\n\n\n");
        if (!(uRL.getProtocol().equals("http") || uRL.getProtocol().equals("file") || uRL.getProtocol().equals("jar"))) {
            this.error = "The protocol '" + uRL.getProtocol() + "' is not supported in this implementation, only http, jar and file are available";
            return null;
        }
        try {
            String string2;
            int n;
            if (uRL.getProtocol().equals("jar")) {
                URLConnection uRLConnection = uRL.openConnection();
                if (uRLConnection instanceof JarURLConnection) {
                    JarURLConnection jarURLConnection = (JarURLConnection)uRLConnection;
                    JarEntry jarEntry = jarURLConnection.getJarEntry();
                    if (jarEntry == null) {
                        System.err.println("Could not get file from JAR");
                        return null;
                    }
                    this.filesize = jarEntry.getCompressedSize();
                    JarFile jarFile = jarURLConnection.getJarFile();
                    if (jarFile == null) {
                        System.err.println("Could not get JAR file");
                        return null;
                    }
                    InputStream inputStream = jarFile.getInputStream(jarEntry);
                    reader = new InputStreamReader(inputStream);
                    return reader;
                }
                System.err.println("Could not get JAR connection from " + uRL);
                return null;
            }
            if (uRL.getProtocol().equals("file")) {
                Object object;
                Object object2;
                this.filesize = new File(uRL.getFile()).length();
                if (string.endsWith("html")) {
                    Object object3;
                    String string3;
                    logger.debug("\n\n\n ### BluejayIOController.getCharContents(" + uRL + ", mimetypes) :: " + "\n\n\n ### filename=" + string + ", filename.endsWith(\"html\") \n\n\n");
                    StringWriter stringWriter = new StringWriter();
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                    Pattern pattern = Pattern.compile("<[Pp][Rr][Ee](\\s+class\\s*=\\s*\"[^\"]*\"\\s*)?>");
                    Pattern pattern2 = Pattern.compile("</[Pp][Rr][Ee]>");
                    int n2 = 0;
                    int n3 = 0;
                    boolean bl = false;
                    boolean bl2 = false;
                    while ((string3 = bufferedReader.readLine()) != null) {
                        Matcher matcher = pattern.matcher(string3);
                        Matcher matcher2 = pattern2.matcher(string3);
                        if (!bl) {
                            if (matcher2.find()) {
                                n3 = matcher2.start();
                                logger.debug("end=" + n3);
                                object3 = matcher2.group();
                                logger.debug("match=" + (String)object3);
                                bl2 = false;
                            }
                            if (bl2) {
                                stringWriter.write(string3 + "\n");
                            }
                            if (!matcher.find()) continue;
                            n2 = matcher.start();
                            logger.debug("start=" + n2);
                            stringWriter.write(string3.substring(n2 + 5) + "\n");
                            object3 = matcher.group();
                            logger.debug("match=" + (String)object3);
                            bl2 = true;
                            continue;
                        }
                        stringWriter.write(string3 + "\n");
                    }
                    object3 = new Converter();
                    reader = new StringReader(((Converter)object3).convert(stringWriter.toString()));
                    bufferedReader.close();
                    if (this.caching) {
                        reader = this.storeDataToCache(uRL, reader);
                    }
                    return reader;
                }
                if (string.endsWith("gz")) {
                    System.out.println(string);
                    FileInputStream fileInputStream = new FileInputStream(string);
                    GZIPInputStream gZIPInputStream = new GZIPInputStream(fileInputStream);
                    return new InputStreamReader(gZIPInputStream);
                }
                boolean bl = false;
                boolean bl3 = false;
                try {
                    object2 = new BufferedReader(new FileReader(string));
                    object = ((BufferedReader)object2).readLine();
                    if (((String)object).indexOf("?xml") != -1) {
                        bl = true;
                    }
                    if (((String)(object = ((BufferedReader)object2).readLine())).indexOf("!DOCTYPE TIGR") != -1) {
                        bl3 = true;
                    }
                    ((BufferedReader)object2).close();
                }
                catch (Exception exception) {
                    logger.error("Either could not open " + string + " for reading or it was empty");
                    exception.printStackTrace();
                    return null;
                }
                logger.debug("      @ isXML=" + bl + ", isTIGR=" + bl3);
                if (bl) {
                    if (this.isSkeletonizing && bl3) {
                        object2 = "Skeletonizing " + uRL + "...";
                        this.ecoord.notify(5, object2);
                        System.err.println("      @ " + (String)object2);
                        object = new XSLTransformer();
                        try {
                            reader = ((XSLTransformer)object).transform(uRL);
                            this.ecoord.notify(5, "Skeletonization done.");
                            System.err.println("      @ Skeletonization done.");
                            return reader;
                        }
                        catch (Exception exception) {
                            logger.error("      @ Skeletonization failed, returning Reader for full XML...");
                            exception.printStackTrace();
                            return new FileReader(URLDecoder.decode(uRL.getFile()));
                        }
                    }
                    return new FileReader(URLDecoder.decode(uRL.getFile()));
                }
                object2 = new Converter();
                reader = ((Converter)object2).convertFile(string);
                return reader;
            }
            if (ComparisonMenuManager.isComparison) {
                n = uRL.toString().indexOf("#");
                string2 = uRL.toString().substring(0, n);
                uRL = new URL(string2);
            }
            this.ecoord.notify(4);
            n = -1;
            this.ecoord.notify(5, "Connecting to host");
            string2 = null;
            Object var7_21 = null;
            try {
                logger.debug("entity_URL=" + uRL);
                boolean bl = false;
                boolean bl4 = false;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                String string4 = bufferedReader.readLine();
                if (string4.indexOf("?xml") != -1) {
                    bl = true;
                }
                if ((string4 = bufferedReader.readLine()).indexOf("!DOCTYPE TIGR") != -1) {
                    bl4 = true;
                }
                bufferedReader.close();
                logger.debug("      @ isXML=" + bl + ", isTIGR=" + bl4);
                if (this.isSkeletonizing && bl && bl4 && uRL.toString().indexOf(63) == -1) {
                    String string5 = "Skeletonizing " + uRL + "...";
                    this.ecoord.notify(5, string5);
                    System.err.println("      @ " + string5);
                    XSLTransformer xSLTransformer = new XSLTransformer();
                    try {
                        reader = xSLTransformer.transform(uRL);
                        this.ecoord.notify(5, "Skeletonization done.");
                        System.err.println("      @ Skeletonization done.");
                    }
                    catch (Exception exception) {
                        logger.error(exception);
                    }
                } else {
                    URLConnection uRLConnection = uRL.openConnection();
                    this.filesize = uRLConnection.getContentLength();
                    if (uRL.toString().endsWith("gz")) {
                        reader = new InputStreamReader(new GZIPInputStream(uRLConnection.getInputStream()));
                        this.filesize *= 4L;
                    } else {
                        reader = new InputStreamReader(uRLConnection.getInputStream());
                    }
                }
            }
            catch (SocketException socketException) {
                logger.error("Can't connect to host: " + socketException.getMessage());
                this.ecoord.notify(6, new String("Can't connect to host: check internet connection or load local file"));
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.error("BluejayIOController: File not found: " + fileNotFoundException.getMessage());
                this.ecoord.notify(6, new String("File not found"));
            }
            catch (IOException iOException) {
                logger.error("BluejayIOController: File not found: " + iOException.getMessage());
                this.ecoord.notify(6, new String("File not found"));
            }
            catch (Exception exception) {
                logger.error("General exception in BluejayIOController.getCharContents: " + exception.getClass().getName() + ": " + exception.getMessage());
                exception.printStackTrace();
                this.ecoord.notify(6, new String("General Exception: Check internet connection or load local file"));
            }
            if (this.caching) {
                reader = this.storeDataToCache(uRL, reader);
            }
            this.ecoord.notify(5, "Request sent, waiting for reply");
            this.ecoord.notify(7, "Loading done");
        }
        catch (IOException iOException) {
            logger.warn(iOException.getMessage());
            this.ecoord.notify(6, "I/O Exception:" + iOException);
            iOException.printStackTrace();
            return null;
        }
        catch (SecurityException securityException) {
            logger.warn(securityException.getMessage());
            this.ecoord.notify(6, "Security Exception:" + securityException);
            securityException.printStackTrace();
            return null;
        }
        return reader;
    }

    public void setHTTPProxy(InetAddress inetAddress, int n) {
        this.proxy = inetAddress;
        this.proxyport = n;
    }

    public int getHTTPProxyPort() {
        return this.proxyport;
    }

    public InetAddress getHTTPProxyAddress() {
        return this.proxy;
    }

    public void setEventCoordinator(EventCoordinator eventCoordinator) {
        this.ecoord = eventCoordinator;
    }

    public String getLastError() {
        return this.error;
    }

    public GeneralCacheAdministrator getCacheAdmin() {
        return this.cAdmin;
    }
}

