/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.client.LinearTarget;
import ca.ucalgary.bluejay.client.TargetAppearance;
import ca.ucalgary.bluejay.client.lineartarget.CircularLinearTarget;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.BluejayUObjectWindow;
import ca.ucalgary.bluejay.gui.DisplayOptions;
import ca.ucalgary.bluejay.gui.Legend;
import ca.ucalgary.bluejay.gui.VisibilityManager;
import ca.ucalgary.bluejay.gui.WaypointsTab;
import ca.ucalgary.bluejay.gui.microarray.AnalysisMonitor;
import ca.ucalgary.bluejay.gui.painter.BluejayMicroArrayComparisonPainter;
import ca.ucalgary.bluejay.gui.painter.BluejayMicroArrayElementPainter;
import ca.ucalgary.bluejay.gui.painter.BluejayMicroArrayPlayerPainter;
import ca.ucalgary.bluejay.gui.painter.LinkingLinePainter;
import ca.ucalgary.bluejay.gui.painter.WaypointsPainter;
import ca.ucalgary.bluejay.gui.util.BluejaySVGGraphics2D;
import ca.ucalgary.bluejay.gui.util.Debug;
import ca.ucalgary.bluejay.gui.util.SwingWorkerVariant;
import ca.ucalgary.bluejay.util.SplashWindow;
import com.simonstl.sax.xlink.LinkSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.List;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.log4j.Logger;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class BluejayAbstractLinearGraphics
implements AbstractLinearGraphics,
ImageObserver {
    private String lastTitleString;
    private Frame parentFrame;
    private Graphics og;
    private Graphics nonSvg_og;
    private Image oi;
    private Vector text_buffer;
    private Vector font_buffer;
    private Vector color_buffer;
    private Vector curr_dei_buffer;
    private Vector text_linkset_buffer;
    private Vector hyperlinks;
    private LinkSet current_linkSet;
    private boolean is_drawLink_not_textLink;
    private int text_x_cursor;
    private int text_y_cursor;
    private int left_margin;
    private int right_margin;
    private int top_space;
    private int bottom_space;
    private int viewing_width;
    private int break_width;
    private int page_width;
    private int page_height;
    private int target_count;
    private int level_of_detail;
    private boolean breakable;
    private boolean eraseable_space;
    private Font currFont;
    private FontMetrics currFontMetrics;
    private FontMetrics nonSvg_currFontMetrics;
    private DisplayOptions dos;
    private Vector targets;
    private Vector target_anchors;
    private Vector target_buffers;
    private Vector targetDeiAppearances;
    private Component component;
    private static double zoom;
    private static double posPerPixelScale;
    private static double hundredPosPerPixelScale;
    private static double minimumPosPerPixelScale;
    private boolean imageSizeExceeded;
    private boolean paintAllowed;
    private LinkSet outgoingXLinks;
    private String outgoingXLinkURL;
    private Point translatedOrigin;
    private Legend legend;
    private static final int NO_SIZE = -1;
    private static final int NO_Y_POSITION = -1;
    private int textStartPoint = -1;
    private int countText = -1;
    private String countString = "";
    private int textEndPoint = -1;
    private boolean scaffolding;
    private String outputSVGFileName;
    private BluejayUObjectWindow outputSVGWindow;
    private Rectangle svgViewbox;
    private SVGGraphics2D batik_g2d;
    private SVGDocument svgDocument;
    private JSVGCanvas svgCanvas;
    private double featureFactor = 1.0;
    private DTDElementInstance deiCurrentlyBeingDrawn;
    private TreeMap posToTopLabelMap;
    private TreeMap posToBottomLabelMap;
    private int viewMode = 313;
    private int viewShape = 315;
    private int translationMode = 1000;
    private int aminoAcidMode = 333;
    private JComponent propertyChangeEventFirer;
    private JTextPane textPane;
    private boolean fitToScreen;
    private Dimension screenSize;
    private SimpleAttributeSet attributes;
    private boolean inTargetText = false;
    private String targetText = "";
    private String lineString = "";
    private static int LINE_NUMBER_WIDTH;
    private static int LEFT_MARGIN;
    private static int RIGHT_MARGIN;
    private static int MARGINS;
    private int STRING_WRAP_LENGTH = 50;
    private int ADJ_STRING_WRAP_LENGTH;
    private static final int JAVA_GRAPHICS_MODE = 101;
    private static final int BATIK_GRAPHICS_MODE = 102;
    private static final int SVG_EXPORT_GRAPHICS_MODE = 103;
    private static final int SMALL_MAGIC_NUMBER_OF_PIXELS = 101;
    private static final int INVALID_NEGATIVE_POSITION = -777;
    private static final String NO_XPOINTER = "";
    private int currentGraphicsMode;
    private int previousGraphicsMode;
    private Vector visibleRangeSegments;
    private boolean preserveAppearances = false;
    private int maxLabelLength = 300;
    private boolean showAG;
    private boolean showGC;
    private boolean showGCSkew;
    private boolean showCleavage;
    private double circularTargetRatioBump;
    private VisibilityManager vizMgr;
    private static MultipleArrayViewer arrayViewer;
    private AnalysisMonitor analysisMonitor;
    private BluejayMicroArrayElementPainter arrayPainter;
    private BluejayMicroArrayPlayerPainter arrayPlayerPainter;
    private BluejayMicroArrayComparisonPainter arrayComparisonPainter;
    private TreeMap xPtrToGBMap;
    private TreeMap GBToXPtrMap;
    private TreeMap slideToXPtrMap;
    private WaypointsPainter waypointsPainter = new WaypointsPainter();
    private static Logger logger;
    private LinkingLinePainter linkingLinePainter;
    private TreeMap xPtrToTextMap = new TreeMap();
    private static final int GHOSTED_ALPHA = 85;
    private static final int SLEEP_INTERVAL = 200;
    private static final int POSITION_KEY_LENGTH = 30;
    private static final String DUMMY_MAP_OBJECT = "";

    private BluejayAbstractLinearGraphics() {
    }

    public BluejayAbstractLinearGraphics(DisplayOptions displayOptions) {
        SplashWindow.setStatus("Initializing Canvas...analysis tools", true);
        this.analysisMonitor = new AnalysisMonitor();
        this.arrayPainter = new BluejayMicroArrayElementPainter();
        this.arrayPlayerPainter = new BluejayMicroArrayPlayerPainter();
        this.arrayComparisonPainter = new BluejayMicroArrayComparisonPainter();
        this.xPtrToGBMap = new TreeMap();
        this.GBToXPtrMap = new TreeMap();
        this.slideToXPtrMap = new TreeMap();
        SplashWindow.setStatus("Initializing Canvas...fonts", true);
        this.attributes = new SimpleAttributeSet();
        StyleConstants.setFontFamily(this.attributes, "Monospaced");
        StyleConstants.setFontSize(this.attributes, 14);
        SplashWindow.setStatus("Initializing Canvas...appearance", true);
        this.dos = displayOptions;
        this.propertyChangeEventFirer = new JButton("");
        this.visibleRangeSegments = new Vector();
        this.page_height = 0;
        this.page_width = 0;
        this.break_width = 0;
        this.viewing_width = 0;
        this.bottom_space = 0;
        this.top_space = 0;
        this.right_margin = 0;
        this.left_margin = 0;
        this.targetDeiAppearances = new Vector();
        this.targets = new Vector();
        this.target_anchors = new Vector();
        this.target_buffers = new Vector();
        this.text_buffer = new Vector();
        this.font_buffer = new Vector();
        this.color_buffer = new Vector();
        this.curr_dei_buffer = new Vector();
        this.text_linkset_buffer = new Vector();
        this.hyperlinks = new Vector();
        this.current_linkSet = null;
        this.level_of_detail = 60;
        this.scaffolding = false;
        zoom = 1.0;
        posPerPixelScale = 2000.0;
        hundredPosPerPixelScale = 0.0;
        minimumPosPerPixelScale = 0.0;
        this.imageSizeExceeded = false;
        SplashWindow.setStatus("Initializing Canvas...coordinate mapping", true);
        this.translatedOrigin = new Point();
        this.paintAllowed = true;
        this.posToTopLabelMap = new TreeMap();
        this.posToBottomLabelMap = new TreeMap();
        this.previousGraphicsMode = 101;
        this.currentGraphicsMode = 101;
        this.linkingLinePainter = new LinkingLinePainter(this);
    }

    public VisibilityManager getVisibilityManager() {
        return this.vizMgr;
    }

    public void setVisibilityManager(VisibilityManager visibilityManager) {
        this.vizMgr = visibilityManager;
    }

    public DisplayOptions getDisplayOptions() {
        return this.dos;
    }

    public void setFrame(Frame frame) {
        this.parentFrame = frame;
    }

    public void setTitle(String string) {
        if (this.parentFrame != null) {
            String string2 = this.parentFrame.getTitle();
            if (string2 == null || string2.length() == 0) {
                this.lastTitleString = string;
                string2 = "";
            } else if (this.lastTitleString != null && string2.endsWith(this.lastTitleString)) {
                if (string2.equals(this.lastTitleString)) {
                    string2 = "";
                } else {
                    string2 = string2.substring(0, string2.lastIndexOf(this.lastTitleString));
                    string = " / " + string;
                }
            } else {
                string = " / " + string;
            }
            this.parentFrame.setTitle(string2 + string);
            this.lastTitleString = string;
        }
    }

    public synchronized void setPaintAllowed(boolean bl) {
        this.paintAllowed = bl;
    }

    public synchronized boolean getPaintAllowed() {
        return this.paintAllowed;
    }

    public void setLegend(Legend legend) {
        this.legend = legend;
    }

    public Legend getLegend() {
        return this.legend;
    }

    public void setSVGExportGraphicsMode(String string, Rectangle rectangle) {
        this.outputSVGFileName = string;
        this.outputSVGWindow = null;
        this.svgViewbox = rectangle;
        if (this.currentGraphicsMode != 103) {
            this.previousGraphicsMode = this.currentGraphicsMode;
            this.currentGraphicsMode = 103;
        }
    }

    public void setSVGExportGraphicsMode(BluejayUObjectWindow bluejayUObjectWindow, Rectangle rectangle) {
        this.outputSVGFileName = null;
        this.outputSVGWindow = bluejayUObjectWindow;
        this.svgViewbox = rectangle;
        if (this.currentGraphicsMode != 103) {
            this.previousGraphicsMode = this.currentGraphicsMode;
            this.currentGraphicsMode = 103;
        }
    }

    public void endSVGExportGraphicsMode() {
        this.currentGraphicsMode = this.previousGraphicsMode;
        this.svgViewbox = null;
    }

    public boolean isSVGExportGraphicsMode() {
        return this.currentGraphicsMode == 103;
    }

    public void setBatikGraphicsMode(JSVGCanvas jSVGCanvas) {
        this.batik_g2d = null;
        this.svgDocument = null;
        this.svgCanvas = jSVGCanvas;
        if (this.currentGraphicsMode != 102) {
            this.previousGraphicsMode = this.currentGraphicsMode;
            this.currentGraphicsMode = 102;
        }
    }

    public void endBatikGraphicsMode() {
        if (this.currentGraphicsMode == 102) {
            // empty if block
        }
        new Exception("Unexpected call to BluejayALG.endConvertToBATIK()").printStackTrace();
        this.previousGraphicsMode = this.currentGraphicsMode;
        this.currentGraphicsMode = 101;
        this.batik_g2d = null;
        this.svgDocument = null;
    }

    public boolean isBatikGraphicsMode() {
        return this.currentGraphicsMode == 102;
    }

    public void setBreakable(boolean bl) {
        this.breakable = bl;
    }

    public boolean isBreakable() {
        return this.breakable;
    }

    public void setScale(double d) {
        if (this.vizMgr == null) {
            System.err.println("Programmer error: vizMgr not set in BluejayAbstractLinearGraphics before setScale() is called, ignoring");
            return;
        }
        try {
            this.vizMgr.setScale(d);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error(illegalArgumentException.getMessage());
            illegalArgumentException.printStackTrace();
        }
    }

    public double getScale() {
        if (this.vizMgr == null) {
            System.err.println("Programmer error: vizMgr not set in BluejayAbstractLinearGraphics before getScale() is called, returning VisibilityManager.SCALE_UNAVAILABLE");
            return -5.898;
        }
        return this.vizMgr.getScale();
    }

    public void setZoom(double d) {
        zoom = d;
    }

    public double getZoom() {
        return zoom;
    }

    public int getPageWidth() {
        return this.page_width;
    }

    public int getPageHeight() {
        return this.text_y_cursor + this.bottom_space;
    }

    public void startPage(Component component, Dimension dimension) {
        logger.info("The current graphics mode is " + this.currentGraphicsMode);
        if (315 == this.viewMode) {
            if (component instanceof JTextPane) {
                this.xPtrToTextMap = new TreeMap();
                StyleConstants.setFontSize(this.attributes, this.dos.getFont().getSize());
                this.targetText = "";
                this.textPane = (JTextPane)component;
                this.textPane.setText("");
                System.gc();
            } else {
                System.out.println("startPage() component is not instanceof JTextPane -- something has gone horribly wrong with the text area");
            }
        }
        this.targets.removeAllElements();
        this.target_anchors.removeAllElements();
        this.deiCurrentlyBeingDrawn = null;
        this.hyperlinks.removeAllElements();
        this.posToTopLabelMap.clear();
        this.posToBottomLabelMap.clear();
        if (Debug.legend && !this.legend.isExtendedItemContent()) {
            this.legend.clear();
        }
        this.component = component;
        this.screenSize = dimension;
        this.page_width = (int)this.screenSize.getWidth();
        this.page_height = (int)this.screenSize.getHeight();
        this.viewing_width = (int)this.screenSize.getWidth();
        logger.debug("startPage() page_width =" + this.page_width + ", page_height =" + this.page_height);
        if (315 == this.viewMode) {
            if (this.oi != null) {
                this.oi.flush();
            }
            ((BluejayDObjectList)this.svgCanvas).getDataManager().clearRenderingTrees();
            System.runFinalization();
            Runtime.getRuntime().gc();
            Font font = new Font("Monospaced", 0, this.dos.getFont().getSize());
            int n = this.textPane.getGraphics().getFontMetrics(font).charWidth('w');
            this.og = this.textPane.getGraphics();
            this.STRING_WRAP_LENGTH = (int)dimension.getWidth() / n - 4 - LINE_NUMBER_WIDTH - 3;
            this.ADJ_STRING_WRAP_LENGTH = this.STRING_WRAP_LENGTH + MARGINS;
            StringBuffer stringBuffer = new StringBuffer(this.ADJ_STRING_WRAP_LENGTH);
            for (int i = 0; i < this.ADJ_STRING_WRAP_LENGTH - 1; ++i) {
                if (i < LINE_NUMBER_WIDTH + 3) {
                    stringBuffer.append(" ");
                    continue;
                }
                stringBuffer.append("_");
            }
            stringBuffer.append("\n");
            this.lineString = stringBuffer.toString();
            return;
        }
        if (this.getImageSizeExceeded()) {
            this.setImageSizeExceeded(false);
        }
        logger.debug("startPage() -- Starting page with dimensions " + this.page_width + "x" + this.page_height);
        if (this.oi != null) {
            this.oi.flush();
            Runtime.getRuntime().gc();
        }
        if (this.currentGraphicsMode == 103) {
            this.og = this.outputSVGFileName != null ? new BluejaySVGGraphics2D(this.outputSVGFileName) : new BluejaySVGGraphics2D(this.outputSVGWindow);
            ((BluejaySVGGraphics2D)this.og).setSize(new Dimension(this.page_width, this.page_height));
            ((BluejaySVGGraphics2D)this.og).setViewbox(this.svgViewbox);
            this.nonSvg_og = this.component.createImage(this.page_width, this.page_height).getGraphics();
        } else if (this.currentGraphicsMode == 102 || this.viewMode == 312 || this.viewMode == 311) {
            ((BluejayDObjectList)this.svgCanvas).getDataManager().clearRenderingTrees();
            this.svgCanvas.setProgressivePaint(false);
            this.svgCanvas.setDoubleBufferedRendering(false);
            this.svgCanvas.setDocumentState(2);
            DOMImplementation dOMImplementation = SVGDOMImplementation.getDOMImplementation();
            String string = "http://www.w3.org/2000/svg";
            this.svgDocument = (SVGDocument)dOMImplementation.createDocument(string, "svg", null);
            this.batik_g2d = new SVGGraphics2D(this.svgDocument);
            this.og = this.batik_g2d;
            this.nonSvg_og = this.component.createImage(this.page_width, this.page_height).getGraphics();
        } else {
            this.oi = component.createImage(this.page_width, this.page_height);
            this.nonSvg_og = this.og = this.oi.getGraphics();
        }
        this.og.setColor(this.dos.getBackgroundColor());
        this.og.fillRect(0, 0, this.page_width, this.page_height);
        this.og.setColor(this.dos.getForegroundColor());
        this.currFont = this.dos.getFont();
        this.currFontMetrics = this.og.getFontMetrics(this.currFont);
        this.nonSvg_currFontMetrics = this.nonSvg_og.getFontMetrics(this.currFont);
        this.left_margin = this.dos.getLeftMargin();
        this.right_margin = this.dos.getRightMargin();
        this.top_space = this.dos.getTopMargin();
        this.bottom_space = this.dos.getBottomMargin();
        this.text_x_cursor = this.left_margin;
        this.text_y_cursor = this.top_space;
        this.target_count = 0;
        this.eraseable_space = false;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return (n & 0x20) == 0;
    }

    public Dimension endPage() throws Exception {
        if (315 == this.viewMode && this.textPane != null) {
            this.textPane.revalidate();
            this.textPane.repaint();
        }
        this.flushAndEndCurrentLine();
        this.deiCurrentlyBeingDrawn = null;
        if (Debug.legend && !this.legend.isExtendedItemContent()) {
            this.legend.sort();
            this.legend.repaint();
        }
        if (this.currentGraphicsMode == 103) {
            ((BluejaySVGGraphics2D)this.og).dispose();
        } else if (this.currentGraphicsMode == 102 && 315 != this.viewMode || this.viewMode == 312 || this.viewMode == 311) {
            Element element = this.svgDocument.getDocumentElement();
            while (element.hasChildNodes()) {
                element.removeChild(element.getFirstChild());
            }
            this.batik_g2d.getRoot(element);
            this.svgCanvas.setSVGDocument(this.svgDocument);
            Element element2 = this.svgCanvas.getSVGDocument().getDocumentElement();
            try {
                element2.setAttributeNS(null, "width", "" + this.page_width);
                element2.setAttributeNS(null, "height", "" + this.page_height);
                logger.info("endPage() SVGDocument size=" + this.page_width + ", x" + this.page_height);
            }
            catch (DOMException dOMException) {
                logger.error(dOMException.getMessage());
                dOMException.printStackTrace();
            }
            this.batik_g2d.dispose();
            this.batik_g2d = null;
            this.og = null;
            logger.debug("endPage() screenSize=" + this.screenSize + ", svgCanvasSize=" + this.svgCanvas.getSize());
        } else {
            this.og.dispose();
        }
        this.getLLPainter().getDeiPool().clear();
        logger.info("End of endpage()");
        return this.screenSize;
    }

    private void doNothing() {
    }

    public void removeAllHyperlinks() {
        this.hyperlinks.removeAllElements();
    }

    public void clear(SwingWorkerVariant swingWorkerVariant) {
        while (swingWorkerVariant.isHolding(this.text_buffer)) {
            this.doNothing();
        }
        this.text_buffer.removeAllElements();
        while (swingWorkerVariant.isHolding(this.font_buffer)) {
            logger.info("Trying to clear(). SwingWorkerVariant is Holding(font_buffer) -- 1. Waiting...");
            this.doNothing();
        }
        this.font_buffer.removeAllElements();
        while (swingWorkerVariant.isHolding(this.color_buffer)) {
            this.doNothing();
        }
        this.color_buffer.removeAllElements();
        while (swingWorkerVariant.isHolding(this.curr_dei_buffer)) {
            logger.info("Trying to clear() SwingWorkerVariant isHolding(curr_dei_buffer) -- 2.5.  Waiting...");
            this.doNothing();
        }
        this.curr_dei_buffer.removeAllElements();
        while (swingWorkerVariant.isHolding(this.text_linkset_buffer)) {
            logger.info("Trying to clear() SwingWorkerVariant.isHolding(text_linkset_buffer) -- 2.  Waiting...");
            this.doNothing();
        }
        this.text_linkset_buffer.removeAllElements();
        while (swingWorkerVariant.isHolding(this.targets)) {
            logger.info("Trying to clear() SwingWorkerVariant.isHolding(targets) -- 2.5.  Waiting...");
            this.doNothing();
        }
        while (swingWorkerVariant.isHolding(this.target_anchors)) {
            logger.info("Trying to clear() SwingWorkerVariant.isHolding(target_anchors) -- 3.  Waiting...");
            this.doNothing();
        }
        while (swingWorkerVariant.isHolding(this.target_buffers)) {
            logger.info("Trying to clear() SwingWorkerVariant.isHolding(target_buffers) -- 4.  Waiting...");
            this.doNothing();
        }
        this.target_buffers.removeAllElements();
        while (swingWorkerVariant.isHolding(this.hyperlinks)) {
            logger.info("Trying to clear() SwingWorkerVariant.isHolding(hyperlinks) -- 5.  Waiting...");
            this.doNothing();
        }
        this.current_linkSet = null;
        this.target_count = 0;
        if (this.currentGraphicsMode != 103 && this.currentGraphicsMode != 102) {
            this.og.dispose();
        }
    }

    public void startHyperlink(DTDElementInstance dTDElementInstance, boolean bl) {
        String string;
        LinkSet linkSet;
        if (315 == this.viewMode) {
            return;
        }
        if (this.outgoingXLinks != null && dTDElementInstance.getXPointer() != null && (linkSet = this.outgoingXLinks.getByFromURLFileFragment(string = this.outgoingXLinkURL + "#" + dTDElementInstance.getXPointer())).size() > 0) {
            this.current_linkSet = linkSet;
            this.is_drawLink_not_textLink = bl;
            if (this.is_drawLink_not_textLink) {
                this.hyperlinks.addElement(new Rectangle(this.text_x_cursor, this.text_y_cursor, -1, 1));
                this.hyperlinks.addElement(this.current_linkSet);
            }
        }
    }

    public void endHyperlink() {
        if (315 == this.viewMode) {
            return;
        }
        if (this.current_linkSet == null) {
            return;
        }
        this.current_linkSet = null;
        if (this.is_drawLink_not_textLink) {
            return;
        }
    }

    public void updateHyperlink(Point point) {
        if (315 == this.viewMode) {
            return;
        }
        if (this.current_linkSet == null) {
            return;
        }
        if (point == null) {
            return;
        }
        if (this.hyperlinks.size() > 1) {
            ((Rectangle)this.hyperlinks.elementAt(this.hyperlinks.size() - 2)).setLocation(point);
        }
    }

    public LinkSet getHyperlinks(double d, double d2) {
        Object object;
        Object object2;
        if (315 == this.viewMode) {
            return null;
        }
        int n = this.hyperlinks.size() / 2;
        logger.debug("The image has " + n + " region-hyperlink pair" + (1 == n ? ":" : "s:"));
        Object object3 = this.hyperlinks.elements();
        while (object3.hasMoreElements()) {
            object2 = object3.nextElement();
            object = object3.nextElement();
            logger.debug("getHyperlinks() \t" + object2 + " -> " + object);
        }
        logger.info("getHyperlinks() Checking for link at (" + d + "," + d2 + ") ...");
        object3 = null;
        object2 = this.hyperlinks.elements();
        while (object2.hasMoreElements()) {
            object = (Rectangle)object2.nextElement();
            logger.info("getHyperlinks() \tChecking linked region " + object + " ...");
            if (((Rectangle2D)object).contains(d, d2)) {
                if (object3 == null) {
                    object3 = new LinkSet();
                }
                ((LinkSet)object3).addLinkSet((LinkSet)object2.nextElement());
                logger.debug("getHyperlinks() Found links! " + object + ", " + ((LinkSet)object3).toString());
                continue;
            }
            object2.nextElement();
        }
        logger.debug("getHyperlinks() Found no links");
        return object3;
    }

    public void paint(Graphics graphics) {
        if (this.oi == null) {
            logger.info("paint() The old image is null.");
        } else {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.currentGraphicsMode == 101) {
                graphics2D.drawImage(this.oi, AffineTransform.getScaleInstance(zoom, zoom), null);
            }
        }
    }

    public TargetAppearance getNextPreservedTargetAppearance() {
        if (this.preserveAppearances && this.targetDeiAppearances.size() > 0) {
            return (TargetAppearance)this.targetDeiAppearances.elementAt(this.targets.size());
        }
        return null;
    }

    public void clearRatioBump(LinearTarget linearTarget) {
        if (linearTarget instanceof CircularLinearTarget) {
            ((CircularLinearTarget)linearTarget).setRatioBump(0.0);
        }
    }

    public void calculateRatioBump(LinearTarget linearTarget) {
    }

    public int addTarget(LinearTarget linearTarget, DTDElementInstance dTDElementInstance, int n) throws Exception {
        this.calculateRatioBump(linearTarget);
        logger.debug("addTarget - there are " + this.targets.size() + " targets.");
        int n2 = this.targets.size();
        if (315 != this.viewMode && this.font_buffer.size() != 0 && this.text_x_cursor + linearTarget.getWidth() > this.viewing_width - this.right_margin && this.breakable) {
            this.flushAndEndCurrentLine();
        }
        this.font_buffer.addElement(linearTarget);
        this.font_buffer.addElement(new Integer(n));
        this.targets.addElement(linearTarget);
        dTDElementInstance.getTargetAppearance().setTargetNumber(n2);
        dTDElementInstance.getTargetAppearance().setLinearTarget(linearTarget instanceof LinearTarget ? linearTarget : null);
        dTDElementInstance.getTargetAppearance().setTopLeftAnchor(this.text_x_cursor, -1);
        this.target_anchors.addElement(dTDElementInstance.getTargetAppearance().getTopLeftAnchor());
        if (!this.preserveAppearances || this.targetDeiAppearances.size() == 0) {
            this.targetDeiAppearances.addElement(dTDElementInstance.getTargetAppearance());
        }
        this.target_buffers.addElement(null);
        if (315 != this.viewMode) {
            this.text_x_cursor += linearTarget.getWidth();
            if (this.text_x_cursor + this.right_margin > this.page_width) {
                this.expandCanvas(this.text_x_cursor + this.right_margin - this.page_width, 0);
            }
            if (this.text_x_cursor >= this.viewing_width - this.right_margin && this.breakable) {
                this.flushAndEndCurrentLine();
            }
        }
        dTDElementInstance.setTarget(n2);
        this.flushAndEndCurrentLine();
        this.calculateVisiblePositionRange(dTDElementInstance.getTargetAppearance());
        return n2;
    }

    public int getPositionInFocus() {
        return this.vizMgr.getFocusPosition();
    }

    private void calculateVisiblePositionRange(TargetAppearance targetAppearance) {
        LinearTarget linearTarget = targetAppearance.getLinearTarget();
        if (this.svgCanvas == null) {
            System.err.println("PG: No SVG Canvas");
            linearTarget.clearVisiblePositionRange();
            this.setVisiblePositionRange(linearTarget.getVisiblePositionRange());
            return;
        }
        int n = this.getPositionInFocus();
        if (n <= 0) {
            System.err.println("PG: No position in focus, resetting visible range");
            linearTarget.clearVisiblePositionRange();
            this.setVisiblePositionRange(linearTarget.getVisiblePositionRange());
            return;
        }
        Point point = this.getPoint(targetAppearance, n, 0.0);
        if (point == null) {
            System.err.println("PG: No point in focus, resetting visible range");
            linearTarget.clearVisiblePositionRange();
            this.setVisiblePositionRange(linearTarget.getVisiblePositionRange());
            return;
        }
        if (targetAppearance.getShape() == 111 || targetAppearance.getShape() == 119) {
            if (n == targetAppearance.getLeftEdgePosition()) {
                point.x += this.svgCanvas.getWidth() / 2;
            } else if (n == targetAppearance.getRightEdgePosition()) {
                point.x -= this.svgCanvas.getWidth() / 2;
            }
        }
        if (targetAppearance.getShape() == 118 || targetAppearance.getShape() == 120) {
            if (n == targetAppearance.getLeftEdgePosition()) {
                point.x += this.svgCanvas.getWidth() / 2;
            } else if (n == targetAppearance.getRightEdgePosition()) {
                point.x -= this.svgCanvas.getWidth() / 2;
            }
        }
        Rectangle rectangle = new Rectangle(point.x - this.svgCanvas.getWidth() / 2 - targetAppearance.getTopLeftAnchor().x, point.y - this.svgCanvas.getHeight() / 2 - targetAppearance.getTopLeftAnchor().y, this.svgCanvas.getWidth(), this.svgCanvas.getHeight());
        linearTarget.calculateVisiblePositionRange(rectangle);
    }

    public LinearTarget getTarget(int n) {
        if (n < this.targets.size() && n > -1) {
            return (LinearTarget)this.targets.elementAt(n);
        }
        return null;
    }

    public Vector getTargetAppearances() {
        return this.targetDeiAppearances;
    }

    public int getStandardPageWidth() {
        return this.viewing_width - this.left_margin - this.right_margin;
    }

    public void resetPageSize() {
        this.page_width = this.left_margin + this.right_margin;
        this.page_height = this.top_space + this.bottom_space;
        this.text_x_cursor = this.left_margin;
        this.text_y_cursor = this.top_space;
    }

    public void resetBreakablePageWidth() {
        this.break_width = 0;
    }

    public void setBreakablePageWidth(int n) {
        if (n <= 0) {
            logger.error("Attempt to set an invalid usable page width " + n);
            throw new IllegalArgumentException("Attempt to set an invalid usable page width " + n);
        }
        this.break_width = n;
    }

    public int getBreakablePageWidth() {
        return this.break_width - this.left_margin - this.right_margin;
    }

    public int getLinespaceLeft() {
        return this.viewing_width - this.text_x_cursor - this.right_margin;
    }

    public void setColor(Color color) {
        if (color != this.og.getColor()) {
            this.og.setColor(color);
        }
    }

    public Color getColor() {
        return this.og.getColor();
    }

    private void expandCanvas(int n, int n2) throws Exception {
        if (this.imageSizeExceeded) {
            return;
        }
        int n3 = this.page_width + n;
        int n4 = this.page_height + n2;
        logger.debug("expandCanvas(): free Memory is" + Runtime.getRuntime().freeMemory() + ", width x height = " + n3 + " x " + n4 + " = " + n3 * n4);
        Color color = this.og.getColor();
        try {
            Image image = null;
            if (this.currentGraphicsMode == 103) {
                ((BluejaySVGGraphics2D)this.og).setSize(new Dimension(n3, n4));
            } else if (this.currentGraphicsMode != 102) {
                image = this.component.createImage(n3, n4);
                this.nonSvg_og = this.og = image.getGraphics();
            }
            this.og.setColor(this.dos.getBackgroundColor());
            if (n != 0) {
                this.og.fillRect(this.page_width, 0, n, n4);
            }
            if (n2 != 0) {
                this.og.fillRect(0, this.page_height, this.page_width, n2);
            }
            this.og.setColor(color);
            if (this.currentGraphicsMode == 101) {
                this.og.drawImage(this.oi, 0, 0, null);
                this.oi = image;
            }
            this.page_width = n3;
            this.page_height = n4;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            logger.error("OutOfMemoryError - need to do something, e.getCause()=" + outOfMemoryError.getCause());
            outOfMemoryError.printStackTrace();
            this.oi.flush();
            Runtime.getRuntime().gc();
            logger.debug("free Memory is" + Runtime.getRuntime().freeMemory());
            throw new Exception("imageSizeExceeded message");
        }
        logger.debug("end of expandCanvas(): the page width is " + this.page_width + ", and the height is " + this.page_height);
    }

    private void flushAndEndCurrentLine() throws Exception {
        Object object;
        if (315 == this.viewMode) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = this.left_margin;
        Enumeration enumeration = this.font_buffer.elements();
        while (enumeration.hasMoreElements()) {
            FontMetrics fontMetrics;
            object = enumeration.nextElement();
            if (object instanceof LinearTarget) {
                int n4 = (Integer)enumeration.nextElement();
                int n5 = ((LinearTarget)object).getHeight();
                if (n4 == 10) {
                    if (n5 <= n2) continue;
                    n2 = n5;
                    continue;
                }
                if (n4 == 0) {
                    if (n5 / 2 > n2) {
                        n2 = n5 / 2;
                    }
                    if (n5 / 2 <= n) continue;
                    n = n5 / 2;
                    continue;
                }
                if (n5 <= n) continue;
                n = n5;
                continue;
            }
            FontMetrics fontMetrics2 = fontMetrics = object == null ? this.currFontMetrics : this.og.getFontMetrics((Font)object);
            if (fontMetrics == null) {
                FontMetrics fontMetrics3 = fontMetrics = object == null ? this.nonSvg_currFontMetrics : this.nonSvg_og.getFontMetrics((Font)object);
            }
            if (fontMetrics.getAscent() > n) {
                n = fontMetrics.getAscent();
            }
            if (fontMetrics.getDescent() + fontMetrics.getLeading() <= n2) continue;
            n2 = fontMetrics.getDescent() + fontMetrics.getLeading();
        }
        this.text_y_cursor += n;
        if (this.text_y_cursor + n2 > this.page_height) {
            try {
                this.expandCanvas(0, this.text_y_cursor + n2 + this.bottom_space - this.page_height);
            }
            catch (Exception exception) {
                logger.error(exception.getMessage());
                throw exception;
            }
        }
        enumeration = this.font_buffer.elements();
        object = this.text_buffer.elements();
        Enumeration enumeration2 = this.color_buffer.elements();
        Enumeration enumeration3 = this.curr_dei_buffer.elements();
        Enumeration enumeration4 = this.text_linkset_buffer.elements();
        while (enumeration.hasMoreElements()) {
            Object object2;
            String string;
            FontMetrics fontMetrics;
            Object e = enumeration.nextElement();
            if (e instanceof LinearTarget) {
                int n6 = this.text_y_cursor;
                int n7 = (Integer)enumeration.nextElement();
                if (n7 == 0) {
                    n6 -= ((LinearTarget)e).getHeight() / 2 - 1;
                } else if (n7 == 20) {
                    n6 -= ((LinearTarget)e).getHeight() - 1;
                }
                ((Point)this.target_anchors.elementAt((int)this.target_count)).y = n6;
                logger.debug("flushAndEndCurrentLine(): Have set target_anchors.elementAt(" + this.target_count + ")).y to " + n6);
                if (this.target_buffers.elementAt(this.target_count) != null) {
                    logger.debug("flushAndEndCurrentLine(): Drawing target #" + this.target_count + " from buffer");
                    this.og.drawImage((Image)this.target_buffers.elementAt(this.target_count), n3, n6, null);
                    this.target_buffers.setElementAt(null, this.target_count);
                }
                ++this.target_count;
                n3 += ((LinearTarget)e).getWidth();
                continue;
            }
            FontMetrics fontMetrics4 = fontMetrics = e == null ? this.currFontMetrics : this.og.getFontMetrics((Font)e);
            if (fontMetrics == null) {
                FontMetrics fontMetrics5 = fontMetrics = e == null ? this.nonSvg_currFontMetrics : this.nonSvg_og.getFontMetrics((Font)e);
            }
            if ((string = (String)object.nextElement()) == null || string.length() == 0 || string.startsWith("\n")) continue;
            Color color = this.og.getColor();
            if (n3 + fontMetrics.stringWidth(string) + this.right_margin > this.page_width) {
                this.expandCanvas(n3 + fontMetrics.stringWidth(string) + this.right_margin - this.page_width, 0);
            }
            this.og.setFont(e == null ? this.currFont : (Font)e);
            this.og.setColor((Color)enumeration2.nextElement());
            int n8 = fontMetrics.stringWidth(string);
            LinkSet linkSet = (LinkSet)enumeration4.nextElement();
            if (linkSet != null && linkSet.size() > 0) {
                object2 = new Rectangle(n3, this.text_y_cursor - n, n8, n);
                DTDElementInstance dTDElementInstance = this.getDTDElementInstance();
                this.setDTDElementInstance(null);
                this.og.drawLine(((Rectangle)object2).x, ((Rectangle)object2).y + ((Rectangle)object2).height, ((Rectangle)object2).x + ((Rectangle)object2).width, ((Rectangle)object2).y + ((Rectangle)object2).height);
                this.setDTDElementInstance(dTDElementInstance);
                this.hyperlinks.add(object2);
                this.hyperlinks.add(linkSet);
            }
            object2 = this.getDTDElementInstance();
            this.setDTDElementInstance((DTDElementInstance)enumeration3.nextElement());
            this.og.drawString(string, n3, this.text_y_cursor);
            this.setDTDElementInstance((DTDElementInstance)object2);
            this.og.setColor(color);
            n3 += fontMetrics.stringWidth(string);
        }
        this.text_y_cursor += n2;
        this.text_x_cursor = this.left_margin;
        this.text_buffer.removeAllElements();
        this.font_buffer.removeAllElements();
        this.color_buffer.removeAllElements();
        this.curr_dei_buffer.removeAllElements();
        this.text_linkset_buffer.removeAllElements();
    }

    public int getTextStartPoint() {
        return this.textStartPoint;
    }

    public int getTextEndPoint() {
        return this.textEndPoint;
    }

    public void setTextStartPoint() {
        this.textStartPoint = this.textPane.getDocument().getLength();
        this.countString = "";
        this.countText = 1;
        this.inTargetText = true;
    }

    private String constructComplementString(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(this.STRING_WRAP_LENGTH + LINE_NUMBER_WIDTH + 3);
        for (n = 0; n < LINE_NUMBER_WIDTH; ++n) {
            stringBuffer.append(" ");
        }
        stringBuffer.append("  -");
        n = string.length();
        block18: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case 'a': {
                    stringBuffer.append('t');
                    continue block18;
                }
                case 'b': {
                    stringBuffer.append('v');
                    continue block18;
                }
                case 'c': {
                    stringBuffer.append('g');
                    continue block18;
                }
                case 'd': {
                    stringBuffer.append('h');
                    continue block18;
                }
                case 'g': {
                    stringBuffer.append('c');
                    continue block18;
                }
                case 'h': {
                    stringBuffer.append('d');
                    continue block18;
                }
                case 'k': {
                    stringBuffer.append('m');
                    continue block18;
                }
                case 'm': {
                    stringBuffer.append('k');
                    continue block18;
                }
                case 'r': {
                    stringBuffer.append('y');
                    continue block18;
                }
                case 's': {
                    stringBuffer.append('s');
                    continue block18;
                }
                case 't': {
                    stringBuffer.append('a');
                    continue block18;
                }
                case 'v': {
                    stringBuffer.append('b');
                    continue block18;
                }
                case 'w': {
                    stringBuffer.append('w');
                    continue block18;
                }
                case 'y': {
                    stringBuffer.append('r');
                    continue block18;
                }
                case 'n': {
                    stringBuffer.append('n');
                    continue block18;
                }
                default: {
                    System.out.println("got to default somehow");
                }
            }
        }
        return stringBuffer.toString();
    }

    public void setTextEndPoint() {
        this.textEndPoint = this.textPane.getDocument().getLength();
        if (this.textEndPoint == this.textStartPoint) {
            return;
        }
        this.inTargetText = false;
        try {
            StyleConstants.setFontSize(this.attributes, this.dos.getFont().getSize());
            this.countStringUpdate();
            this.targetText = this.targetText.toLowerCase();
            String string = this.constructComplementString(this.targetText);
            this.textPane.getDocument().insertString(this.textPane.getDocument().getLength(), this.countString + this.targetText + "\n", this.attributes);
            this.textPane.getDocument().insertString(this.textPane.getDocument().getLength(), string, this.attributes);
            this.targetText = "";
            this.textEndPoint = this.textPane.getDocument().getLength();
        }
        catch (BadLocationException badLocationException) {
            logger.error("setTextEndPoint() BadLocationException -- something wacky is happening in textendpoint" + badLocationException.getMessage());
        }
    }

    public void drawString(String string, String string2, Font font) throws Exception {
        int n;
        FontMetrics fontMetrics;
        if (string == null || string.length() == 0 || string.startsWith("\n")) {
            return;
        }
        if (315 == this.viewMode) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            if (font != null) {
                if (simpleAttributeSet == null) {
                    logger.warn("drawString() in textMode, newAttributes==null");
                }
                if (font.getFamily() != null) {
                    StyleConstants.setFontFamily(simpleAttributeSet, font.getFamily());
                }
                StyleConstants.setFontSize(simpleAttributeSet, font.getSize());
            }
            if (this.inTargetText) {
                StyleConstants.setFontSize(this.attributes, this.dos.getFont().getSize());
                string = string.replaceAll(" ", "");
                string = string.replaceAll("\r", "");
                string = string.replaceAll("\n", "");
                string = string.replaceAll("\t", "");
                if (string.equals("")) {
                    return;
                }
                if (this.targetText.length() + string.length() < this.STRING_WRAP_LENGTH) {
                    this.targetText = this.targetText.concat(string);
                } else {
                    if (this.targetText.length() + string.length() == this.STRING_WRAP_LENGTH) {
                        this.countStringUpdate();
                        this.targetText = this.targetText.concat(string);
                        this.targetText = this.targetText.toLowerCase();
                        String string3 = this.constructComplementString(this.targetText);
                        this.textPane.getDocument().insertString(this.textPane.getDocument().getLength(), this.countString + this.targetText + "\n", this.attributes);
                        this.textPane.getDocument().insertString(this.textPane.getDocument().getLength(), string3 + "\n", this.attributes);
                        this.textPane.getDocument().insertString(this.textPane.getDocument().getLength(), this.lineString, this.attributes);
                        this.countText += this.STRING_WRAP_LENGTH;
                        this.targetText = "";
                        return;
                    }
                    string = string.toLowerCase();
                    int n2 = string.length();
                    StringBuffer stringBuffer = new StringBuffer(3 * (this.STRING_WRAP_LENGTH + LINE_NUMBER_WIDTH + 4) * (n2 / this.STRING_WRAP_LENGTH + 1));
                    this.targetText = this.targetText.toLowerCase();
                    String string4 = this.targetText + string.substring(0, this.STRING_WRAP_LENGTH - this.targetText.length());
                    this.countStringUpdate();
                    stringBuffer.append(this.countString);
                    stringBuffer.append(string4);
                    stringBuffer.append("\n");
                    stringBuffer.append(this.constructComplementString(string4));
                    stringBuffer.append("\n");
                    stringBuffer.append(this.lineString);
                    this.countText += this.STRING_WRAP_LENGTH;
                    int n3 = this.STRING_WRAP_LENGTH - this.targetText.length();
                    while (n3 + this.STRING_WRAP_LENGTH <= n2) {
                        string4 = string.substring(n3, n3 + this.STRING_WRAP_LENGTH);
                        this.countStringUpdate();
                        stringBuffer.append(this.countString);
                        stringBuffer.append(string4);
                        stringBuffer.append("\n");
                        stringBuffer.append(this.constructComplementString(string4));
                        stringBuffer.append("\n");
                        stringBuffer.append(this.lineString);
                        this.countText += this.STRING_WRAP_LENGTH;
                        n3 += this.STRING_WRAP_LENGTH;
                    }
                    this.textPane.getDocument().insertString(this.textPane.getDocument().getLength(), stringBuffer.toString(), this.attributes);
                    this.targetText = n3 < n2 ? string.substring(n3) : "";
                }
                return;
            }
            if (font != null) {
                logger.debug("drawString(): Printing " + string + " with defined font.");
                this.textPane.getDocument().insertString(this.textPane.getDocument().getLength(), string, simpleAttributeSet);
            } else {
                logger.debug("drawString(): No font defined. Printing " + string + " with default font.");
                StyleConstants.setFontSize(this.attributes, this.dos.getFont().getSize());
                this.textPane.getDocument().insertString(this.textPane.getDocument().getLength(), string, this.attributes);
            }
            return;
        }
        if (string2.equals("") && string.indexOf("\n") == 0) {
            try {
                this.flushAndEndCurrentLine();
            }
            catch (Exception exception) {
                logger.error(exception.getMessage());
                throw exception;
            }
            if (string.length() > 1) {
                this.drawString(string.substring(1, string.length()), "", font);
            }
            return;
        }
        if (string.indexOf(10) != -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", false);
            while (stringTokenizer.hasMoreTokens()) {
                this.drawString(stringTokenizer.nextToken(), string2, font);
                this.flushAndEndCurrentLine();
            }
            return;
        }
        FontMetrics fontMetrics2 = fontMetrics = font == null ? this.currFontMetrics : this.og.getFontMetrics(font);
        if (fontMetrics == null) {
            FontMetrics fontMetrics3 = fontMetrics = font == null ? this.nonSvg_currFontMetrics : this.nonSvg_og.getFontMetrics(font);
        }
        if (this.text_x_cursor + (n = fontMetrics.stringWidth(string)) > this.viewing_width - this.right_margin && this.breakable) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                n = fontMetrics.stringWidth(string5);
                if (this.text_x_cursor + n > this.viewing_width - this.right_margin) {
                    String string6 = "";
                    if (this.font_buffer.size() == 0) {
                        this.text_buffer.addElement(string5);
                        this.font_buffer.addElement(font);
                        this.color_buffer.addElement(this.og.getColor());
                        this.curr_dei_buffer.addElement(this.getDTDElementInstance());
                        this.text_linkset_buffer.addElement(this.current_linkSet);
                    } else if (!this.eraseable_space || !string5.equals(" ")) {
                        string6 = string5;
                    }
                    while (stringTokenizer.hasMoreTokens()) {
                        string5 = stringTokenizer.nextToken();
                        if (string6.length() == 0 && string5.equals(" ")) continue;
                        string6 = string6 + string5;
                        break;
                    }
                    this.flushAndEndCurrentLine();
                    while (stringTokenizer.hasMoreTokens()) {
                        string6 = string6 + stringTokenizer.nextToken();
                    }
                    if (string6.length() > 0) {
                        this.drawString(string6, string2, font);
                    }
                    return;
                }
                this.text_x_cursor += n;
                this.text_buffer.addElement(string5);
                this.font_buffer.addElement(font);
                this.color_buffer.addElement(this.og.getColor());
                this.curr_dei_buffer.addElement(this.getDTDElementInstance());
                this.text_linkset_buffer.addElement(this.current_linkSet);
            }
        } else {
            this.text_x_cursor += n;
            this.text_buffer.addElement(string);
            this.font_buffer.addElement(font);
            this.color_buffer.addElement(this.og.getColor());
            this.curr_dei_buffer.addElement(this.getDTDElementInstance());
            this.text_linkset_buffer.addElement(this.current_linkSet);
        }
    }

    private void countStringUpdate() {
        this.countString = Integer.toString(this.countText);
        int n = LINE_NUMBER_WIDTH - this.countString.length();
        StringBuffer stringBuffer = new StringBuffer(LINE_NUMBER_WIDTH);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        stringBuffer.append(this.countString);
        stringBuffer.append(": +");
        this.countString = stringBuffer.toString();
    }

    public void drawString(String string) throws Exception {
        if (string == null || string.length() == 0 || string.startsWith("\n")) {
            return;
        }
        if (315 == this.viewMode) {
            if (this.inTargetText) {
                this.drawString(string, "\t ", null);
            } else {
                StyleConstants.setFontSize(this.attributes, this.dos.getFont().getSize());
                this.textPane.getDocument().insertString(this.textPane.getDocument().getLength(), string, this.attributes);
            }
            return;
        }
        this.eraseable_space = true;
        this.drawString(string, "\t ", null);
        this.eraseable_space = false;
    }

    private String createPositionKey(int n) {
        String string = "" + n;
        int n2 = 30 - string.length();
        for (int i = 0; i < n2; ++i) {
            string = " " + string;
        }
        return string;
    }

    public boolean isLabelSpaceAvailable(int n, String string, Font font, int n2, double d, double d2, int n3) {
        int n4;
        double d3;
        SortedMap sortedMap;
        String string2;
        boolean bl = d >= 0.0 && d2 >= 0.0;
        TreeMap treeMap = bl ? this.posToTopLabelMap : this.posToBottomLabelMap;
        SortedMap sortedMap2 = treeMap.headMap(string2 = this.createPositionKey(n2));
        if (sortedMap2 != null && !sortedMap2.isEmpty() && (sortedMap = sortedMap2.lastKey()) != null && !"".equals(sortedMap) && (d3 = (double)(n2 - (n4 = Integer.valueOf(((String)((Object)sortedMap)).trim()).intValue())) / this.getScale()) < 12.0) {
            return false;
        }
        sortedMap = treeMap.tailMap(string2);
        if (sortedMap != null && !sortedMap.isEmpty()) {
            int n5;
            double d4;
            String string3 = (String)sortedMap.firstKey();
            if (string3.equals(string2) && (sortedMap = treeMap.tailMap(this.createPositionKey(n2 + 1))) != null && !sortedMap.isEmpty()) {
                string3 = sortedMap.firstKey();
            }
            if (string3 != null && !"".equals(string3) && (d4 = (double)((n5 = Integer.valueOf(string3.trim()).intValue()) - n2) / this.getScale()) < 12.0) {
                return false;
            }
        }
        treeMap.put(string2, "");
        return true;
    }

    public void drawString(int n, String string, Font font, int n2, double d, double d2, int n3) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (315 == this.viewMode) {
            return;
        }
        Graphics graphics = this.getGraphics(n);
        graphics.setFont(font == null ? this.currFont : font);
        LinearTarget linearTarget = (LinearTarget)this.targets.elementAt(n);
        linearTarget.drawString(graphics, string, n2, d, d2, n3);
        this.og.setFont(this.currFont);
        this.resetGraphics(n);
    }

    public void drawStringIfPossible(int n, String string, Font font, int n2, double d, double d2, int n3) {
        if (this.isLabelSpaceAvailable(n, string, font, n2, d, d2, n3)) {
            this.drawString(n, string, font, n2, d, d2, n3);
        }
    }

    public void drawAngledString(int n, String string, Font font, int n2, double d, double d2, int n3, double d3) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (315 == this.viewMode) {
            return;
        }
        Graphics graphics = this.getGraphics(n);
        graphics.setFont(font == null ? this.currFont : font);
        LinearTarget linearTarget = (LinearTarget)this.targets.elementAt(n);
        if (this.isInTextMode()) {
            AffineTransform affineTransform = ((Graphics2D)graphics).getTransform();
            linearTarget.drawAngledString(graphics, string, n2, d, d2, n3, d3);
            ((Graphics2D)graphics).setTransform(affineTransform);
        } else {
            linearTarget.drawAngledString(graphics, string, n2, d, d2, n3, d3);
        }
        this.og.setFont(this.currFont);
        this.resetGraphics(n);
    }

    public void drawAngledString(int n, String string, Font font, int n2, double d, int n3, double d2) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (315 == this.viewMode) {
            return;
        }
        Graphics graphics = this.getGraphics(n);
        graphics.setFont(font == null ? this.currFont : font);
        LinearTarget linearTarget = (LinearTarget)this.targets.elementAt(n);
        linearTarget.drawAngledString(graphics, string, n2, d, n3, d2);
        this.og.setFont(this.currFont);
        this.resetGraphics(n);
    }

    public void drawString(int n, String string, Font font, int n2, double d, int n3) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (315 == this.viewMode) {
            return;
        }
        Graphics graphics = this.getGraphics(n);
        graphics.setFont(font == null ? this.currFont : font);
        LinearTarget linearTarget = (LinearTarget)this.targets.elementAt(n);
        linearTarget.drawString(graphics, string, n2, d, n3);
        this.og.setFont(this.currFont);
        this.resetGraphics(n);
    }

    public void drawWaypointIcon(int n, String string, Image image, int n2, int n3, int n4, int n5, double d) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (315 == this.viewMode) {
            return;
        }
        ((LinearTarget)this.targets.elementAt(n)).drawWaypointIcon(this.getGraphics(n), string, image, n2, n3, n4, n5, d);
        this.resetGraphics(n);
    }

    public void drawVerticalString(int n, String string, Font font, int n2, double d, int n3) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (315 == this.viewMode) {
            return;
        }
        Graphics graphics = this.getGraphics(n);
        graphics.setFont(font == null ? this.currFont : font);
        LinearTarget linearTarget = (LinearTarget)this.targets.elementAt(n);
        linearTarget.drawVerticalString(graphics, string, n2, d, n3);
        this.og.setFont(this.currFont);
        this.resetGraphics(n);
    }

    public void setFont(Font font) {
        this.currFont = font;
    }

    public Font getFont() {
        return this.currFont;
    }

    private Graphics createGraphics(int n) {
        Graphics graphics = null;
        if (this.target_buffers.elementAt(n) == null) {
            logger.warn("BlueALG.createGraphics() -- Target #" + n + " does not have a graphics context: calling this method is seriously deprecated!");
            return null;
        }
        graphics = ((Image)this.target_buffers.elementAt(n)).getGraphics();
        graphics.setColor(this.og.getColor());
        return graphics;
    }

    private Graphics getGraphics(int n) {
        if (this.target_anchors == null || this.target_anchors.size() == 0) {
            return null;
        }
        Point point = (Point)this.target_anchors.elementAt(n);
        if (point != null) {
            while (point.y == -1) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("    -> BALG.getGraphics(): Sleep interrupted");
                    return null;
                }
            }
            if (this.og == null) {
                Graphics graphics = this.component.createImage(20, 20).getGraphics();
                graphics.translate(point.x, point.y);
                this.translatedOrigin.translate(point.x, point.y);
                return graphics;
            }
            this.og.translate(point.x, point.y);
            this.translatedOrigin.translate(point.x, point.y);
            return this.og;
        }
        System.out.println("Anguo:: it is in <<BluejayAbstractLinearGraphics>> getGraphics else");
        if (this.currentGraphicsMode == 103) {
            new Exception("WARNING: Attempt to alg.getGraphics for SVG").printStackTrace();
            return null;
        }
        if (this.currentGraphicsMode == 102) {
            new Exception("WARNING: Attempt to alg.getGraphics for BATIK").printStackTrace();
            return null;
        }
        return this.createGraphics(n);
    }

    public void resetGraphics(int n) {
        Point point = (Point)this.target_anchors.elementAt(n);
        if (point.y != -1) {
            if (this.og != null) {
                this.og.translate(-point.x, -point.y);
            }
            this.translatedOrigin.translate(-point.x, -point.y);
        }
    }

    public void drawLine(int n, int n2, int n3, double d, double d2) {
        if (315 == this.viewMode) {
            return;
        }
        ((LinearTarget)this.targets.elementAt(n)).drawLine(this.getGraphics(n), n2, n3, d, d2);
        this.resetGraphics(n);
    }

    public void drawLinkingLine(int n, int n2, int n3, double d, double d2, double d3, int n4, int n5, double d4, double d5, double d6) throws Exception {
        if (315 == this.viewMode) {
            return;
        }
        ((LinearTarget)this.targets.elementAt(n)).drawLinkingLine(this.getGraphics(n), n2, n3, d, d2, d3, n4, n5, d4, d5, d6);
        this.resetGraphics(n);
    }

    public void drawRect(int n, int n2, int n3, double d, double d2) {
        if (315 == this.viewMode) {
            return;
        }
        if (this.isArrowShape()) {
            this.drawArrowShape(n, n2, n3, d, d2);
            return;
        }
        ((LinearTarget)this.targets.elementAt(n)).drawRect(this.getGraphics(n), n2, n3, d, d2);
        this.resetGraphics(n);
    }

    public void setTextModePosition(int n) {
        if (315 == this.viewMode) {
            int n2 = n / this.STRING_WRAP_LENGTH * (3 * this.ADJ_STRING_WRAP_LENGTH) + n % this.STRING_WRAP_LENGTH + MARGINS - 1;
            int n3 = this.textStartPoint + n2 + 550;
            if (this.textPane.getDocument().getLength() <= n3) {
                n3 = this.textPane.getDocument().getLength() - 1;
            }
            this.textPane.setCaretPosition(n3);
            this.textPane.revalidate();
            this.textPane.repaint();
        }
    }

    private void fillTextRect(int n, int n2, boolean bl, Color color) {
        SimpleAttributeSet simpleAttributeSet = (SimpleAttributeSet)this.attributes.copyAttributes();
        if (color.getRed() + color.getGreen() + color.getBlue() > 384) {
            StyleConstants.setForeground(simpleAttributeSet, Color.black);
        } else {
            StyleConstants.setForeground(simpleAttributeSet, Color.white);
        }
        StyleConstants.setBackground(simpleAttributeSet, color);
        StyleConstants.setFontSize(simpleAttributeSet, this.dos.getFont().getSize());
        int n3 = n / this.STRING_WRAP_LENGTH * (3 * this.ADJ_STRING_WRAP_LENGTH) + n % this.STRING_WRAP_LENGTH + MARGINS - 1;
        int n4 = n2 / this.STRING_WRAP_LENGTH * (3 * this.ADJ_STRING_WRAP_LENGTH) + n2 % this.STRING_WRAP_LENGTH + MARGINS - 1;
        int n5 = n4 - n3 + 1;
        if (!bl) {
            n3 += this.ADJ_STRING_WRAP_LENGTH;
            n4 += this.ADJ_STRING_WRAP_LENGTH;
        }
        boolean bl2 = true;
        int n6 = n3;
        while (bl2 && n6 <= n4) {
            int n7 = (n6 / (3 * this.ADJ_STRING_WRAP_LENGTH) + 1) * this.ADJ_STRING_WRAP_LENGTH * 3 - RIGHT_MARGIN - this.ADJ_STRING_WRAP_LENGTH;
            if (bl) {
                n7 -= this.ADJ_STRING_WRAP_LENGTH;
            }
            if (n7 > n4) {
                n7 = n4;
                bl2 = false;
            }
            if (n6 > n4) continue;
            int n8 = n7 - n6 + 1;
            ((StyledDocument)this.textPane.getDocument()).setCharacterAttributes(this.textStartPoint + n6 - 1, n8, simpleAttributeSet, true);
            n6 = n7 + MARGINS + 1 + 2 * this.ADJ_STRING_WRAP_LENGTH;
        }
        logger.debug("fillTextRect(): The following should be on the " + (bl ? "positive" : "negative") + " strand");
        logger.debug("fillTextRect(): start is: " + n + " stop is: " + n2 + "stop-start+1 is: " + (n2 - n + 1));
        logger.debug("fillTextRect(): the adjusted start position is: " + n3 + ", the adjusted stop position is: " + n4 + " and the difference between stop and start +1 is: " + (n4 - n3 + 1));
    }

    public void setDEITextVisible(String string, int n) {
        Vector vector;
        if (this.xPtrToTextMap.containsKey(string) && (vector = (Vector)this.xPtrToTextMap.get(string)) != null) {
            int n2 = (Integer)vector.elementAt(0);
            int n3 = (Integer)vector.elementAt(1);
            boolean bl = (Boolean)vector.elementAt(2);
            Color color = null;
            if (n == 112) {
                color = (Color)vector.elementAt(3);
            } else if (n == 113) {
                color = (Color)vector.elementAt(3);
                color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 85);
            } else if (n == 114) {
                color = Color.white;
            }
            this.fillTextRect(n2, n3, bl, color);
        }
    }

    public void fillRect(int n, int n2, int n3, double d, double d2) {
        if (315 == this.viewMode) {
            if (n2 >= 125000 && n3 >= 125000) {
                return;
            }
            if (n2 >= 125000) {
                n2 = 124999;
            } else if (n3 >= 125000) {
                n3 = 124999;
            }
            Color color = this.getColor();
            boolean bl = d >= 0.0;
            Vector<Object> vector = new Vector<Object>();
            vector.add(new Integer(n2));
            vector.add(new Integer(n3));
            vector.add(new Boolean(bl));
            vector.add(color);
            this.xPtrToTextMap.put(this.getDTDElementInstance().getXPointer(), vector);
            String string = this.getDTDElementInstance().getLegendLabel();
            int n4 = string == null ? 112 : this.legend.getLegendItemVisibility(string);
            this.setDEITextVisible(this.getDTDElementInstance().getXPointer(), n4);
            return;
        }
        ((LinearTarget)this.targets.elementAt(n)).fillRect(this.getGraphics(n), n2, n3, d, d2);
        this.resetGraphics(n);
    }

    public Point getPoint(int n, int n2, double d) {
        if (315 == this.viewMode) {
            return null;
        }
        if (this.targets == null || this.targets.size() == 0) {
            return null;
        }
        Graphics graphics = this.getGraphics(n);
        Point point = ((LinearTarget)this.targets.elementAt(n)).getPointLocally(n2, d);
        point.translate(this.translatedOrigin.x, this.translatedOrigin.y);
        this.resetGraphics(n);
        return point;
    }

    public Point getPoint(TargetAppearance targetAppearance, int n, double d) {
        if (315 == this.viewMode) {
            return null;
        }
        Point point = targetAppearance.getTopLeftAnchor();
        if (point.y == -1) {
            new Exception("###ERROR: Target topLeftAnchor hasn't been positioned").printStackTrace();
            return null;
        }
        Point point2 = targetAppearance.getLinearTarget().getPointLocally(n, d);
        point2.translate(point.x, point.y);
        return point2;
    }

    public int getPosition(TargetAppearance targetAppearance, Point point) {
        if (315 == this.viewMode) {
            return -777;
        }
        Point point2 = targetAppearance.getTopLeftAnchor();
        if (point2.y == -1) {
            logger.error("getPosition(): Target topLeftAnchor hasn't been positioned");
            new Exception("ERROR: Target topLeftAnchor hasn't been positioned").printStackTrace();
            return -777;
        }
        Point point3 = new Point(point);
        point3.translate(-point2.x, -point2.y);
        return targetAppearance.getLinearTarget().getPositionLocally(point3);
    }

    public boolean isWithinTargetArea(TargetAppearance targetAppearance, Point point) {
        if (315 == this.viewMode) {
            return false;
        }
        Point point2 = targetAppearance.getTopLeftAnchor();
        if (point2.y == -1) {
            logger.error("isWithinTargetArea: Target topLeftAnchor hasn't been positioned");
            new Exception("ERROR: Target topLeftAnchor hasn't been positioned").printStackTrace();
            return false;
        }
        Point point3 = new Point(point);
        point3.translate(-point2.x, -point2.y);
        logger.debug("isWithinTargetArea(): the point being checked = " + point + "  -> local Point (with target offset) =" + point3);
        return targetAppearance.getLinearTarget().isWithinTargetAreaLocally(point3);
    }

    public Vector getVisiblePositionRange(int n) {
        Vector<int[]> vector = new Vector<int[]>(1);
        int[] nArray = this.vizMgr.getDrawnRange();
        if (nArray[0] > nArray[1]) {
            if (this.isInTextMode()) {
                LinearTarget linearTarget = this.getTarget(n);
                nArray[0] = linearTarget.getMinPosition();
                vector.add(nArray);
            } else {
                LinearTarget linearTarget = this.getTarget(n);
                int[] nArray2 = new int[]{nArray[0], linearTarget.getMaxPosition()};
                nArray[0] = linearTarget.getMinPosition();
                vector.add(nArray);
                vector.add(nArray2);
            }
        } else {
            vector.add(nArray);
        }
        return vector;
    }

    public void setVisiblePositionRange(List list) {
        logger.info("setVisiblePositionRange(): Setting visible range segments:");
        if (!this.visibleRangeSegments.isEmpty()) {
            this.visibleRangeSegments = new Vector();
        }
        for (int i = 0; i < list.size(); ++i) {
            int[] nArray = (int[])list.get(i);
            int[] nArray2 = new int[]{nArray[0], nArray[1]};
            this.visibleRangeSegments.add(nArray2);
            logger.info("\tSETTING [" + nArray2[0] + "," + nArray2[1] + "] ");
            this.vizMgr.setVisibleRange(0, nArray2[0], nArray2[1]);
        }
    }

    public void clearVisiblePositionRange() {
        if (!this.visibleRangeSegments.isEmpty()) {
            this.visibleRangeSegments = new Vector();
        }
    }

    public boolean hasPositionsOutsideVisibleRange() {
        TargetAppearance targetAppearance;
        int[] nArray;
        if (this.visibleRangeSegments == null || this.visibleRangeSegments.isEmpty()) {
            return false;
        }
        if (this.targetDeiAppearances == null || this.targetDeiAppearances.isEmpty()) {
            return false;
        }
        return this.visibleRangeSegments.size() != 1 || (nArray = (int[])this.visibleRangeSegments.get(0))[0] > (targetAppearance = (TargetAppearance)this.targetDeiAppearances.firstElement()).getMinPosition() || nArray[1] < targetAppearance.getMaxPosition();
    }

    public double ratioPositionsInVisibleRange() {
        if (this.hasPositionsOutsideVisibleRange() || this.targetDeiAppearances.size() == 0) {
            return 1.0;
        }
        TargetAppearance targetAppearance = (TargetAppearance)this.targetDeiAppearances.firstElement();
        int n = 0;
        int n2 = this.visibleRangeSegments.size();
        for (int i = 0; i < n2; ++i) {
            int[] nArray = (int[])this.visibleRangeSegments.get(i);
            int n3 = nArray[0] > targetAppearance.getMinPosition() ? nArray[0] : targetAppearance.getMinPosition();
            int n4 = nArray[1] < targetAppearance.getMaxPosition() ? nArray[1] : targetAppearance.getMaxPosition();
            n += n4 - n3 + 1;
        }
        return (double)n / (double)(targetAppearance.getMaxPosition() - targetAppearance.getMinPosition() + 1);
    }

    private boolean isOutsideVisiblePositionRange(int n) {
        return this.isOutsideVisiblePositionRange(n, n);
    }

    private boolean isOutsideVisiblePositionRange(int n, int n2) {
        if (this.currentGraphicsMode == 103 && this.svgViewbox == null) {
            return false;
        }
        if (this.vizMgr != null) {
            int[] nArray = this.vizMgr.getDrawnRange();
            return n < n2 ? n > nArray[1] || n2 < nArray[0] : n2 > nArray[1] || n < nArray[0];
        }
        if (this.visibleRangeSegments == null || this.visibleRangeSegments.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.visibleRangeSegments.size(); ++i) {
            int[] nArray = (int[])this.visibleRangeSegments.get(i);
            if (n < nArray[0] && n2 < nArray[0] || n > nArray[1] && n2 > nArray[1]) continue;
            return false;
        }
        return true;
    }

    public void drawPolygon(int n, Polygon polygon, Rectangle rectangle, int n2, int n3, double d, double d2) {
        if (315 == this.viewMode) {
            return;
        }
        ((LinearTarget)this.targets.elementAt(n)).drawPolygon(this.getGraphics(n), polygon, rectangle, n2, n3, d, d2);
        this.resetGraphics(n);
    }

    public void fillPolygon(int n, Polygon polygon, Rectangle rectangle, int n2, int n3, double d, double d2) {
        if (315 == this.viewMode) {
            return;
        }
        ((LinearTarget)this.targets.elementAt(n)).fillPolygon(this.getGraphics(n), polygon, rectangle, n2, n3, d, d2);
        this.resetGraphics(n);
    }

    public void drawArc(int n, int n2, int n3, double d, double d2, int n4, int n5) {
        ((LinearTarget)this.targets.elementAt(n)).drawArc(this.getGraphics(n), n2, n3, d, d2, n4, n5);
        this.resetGraphics(n);
    }

    public void drawArrowShape(int n, int n2, int n3, double d, double d2) {
        if (315 == this.viewMode) {
            return;
        }
        ((LinearTarget)this.targets.elementAt(n)).drawArrowShape(this.getGraphics(n), n2, n3, d, d2);
        this.resetGraphics(n);
    }

    public void fillArc(int n, int n2, int n3, double d, double d2, int n4, int n5) {
        if (315 == this.viewMode) {
            return;
        }
        ((LinearTarget)this.targets.elementAt(n)).fillArc(this.getGraphics(n), n2, n3, d, d2, n4, n5);
        this.resetGraphics(n);
    }

    public void drawImage(int n, Image image, int n2, int n3, double d, double d2) {
        System.err.println("DRAWING");
        if (315 == this.viewMode) {
            return;
        }
        ((LinearTarget)this.targets.elementAt(n)).drawImage(this.getGraphics(n), image, n2, n3, d, d2);
        this.resetGraphics(n);
    }

    public Object drawObject(int n, Object object) {
        return ((LinearTarget)this.targets.elementAt(n)).drawObject(object);
    }

    public int getLOD() {
        return this.level_of_detail;
    }

    public void setLOD(int n) throws IllegalArgumentException {
        if (n != this.level_of_detail) {
            switch (n) {
                case 60: {
                    break;
                }
                case 70: {
                    break;
                }
                case 80: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized level-of-detail ID=" + n);
                }
            }
            int n2 = this.level_of_detail;
            this.level_of_detail = n;
            this.propertyChangeEventFirer.firePropertyChange("LOD", n2, this.level_of_detail);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeEventFirer.addPropertyChangeListener(propertyChangeListener);
    }

    public boolean getImageSizeExceeded() {
        return this.imageSizeExceeded;
    }

    public void setImageSizeExceeded(boolean bl) {
        this.imageSizeExceeded = bl;
    }

    public void setLinkSet(LinkSet linkSet) {
        this.outgoingXLinks = linkSet;
        if (this.outgoingXLinks.isEmpty()) {
            this.outgoingXLinkURL = null;
        } else {
            this.outgoingXLinkURL = this.outgoingXLinks.firstLink().getFromNode().getURL().toString();
            this.outgoingXLinkURL = this.outgoingXLinkURL.substring(0, this.outgoingXLinkURL.indexOf(35));
        }
    }

    public LinkSet getLinkSet() {
        return this.outgoingXLinks;
    }

    public boolean isInTextMode() {
        return this.isTextHMode() || this.isTextVMode();
    }

    public void setDTDElementInstance(DTDElementInstance dTDElementInstance) {
        this.deiCurrentlyBeingDrawn = dTDElementInstance;
        if (this.currentGraphicsMode == 102 && 315 != this.viewMode) {
            this.batik_g2d.setDataXPointer(dTDElementInstance == null ? null : dTDElementInstance.getXPointer());
            this.batik_g2d.setDataVisibility(dTDElementInstance == null ? 114 : dTDElementInstance.getVisibility());
            this.batik_g2d.setDataGenomeNum(dTDElementInstance == null ? -1 : dTDElementInstance.getSlaveNum());
        }
    }

    public DTDElementInstance getDTDElementInstance() {
        return this.deiCurrentlyBeingDrawn;
    }

    public double getFeatureFactor() {
        return this.featureFactor;
    }

    public void setFeatureFactor(double d) {
        this.featureFactor = d;
    }

    public void setSingleFrameMode() {
        this.viewMode = 316;
        this.xPtrToTextMap = new TreeMap();
    }

    public boolean isSingleFrameMode() {
        return 316 == this.viewMode;
    }

    public boolean isTwoFrameMode() {
        return 313 == this.viewMode;
    }

    public void setTwoFrameMode() {
        this.viewMode = 313;
        this.xPtrToTextMap = new TreeMap();
    }

    public boolean isTextHMode() {
        return 317 == this.viewMode;
    }

    public void setTextHMode() {
        this.viewMode = 317;
        this.xPtrToTextMap = new TreeMap();
    }

    public boolean isTextVMode() {
        return 318 == this.viewMode;
    }

    public void setTextVMode() {
        this.viewMode = 318;
        this.xPtrToTextMap = new TreeMap();
    }

    public boolean isSixFrameMode() {
        return 314 == this.viewMode;
    }

    public void setSixFrameMode() {
        this.viewMode = 314;
        this.xPtrToTextMap = new TreeMap();
    }

    public boolean isArrowShape() {
        return 316 == this.viewShape;
    }

    public boolean isRectShape() {
        return 315 == this.viewShape;
    }

    public void setArrowShape() {
        this.viewShape = 316;
    }

    public void setRectShape() {
        this.viewShape = 315;
    }

    public void setPreserveTargetAppearances(boolean bl) {
        this.preserveAppearances = bl;
        if (!this.preserveAppearances) {
            this.targetDeiAppearances.removeAllElements();
        }
    }

    public boolean isPreserveTargetAppearances() {
        return this.preserveAppearances;
    }

    public void setPieChartMode() {
        this.viewMode = 312;
    }

    public boolean isPieChartMode() {
        return 312 == this.viewMode;
    }

    public void setBarChartMode() {
        this.viewMode = 311;
    }

    public boolean isBarChartMode() {
        return 311 == this.viewMode;
    }

    public boolean isInChartMode() {
        return this.isBarChartMode() || this.isPieChartMode();
    }

    public boolean isTwoFrameTranslation() {
        return 1001 == this.translationMode;
    }

    public void setTwoFrameTranslation() {
        this.translationMode = 1001;
    }

    public boolean isSixFrameTranslation() {
        return 1002 == this.translationMode;
    }

    public void setSixFrameTranslation() {
        this.translationMode = 1002;
    }

    public boolean isNoTranslation() {
        return 1000 == this.translationMode;
    }

    public void setNoTranslation() {
        this.translationMode = 1000;
    }

    public boolean isThreeLetter() {
        return 333 == this.aminoAcidMode;
    }

    public void setThreeLetter() {
        this.aminoAcidMode = 333;
    }

    public boolean isOneLetter() {
        return 1 == this.aminoAcidMode;
    }

    public void setOneLetter() {
        this.aminoAcidMode = 1;
    }

    public void makeBarChart() {
        logger.debug("### BALG.makeBarChart() legend=" + this.legend + ", batik_g2d=" + this.batik_g2d);
        this.legend.makeBarChart(this.og, this.component.getSize());
    }

    public void makePieChart() {
        logger.debug("### BALG.makePieChart() legend=" + this.legend + ", batik_g2d=" + this.batik_g2d);
        this.legend.makePieChart(this.og, this.component.getSize());
    }

    public int getMaxLabelLength() {
        return this.maxLabelLength;
    }

    public void setMaxLabelLength(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException("Attempt to set an invalid max label length " + n);
        }
        this.maxLabelLength = n;
    }

    public int getLeftMargin() {
        return this.left_margin;
    }

    public int getRightMargin() {
        return this.right_margin;
    }

    public Graphics2D getSVGExportLegendGraphics() {
        return null;
    }

    public void setAGLevelShown(boolean bl) {
        this.showAG = bl;
    }

    public boolean isAGLevelShown() {
        return this.showAG;
    }

    public void setGCLevelShown(boolean bl) {
        this.showGC = bl;
    }

    public boolean isGCLevelShown() {
        return this.showGC;
    }

    public void setCleavageShown(boolean bl) {
        this.showCleavage = bl;
    }

    public boolean isCleavageShown() {
        return this.showCleavage;
    }

    public MultipleArrayViewer getArrayViewer() {
        return arrayViewer;
    }

    public void setArrayViewer(MultipleArrayViewer multipleArrayViewer) {
        arrayViewer = multipleArrayViewer;
    }

    public BluejayMicroArrayElementPainter getArrayPainter() {
        return this.arrayPainter;
    }

    public WaypointsPainter getWaypointsPainter() {
        return this.waypointsPainter;
    }

    public TreeMap getxPtrToGBMap() {
        return this.xPtrToGBMap;
    }

    public TreeMap getGBToXPtrMap() {
        return this.GBToXPtrMap;
    }

    public void resetMicroArrayTreeMaps() {
        this.xPtrToGBMap = new TreeMap();
        this.GBToXPtrMap = new TreeMap();
        this.slideToXPtrMap = new TreeMap();
    }

    public void setAnalysisMonitor(AnalysisMonitor analysisMonitor) {
        this.analysisMonitor = analysisMonitor;
    }

    public AnalysisMonitor getAnalysisMonitor() {
        return this.analysisMonitor;
    }

    public TreeMap getSlideToXPtrMap() {
        return this.slideToXPtrMap;
    }

    public BluejayMicroArrayPlayerPainter getArrayPlayerPainter() {
        return this.arrayPlayerPainter;
    }

    public BluejayMicroArrayComparisonPainter getArrayComparisonPainter() {
        return this.arrayComparisonPainter;
    }

    public void setDoubleBuffering(boolean bl) {
        this.svgCanvas.setDoubleBufferedRendering(bl);
    }

    public boolean getDoubleBuffering() {
        return this.svgCanvas.getDoubleBufferedRendering();
    }

    public Dimension getVisibleSize() {
        return this.svgCanvas.getSize();
    }

    public WaypointsTab getWaypointsWidget() {
        return ((BluejayDObjectList)this.svgCanvas).getWaypointsWidget();
    }

    public int[] getDimensions(String string) {
        int[] nArray = new int[3];
        FontMetrics fontMetrics = null;
        if (this.currFontMetrics != null) {
            fontMetrics = this.currFontMetrics;
        } else if (this.nonSvg_currFontMetrics != null) {
            fontMetrics = this.nonSvg_currFontMetrics;
        }
        if (fontMetrics == null) {
            System.err.println("Warning: Cannot get a font metrics from BluejayAbstractLinearGraphics");
            return null;
        }
        nArray[0] = (int)fontMetrics.getStringBounds(string, this.og).getWidth();
        nArray[1] = fontMetrics.getHeight();
        nArray[2] = fontMetrics.getDescent();
        return nArray;
    }

    public boolean isGCSkewShown() {
        return this.showGCSkew;
    }

    public void setGCSkewShown(boolean bl) {
        this.showGCSkew = bl;
    }

    public void fillRectangle(int n, int n2, int n3, double d, double d2) {
        if (315 == this.viewMode) {
            return;
        }
        ((LinearTarget)this.targets.elementAt(n)).fillRect(this.getGraphics(n), n2, n3, d, d2);
        this.resetGraphics(n);
    }

    public void fillArrowShape(int n, int n2, int n3, double d, double d2) {
        if (315 == this.viewMode) {
            return;
        }
        ((LinearTarget)this.targets.elementAt(n)).fillArrowShape(this.getGraphics(n), n2, n3, d, d2);
        this.resetGraphics(n);
    }

    public LinkingLinePainter getLLPainter() {
        return this.linkingLinePainter;
    }

    public void setLLPainter(LinkingLinePainter linkingLinePainter) {
        this.linkingLinePainter = linkingLinePainter;
    }

    public double getCharWidth() {
        this.nonSvg_og.setFont(new Font("Monospaced", 0, 12));
        Rectangle2D rectangle2D = this.nonSvg_og.getFontMetrics().getStringBounds("a", this.nonSvg_og);
        double d = rectangle2D.getWidth();
        return d += (double)0.2f;
    }

    public double getCharHeight() {
        this.nonSvg_og.setFont(new Font("Monospaced", 0, 12));
        double d = this.nonSvg_og.getFontMetrics().getAscent();
        return d;
    }

    public void removeAllTargets() {
        this.targets.removeAllElements();
    }

    static {
        LINE_NUMBER_WIDTH = 7;
        LEFT_MARGIN = LINE_NUMBER_WIDTH + 3;
        RIGHT_MARGIN = 1;
        MARGINS = LEFT_MARGIN + RIGHT_MARGIN;
        logger = Logger.getLogger(BluejayAbstractLinearGraphics.class);
    }
}

