/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.client.TargetAppearance;
import ca.ucalgary.bluejay.client.URLLoader;
import ca.ucalgary.bluejay.client.XPointerResolver;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.DataNavigator;
import ca.ucalgary.bluejay.gui.SelectedTextGUI;
import ca.ucalgary.bluejay.gui.comparison.Genome;
import ca.ucalgary.bluejay.gui.menu.ComparisonMenuManager;
import ca.ucalgary.bluejay.gui.microarray.MicroArrayGUI;
import ca.ucalgary.bluejay.session.WaypointsGUI;
import ca.ucalgary.bluejay.util.MobyUtils;
import ca.ucalgary.seahawk.gui.MobyServicesGUI;
import com.simonstl.sax.xlink.Link;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;
import org.biomoby.shared.data.MobyDataComposite;
import org.biomoby.shared.data.MobyDataInstance;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CanvasPopupItemGenerator
extends Thread {
    private ActionListener actionListener;
    private MouseEvent e;
    private int position;
    private boolean isTextSelected;
    private Point startPoint;
    private Point endPoint;
    private int startPosition;
    private int endPosition;
    private JPopupMenu linkPopup;
    private BluejayDObjectList canvas;
    private URLLoader url_loader;
    private JMenuItem checkingLinksPopupItem;
    private MicroArrayGUI microArrayGUI;
    private SelectedTextGUI selectedTextGUI;
    private static MobyServicesGUI mobyGUI;
    private static Logger logger;

    public CanvasPopupItemGenerator(JPopupMenu jPopupMenu, JMenuItem jMenuItem, URLLoader uRLLoader, MouseEvent mouseEvent, int n, boolean bl, Point point, Point point2, int n2, int n3, BluejayDObjectList bluejayDObjectList, ActionListener actionListener) {
        this.linkPopup = jPopupMenu;
        this.checkingLinksPopupItem = jMenuItem;
        this.url_loader = uRLLoader;
        this.e = mouseEvent;
        this.position = n;
        this.isTextSelected = bl;
        this.startPoint = point;
        this.endPoint = point2;
        this.startPosition = n2;
        this.endPosition = n3;
        this.actionListener = actionListener;
        this.canvas = bluejayDObjectList;
    }

    public void run() {
        Point2D point2D;
        Point point = this.e.getPoint();
        DataNavigator dataNavigator = this.canvas.getDataNavigator();
        String string = dataNavigator.getHitGraphicsNodeXPointer((point2D = dataNavigator.getCanvasToTrueCoords(point.x, point.y)).getX(), point2D.getY());
        if (string == null || string.equals("")) {
            this.linkPopup.setVisible(false);
            this.linkPopup.removeAll();
            return;
        }
        boolean bl = false;
        this.canvas.getCompMenuMan();
        boolean bl2 = ComparisonMenuManager.isComparison;
        if (this.e.getButton() == 3) {
            if (!this.canvas.getArrayViewer().isPlayerSelected()) {
                if (this.canvas.getAbstractLinearGraphics().getxPtrToGBMap().containsKey(string)) {
                    this.linkPopup.setVisible(false);
                    this.linkPopup.removeAll();
                    bl = true;
                    this.createMicroArrayGUI(this.linkPopup, string);
                    this.linkPopup.setVisible(true);
                }
                if (this.isTextSelected) {
                    bl = true;
                    this.selectedTextGUI = new SelectedTextGUI(this.canvas, this.url_loader, this.startPoint, this.endPoint, this.startPosition, this.endPosition);
                    this.linkPopup.add(this.selectedTextGUI.createLinkPopup());
                } else {
                    Object object;
                    double d = 1.0;
                    Vector vector = this.canvas.getAbstractLinearGraphics().getTargetAppearances();
                    int n = vector.size();
                    for (int i = 0; i < n; ++i) {
                        String string2 = ((TargetAppearance)vector.elementAt(i)).getXPointer();
                        if (!string.equals(string2)) continue;
                        this.linkPopup.setVisible(false);
                        this.linkPopup.removeAll();
                        return;
                    }
                    Document document = this.canvas.getDocument();
                    Node node = null;
                    if (!bl2) {
                        if (document != null && document.getDocumentElement() != null) {
                            node = XPointerResolver.getNodeFromXPointer(document, string);
                            if (node == null) {
                                logger.warn("Couldn't resolve XPointer in the document using DOM.");
                                this.linkPopup.setVisible(false);
                                this.linkPopup.removeAll();
                                return;
                            }
                        } else {
                            node = XPointerResolver.getNodeFromXPointer(this.url_loader.getActualURLName(), string, this.canvas.getBluejayParser());
                            if (node == null) {
                                logger.warn("Couldn't resolve XPointer in the document using SAX.");
                                this.linkPopup.setVisible(false);
                                this.linkPopup.removeAll();
                                return;
                            }
                        }
                    } else {
                        int n2 = dataNavigator.getHitGraphicsNodeGenomeNum(point2D.getX(), point2D.getY());
                        object = this.canvas.getComparisonPool().getSeqsFromPool().elementAt(n2);
                        node = XPointerResolver.getNodeFromXPointer((Genome)object, string);
                        if (n2 > 0) {
                            d = ((Genome)object).getLenRatio();
                        }
                        if (node == null) {
                            logger.warn("Couldn't resolve XPointer using DOM in Genome class.");
                            this.linkPopup.setVisible(false);
                            this.linkPopup.removeAll();
                            return;
                        }
                    }
                    Object var12_24 = null;
                    if (node != null && node instanceof DTDElementInstance) {
                        object = ((DTDElementInstance)node).getAttribute("element_id");
                        if (((String)object).equals("")) {
                            this.linkPopup.setVisible(false);
                            this.linkPopup.removeAll();
                            return;
                        }
                        this.linkPopup.setVisible(false);
                        bl = true;
                        this.createWaypointsGUI(this.linkPopup, string, node, this.position);
                        this.linkPopup.setVisible(true);
                    }
                }
            }
        } else if (this.e.getButton() == 1) {
            List list = null;
            if (!bl2) {
                list = this.canvas.getDataManager().getHyperlinks(string);
            } else {
                int n = dataNavigator.getHitGraphicsNodeGenomeNum(point2D.getX(), point2D.getY());
                Genome genome = this.canvas.getComparisonPool().getSeqsFromPool().elementAt(n);
                list = this.canvas.getDataManager().getHyperlinks(string, genome);
            }
            if (list != null && list.size() > 0) {
                this.linkPopup.removeAll();
                bl = true;
                this.populateLinkPopup(this.linkPopup, this.actionListener, list);
            }
            Vector vector = this.canvas.getAbstractLinearGraphics().getTargetAppearances();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                String string3 = ((TargetAppearance)vector.elementAt(i)).getXPointer();
                if (!string.equals(string3)) continue;
                this.linkPopup.setVisible(false);
                this.linkPopup.removeAll();
                return;
            }
            Document document = this.canvas.getDocument();
            Node node = null;
            if (!bl2) {
                if (document != null && document.getDocumentElement() != null) {
                    node = XPointerResolver.getNodeFromXPointer(document, string);
                    if (node == null) {
                        this.linkPopup.setVisible(false);
                        this.linkPopup.removeAll();
                        return;
                    }
                } else if (this.url_loader != null && this.url_loader.getActualURLName() != null && (node = XPointerResolver.getNodeFromXPointer(this.url_loader.getActualURLName(), string, this.canvas.getBluejayParser())) == null) {
                    this.linkPopup.setVisible(false);
                    this.linkPopup.removeAll();
                    return;
                }
            } else {
                int n3 = dataNavigator.getHitGraphicsNodeGenomeNum(point2D.getX(), point2D.getY());
                Genome genome = this.canvas.getComparisonPool().getSeqsFromPool().elementAt(n3);
                node = XPointerResolver.getNodeFromXPointer(genome, string);
                if (node == null) {
                    logger.warn("Couldn't resolve XPointer using DOM in Genome class.");
                    this.linkPopup.setVisible(false);
                    this.linkPopup.removeAll();
                    return;
                }
            }
            if (mobyGUI == null) {
                mobyGUI = ca.ucalgary.seahawk.util.MobyUtils.getMobyServicesGUI(null);
            }
            if (mobyGUI != null) {
                mobyGUI.addPopupOptions(node, this.linkPopup, true);
                MobyDataComposite mobyDataComposite = MobyUtils.createMobySequence(this.canvas.getAbstractLinearGraphics(), node);
                if (mobyDataComposite != null) {
                    bl = true;
                    mobyGUI.addPopupOptions((MobyDataInstance)mobyDataComposite, this.linkPopup, true);
                }
            }
        }
        if (this.linkPopup.getSubElements().length > 0) {
            this.linkPopup.setSelected(null);
            this.linkPopup.setVisible(false);
            this.linkPopup.remove(this.checkingLinksPopupItem);
        }
        if (bl) {
            this.linkPopup.validate();
            this.linkPopup.setVisible(true);
        }
    }

    private void populateLinkPopup(JPopupMenu jPopupMenu, ActionListener actionListener, List list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            JMenuItem jMenuItem;
            String string;
            Link link = (Link)list.get(i);
            String string2 = link.getInfo().getLinkTitle();
            String string3 = link.getToNode().getURL().toString();
            String string4 = string = "".equals(string2) ? string3 : string2 + "   >   " + string3;
            if ("embed".equals(link.getArc().getShow())) {
                if (!"onRequest".equals(link.getArc().getActuate()) && "http://www.bioxml.info/roles/feature-elucidation".equals(link.getToNode().getRole())) continue;
                String string5 = link.getFromNode().getURL().getRef();
                jMenuItem = new JMenuItem("Embed XLink " + string);
                jMenuItem.setActionCommand("embedLink_" + string5 + "_" + string3);
            } else {
                jMenuItem = new JMenuItem("XLink " + string);
                jMenuItem.setActionCommand("gotoLink_" + string3);
            }
            if (actionListener != null) {
                jMenuItem.addActionListener(actionListener);
            }
            jPopupMenu.add(jMenuItem);
        }
    }

    private void createWaypointsGUI(JPopupMenu jPopupMenu, String string, Node node, int n) {
        WaypointsGUI waypointsGUI = new WaypointsGUI(this.canvas, this.canvas.getWaypointsWidget(), this.canvas.getViewMenu(), node, n);
        jPopupMenu.add(waypointsGUI.createLinkPopup());
    }

    private void createMicroArrayGUI(JPopupMenu jPopupMenu, String string) {
        this.microArrayGUI = new MicroArrayGUI(this.canvas, this.canvas.getViewMenu());
        jPopupMenu.add(this.microArrayGUI.createLinkPopup(string));
    }

    static {
        logger = Logger.getLogger(CanvasPopupItemGenerator.class);
    }
}

