/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import ca.ucalgary.bluejay.client.impl.BluejayEventCoordinator;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.DataNavigator;
import ca.ucalgary.bluejay.gui.VisibilityManager;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.JScrollBar;
import org.apache.log4j.Logger;

public class CanvasScrollListener
extends MouseAdapter
implements AdjustmentListener {
    private static final int MIN_SCROLL_PIXEL_ADJUSTMENT = 10;
    private static final int SLEEP_INTERVAL = 200;
    private BluejayDObjectList dlist;
    private JScrollBar scroll;
    private int orientation;
    private BluejayEventCoordinator bec;
    private int[] bufferedRange;
    private boolean ignoreAdjustment;
    private int oldScrollValue = -262562;
    private static Logger logger = Logger.getLogger(CanvasScrollListener.class);

    public CanvasScrollListener(JScrollBar jScrollBar, BluejayDObjectList bluejayDObjectList) {
        this.scroll = jScrollBar;
        this.dlist = bluejayDObjectList;
        this.bec = bluejayDObjectList.getEventCoordinator();
        this.orientation = this.scroll.getOrientation();
        this.scroll.setUnitIncrement(10);
        this.scroll.addAdjustmentListener(this);
        this.scroll.addMouseListener(this);
        this.bufferedRange = null;
        this.ignoreAdjustment = false;
    }

    public void setIgnoreAdjustment(boolean bl) {
        this.ignoreAdjustment = bl;
    }

    public boolean isIgnoringAdjustment() {
        return this.ignoreAdjustment;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.isIgnoringAdjustment()) {
            return;
        }
        this.setIgnoreAdjustment(true);
        int n = this.scroll.getValue();
        if (this.bufferedRange != null) {
            if (!this.updateCanvas(this.bufferedRange[0], this.bufferedRange[1])) {
                int n2 = this.getCurrentFocusPosition();
                this.bec.notify(8, "Release scrollbar to display region around position " + n2);
            } else {
                this.bec.notify(8, "Refocused canvas");
            }
            this.setIgnoreAdjustment(false);
        } else {
            this.mousePressed(null);
            if (!this.updateCanvas(this.bufferedRange[0], this.bufferedRange[1])) {
                VisibilityManager visibilityManager = this.dlist.getVisibilityManager();
                int n3 = visibilityManager.getFocusPosition();
                visibilityManager.setFocusPosition(visibilityManager.getFocusTarget(), n3);
            } else {
                this.bec.notify(8, "Refocused canvas");
            }
            this.bufferedRange = null;
        }
        this.setIgnoreAdjustment(false);
    }

    private boolean updateCanvas(int n, int n2) {
        int n3 = this.scroll.getValue();
        if (n < n2 && (n3 > n2 || n3 < n) || n2 < n && (n3 > n || n3 < n2)) {
            this.oldScrollValue = n3;
            return false;
        }
        if (this.oldScrollValue != n3) {
            Point2D point2D = this.dlist.getDataNavigator().getCanvasToTrueCoords(0.0f, 0.0f);
            AffineTransform affineTransform = this.dlist.getRenderingTransform();
            if (this.orientation == 0) {
                affineTransform.translate((int)point2D.getX() - n3, 0.0);
            } else {
                affineTransform.translate(0.0, (int)point2D.getY() - n3);
            }
            this.dlist.setRenderingTransform(affineTransform);
            this.oldScrollValue = n3;
            return true;
        }
        return true;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.bufferedRange = new int[2];
        int n = this.scroll.getVisibleAmount();
        try {
            int n2;
            VisibilityManager visibilityManager = this.dlist.getVisibilityManager();
            AbstractLinearGraphics abstractLinearGraphics = this.dlist.getAbstractLinearGraphics();
            int[] nArray = visibilityManager.getDrawnRange();
            Point point = abstractLinearGraphics.getPoint(visibilityManager.getFocusTarget(), nArray[0], 0.0);
            while (point == null) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("    -> CanvasScrollListener.mousePressed(): Sleep interrupted");
                    return;
                }
                point = abstractLinearGraphics.getPoint(visibilityManager.getFocusTarget(), nArray[0], 0.0);
            }
            int n3 = (int)(this.orientation == 0 ? ((Point2D)point).getX() : ((Point2D)point).getY());
            point = abstractLinearGraphics.getPoint(visibilityManager.getFocusTarget(), nArray[1], 0.0);
            int n4 = (int)(this.orientation == 0 ? ((Point2D)point).getX() : ((Point2D)point).getY());
            if (n4 < n3) {
                n2 = n4;
                n4 = n3;
                n3 = n2;
            }
            if (n3 < (n2 = this.scroll.getValue()) && n4 > n2 + n) {
                this.bufferedRange[0] = n3;
                this.bufferedRange[1] = n4 - n;
            } else if (n3 < n2) {
                this.bufferedRange[0] = n3;
                this.bufferedRange[1] = n4;
            } else if (n4 > n2 + n) {
                this.bufferedRange[0] = Math.max(0, n3 - n);
                this.bufferedRange[1] = n4 - n;
            } else {
                int n5 = (this.scroll.getMaximum() - n) / 2;
                if (n3 < n5) {
                    this.bufferedRange[0] = this.scroll.getMinimum();
                    this.bufferedRange[1] = n5;
                } else if (n3 > n5) {
                    this.bufferedRange[1] = this.scroll.getMaximum();
                    this.bufferedRange[0] = n5;
                } else {
                    this.bufferedRange[0] = this.scroll.getMinimum();
                    this.bufferedRange[1] = this.scroll.getMaximum();
                }
            }
        }
        catch (Exception exception) {
            logger.error("PG: Ignoring mousePressed due to exception" + exception);
            exception.printStackTrace();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.bufferedRange != null && !this.updateCanvas(this.bufferedRange[0], this.bufferedRange[1])) {
            int n = this.getCurrentFocusPosition();
            VisibilityManager visibilityManager = this.dlist.getVisibilityManager();
            visibilityManager.setFocusPosition(visibilityManager.getFocusTarget(), n);
        }
        this.bufferedRange = null;
    }

    private int getCurrentFocusPosition() {
        DataNavigator dataNavigator = this.dlist.getDataNavigator();
        return dataNavigator.getTruePointPosition(dataNavigator.getHorizontalScrollBar().getValue() + dataNavigator.getHorizontalScrollBar().getVisibleAmount() / 2, dataNavigator.getVerticalScrollBar().getValue() + dataNavigator.getVerticalScrollBar().getVisibleAmount() / 2, this.dlist.getVisibilityManager().getFocusTarget());
    }
}

