/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import ca.ucalgary.bluejay.gui.BookmarkInfo;
import ca.ucalgary.bluejay.gui.BookmarkNode;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.metal.MetalTreeUI;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class DnDJTree
extends JTree
implements TreeSelectionListener,
DragGestureListener,
DropTargetListener,
DragSourceListener {
    private Frame Parent = null;
    protected TreePath SelectedTreePath = null;
    protected BookmarkNode SelectedNode = null;
    private DragSource dragSource = null;
    private DragSourceContext dragSourceContext = null;
    private static Logger logger = Logger.getLogger(DnDJTree.class);

    public DnDJTree(DefaultTreeModel defaultTreeModel, Frame frame) {
        super(defaultTreeModel);
        this.Parent = frame;
        this.addTreeSelectionListener(this);
        this.dragSource = DragSource.getDefaultDragSource();
        DragGestureRecognizer dragGestureRecognizer = this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        dragGestureRecognizer.setSourceActions(dragGestureRecognizer.getSourceActions() & 0xFFFFFFFB);
        DropTarget dropTarget = new DropTarget(this, this);
        this.putClientProperty("JTree.lineStyle", "Angled");
        MetalTreeUI metalTreeUI = (MetalTreeUI)this.getUI();
    }

    public BookmarkNode getSelectedNode() {
        return this.SelectedNode;
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        BookmarkNode bookmarkNode = this.getSelectedNode();
        if (bookmarkNode != null && bookmarkNode.isLeaf()) {
            BookmarkInfo bookmarkInfo = bookmarkNode.getBookmarkInfo();
            Cursor cursor = DragSource.DefaultCopyDrop;
            int n = dragGestureEvent.getDragAction();
            if (n == 2) {
                cursor = DragSource.DefaultMoveDrop;
            }
            this.dragSource.startDrag(dragGestureEvent, cursor, bookmarkInfo, this);
        }
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (!transferable.isDataFlavorSupported(BookmarkInfo.INFO_FLAVOR)) {
                dropTargetDropEvent.rejectDrop();
            }
            BookmarkInfo bookmarkInfo = (BookmarkInfo)transferable.getTransferData(BookmarkInfo.INFO_FLAVOR);
            Point point = dropTargetDropEvent.getLocation();
            TreePath treePath = this.getPathForLocation(point.x, point.y);
            final String string = this.testDropTarget(treePath, this.SelectedTreePath);
            if (string != null) {
                dropTargetDropEvent.rejectDrop();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(DnDJTree.this.Parent, string, "Error Dialog", 0);
                    }
                });
                return;
            }
            BookmarkNode bookmarkNode = (BookmarkNode)treePath.getLastPathComponent();
            BookmarkNode bookmarkNode2 = (BookmarkNode)this.getSelectedNode().getParent();
            int n = dropTargetDropEvent.getDropAction();
            boolean bl = n == 1;
            BookmarkNode bookmarkNode3 = new BookmarkNode(bookmarkInfo);
            try {
                if (!bl) {
                    bookmarkNode2.remove(this.getSelectedNode());
                }
                bookmarkNode.add(bookmarkNode3);
                if (bl) {
                    dropTargetDropEvent.acceptDrop(1);
                } else {
                    dropTargetDropEvent.acceptDrop(2);
                }
            }
            catch (IllegalStateException illegalStateException) {
                dropTargetDropEvent.rejectDrop();
            }
            dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
            defaultTreeModel.reload(bookmarkNode2);
            defaultTreeModel.reload(bookmarkNode);
            TreePath treePath2 = new TreePath(bookmarkNode.getPath());
            this.expandPath(treePath2);
        }
        catch (IOException iOException) {
            dropTargetDropEvent.rejectDrop();
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            dropTargetDropEvent.rejectDrop();
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        Point point = dropTargetDragEvent.getLocation();
        TreePath treePath = this.getPathForLocation(point.x, point.y);
        if (this.testDropTarget(treePath, this.SelectedTreePath) == null) {
            dropTargetDragEvent.acceptDrag(3);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.SelectedTreePath = treeSelectionEvent.getNewLeadSelectionPath();
        if (this.SelectedTreePath == null) {
            this.SelectedNode = null;
            return;
        }
        this.SelectedNode = (BookmarkNode)this.SelectedTreePath.getLastPathComponent();
    }

    private String testDropTarget(TreePath treePath, TreePath treePath2) {
        boolean bl;
        boolean bl2 = bl = treePath == null;
        if (bl) {
            return "Invalid drop location.";
        }
        BookmarkNode bookmarkNode = (BookmarkNode)treePath.getLastPathComponent();
        if (!bookmarkNode.getAllowsChildren()) {
            return "This node does not allow children";
        }
        if (treePath.equals(treePath2)) {
            return "Destination cannot be same as source";
        }
        if (treePath2.isDescendant(treePath)) {
            return "Destination node cannot be a descendant.";
        }
        if (treePath2.getParentPath().equals(treePath)) {
            return "Destination node cannot be a parent.";
        }
        return null;
    }
}

