/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import ca.ucalgary.bluejay.gui.ColorGradientPreview;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.math.BigDecimal;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ExpressionSliderWidget
extends JPanel
implements ChangeListener,
ActionListener,
FocusListener,
MouseListener {
    private Rectangle2D.Double rect;
    private double x = 10.0;
    private double y = 50.0;
    private double width = 100.0;
    private double height = 20.0;
    private Rectangle2D.Double rectTwo;
    private ColorGradientPreview previewPanel = new ColorGradientPreview();
    private JPanel gradientPreviewPanel = new JPanel();
    public static BigDecimal max = new BigDecimal(3);
    public static BigDecimal min = new BigDecimal(-3);
    public static BigDecimal maxTicks = new BigDecimal(3000);
    public static BigDecimal minTicks = new BigDecimal(-3000);
    private JTextField topTextField;
    private JTextField bottomTextField;
    private JSlider topSlide;
    private JSlider bottomSlide;
    private BufferedImage posGradient;
    private BufferedImage negGradient;
    private boolean refreshHigh = false;
    private boolean refreshLow = false;
    private Insets insets;
    private boolean updateAlreadyPerformed = false;
    private static Logger logger = Logger.getLogger(ExpressionSliderWidget.class);

    public ExpressionSliderWidget() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(500, 70));
        this.setMinimumSize(new Dimension(200, 70));
        this.insets = this.getInsets();
        Panel panel = new Panel();
        panel.setSize(70, 25);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 1;
        this.add((Component)panel, gridBagConstraints);
        JLabel jLabel = new JLabel();
        jLabel.setText("Ratio = log2(E / C)");
        jLabel.setPreferredSize(new Dimension(190, 25));
        jLabel.setMinimumSize(new Dimension(190, 25));
        jLabel.setHorizontalAlignment(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = 1;
        this.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("E = experiment   C = control");
        jLabel2.setPreferredSize(new Dimension(190, 25));
        jLabel2.setMinimumSize(new Dimension(190, 25));
        jLabel2.setFont(new Font("dialog", 1, 11));
        jLabel2.setHorizontalAlignment(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = 1;
        this.add((Component)jLabel2, gridBagConstraints);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("E<C");
        jLabel3.setPreferredSize(new Dimension(25, 25));
        jLabel3.setMinimumSize(new Dimension(25, 25));
        jLabel3.setFont(new Font("dialog", 1, 11));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)jLabel3, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("E=C");
        jLabel4.setPreferredSize(new Dimension(25, 25));
        jLabel4.setMinimumSize(new Dimension(25, 25));
        jLabel4.setFont(new Font("dialog", 1, 11));
        jLabel4.setHorizontalAlignment(0);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)jLabel4, gridBagConstraints);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("E>C");
        jLabel5.setPreferredSize(new Dimension(25, 25));
        jLabel5.setMinimumSize(new Dimension(25, 25));
        jLabel5.setFont(new Font("dialog", 1, 11));
        jLabel5.setHorizontalAlignment(4);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)jLabel5, gridBagConstraints);
        this.gradientPreviewPanel.setLayout(new BorderLayout());
        this.gradientPreviewPanel.setBorder(new TitledBorder(new EtchedBorder(), ""));
        this.gradientPreviewPanel.setPreferredSize(new Dimension(175, 50));
        this.gradientPreviewPanel.setMinimumSize(new Dimension(150, 50));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        this.posGradient = this.previewPanel.createGradientImage(Color.GREEN, Color.BLACK);
        this.negGradient = this.previewPanel.createGradientImage(Color.BLACK, Color.RED);
        this.previewPanel = new ColorGradientPreview(this.posGradient, this.negGradient);
        this.gradientPreviewPanel.add((Component)this.previewPanel, "Center");
        this.add((Component)this.gradientPreviewPanel, gridBagConstraints);
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Max");
        jLabel6.setPreferredSize(new Dimension(25, 25));
        jLabel6.setMinimumSize(new Dimension(25, 25));
        jLabel6.setFont(new Font("dialog", 1, 11));
        jLabel6.setHorizontalAlignment(4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)jLabel6, gridBagConstraints);
        int n = (int)this.height;
        int n2 = (int)(this.width * 2.0) + 13;
        this.topSlide = new JSlider(0, minTicks.intValue(), maxTicks.intValue(), 0);
        this.topSlide.setMajorTickSpacing(1000);
        this.topSlide.setPaintTicks(true);
        this.topSlide.setPaintLabels(false);
        this.topSlide.setBorder(null);
        this.topSlide.setValue(0);
        this.topSlide.addChangeListener(this);
        this.topSlide.addMouseListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        this.add((Component)this.topSlide, gridBagConstraints);
        this.topTextField = new JTextField();
        this.topTextField.setPreferredSize(new Dimension(40, 20));
        this.topTextField.setMinimumSize(new Dimension(40, 20));
        this.topTextField.addActionListener(this);
        this.topTextField.addFocusListener(this);
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        this.add((Component)this.topTextField, gridBagConstraints);
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Min");
        jLabel7.setPreferredSize(new Dimension(25, 25));
        jLabel7.setMinimumSize(new Dimension(25, 25));
        jLabel7.setFont(new Font("dialog", 1, 11));
        jLabel7.setHorizontalAlignment(4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)jLabel7, gridBagConstraints);
        this.bottomSlide = new JSlider(0, minTicks.intValue(), maxTicks.intValue(), 0);
        this.bottomSlide.setMajorTickSpacing(1000);
        this.bottomSlide.setPaintTicks(true);
        this.bottomSlide.setPaintLabels(true);
        this.bottomSlide.setBorder(null);
        this.bottomSlide.setValue(0);
        this.bottomSlide.addChangeListener(this);
        this.bottomSlide.addMouseListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        this.add((Component)this.bottomSlide, gridBagConstraints);
        this.bottomTextField = new JTextField();
        this.bottomTextField.setPreferredSize(new Dimension(40, 20));
        this.bottomTextField.setMinimumSize(new Dimension(40, 20));
        this.bottomTextField.addActionListener(this);
        this.bottomTextField.addFocusListener(this);
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        this.add((Component)this.bottomTextField, gridBagConstraints);
        this.topTextField.setText(new Double((double)this.topSlide.getValue() / 1000.0).toString());
        this.bottomTextField.setText(new Double((double)this.bottomSlide.getValue() / 1000.0).toString());
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(minTicks.intValue()), new JLabel(min.toString()));
        hashtable.put(new Integer(0), new JLabel("0"));
        hashtable.put(new Integer(maxTicks.intValue()), new JLabel(max.toString()));
        this.topSlide.setLabelTable(hashtable);
        this.bottomSlide.setLabelTable(hashtable);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        if (jSlider.getValueIsAdjusting()) {
            if (jSlider.hashCode() == this.topSlide.hashCode()) {
                this.topTextField.setText(new Double((double)jSlider.getValue() / 1000.0).toString());
                if (this.topSlide.getValue() < this.bottomSlide.getValue()) {
                    this.bottomSlide.setValue(this.topSlide.getValue());
                    this.bottomTextField.setText(new Double((double)jSlider.getValue() / 1000.0).toString());
                    this.refreshLow = true;
                }
            } else if (jSlider.hashCode() == this.bottomSlide.hashCode()) {
                this.bottomTextField.setText(new Double((double)jSlider.getValue() / 1000.0).toString());
                if (this.bottomSlide.getValue() > this.topSlide.getValue()) {
                    this.topSlide.setValue(this.bottomSlide.getValue());
                    this.topTextField.setText(new Double((double)jSlider.getValue() / 1000.0).toString());
                    this.refreshHigh = true;
                }
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JTextField jTextField = (JTextField)actionEvent.getSource();
        this.performUpdate(jTextField);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void performUpdate(JTextField jTextField) {
        logger.info("Updating ...");
        this.updateAlreadyPerformed = true;
        try {
            block16: {
                block15: {
                    block14: {
                        if (new Double(jTextField.getText()) < min.doubleValue()) break block14;
                        Double d = new Double(jTextField.getText());
                        if (!(d > max.doubleValue())) break block15;
                    }
                    logger.info("Out of Bounds");
                    JOptionPane.showMessageDialog(null, "Out of bounds.  Please try again.", "Error", 0);
                    if (jTextField.hashCode() == this.topTextField.hashCode()) {
                        this.topTextField.setText(new Double((double)this.topSlide.getValue() / 1000.0).toString());
                        break block16;
                    } else if (jTextField.hashCode() == this.bottomTextField.hashCode()) {
                        this.bottomTextField.setText(new Double((double)this.bottomSlide.getValue() / 1000.0).toString());
                    }
                    break block16;
                }
                if (jTextField.hashCode() == this.topTextField.hashCode()) {
                    double d = new Double(this.topTextField.getText());
                    if (d * 1000.0 < (double)this.bottomSlide.getValue()) {
                        this.topSlide.setValue(this.bottomSlide.getValue());
                        this.topTextField.setText(new Double((double)this.bottomSlide.getValue() / 1000.0).toString());
                    } else {
                        this.topSlide.setValue(new Double(d * 1000.0).intValue());
                    }
                    this.refreshHigh = true;
                } else if (jTextField.hashCode() == this.bottomTextField.hashCode()) {
                    double d = new Double(this.bottomTextField.getText());
                    if (d * 1000.0 > (double)this.topSlide.getValue()) {
                        this.bottomSlide.setValue(this.topSlide.getValue());
                        this.bottomTextField.setText(new Double((double)this.topSlide.getValue() / 1000.0).toString());
                    } else {
                        this.bottomSlide.setValue(new Double(d * 1000.0).intValue());
                    }
                    this.refreshLow = true;
                }
            }
            if (this.refreshHigh) {
                this.firePropertyChange("topSlide", new Double(-1000.0), new Double(this.topSlide.getValue()));
                this.refreshHigh = false;
            }
            if (!this.refreshLow) return;
            this.firePropertyChange("bottomSlide", new Double(-1000.0), new Double(this.bottomSlide.getValue()));
            this.refreshLow = false;
            return;
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
            if (!(exception instanceof NumberFormatException)) return;
            logger.error("ExpressionSliderWidget :: Number Format Exception  ***ACA");
            JOptionPane.showMessageDialog(null, "Illegal format.  Please try again.", "Error", 0);
            if (jTextField.hashCode() == this.topTextField.hashCode()) {
                this.topTextField.setText(new Double((double)this.topSlide.getValue() / 1000.0).toString());
                return;
            }
            if (jTextField.hashCode() != this.bottomTextField.hashCode()) return;
            this.bottomTextField.setText(new Double((double)this.bottomSlide.getValue() / 1000.0).toString());
        }
    }

    public ColorGradientPreview getColorGradientPreview() {
        return this.previewPanel;
    }

    public void focusGained(FocusEvent focusEvent) {
        logger.debug("focusGained :: updateAlreadyPerformed == " + this.updateAlreadyPerformed);
        this.updateAlreadyPerformed = false;
    }

    public void focusLost(FocusEvent focusEvent) {
        logger.debug("focusLost :: updateAlreadyPerformed == " + this.updateAlreadyPerformed);
        if (!this.updateAlreadyPerformed) {
            JTextField jTextField = (JTextField)focusEvent.getSource();
            this.performUpdate(jTextField);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        logger.info("Mouse has been released");
        JSlider jSlider = (JSlider)mouseEvent.getSource();
        if (jSlider.hashCode() == this.topSlide.hashCode()) {
            this.topTextField.setText(new Double((double)jSlider.getValue() / 1000.0).toString());
            this.refreshHigh = true;
        } else if (jSlider.hashCode() == this.bottomSlide.hashCode()) {
            this.bottomTextField.setText(new Double((double)jSlider.getValue() / 1000.0).toString());
            this.refreshLow = true;
        }
        if (this.refreshHigh && this.refreshLow) {
            this.firePropertyChange("bothSlides", new Double(-1000.0), new Double(this.topSlide.getValue()));
            this.refreshHigh = false;
            this.refreshLow = false;
        } else {
            if (this.refreshHigh) {
                this.firePropertyChange("topSlide", new Double(-1000.0), new Double(this.topSlide.getValue()));
                this.refreshHigh = false;
            }
            if (this.refreshLow) {
                this.firePropertyChange("bottomSlide", new Double(-1000.0), new Double(this.bottomSlide.getValue()));
                this.refreshLow = false;
            }
        }
    }

    public void updateExtremeValues(float f, float f2) {
        BigDecimal bigDecimal = new BigDecimal(Float.toString(f2)).setScale(0, 1);
        BigDecimal bigDecimal2 = new BigDecimal(Float.toString(f)).setScale(0, 0);
        min = bigDecimal;
        max = bigDecimal2;
        minTicks = new BigDecimal(min.doubleValue() * 1000.0);
        maxTicks = new BigDecimal(max.doubleValue() * 1000.0);
        this.refreshLabels();
    }

    public void refreshLabels() {
        this.topSlide.setMaximum(maxTicks.intValue());
        this.topSlide.setMinimum(minTicks.intValue());
        this.bottomSlide.setMaximum(maxTicks.intValue());
        this.bottomSlide.setMinimum(minTicks.intValue());
        this.topTextField.setText(new Double((double)this.topSlide.getValue() / 1000.0).toString());
        this.bottomTextField.setText(new Double((double)this.bottomSlide.getValue() / 1000.0).toString());
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(minTicks.intValue()), new JLabel(min.toString()));
        hashtable.put(new Integer(0), new JLabel("0"));
        hashtable.put(new Integer(maxTicks.intValue()), new JLabel(max.toString()));
        this.topSlide.setLabelTable(hashtable);
        this.bottomSlide.setLabelTable(hashtable);
    }
}

