/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.FeatureRangeTableModel;
import ca.ucalgary.bluejay.gui.VisibilityManager;
import ca.ucalgary.bluejay.gui.util.TableSorter;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class FeatureRangeGUI
extends JFrame
implements ActionListener,
ListSelectionListener,
PropertyChangeListener,
WindowListener {
    public static final String FRAME_TITLE = "Feature start/stop editor";
    public static final int DEFAULT_WIDTH = 400;
    public static final int DEFAULT_HEIGHT = 600;
    private ListSelectionModel listSelectionModel;
    private ListSelectionModel tableSelectionModel;
    private Vector deis;
    private int maxNumFeatures = 50;
    private int maxNumSections = 25;
    private VisibilityManager vizMgr;
    private JCheckBoxMenuItem toggle;
    private FeatureRangeTableModel dataModel;
    private String[] sectionNames;
    private BluejayDObjectList dlist;
    private int sectionSize;
    private int[] existingRange;
    private static Logger logger = Logger.getLogger(FeatureRangeGUI.class);
    private JButton apply;
    private JButton cancel;
    private JPanel buttonPanel;

    public FeatureRangeGUI(VisibilityManager visibilityManager, BluejayDObjectList bluejayDObjectList, JCheckBoxMenuItem jCheckBoxMenuItem) {
        super(FRAME_TITLE);
        this.setSize(400, 600);
        this.setDefaultCloseOperation(1);
        this.addWindowListener(this);
        this.getContentPane().setLayout(new BoxLayout(this, 1));
        this.vizMgr = visibilityManager;
        if (visibilityManager != null) {
            visibilityManager.addPropertyChangeListener("target visible range", this);
        }
        this.toggle = jCheckBoxMenuItem;
        this.dlist = bluejayDObjectList;
        this.deis = new Vector();
        this.createButton();
    }

    public void createButton() {
        this.apply = new JButton("OK");
        this.apply.setActionCommand("OK");
        this.apply.addActionListener(this);
        this.cancel = new JButton("Cancel");
        this.cancel.setActionCommand("Cancel");
        this.cancel.addActionListener(this);
        this.buttonPanel = new JPanel();
        this.buttonPanel.add(this.apply);
        this.buttonPanel.add(this.cancel);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this.isVisible()) {
            return;
        }
        if (propertyChangeEvent.getSource() == this.vizMgr) {
            this.clearFeatureList();
            this.populateFeatureList();
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.toggle.setState(false);
        this.existingRange = null;
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (object == this.toggle) {
            if (this.toggle.getState()) {
                this.setVisible(true);
            } else {
                this.setVisible(false);
            }
        } else {
            logger.warn("Source of feature range GUI visibility update is unrecognized (" + object.getClass().toString() + "), ignoring");
        }
        if (string == "Cancel") {
            this.setVisible(false);
            this.toggle.setSelected(false);
        }
        if (string == "OK") {
            this.setVisible(false);
            this.toggle.setSelected(false);
        }
    }

    public void setVisible(boolean bl) {
        if (!bl) {
            this.clearFeatureList();
            super.setVisible(false);
            return;
        }
        if (this.isVisible()) {
            return;
        }
        this.clearFeatureList();
        this.populateFeatureList();
        super.setVisible(true);
    }

    private void clearFeatureList() {
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new FlowLayout());
        this.deis.clear();
        this.dataModel = null;
    }

    private int[] getVisibleRange() {
        if (this.existingRange != null) {
            return this.existingRange;
        }
        return this.vizMgr == null ? (int[])this.dlist.getAbstractLinearGraphics().getVisiblePositionRange(0).elementAt(0) : this.vizMgr.getVisibleRange();
    }

    private void setVisibleRange(int[] nArray) {
        this.existingRange = nArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void populateFeatureList() {
        int n;
        int[] nArray = this.getVisibleRange();
        int n2 = n = this.vizMgr == null ? (nArray[1] - nArray[0]) / 400 : this.vizMgr.getNumFeatures(this.vizMgr.getFocusTarget(), nArray[0], nArray[1]);
        if (n == 0) {
            this.getContentPane().add(new JLabel("Sorry, the specified region (" + nArray[0] + ", " + nArray[1] + ") has no editable features.\n " + "Try another region, if possible."));
            return;
        }
        this.dataModel = new FeatureRangeTableModel(this.dlist, this.deis);
        if (this.vizMgr != null) {
            this.vizMgr.addFeatures(this, this.vizMgr.getFocusTarget());
        } else if ((DTDElementInstance)this.dlist.getDocument().getDocumentElement() == null || this.dlist.isMemorySavingMode()) {
            int n3 = JOptionPane.showOptionDialog(this, "In order to edit features, Program->Memory Prefs->\"Run faster but use more memory\" must be enabled.\nPress \"Edit\" to automatically enable this and reparse the document.\nThis may cause OutOfMemory errors for applet users.", "Editing Not Currently Enabled", 0, 3, null, new String[]{"Edit", "Cancel"}, "Cancel");
            if (n3 != 0) {
                this.setVisible(false);
                return;
            }
            this.dlist.setMemorySavingMode(false);
            try {
                this.dlist.repaintSynchronous();
            }
            catch (InterruptedException interruptedException) {
                JOptionPane.showMessageDialog(this, "Could not reload the document, aborting feature editor\n" + interruptedException, "Error Reloading Document", 0);
                this.setVisible(false);
                return;
            }
            this.addDocumentFeatures((DTDElementInstance)this.dlist.getDocument().getDocumentElement(), nArray[0], nArray[1]);
        } else {
            this.addDocumentFeatures((DTDElementInstance)this.dlist.getDocument().getDocumentElement(), nArray[0], nArray[1]);
        }
        TableSorter tableSorter = new TableSorter(this.dataModel);
        JTable jTable = new JTable(tableSorter);
        jTable.getTableHeader().setToolTipText("Click to sort; Shift-Click to sort in reverse order");
        tableSorter.setTableHeader(jTable.getTableHeader());
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jTable.setPreferredScrollableViewportSize(new Dimension(380, 590));
        jTable.setSelectionMode(0);
        jTable.getSelectionModel().addListSelectionListener(this);
        this.getContentPane().add(jScrollPane);
        this.getContentPane().add(this.buttonPanel);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        Object object = listSelectionEvent.getSource();
        if (object instanceof ListSelectionModel) {
            if (!((ListSelectionModel)object).isSelectionEmpty()) {
                int n = ((ListSelectionModel)object).getMinSelectionIndex();
            }
        } else if (object instanceof JList) {
            ListSelectionModel listSelectionModel = ((JList)object).getSelectionModel();
            if (!listSelectionModel.isSelectionEmpty()) {
                int n = listSelectionModel.getMinSelectionIndex();
                String string = this.sectionNames[n];
                int[] nArray = new int[]{new Integer(string.substring(0, string.indexOf(45))), new Integer(string.substring(string.indexOf(45) + 1))};
                this.setVisibleRange(nArray);
                this.clearFeatureList();
                this.validate();
                this.populateFeatureList();
                this.validate();
            }
        } else {
            logger.warn("PG: Unknown source for list selection event, found " + object + ")");
        }
    }

    private void addDocumentFeatures(DTDElementInstance dTDElementInstance, int n, int n2) {
        Object object;
        if (dTDElementInstance == null || dTDElementInstance.getPainter() == null) {
            return;
        }
        int[] nArray = dTDElementInstance.getPainter().getFeatureRange(dTDElementInstance);
        if (nArray != null && nArray[0] >= n && nArray[1] <= n2) {
            object = dTDElementInstance.getPainter().getToolTip(dTDElementInstance);
            this.addFeature(dTDElementInstance, (String)object, nArray[0], nArray[1], 0, 0);
        }
        object = dTDElementInstance.getChildNodes();
        int n3 = object.getLength();
        for (int i = 0; i < n3; ++i) {
            if (!(object.item(i) instanceof DTDElementInstance)) continue;
            this.addDocumentFeatures((DTDElementInstance)object.item(i), n, n2);
        }
    }

    public void addFeature(DTDElementInstance dTDElementInstance, String string, int n, int n2, int n3, int n4) {
        Vector<Object> vector = new Vector<Object>(3);
        vector.add(string);
        vector.add(new Integer(n));
        vector.add(new Integer(n2));
        this.deis.add(dTDElementInstance);
        this.dataModel.addRow(vector);
    }

    private void populateSectionsList(int n) {
        Container container = this.getContentPane();
        container.add(new JLabel("The specified region has more editable features (" + n + ") than can be listed. " + "Select a region to edit:"));
        int[] nArray = this.getVisibleRange();
        int n2 = (nArray[1] - nArray[0] + 1) / this.maxNumSections;
        if (n2 < 1000) {
            n2 = 1000;
        }
        int n3 = 0;
        int n4 = nArray[0] / 1000 * 1000;
        while (n4 < nArray[1]) {
            ++n3;
            n4 = (n4 + n2) / 1000 * 1000;
        }
        this.sectionNames = new String[n3];
        n3 = 0;
        n4 = nArray[0] / 1000 * 1000;
        while (n4 < nArray[1]) {
            this.sectionNames[n3] = "" + n4 + "-" + (n4 + n2);
            n4 = (n4 + n2) / 1000 * 1000;
            ++n3;
        }
        JList<String> jList = new JList<String>(this.sectionNames);
        JScrollPane jScrollPane = new JScrollPane(jList);
        jList.setPreferredSize(new Dimension(380, 580));
        jList.setSelectionMode(0);
        jList.addListSelectionListener(this);
        container.add(jScrollPane);
    }
}

