/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import com.jhlabs.awt.BasicGridLayout;
import com.jhlabs.awt.ParagraphLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;

public class GeometryListWidget
extends JPanel {
    private JButton apply;
    private JScrollPane scroll;
    private JPanel mainPanel;
    private Vector geom = new Vector();
    private final String ALL = "Change All";
    private final String IND = "Change Individually";
    private boolean all = false;
    private GeometryPanel AllPanel = null;
    private static Logger logger = Logger.getLogger(GeometryListWidget.class);

    public GeometryListWidget() {
        this.mainPanel = new JPanel();
        this.setLayout(new BoxLayout(this, 1));
        this.mainPanel.setLayout(new BasicGridLayout());
        this.AllPanel = new GeometryPanel("All", false);
        this.scroll = new JScrollPane(this.mainPanel);
        this.apply = new JButton("Apply");
        this.add(this.scroll);
        this.add(this.apply);
    }

    public void removeAllGeometryPanels() {
        this.mainPanel.removeAll();
        this.geom.removeAllElements();
        this.scroll.revalidate();
        this.scroll.repaint();
    }

    public Vector getGeometryPanels() {
        return this.geom;
    }

    public void setEnabledAll(boolean bl) {
        this.apply.setEnabled(bl);
    }

    public JButton getApplyButton() {
        return this.apply;
    }

    public boolean isCircularSelectedforAll() {
        return this.AllPanel.isCircularSelected();
    }

    public boolean isCircularSelected(int n) {
        return ((GeometryPanel)this.geom.elementAt(n)).isCircularSelected();
    }

    public void removeAllPanel() {
        this.removeAll();
        this.scroll = new JScrollPane(this.mainPanel);
        this.add(this.scroll);
        this.scroll.revalidate();
        this.scroll.repaint();
        this.add(this.apply);
        this.revalidate();
        this.repaint();
    }

    public boolean isAll() {
        return this.all;
    }

    public void addAllPanel(String string) {
        this.removeAll();
        final JPanel jPanel = new JPanel();
        jPanel.setLayout(new CardLayout());
        String[] stringArray = new String[]{"Change All", "Change Individually"};
        JPanel jPanel2 = new JPanel();
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setEditable(false);
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (((String)itemEvent.getItem()).equals("Change All")) {
                    GeometryListWidget.this.all = true;
                } else {
                    GeometryListWidget.this.all = false;
                }
                CardLayout cardLayout = (CardLayout)jPanel.getLayout();
                cardLayout.show(jPanel, (String)itemEvent.getItem());
            }
        });
        jPanel2.add(jComboBox);
        this.add(jPanel2);
        JScrollPane jScrollPane = new JScrollPane(this.AllPanel, 21, 31);
        jScrollPane.setPreferredSize(new Dimension(100, 50));
        this.AllPanel.setLabelText(string);
        this.all = false;
        jPanel.add((Component)jScrollPane, "Change All");
        jPanel.add((Component)this.scroll, "Change Individually");
        this.add(jPanel);
        this.add(this.apply);
        this.revalidate();
        this.repaint();
    }

    public void addGeometryPanel(String string, boolean bl) {
        GeometryPanel geometryPanel = new GeometryPanel(string, bl);
        this.geom.add(geometryPanel);
        if (this.geom.size() == 2) {
            this.mainPanel.add(new JSeparator());
        }
        this.mainPanel.add(geometryPanel);
        if (this.geom.size() != 1) {
            this.mainPanel.add(new JSeparator());
        }
        this.scroll.revalidate();
        this.scroll.repaint();
    }

    private class GeometryPanel
    extends JPanel
    implements ActionListener {
        private JRadioButton linear;
        private JRadioButton circular;
        private String label = null;
        private ButtonGroup choice;
        private JTextArea jta;

        public GeometryPanel(String string, boolean bl) {
            this();
            this.jta.setText(string);
            this.label = string;
            if (bl) {
                this.circular.setSelected(true);
            } else {
                this.linear.setSelected(true);
            }
        }

        private void setLabelText(String string) {
            this.jta.setText(string);
            this.label = string;
        }

        public boolean isCircularSelected() {
            return this.circular.isSelected();
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public GeometryPanel() {
            this.setLayout(new ParagraphLayout(5, 5));
            this.setBorder(null);
            this.jta = new JTextArea();
            this.jta.setBackground(this.getBackground());
            this.jta.setLineWrap(true);
            this.jta.setWrapStyleWord(true);
            this.jta.setEditable(false);
            this.jta.setText(this.label);
            this.add((Component)this.jta, ParagraphLayout.NEW_PARAGRAPH);
            this.choice = new ButtonGroup();
            this.linear = new JRadioButton("Linear");
            this.add(this.linear);
            this.jta.setFont(this.linear.getFont());
            this.circular = new JRadioButton("Circular");
            this.add((Component)this.circular, ParagraphLayout.NEW_LINE);
            this.choice.add(this.linear);
            this.choice.add(this.circular);
        }
    }
}

