/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.apache.log4j.Logger;

public class GeometryWidget
extends JPanel {
    private DefaultComboBoxModel model;
    private JComboBox backbones;
    private double old;
    private GeometryPanel geometry;
    private JButton apply;
    private static Logger logger = Logger.getLogger(GeometryWidget.class);

    public GeometryWidget() {
        this.setLayout(new BoxLayout(this, 1));
        this.setPreferredSize(new Dimension(150, 150));
        this.geometry = new GeometryPanel();
        this.add(this.geometry);
        this.old = this.geometry.getExtent();
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel("geometry:"));
        this.model = new DefaultComboBoxModel();
        this.backbones = new JComboBox(this.model);
        jPanel.add(this.backbones);
        this.add(jPanel);
        this.apply = new JButton("Apply");
        this.add(this.apply);
    }

    public void setEnabledAll(boolean bl) {
        this.geometry.setEnabled(bl);
        this.apply.setEnabled(bl);
        this.backbones.setEnabled(bl);
    }

    public JButton getApplyButton() {
        return this.apply;
    }

    public void updateModel(DefaultComboBoxModel defaultComboBoxModel) {
        this.model = defaultComboBoxModel;
        this.backbones.setModel(this.model);
        this.backbones.repaint();
    }

    public double getRotationAngle() {
        return Math.abs(this.geometry.getExtent());
    }

    public DefaultComboBoxModel getModel() {
        return this.model;
    }

    private class GeometryPanel
    extends JPanel {
        private double x = 30.0;
        private double y = 30.0;
        private double width = 50.0;
        private double height = 50.0;
        private double start = 90.0;
        private double extent = 0.0;
        private JRadioButton linear;
        private JRadioButton circular;

        public GeometryPanel() {
            this.setPreferredSize(new Dimension(100, 100));
            this.setBorder(BorderFactory.createEtchedBorder());
            this.linear = new JRadioButton("Linear");
            this.add(this.linear);
            this.circular = new JRadioButton("Circular");
            this.add(this.circular);
        }

        public double getExtent() {
            return this.extent;
        }
    }
}

