/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.Zoom;
import ca.ucalgary.bluejay.gui.util.Debug;
import ca.ucalgary.bluejay.gui.util.SwingWorkerVariant;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class ImageCreator {
    private BluejayDObjectList dlist;
    private Zoom zoomerang;
    private Zoom batikZoom;
    private SwingWorkerVariant worker;
    public static final int INTERRUPTED = -100;
    public static final int IMAGE_SIZE_EXCEEDED = -10;
    public static final int SCAFFOLD_PAINT = -5;
    private static Logger logger = Logger.getLogger(ImageCreator.class);

    private ImageCreator() {
    }

    public ImageCreator(BluejayDObjectList bluejayDObjectList) {
        this.dlist = bluejayDObjectList;
        this.zoomerang = this.dlist.getZoom();
        this.batikZoom = this.dlist.getBatikZoom();
        this.worker = new SwingWorkerVariant(){
            private int err = 0;

            public Object constructImage() {
                int[] nArray = new int[20000];
                try {
                    this.err = ImageCreator.this.dlist.doStuff();
                    if (this.err == -3) {
                        return new Integer(this.err);
                    }
                    AbstractLinearGraphics abstractLinearGraphics = ImageCreator.this.dlist.getAbstractLinearGraphics();
                    if (abstractLinearGraphics.getPaintAllowed() && this.err != -5) {
                        ImageCreator.this.dlist.getEventCoordinator().notify(8, "Image done");
                    }
                    abstractLinearGraphics.setPaintAllowed(true);
                    ImageCreator.this.dlist.setPreferredSize(ImageCreator.this.dlist.getPreferredCanvasSize());
                    ImageCreator.this.dlist.revalidate();
                    ImageCreator.this.dlist.setChangedLayout(false);
                    ImageCreator.this.dlist.getProgressBar().setValue(0);
                    ImageCreator.this.dlist.setNoWorker(true);
                    return new Object();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    nArray = null;
                    System.gc();
                    JOptionPane.showMessageDialog(null, "Bluejay has run out of memory (drawing a large document) due to applet restrictions.  Please refer to the \"Out of Memory\" instructions on the applet's Web page.", "Bluejay is Out of Memory", 0);
                    return new Object();
                }
            }

            public void finished() {
                int[] nArray = new int[20000];
                try {
                    Object object;
                    logger.debug("DList.imageCreator.SwingWorkerVariant.finished() -- GOT TO FINISHED");
                    if (Debug.legend) {
                        object = ImageCreator.this.dlist.getLegend();
                        ((JComponent)object).revalidate();
                        ((Component)object).repaint();
                        ImageCreator.this.dlist.getLegendBar().repaint();
                    }
                    object = ImageCreator.this.dlist.getAbstractLinearGraphics();
                    object.setPaintAllowed(true);
                    if (object.isSVGExportGraphicsMode()) {
                        object.endSVGExportGraphicsMode();
                        ImageCreator.this.dlist.repaint(true);
                        return;
                    }
                    if (this.err == -10) {
                        this.err = 0;
                        logger.debug("DList.imageCreator.SwingWorkerVariant.finished() -- WE GOT TO THE RIGHT RESTART");
                        ImageCreator.this.dlist.getEventCoordinator().notify(8, "Image created is too large, zooming out...");
                        object.setScale(ImageCreator.this.zoomerang.zoomPctToPixelScale(ImageCreator.this.zoomerang.getOldZoom()));
                        logger.debug("DList.imageCreator.SwingWorkerVariant.finished() -- oldzoom is :" + ImageCreator.this.zoomerang.getOldZoom());
                        ImageCreator.this.batikZoom.setZoomFactor(100.0);
                        logger.debug("DList.imageCreator.SwingWorkerVariant.finished() -- after setting zoom");
                        object.clear(this);
                        ImageCreator.this.dlist.setNoWorker(true);
                        ImageCreator.this.dlist.repaint(true);
                        logger.debug("DList.imageCreator.SwingWorkerVariant.finished() -- after repaint");
                        return;
                    }
                    if (this.err == -5) {
                        logger.warn("This \"crap\" is deprecated (SCAFFOLD_PAINT), returning...");
                        return;
                    }
                    ImageCreator.this.dlist.updateWidgetModels();
                    ImageCreator.this.dlist.repaint();
                    if (Debug.legend) {
                        ImageCreator.this.dlist.getLegend().revalidate();
                        ImageCreator.this.dlist.getLegendBar().repaint();
                    }
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    nArray = null;
                    System.gc();
                    JOptionPane.showMessageDialog(null, "Bluejay has run out of memory (drawing a large document) due to applet restrictions.  Please refer to the \"Out of Memory\"instructions on the applet's Web page.", "Bluejay is Out of Memory", 0);
                }
            }

            public void doThings() {
                this.setValue(this.constructImage());
            }
        };
    }

    public Thread getThread() {
        return this.worker.getOldThread();
    }

    public void check(Object object) {
        boolean bl = this.worker.isHolding(object);
    }

    public void goSynchronous() throws InterruptedException {
        this.worker.start();
        this.worker.join();
    }

    public void go() {
        this.worker.start();
    }

    public synchronized void stop() {
        this.worker.interrupt();
    }
}

