/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.LegendItem;
import ca.ucalgary.bluejay.gui.XCheckBox;
import ca.ucalgary.bluejay.gui.util.BluejayBar;
import ca.ucalgary.bluejay.gui.util.BluejayPie;
import ca.ucalgary.bluejay.gui.util.Debug;
import ca.ucalgary.bluejay.session.StateCollection;
import com.jhlabs.awt.BasicGridLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Legend
extends JPanel
implements ItemSelectable,
ItemListener,
Runnable {
    public static int SWATCH_WIDTH = 12;
    public static int SWATCH_HEIGHT = 16;
    public static int LEGEND_ITEM_HEIGHT = 21;
    public static final int SELECT_ALL_SOURCE = 702;
    public static final int MAX_ITEMS_PIE_TEXT_LABELS = 8;
    public static final int MAX_ITEMS_PIE_PCT_LABELS = 32;
    public static final int MAX_LEN_PIE_TEXT_LABEL = 12;
    private StateCollection collection;
    private XCheckBox check;
    private Vector legendItems;
    private Vector listeners;
    private Vector data_change_listeners;
    private Hashtable xpaths;
    private Hashtable images;
    private Hashtable counts;
    private Hashtable colours;
    private Hashtable deiXPointers;
    private Hashtable unclicked;
    private Hashtable greyed;
    private PrefixResolver prefix_resolver;
    private PrefixResolver doc_prefix_resolver;
    private XPathContext xpath_context;
    private boolean ignoreRedraw = false;
    private Node current_node;
    private Integer One = new Integer(1);
    private int numOfColumns = 5;
    private Legend legend = this;
    private boolean makeExtendedItemContent = false;
    private boolean addingItems = false;
    private boolean revise = false;
    private boolean clusterDataShown = false;
    private BluejayDObjectList dObjectLegend;
    public int selectAllState = 112;
    private static Logger logger = Logger.getLogger(Legend.class);

    public Legend(BluejayDObjectList bluejayDObjectList, int n) {
        this.numOfColumns = n;
        this.collection = new StateCollection();
        this.legendItems = new Vector();
        this.colours = new Hashtable();
        this.images = new Hashtable();
        this.xpaths = new Hashtable();
        this.counts = new Hashtable();
        this.deiXPointers = new Hashtable();
        this.unclicked = new Hashtable();
        this.greyed = new Hashtable();
        this.listeners = new Vector(1);
        this.data_change_listeners = new Vector(1);
        this.dObjectLegend = bluejayDObjectList;
        this.xpath_context = new XPathContext();
        this.setLayout(new BasicGridLayout());
        this.setBackground(new Color(255, 255, 255));
        this.setPreferredSize(new Dimension(205, 100));
        this.setBorder(new EmptyBorder(3, 5, 3, 0));
    }

    public void makeBarChart(Graphics graphics, Dimension dimension) {
        this.dObjectLegend.getLegendManager().buildLegendItemsPublic();
        this.sortSynchronous();
        if (this.legendItems.size() == 0) {
            System.out.println("There are no legend items!");
            return;
        }
        BluejayBar bluejayBar = new BluejayBar();
        Vector vector = new Vector(this.legendItems);
        bluejayBar.drawBar(this.dObjectLegend, dimension, (Graphics2D)graphics, vector);
    }

    public void makePieChart(Graphics graphics, Dimension dimension) {
        this.dObjectLegend.getLegendManager().buildLegendItemsPublic();
        this.sortSynchronous();
        if (this.legendItems.size() == 0) {
            System.out.println("there are no legend items $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$");
            return;
        }
        BluejayPie bluejayPie = new BluejayPie();
        Vector vector = new Vector(this.legendItems);
        bluejayPie.drawPie(dimension, (Graphics2D)graphics, vector);
    }

    public Object[] getLegendItems() {
        return this.legendItems.toArray();
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.listeners.add(itemListener);
    }

    public Object[] getSelectedObjects() {
        return null;
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.listeners.removeElement(itemListener);
    }

    public void setNumOfColumns(int n) {
        this.numOfColumns = n;
    }

    public int getNumOfColumns() {
        return this.numOfColumns;
    }

    public void clear() {
        if (this.ignoreRedraw) {
            return;
        }
        this.legendItems.clear();
        this.xpaths.clear();
        this.colours.clear();
        this.images.clear();
        this.counts.clear();
        this.deiXPointers.clear();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Legend.this.removeAll();
                Legend.this.repaint();
            }
        });
    }

    public void clearClicks() {
        this.greyed.clear();
        this.unclicked.clear();
    }

    public void setPrefixResolver(PrefixResolver prefixResolver) {
        this.prefix_resolver = prefixResolver;
    }

    public void init(Node node, String string) {
        this.doc_prefix_resolver = new PrefixResolverDefault(node);
        this.current_node = node;
        int n = this.xpath_context.getDTMHandleFromNode(node);
        this.xpath_context.pushCurrentNodeAndExpression(n, n);
        Enumeration enumeration = this.unclicked.keys();
        while (enumeration.hasMoreElements()) {
            this.applyLegendItem((LegendItem)this.unclicked.get(enumeration.nextElement()));
        }
        enumeration = this.greyed.keys();
        while (enumeration.hasMoreElements()) {
            this.applyLegendItem((LegendItem)this.greyed.get(enumeration.nextElement()));
        }
        this.ignoreRedraw(false);
    }

    public void reviseContent() {
        if (this.legendItems != null) {
            int n = this.legendItems.size();
            for (int i = 0; i < n; ++i) {
                if (!(this.legendItems.get(i) instanceof LegendItem)) continue;
                this.reviseLegendItemContent((LegendItem)this.legendItems.get(i));
            }
        }
    }

    public void ignoreRedraw(boolean bl) {
        this.ignoreRedraw = bl;
    }

    public synchronized void addItem(Image image, String string, String string2, String string3, Color color) {
        if (this.ignoreRedraw) {
            return;
        }
        if (this.images.containsKey(string)) {
            this.counts.put(string, new Integer((Integer)this.counts.get(string) + 1));
            ((Vector)this.deiXPointers.get(string)).add(string3);
            return;
        }
        this.colours.put(string, color);
        this.images.put(string, image);
        this.counts.put(string, this.One);
        Vector<String> vector = new Vector<String>();
        vector.add(string3);
        this.deiXPointers.put(string, vector);
        try {
            XPath xPath = new XPath(string2, null, this.prefix_resolver, 0);
            this.xpaths.put(string, xPath);
        }
        catch (TransformerException transformerException) {
            System.err.println("Could not create XPath select statement from '" + string2 + "': " + transformerException);
        }
    }

    public void removeItem(Object object) {
        this.legendItems.remove(object);
        this.xpaths.remove(object);
        this.colours.remove(object);
        this.images.remove(object);
        this.counts.remove(object);
        this.deiXPointers.remove(object);
    }

    public synchronized void itemStateChanged(ItemEvent itemEvent) {
        if (Debug.DEBUG) {
            System.err.println("Legend: itemStateChanged");
        }
        if (itemEvent.getSource() == this.check) {
            this.check.updateVisualState(101);
            this.selectAllAction(this.check.getSelectionState());
            if (this.selectAllState == 112) {
                this.greyed = new Hashtable();
                this.unclicked = new Hashtable();
            } else if (this.selectAllState == 113) {
                this.greyed = this.fillHashtablewithVector(this.legendItems);
                this.unclicked = new Hashtable();
            } else if (this.selectAllState == 114) {
                this.greyed = new Hashtable();
                this.unclicked = this.fillHashtablewithVector(this.legendItems);
            }
            this.collection = this.dObjectLegend.getCurrentCollection();
            this.collection.setLegendSelectAll((Hashtable)this.unclicked.clone(), (Hashtable)this.greyed.clone());
        } else {
            if (this.current_node == null) {
                return;
            }
            LegendItem legendItem = (LegendItem)itemEvent.getItemSelectable();
            if (legendItem.isVisibilityEvent(itemEvent)) {
                this.passOnVisibilityEvent(itemEvent, legendItem);
                this.collection = this.dObjectLegend.getCurrentCollection();
                this.collection.setLegendChange((Hashtable)this.unclicked.clone(), (Hashtable)this.greyed.clone());
            }
        }
    }

    private Hashtable fillHashtablewithVector(Vector vector) {
        Hashtable<String, LegendItem> hashtable = new Hashtable<String, LegendItem>();
        int n = this.legendItems.size();
        for (int i = 0; i < n; ++i) {
            if (!(this.legendItems.elementAt(i) instanceof LegendItem)) continue;
            LegendItem legendItem = (LegendItem)this.legendItems.elementAt(i);
            hashtable.put(legendItem.getDescription(), legendItem);
        }
        return hashtable;
    }

    private void passOnVisibilityEvent(ItemEvent itemEvent, LegendItem legendItem) {
        this.ignoreRedraw = true;
        if (Debug.DEBUG) {
            System.out.println("before applyLegendItem(li) > 0");
        }
        if (this.applyLegendItem(legendItem) <= 0) {
            // empty if block
        }
        if (Debug.DEBUG) {
            System.out.println("after applyLegendItem(li) > 0");
        }
        ItemEvent itemEvent2 = new ItemEvent(this, itemEvent.getID(), itemEvent.getSource(), itemEvent.getStateChange());
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ItemListener)this.listeners.elementAt(i)).itemStateChanged(itemEvent2);
        }
        this.ignoreRedraw = false;
    }

    public void selectAllAction(int n) {
        int n2;
        this.selectAllState = n;
        int n3 = this.legendItems.size();
        for (n2 = 0; n2 < n3; ++n2) {
            LegendItem legendItem;
            if (!(this.legendItems.elementAt(n2) instanceof LegendItem) || (legendItem = (LegendItem)this.legendItems.elementAt(n2)).getItemSelectionState() == n) continue;
            legendItem.setSelectionState(n);
        }
        this.check.setSelectionState(n);
        for (n2 = 0; n2 < this.listeners.size(); ++n2) {
            ((ItemListener)this.listeners.elementAt(n2)).itemStateChanged(new ItemEvent(this, n, null, 1));
        }
        if (this.check.getSelectionState() == 112) {
            this.greyed = new Hashtable();
            this.unclicked = new Hashtable();
        } else if (this.check.getSelectionState() == 114) {
            for (n2 = 0; n2 > this.legendItems.size(); ++n2) {
                LegendItem legendItem = (LegendItem)this.legendItems.elementAt(n2);
                this.unclicked.put(legendItem.getDescription(), legendItem);
            }
            this.greyed = new Hashtable();
        } else {
            for (n2 = 0; n2 > this.legendItems.size(); ++n2) {
                LegendItem legendItem = (LegendItem)this.legendItems.elementAt(n2);
                this.greyed.put(legendItem.getDescription(), legendItem);
            }
            this.unclicked = new Hashtable();
        }
    }

    private void reviseLegendItemContent(LegendItem legendItem) {
        NodeList nodeList = this.getLegendItemNodeList(legendItem);
        if (nodeList == null) {
            System.err.println("Warning: XPath evaluation returned null result list, nothing to select");
            return;
        }
        int n = nodeList.getLength();
        int n2 = 0;
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof DTDElementInstance)) continue;
            ++n2;
            String string = ((DTDElementInstance)node).getXPointer();
            if (string == null || "".equals(string)) continue;
            vector.add(string);
        }
        legendItem.setTotalCount(n2);
        legendItem.setXPointers(vector);
    }

    private int applyLegendItem(LegendItem legendItem) {
        if (Debug.DEBUG) {
            System.err.println("applyLegendItem");
        }
        boolean bl = this.makeExtendedItemContent;
        NodeList nodeList = null;
        Vector vector = null;
        int n = 0;
        if (bl) {
            nodeList = this.getLegendItemNodeList(legendItem);
            if (nodeList == null) {
                System.err.println("Warning: XPath evaluation returned null result list, nothing to select");
                return 0;
            }
            n = nodeList.getLength();
        } else {
            vector = this.getLegendItemOriginalNodes(legendItem);
            if (vector == null) {
                System.err.println("Warning: no nodes match the item description, nothing to select");
                return 0;
            }
            n = vector.size();
        }
        int n2 = legendItem.getItemSelectionState();
        if (Debug.DEBUG) {
            System.err.println("visible = " + n2);
        }
        if (Debug.DEBUG) {
            System.out.println("After Document");
        }
        if (n2 == 112) {
            this.unclicked.remove(legendItem.getDescription());
            this.greyed.remove(legendItem.getDescription());
        } else if (n2 == 114) {
            this.unclicked.put(legendItem.getDescription(), legendItem);
            this.greyed.remove(legendItem.getDescription());
        } else if (n2 == 113) {
            this.unclicked.remove(legendItem.getDescription());
            this.greyed.put(legendItem.getDescription(), legendItem);
        }
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            Node node;
            Node node2 = node = bl ? nodeList.item(i) : (Node)vector.elementAt(i);
            if (!(node instanceof DTDElementInstance) || n2 == ((DTDElementInstance)node).getVisibility()) continue;
            if (Debug.DEBUG) {
                System.err.println("### L.applyLI() visible=" + n2 + ", xPtr=" + ((DTDElementInstance)node).getXPointer() + "\n n.getLegendLabel()=" + ((DTDElementInstance)node).getLegendLabel() + ", li.desc() = " + legendItem.getDescription());
            }
            ((DTDElementInstance)node).setVisibility(n2);
            ++n3;
        }
        return n3;
    }

    public NodeList getLegendItemNodeList(LegendItem legendItem) {
        XPath xPath = legendItem.getXPath();
        if (xPath == null) {
            System.err.println("XPath statement was null, cannot select document nodes");
            return null;
        }
        XObject xObject = null;
        try {
            xObject = xPath.execute(this.xpath_context, this.current_node, this.doc_prefix_resolver);
        }
        catch (TransformerException transformerException) {
            System.err.println("Warning: Cannot select nodes due to exception while executing XPath statement (" + xPath.getPatternString() + "):" + transformerException);
            return null;
        }
        if (xObject instanceof XNodeSet) {
            NodeList nodeList = null;
            try {
                nodeList = ((XNodeSet)xObject).nodelist();
                return nodeList;
            }
            catch (TransformerException transformerException) {
                System.err.println("Warning: Cannot access resulting node list due to exception in its retrieval: " + transformerException);
                return null;
            }
        }
        return null;
    }

    public Vector getXPointers(String string) {
        Object v = this.deiXPointers.get(string);
        return v == null ? null : (Vector)v;
    }

    private Vector getLegendItemOriginalNodes(LegendItem legendItem) {
        Vector<DTDElementInstance> vector = new Vector<DTDElementInstance>();
        Stack<Node> stack = new Stack<Node>();
        if (this.current_node != null) {
            stack.push(this.current_node);
            while (!stack.empty()) {
                Node node = (Node)stack.pop();
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    stack.push(node2);
                }
                if (!(node instanceof DTDElementInstance)) continue;
                DTDElementInstance dTDElementInstance = (DTDElementInstance)node;
                if (!legendItem.getDescription().equals(dTDElementInstance.getLegendLabel())) continue;
                if (Debug.DEBUG) {
                    System.err.println("### getLegendItemOriginalNodes dei=" + dTDElementInstance.getLegendLabel() + ", " + dTDElementInstance.getXPointer());
                }
                vector.add(dTDElementInstance);
            }
        }
        return vector;
    }

    public void sort() {
        this.sortAndReviseContent(false);
    }

    public void sort(boolean bl) {
        this.sortAndReviseContent(false, this.clusterDataShown);
    }

    public void sortAndReviseContent(boolean bl) {
        this.sortAndReviseContent(bl, false);
    }

    public void sortAndReviseContent(boolean bl, boolean bl2) {
        this.setRevise(bl);
        this.setClusterDataShown(bl2);
        if (this.ignoreRedraw) {
            return;
        }
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        this.sortSynchronous();
    }

    public void setRevise(boolean bl) {
        this.revise = bl;
    }

    public void setClusterDataShown(boolean bl) {
        this.clusterDataShown = bl;
    }

    public boolean isClusterDataShown() {
        return this.clusterDataShown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sortSynchronous() {
        Serializable serializable;
        int n;
        Serializable serializable2;
        Object object;
        this.legendItems.clear();
        Object object2 = this.images.keys();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            if (this.clusterDataShown && ((String)object).equals("high expression") || this.clusterDataShown && ((String)object).equals("low expression")) continue;
            serializable2 = (Integer)this.counts.get(object);
            n = serializable2 == null ? 0 : (Integer)serializable2;
            serializable = (Color)this.colours.get(object);
            Vector vector = (Vector)this.deiXPointers.get(object);
            Image image = (Image)this.images.get(object);
            ImageIcon imageIcon = null;
            if (image != null) {
                imageIcon = new ImageIcon(image);
            }
            int n2 = this.unclicked.get(object) == null && this.greyed.get(object) == null ? 112 : (this.greyed.get(object) == null ? 114 : 113);
            if (this.clusterDataShown && ((String)object).startsWith("Cluster")) {
                n2 = 113;
            }
            LegendItem legendItem = new LegendItem(imageIcon, LegendItem.GENERIC, (String)object, n, (XPath)this.xpaths.get(object), n2, false, vector, (Color)serializable);
            legendItem.addItemListener(this.legend);
            this.legendItems.add(legendItem);
        }
        object2 = new SortLegendItems();
        Collections.sort(this.legendItems, object2);
        if (this.legendItems.size() > 0) {
            object = this.createLegendHeader(" All Categories", 112);
            this.legendItems.insertElementAt(object, 0);
            serializable2 = new JPanel(false);
            ((JComponent)serializable2).setPreferredSize(new Dimension(900, 1));
            ((JComponent)serializable2).setBackground(Color.gray);
            this.legendItems.insertElementAt(serializable2, 1);
        }
        this.removeAll();
        this.revalidate();
        this.repaint();
        int n3 = this.legendItems.size() / this.numOfColumns;
        int n4 = this.legendItems.size() % this.numOfColumns;
        n = 0;
        serializable = this;
        synchronized (serializable) {
            for (int i = 0; i <= n3; ++i) {
                int n5;
                n = i;
                for (n5 = 0; n5 < n4; ++n5) {
                    this.add((JPanel)this.legendItems.elementAt(n));
                    n = n + n3 + 1;
                }
                if (i == n3) continue;
                for (n5 = n4; n5 < this.numOfColumns; ++n5) {
                    this.add((JPanel)this.legendItems.elementAt(n));
                    n += n3;
                }
            }
        }
        this.legendItems.trimToSize();
        this.setPreferredSize(new Dimension(705, LEGEND_ITEM_HEIGHT * this.legendItems.size()));
        this.revalidate();
        this.repaint();
        if (this.revise) {
            this.reviseContent();
        }
    }

    private JPanel createLegendHeader(String string, int n) {
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new FlowLayout(3, 0, 0));
        jPanel.setBackground(Color.white);
        this.check = new XCheckBox("", n);
        this.check.setBackground(Color.white);
        this.check.setMargin(new Insets(1, 1, 1, 1));
        this.check.addItemListener(this);
        Color color = Color.white;
        JLabel jLabel = new JLabel();
        jLabel.setPreferredSize(new Dimension(15 + SWATCH_WIDTH, 11));
        JLabel jLabel2 = new JLabel(string, 2);
        Font font = jLabel2.getFont();
        jLabel2.setMinimumSize(new Dimension(15, 15));
        jLabel2.setFont(font.deriveFont(10.0f));
        jPanel.add(this.check);
        jPanel.add(jLabel);
        jPanel.add(jLabel2);
        return jPanel;
    }

    public void setExtendedItemContent(boolean bl) {
        this.makeExtendedItemContent = bl;
    }

    public boolean isExtendedItemContent() {
        return this.makeExtendedItemContent;
    }

    public void setAddingItems(boolean bl) {
        this.addingItems = bl;
    }

    public boolean isAddingItems() {
        return this.addingItems;
    }

    public LegendItem getLegendItem(String string) {
        int n = this.legendItems.size();
        for (int i = 0; i < n; ++i) {
            LegendItem legendItem;
            if (!(this.legendItems.elementAt(i) instanceof LegendItem) || !(legendItem = (LegendItem)this.legendItems.elementAt(i)).getDescription().equals(string)) continue;
            return legendItem;
        }
        return null;
    }

    private boolean testHashtables(Hashtable hashtable, Hashtable hashtable2) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            LegendItem legendItem = (LegendItem)hashtable.get(enumeration.nextElement());
            if (hashtable2.contains(legendItem)) continue;
            legendItem.itemStateChanged(new ItemEvent(this, 100, legendItem, 1));
            return true;
        }
        return false;
    }

    public void changeVisibility(Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3, Hashtable hashtable4) {
        if (this.testHashtables(hashtable2, hashtable4)) {
            return;
        }
        if (this.testHashtables(hashtable4, hashtable2)) {
            return;
        }
        if (this.testHashtables(hashtable, hashtable3)) {
            return;
        }
        if (this.testHashtables(hashtable3, hashtable)) {
            return;
        }
        System.err.println("No difference between old legend and current legend");
    }

    public void changeVisibility(Hashtable hashtable, Hashtable hashtable2) {
        if (Debug.DEBUG) {
            System.err.println("Legend: changeVisibility(Hashtable,Hashtable)");
        }
        this.testHashtables2(hashtable2, this.greyed);
        this.testHashtables2(this.greyed, hashtable2);
        this.testHashtables2(hashtable, this.unclicked);
        this.testHashtables2(this.unclicked, hashtable);
    }

    private void testHashtables2(Hashtable hashtable, Hashtable hashtable2) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            LegendItem legendItem = (LegendItem)hashtable.get(enumeration.nextElement());
            if (hashtable2.contains(legendItem)) continue;
            legendItem.itemStateChanged(new ItemEvent(this, 100, legendItem, 1));
        }
    }

    public int getLegendItemVisibility(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Cannot get visibility for a null legend item label");
        }
        int n = this.unclicked.get(string) == null && this.greyed.get(string) == null ? 112 : (this.greyed.get(string) == null ? 114 : 113);
        return n;
    }

    public void setLegendItems(Hashtable hashtable, Hashtable hashtable2) {
        this.unclicked = hashtable;
        this.greyed = hashtable2;
    }

    private class SortLegendItems
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (object instanceof LegendItem && object2 instanceof LegendItem) {
                String string = ((LegendItem)object).getDescription();
                String string2 = ((LegendItem)object2).getDescription();
                return string.compareToIgnoreCase(string2);
            }
            System.err.println("This comparator only works for LegendItem objects");
            return -1;
        }
    }
}

