/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.DataManager;
import ca.ucalgary.bluejay.gui.Legend;
import ca.ucalgary.bluejay.gui.LegendItem;
import ca.ucalgary.bluejay.gui.painter.AbstractLinearPainter;
import ca.ucalgary.bluejay.gui.painter.BasicTargetPainter;
import ca.ucalgary.bluejay.gui.util.Debug;
import ca.ucalgary.bluejay.session.StateCollection;
import com.jhlabs.awt.BasicGridLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.Stack;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.plaf.basic.BasicToolBarUI;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LegendManager
implements ItemListener {
    private Legend legendPanel;
    private JToolBar legendBar;
    private JScrollPane legendPane;
    private BluejayDObjectList dlist;
    private AbstractLinearGraphics alg;
    private DataManager dataManager;
    private final int SIDE = 1;
    private boolean ignoreLegendRedrawWhileRepainting = false;
    private static Logger logger = Logger.getLogger(LegendManager.class);

    public LegendManager(BluejayDObjectList bluejayDObjectList, AbstractLinearGraphics abstractLinearGraphics, DataManager dataManager) {
        this.dlist = bluejayDObjectList;
        this.alg = abstractLinearGraphics;
        this.dataManager = dataManager;
        if (Debug.legend) {
            this.setLegendBar();
        }
    }

    private void setLegendBar() {
        this.legendPanel = new Legend(this.dlist, 1);
        this.legendPanel.setPrefixResolver(this.dlist);
        this.legendPanel.addItemListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new BasicGridLayout());
        this.dlist.clearScaleComponent();
        jPanel.add(this.legendPanel);
        this.legendPane = new JScrollPane(jPanel, 20, 30);
        this.legendPane.getViewport().setBackground(Color.white);
        Dimension dimension = new Dimension(100, 50);
        this.dlist.setMinimumSize(dimension);
        this.dlist.setPreferredSize(new Dimension(400, 400));
        this.legendBar = new JToolBar("Legend");
        this.legendBar.setMinimumSize(dimension);
        ((BasicToolBarUI)this.legendBar.getUI()).setDockingColor(Color.darkGray);
        if (this.dlist.getInTab()) {
            this.legendBar.setPreferredSize(new Dimension(200, 200));
        } else {
            this.legendBar.setPreferredSize(new Dimension(200, 400));
            this.legendBar.setMaximumSize(new Dimension(200, 400));
        }
        this.legendBar.setMinimumSize(new Dimension(200, 200));
        this.legendBar.setMaximumSize(new Dimension(205, 800));
        this.legendBar.add(this.legendPane);
        this.alg.setLegend(this.legendPanel);
    }

    public void switchLegendBarLayout() {
        Dimension dimension = this.legendBar.getPreferredSize();
        if (dimension.equals(new Dimension(200, 200))) {
            this.legendBar.setPreferredSize(new Dimension(200, 300));
            logger.debug("DList.switchLegendBarLayout() -- in tab ya ya");
        } else {
            this.legendBar.setPreferredSize(new Dimension(200, 200));
            logger.debug("DList.switchLegendBarLayout() -- outside we are we area are");
        }
        this.legendBar.repaint();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() instanceof Legend) {
            this.ignoreLegendRedrawWhileRepainting = true;
            LegendItem legendItem = (LegendItem)itemEvent.getItem();
            Object[] objectArray = null;
            objectArray = legendItem == null ? ((Legend)itemEvent.getSource()).getLegendItems() : new LegendItem[]{legendItem};
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof LegendItem)) continue;
                legendItem = (LegendItem)objectArray[i];
                int n = legendItem.getItemSelectionState();
                Vector vector = this.legendPanel.getXPointers(legendItem.getDescription());
                TreeMap treeMap = this.dataManager.getXPtrToGVTMap();
                int n2 = vector.size();
                for (int j = 0; j < n2; ++j) {
                    if (vector.elementAt(j) == null) continue;
                    String string = (String)vector.elementAt(j);
                    Vector vector2 = (Vector)this.dataManager.getXPtrToGVTMap().get(string);
                    if (vector2 != null) {
                        this.setLegendVisibility(n, vector2);
                    }
                    Vector<String> vector3 = new Vector<String>();
                    SortedMap sortedMap = treeMap.tailMap(string + "/");
                    if (sortedMap != null && !sortedMap.isEmpty()) {
                        String string2;
                        Iterator<String> iterator = sortedMap.keySet().iterator();
                        while (iterator.hasNext() && (string2 = iterator.next().toString()).startsWith(string + "/")) {
                            vector3.addElement(string2);
                        }
                    }
                    if (vector3 == null) continue;
                    int n3 = vector3.size();
                    for (int k = 0; k < n3; ++k) {
                        String string3 = (String)vector3.elementAt(k);
                        Vector vector4 = (Vector)treeMap.get(string3);
                        if (vector4 == null) continue;
                        this.setLegendVisibility(n, vector4);
                    }
                }
            }
            this.dlist.refreshDisplay();
        }
    }

    public void setLegendVisibility(int n, Vector vector) {
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            GraphicsNode graphicsNode = (GraphicsNode)vector.elementAt(i);
            if (n == graphicsNode.getDataVisibility()) continue;
            graphicsNode.setDataVisibility(n);
        }
    }

    public void buildLegend(Document document) {
        if (Debug.legend) {
            if (this.legendPanel.isExtendedItemContent()) {
                this.legendPanel.clear();
                this.legendPanel.init(document, null);
                this.legendPanel.sortAndReviseContent(true);
                this.ignoreLegendRedrawWhileRepainting = false;
                this.legendPanel.repaint();
            } else {
                this.legendPanel.init(document, null);
                this.ignoreLegendRedrawWhileRepainting = false;
            }
        }
    }

    public void repaintLegendUsing(Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3, Hashtable hashtable4, StateCollection stateCollection) {
        this.legendPanel.setLegendItems(hashtable, hashtable2);
        stateCollection.resetLegendHashtables((Hashtable)hashtable.clone(), (Hashtable)hashtable2.clone());
        this.legendPanel.changeVisibility(hashtable, hashtable2, hashtable3, hashtable4);
    }

    public void repaintLegendUsing(Hashtable hashtable, Hashtable hashtable2, StateCollection stateCollection) {
        this.legendPanel.setLegendItems(hashtable, hashtable2);
        int n = this.legendPanel.selectAllState;
        if (n == 112) {
            n = 114;
        } else if (n == 113) {
            n = 112;
        } else if (n == 114) {
            n = 113;
        }
        this.legendPanel.selectAllAction(n);
        stateCollection.resetLegendHashtables((Hashtable)hashtable.clone(), (Hashtable)hashtable2.clone());
        this.legendPanel.changeVisibility(hashtable, hashtable2);
        this.legendPanel.setLegendItems(hashtable, hashtable2);
    }

    private void buildLegendItems() {
        Stack<Node> stack = new Stack<Node>();
        boolean bl = true;
        this.legendPanel.setAddingItems(true);
        Element element = this.dlist.getDocument().getDocumentElement();
        if (element == null) {
            System.err.println("PG: No document root to paint, aborting legend update in buildLegendItems()");
            return;
        }
        stack.push(element);
        while (!stack.empty()) {
            DTDElementInstance dTDElementInstance;
            AbstractLinearPainter abstractLinearPainter;
            Node node = (Node)stack.pop();
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                stack.push(node2);
            }
            if (!(node instanceof DTDElementInstance) || (abstractLinearPainter = (dTDElementInstance = (DTDElementInstance)node).getPainter()) == null) continue;
            try {
                if (bl && abstractLinearPainter instanceof BasicTargetPainter) {
                    ((BasicTargetPainter)abstractLinearPainter).clearLayout();
                    bl = false;
                }
                abstractLinearPainter.updateLegendItem(this.alg, dTDElementInstance);
            }
            catch (Exception exception) {
                System.err.println("Cannot perform painter.updateLegendItem(alg, dei) for dei=" + dTDElementInstance.getLocalName());
                exception.printStackTrace();
            }
        }
        this.legendPanel.setAddingItems(false);
    }

    public void buildLegendItemsPublic() {
        this.buildLegendItems();
    }

    public void updateLegendPainting() {
        this.legendPanel.ignoreRedraw(this.ignoreLegendRedrawWhileRepainting);
    }

    public void sortSynchronous() {
        this.legendPanel.sortSynchronous();
    }

    public JToolBar getLegendBar() {
        return this.legendBar;
    }

    public void setLegendBar(JToolBar jToolBar) {
        this.legendBar = jToolBar;
    }

    public Legend getLegendPanel() {
        return this.legendPanel;
    }

    public void setLegendPanel(Legend legend) {
        this.legendPanel = legend;
    }

    public void setIgnoreLegendRedrawWhileRepainting(boolean bl) {
        this.ignoreLegendRedrawWhileRepainting = bl;
    }
}

