/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import com.jhlabs.awt.BasicGridLayout;
import com.jhlabs.awt.ParagraphLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class ReverseComplementWidget
extends JPanel
implements ItemListener {
    private DefaultComboBoxModel allModel;
    private JComboBox allBackbones;
    private Vector reverses;
    private ReversePanel reverse;
    private JButton apply;
    private static Logger logger = Logger.getLogger(ReverseComplementWidget.class);
    private boolean allReversed = false;
    private String back = "to original strand";
    private String comp = "to opposite strand";
    private JLabel to;

    public ReverseComplementWidget() {
        BasicGridLayout basicGridLayout = new BasicGridLayout();
        this.setLayout(basicGridLayout);
        this.reverse = new ReversePanel();
        this.add(this.reverse);
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(200, 100));
        jPanel.setLayout(new ParagraphLayout(5, 5));
        jPanel.add((Component)new JLabel("Reverse:"), ParagraphLayout.NEW_PARAGRAPH);
        this.allModel = new DefaultComboBoxModel();
        this.allBackbones = new JComboBox(this.allModel);
        this.allBackbones.addItemListener(this);
        jPanel.add(this.allBackbones);
        this.to = new JLabel(this.comp);
        jPanel.add((Component)this.to, ParagraphLayout.NEW_LINE);
        this.add(jPanel);
        this.apply = new JButton("Apply");
    }

    public void setEnabledAll(boolean bl) {
        this.reverse.setEnabled(bl);
        this.allBackbones.setEnabled(bl);
        this.apply.setEnabled(bl);
    }

    public boolean getAllReversed() {
        return this.allReversed;
    }

    public void setAllReversed(boolean bl) {
        this.allReversed = bl;
    }

    public JButton getApplyButton() {
        return this.apply;
    }

    public void updateModel(DefaultComboBoxModel defaultComboBoxModel, Vector vector) {
        this.reverses = (Vector)vector.clone();
        this.allModel = defaultComboBoxModel;
        this.allBackbones.setModel(this.allModel);
        this.allBackbones.repaint();
        if (this.allBackbones.getItemCount() != 0) {
            Boolean bl = (Boolean)this.reverses.elementAt(this.allBackbones.getSelectedIndex());
            this.reverse.setReverse(bl);
            this.reverse.revalidate();
            this.reverse.repaint();
            if (bl.booleanValue()) {
                this.to.setText(this.back);
            } else {
                this.to.setText(this.comp);
            }
            this.to.repaint();
        }
    }

    public DefaultComboBoxModel getModel() {
        return this.allModel;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.allBackbones) {
            Boolean bl = (Boolean)this.reverses.elementAt(((JComboBox)itemEvent.getSource()).getSelectedIndex());
            this.reverse.setReverse(bl);
            this.reverse.revalidate();
            this.reverse.repaint();
            if (bl.booleanValue()) {
                this.to.setText(this.back);
            } else {
                this.to.setText(this.comp);
            }
            this.to.repaint();
        }
    }

    private class ReversePanel
    extends JPanel {
        private Rectangle2D.Double rect;
        private double x = 5.0;
        private double y = 20.0;
        private double width = 190.0;
        private double height = 10.0;
        private Rectangle2D.Double rectTwo;
        private boolean isReverse = false;

        public ReversePanel() {
            this.setPreferredSize(new Dimension(205, 60));
            this.setBorder(BorderFactory.createEtchedBorder());
            this.rect = new Rectangle2D.Double(this.x, this.y, this.width, this.height);
            this.rectTwo = new Rectangle2D.Double(this.x, this.y + this.height, this.width, this.height);
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Paint paint = graphics2D.getPaint();
            if (this.isReverse) {
                graphics2D.setColor(Color.red);
                graphics2D.drawString("5'", (int)this.x, (int)this.y - 5);
                graphics2D.drawString("3'", (int)this.x + (int)this.width - 10, (int)this.y - 5);
                GradientPaint gradientPaint = new GradientPaint((int)this.x, (int)this.y, Color.red, (int)this.x + (int)this.width, (int)this.y, Color.white);
                graphics2D.setPaint(gradientPaint);
                graphics2D.fill(this.rect);
                graphics2D.setPaint(paint);
                graphics2D.setColor(Color.white);
                graphics2D.drawString("Reverse", (int)this.x, (int)this.y + 10);
                graphics2D.setPaint(paint);
                graphics2D.setColor(Color.blue);
                graphics2D.drawString("3'", (int)this.x, (int)(this.y + this.height + this.height + 10.0));
                graphics2D.drawString("5'", (int)this.x + (int)this.width - 10, (int)(this.y + this.height + this.height) + 10);
                GradientPaint gradientPaint2 = new GradientPaint((int)this.x, (int)this.y, Color.white, (int)this.x + (int)this.width, (int)this.y, Color.blue);
                graphics2D.setPaint(gradientPaint2);
                graphics2D.fill(this.rectTwo);
                graphics2D.setPaint(paint);
                graphics2D.setColor(Color.white);
                graphics2D.drawString("Forward", (int)this.x + (int)this.width - 50, (int)(this.y + this.height + this.height));
            } else {
                graphics2D.setColor(Color.blue);
                graphics2D.drawString("5'", (int)this.x, (int)this.y - 5);
                graphics2D.drawString("3'", (int)this.x + (int)this.width - 10, (int)this.y - 5);
                GradientPaint gradientPaint = new GradientPaint((int)this.x, (int)this.y, Color.blue, (int)this.x + (int)this.width, (int)this.y, Color.white);
                graphics2D.setPaint(gradientPaint);
                graphics2D.fill(this.rect);
                graphics2D.setPaint(paint);
                graphics2D.setColor(Color.white);
                graphics2D.drawString("Forward", (int)this.x, (int)this.y + 10);
                graphics2D.setPaint(paint);
                graphics2D.setColor(Color.red);
                graphics2D.drawString("3'", (int)this.x, (int)(this.y + this.height + this.height + 10.0));
                graphics2D.drawString("5'", (int)this.x + (int)this.width - 10, (int)(this.y + this.height + this.height) + 10);
                GradientPaint gradientPaint3 = new GradientPaint((int)this.x, (int)this.y, Color.white, (int)this.x + (int)this.width, (int)this.y, Color.red);
                graphics2D.setPaint(gradientPaint3);
                graphics2D.fill(this.rectTwo);
                graphics2D.setPaint(paint);
                graphics2D.setColor(Color.white);
                graphics2D.drawString("Reverse", (int)this.x + (int)this.width - 50, (int)(this.y + this.height + this.height));
            }
            graphics2D.setPaint(paint);
        }

        public void setReverse(boolean bl) {
            this.isReverse = bl;
        }
    }
}

