/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import com.jhlabs.awt.BasicGridLayout;
import com.jhlabs.awt.ParagraphLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class RotateWidget
extends JPanel
implements DocumentListener,
ItemListener {
    private DefaultComboBoxModel model;
    private JComboBox backbones;
    private double old;
    private RotatePanel rotate;
    private static Logger logger = Logger.getLogger(RotateWidget.class);
    private JButton apply;
    private JSpinner spin;
    private JTextField editor;
    private Vector angles;
    private int currSeqNum = -1;
    public static final double INVALIDANGLE = -555.0;

    public RotateWidget() {
        this.setLayout(new BasicGridLayout());
        this.rotate = new RotatePanel();
        this.add(this.rotate);
        this.angles = new Vector();
        this.old = this.rotate.getExtent();
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(200, 100));
        jPanel.setLayout(new ParagraphLayout(5, 5));
        jPanel.add((Component)new JLabel("Rotate:"), ParagraphLayout.NEW_PARAGRAPH);
        this.model = new DefaultComboBoxModel();
        this.backbones = new JComboBox(this.model);
        this.backbones.addItemListener(this);
        jPanel.add(this.backbones);
        jPanel.add((Component)new JLabel("To:"), ParagraphLayout.NEW_PARAGRAPH);
        this.spin = new JSpinner(new SpinnerNumberModel(this.rotate.getExtent(), -360.0, 360.0, 15.0));
        this.editor = ((JSpinner.DefaultEditor)this.spin.getEditor()).getTextField();
        this.editor.getDocument().addDocumentListener(this);
        this.spin.addChangeListener(this.rotate);
        jPanel.add(this.spin);
        jPanel.add(new JLabel("degrees"));
        this.add(jPanel);
        this.apply = new JButton("Apply");
    }

    public void setEnabledAll(boolean bl) {
        this.rotate.setEnabled(bl);
        this.spin.setEnabled(bl);
        this.apply.setEnabled(bl);
        this.backbones.setEnabled(bl);
    }

    public JButton getApplyButton() {
        return this.apply;
    }

    public void updateModel(DefaultComboBoxModel defaultComboBoxModel, Vector vector) {
        this.angles = (Vector)vector.clone();
        this.model = defaultComboBoxModel;
        this.backbones.setModel(this.model);
        this.backbones.repaint();
    }

    public double getRotationAngle() {
        return -this.rotate.getExtent();
    }

    public DefaultComboBoxModel getModel() {
        return this.model;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.refreshButton();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.refreshButton();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.refreshButton();
    }

    private void refreshButton() {
        if (!this.editor.getText().equals("")) {
            this.apply.setEnabled(this.isOkay(this.editor.getText()));
        }
    }

    private boolean isOkay(String string) {
        boolean bl = true;
        try {
            Double d = new Double(string);
            double d2 = d;
            bl = -360.0 <= d2 && d2 <= 360.0;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() instanceof JComboBox) {
            int n = ((JComboBox)itemEvent.getSource()).getSelectedIndex();
            Double d = (Double)this.angles.elementAt(((JComboBox)itemEvent.getSource()).getSelectedIndex());
            this.spin.setValue(d);
        }
    }

    public void setCurrSeqNum(int n) {
        this.currSeqNum = n;
    }

    public int getCurrSeqNum() {
        return this.currSeqNum;
    }

    public JComboBox getRotateBox() {
        return this.backbones;
    }

    private class RotatePanel
    extends JPanel
    implements ChangeListener {
        private double x = 50.0;
        private double y = 5.0;
        private double width = 50.0;
        private double height = 50.0;
        private double start = 90.0;
        private double extent = 0.0;
        private double old = 0.0;
        private Ellipse2D.Double circle;

        public RotatePanel() {
            this.setPreferredSize(new Dimension(190, 60));
            this.setBorder(BorderFactory.createEtchedBorder());
            this.circle = new Ellipse2D.Double(this.x, this.y, this.width, this.height);
        }

        public void setExtent(double d) {
            this.extent = d;
        }

        public double getExtent() {
            return this.extent;
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(new Color(196, 191, 204));
            graphics2D.fill(this.circle);
            graphics2D.setColor(new Color(171, 173, 208));
            Arc2D.Double double_ = new Arc2D.Double(this.x, this.y, this.width, this.height, this.start, this.extent, 2);
            graphics2D.fill(double_);
            graphics2D.setColor(Color.black);
            Line2D.Double double_2 = new Line2D.Double(this.x + this.width / 2.0, this.y + this.height / 2.0, this.x + this.width / 2.0, this.y);
            graphics2D.draw(double_2);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() instanceof JSpinner) {
                JSpinner jSpinner = (JSpinner)changeEvent.getSource();
                if (((Number)jSpinner.getValue()).doubleValue() == 360.0 || ((Number)jSpinner.getValue()).doubleValue() == -360.0) {
                    jSpinner.setValue(new Double(0.0));
                    this.extent = 0.0;
                } else {
                    this.extent = -((Number)jSpinner.getValue()).doubleValue();
                }
                this.repaint();
            }
        }
    }
}

