/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.client.TargetAppearance;
import ca.ucalgary.bluejay.client.URLLoader;
import ca.ucalgary.bluejay.client.XPointerResolver;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.DataNavigator;
import ca.ucalgary.bluejay.gui.VisibilityManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SelectedTextGUI
implements ActionListener {
    private BluejayDObjectList canvas;
    private URLLoader urlLoader;
    private Point startPoint;
    private Point endPoint;
    private int startPosition;
    private int endPosition;
    private int origin = 3;
    private Node nodeCurrent = null;
    private Node nodeBefore = null;
    private Node nodeAfter = null;
    private static final int SEQUENCE = 0;
    private static final int GENE = 1;
    private static final int ELEMENT = 2;
    private static final int UNKNOWN = 3;
    private static final String TEXT = "Text Options";
    private static final String CONTRACT = "Contract Region";
    private static final String MERGE_BEFORE = "Merge with Region Before";
    private static final String MERGE_AFTER = "Merge with Region After";
    private static final int POINT_OFFSET = 10;
    private static Logger logger = Logger.getLogger(SelectedTextGUI.class);

    public SelectedTextGUI(BluejayDObjectList bluejayDObjectList, URLLoader uRLLoader, Point point, Point point2, int n, int n2) {
        this.canvas = bluejayDObjectList;
        this.urlLoader = uRLLoader;
        this.startPoint = point;
        this.endPoint = point2;
        this.startPosition = n;
        this.endPosition = n2;
    }

    private int findTextOrigin(Point point, int n) {
        String string;
        DataNavigator dataNavigator = this.canvas.getDataNavigator();
        Point2D point2D = this.canvas.getAbstractLinearGraphics().isTextHMode() ? dataNavigator.getCanvasToTrueCoords(point.x + n, point.y) : dataNavigator.getCanvasToTrueCoords(point.x, point.y + n);
        String string2 = dataNavigator.getHitGraphicsNodeXPointer(point2D.getX(), point2D.getY());
        Vector vector = this.canvas.getAbstractLinearGraphics().getTargetAppearances();
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            string = ((TargetAppearance)vector.elementAt(i)).getXPointer();
            if (string2 == null || !string2.equals(string)) continue;
            return 0;
        }
        Document document = this.canvas.getDocument();
        Node node = null;
        if (document != null && document.getDocumentElement() != null) {
            node = XPointerResolver.getNodeFromXPointer(document, string2);
            if (node == null) {
                logger.warn("findTextOrigin(): Couldn't resolve XPointer in the document using DOM.");
                return 3;
            }
        } else {
            node = XPointerResolver.getNodeFromXPointer(this.urlLoader.getActualURLName(), string2, this.canvas.getBluejayParser());
            if (node == null) {
                logger.warn("findTextOrigin(): Couldn't resolve XPointer in the document using SAX.");
                return 3;
            }
        }
        if (node != null && node instanceof DTDElementInstance) {
            if (n == 0) {
                this.nodeCurrent = node;
            } else if (n < 0) {
                this.nodeBefore = node;
            } else {
                this.nodeAfter = node;
            }
            string = ((DTDElementInstance)node).getAttribute("element_id");
            if (string.equals("")) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    public JMenu createLinkPopup() {
        JMenu jMenu = new JMenu(TEXT);
        JMenuItem jMenuItem = new JMenuItem(CONTRACT);
        jMenuItem.setActionCommand(CONTRACT);
        jMenuItem.addActionListener(this);
        JMenuItem jMenuItem2 = new JMenuItem(MERGE_BEFORE);
        jMenuItem2.setActionCommand(MERGE_BEFORE);
        jMenuItem2.addActionListener(this);
        JMenuItem jMenuItem3 = new JMenuItem(MERGE_AFTER);
        jMenuItem3.setActionCommand(MERGE_AFTER);
        jMenuItem3.addActionListener(this);
        this.origin = this.findTextOrigin(this.startPoint, 0);
        switch (this.origin) {
            case 1: {
                jMenu.add(jMenuItem);
                break;
            }
            case 2: {
                jMenu.add(jMenuItem);
                break;
            }
            case 0: {
                int n = this.findTextOrigin(this.startPoint, -10);
                int n2 = this.findTextOrigin(this.endPoint, 10);
                if (n == 1 || n == 2) {
                    jMenu.add(jMenuItem2);
                }
                if (n2 != 1 && n2 != 2) break;
                jMenu.add(jMenuItem3);
                break;
            }
            case 3: {
                break;
            }
        }
        return jMenu;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            if (actionEvent.getActionCommand() == CONTRACT) {
                this.contractRegion();
            } else if (actionEvent.getActionCommand() == MERGE_BEFORE) {
                this.mergeWithRegionBefore();
            } else if (actionEvent.getActionCommand() == MERGE_AFTER) {
                this.mergeWithRegionAfter();
            } else {
                System.err.println("SelectedTextGUI.actionPerformed(): strange action command");
            }
        }
    }

    private void mergeWithRegionBefore() {
        int n = JOptionPane.showConfirmDialog(null, "Do you want to merge the selected range with " + this.makeRegionName(this.nodeBefore) + "?", "Expand Region", 0);
        if (n == 0) {
            for (Node node = this.nodeBefore.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof DTDElementInstance) || !((DTDElementInstance)node).getLocalName().equals("seq_location")) continue;
                ((DTDElementInstance)node).setAttribute("greatest_end", "" + this.endPosition);
                this.repaintRegions(node, this.startPosition);
            }
        }
    }

    private void mergeWithRegionAfter() {
        int n = JOptionPane.showConfirmDialog(null, "Do you want to merge the selected range with " + this.makeRegionName(this.nodeAfter) + "?", "Expand Region", 0);
        if (n == 0) {
            for (Node node = this.nodeAfter.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof DTDElementInstance) || !((DTDElementInstance)node).getLocalName().equals("seq_location")) continue;
                ((DTDElementInstance)node).setAttribute("least_start", "" + this.startPosition);
                this.repaintRegions(node, this.endPosition);
            }
        }
    }

    private void contractRegion() {
        int n = JOptionPane.showConfirmDialog(null, "Do you want to contract " + this.makeRegionName(this.nodeCurrent) + " to the selected range?", CONTRACT, 0);
        if (n == 0) {
            for (Node node = this.nodeCurrent.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof DTDElementInstance) || !((DTDElementInstance)node).getLocalName().equals("seq_location")) continue;
                ((DTDElementInstance)node).setAttribute("least_start", "" + this.startPosition);
                ((DTDElementInstance)node).setAttribute("greatest_end", "" + this.endPosition);
                this.repaintRegions(node, this.startPosition);
            }
        }
    }

    private void repaintRegions(Node node, int n) {
        VisibilityManager visibilityManager = this.canvas.getVisibilityManager();
        visibilityManager.setPropagation(false);
        visibilityManager.setFocusPosition(((DTDElementInstance)node).getTarget(), n);
        visibilityManager.setPropagation(true);
        this.canvas.repaint(true);
    }

    private String makeRegionName(Node node) {
        String string = ((DTDElementInstance)node).getAttribute("element_id");
        String string2 = ((DTDElementInstance)node).getAttribute("label");
        if (!string.equals("")) {
            return "gene\"" + string2 + "\"";
        }
        if (!string2.equals("")) {
            return "\"" + string2 + "\"";
        }
        return "repeat_region";
    }
}

