/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import ca.ucalgary.bluejay.session.SessionManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class SessionSettingsPanel
extends JPanel
implements ActionListener {
    private JFrame f;
    private JPanel panel1;
    private String[] options;
    private JTextField newEmail;
    private JTextField confirmEmail;
    private JPasswordField oldPassword;
    private JPasswordField newPassword;
    private JPasswordField confirmPassword;
    private JLabel userNameLabel;
    private JLabel editProfileLabel;
    private SessionManager sessionManager;
    private boolean isAnApplet;
    private static Logger logger = Logger.getLogger(SessionSettingsPanel.class);

    public SessionSettingsPanel() {
        super(new GridLayout(1, 1));
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.userNameLabel = new JLabel("");
        this.panel1 = this.makeProfilePanel();
        jTabbedPane.addTab("Profile", null, this.panel1, "User Information");
        this.options = new String[]{"Done"};
        this.add(jTabbedPane);
    }

    private JPanel makeProfilePanel() {
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel("Email:   ");
        jLabel.setHorizontalAlignment(4);
        gridBagConstraints.ipady = 30;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.userNameLabel, gridBagConstraints);
        JButton jButton = new JButton("Change Email/Password");
        jButton.addActionListener(this);
        jButton.setActionCommand("Edit Profile");
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)new JLabel(""), gridBagConstraints);
        return jPanel;
    }

    private JComponent makeEditProfilePanel() {
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new GridLayout(0, 1));
        this.editProfileLabel = new JLabel("");
        JButton jButton = new JButton("Change Email");
        jButton.setActionCommand("Change Email");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Change Password");
        jButton2.setActionCommand("Change Password");
        jButton2.addActionListener(this);
        jPanel.add(this.editProfileLabel);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        return jPanel;
    }

    private JComponent makeEditEmailPanel() {
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new GridLayout(0, 1));
        JPanel jPanel2 = new JPanel(false);
        jPanel2.setLayout(new GridLayout(0, 2));
        JLabel jLabel = new JLabel("New Email:");
        jPanel2.add(jLabel);
        this.newEmail = new JTextField();
        jPanel2.add(this.newEmail);
        JLabel jLabel2 = new JLabel("Confirm New Email:");
        jPanel2.add(jLabel2);
        this.confirmEmail = new JTextField();
        jPanel2.add(this.confirmEmail);
        jPanel.add(jPanel2);
        JLabel jLabel3 = new JLabel("This will be your log-in name. Please record it for future reference.");
        jPanel.add(jLabel3);
        return jPanel;
    }

    private JComponent makeEditPasswordPanel() {
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new GridLayout(0, 1));
        JPanel jPanel2 = new JPanel(false);
        jPanel2.setLayout(new GridLayout(0, 2));
        JLabel jLabel = new JLabel("Old Password:");
        jPanel2.add(jLabel);
        this.oldPassword = new JPasswordField();
        jPanel2.add(this.oldPassword);
        JLabel jLabel2 = new JLabel("New Password:");
        jPanel2.add(jLabel2);
        this.newPassword = new JPasswordField();
        jPanel2.add(this.newPassword);
        JLabel jLabel3 = new JLabel("Confirm New Password:");
        jPanel2.add(jLabel3);
        this.confirmPassword = new JPasswordField();
        jPanel2.add(this.confirmPassword);
        jPanel.add(jPanel2);
        JLabel jLabel4 = new JLabel("This will be your password. Please record or remember it for future reference.");
        jPanel.add(jLabel4);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Change Email")) {
            this.editProfileLabel.setText("Changing Email...");
            JPanel jPanel = (JPanel)this.makeEditEmailPanel();
            this.options = new String[]{"OK", "Cancel"};
            boolean bl = false;
            while (!bl) {
                int n = JOptionPane.showOptionDialog(this.f, jPanel, "Change Email", 2, -1, null, this.options, null);
                if (n == 0) {
                    if (!this.newEmail.getText().equals("") && !this.confirmEmail.getText().equals("")) {
                        if (this.newEmail.getText().equals(this.confirmEmail.getText())) {
                            int n2 = this.sessionManager.changeEmail(this.newEmail.getText());
                            if (n2 == 0) {
                                bl = true;
                                if (this.isAnApplet) {
                                    this.f.setTitle("Bluejay Browser Applet: " + this.sessionManager.getUserName());
                                } else {
                                    this.f.setTitle("Bluejay Browser Application: " + this.sessionManager.getUserName());
                                }
                                this.userNameLabel.setText(this.sessionManager.getUserName());
                                this.editProfileLabel.setText("Email successfully changed.");
                                continue;
                            }
                            JOptionPane.showOptionDialog(this.f, "There was some error in changing your email. The attempt was unsuccessful. Please try another email address.", "Change Email Unsuccessful", 0, 0, null, new String[]{"Dismiss"}, "Dismiss");
                            bl = false;
                            continue;
                        }
                        JOptionPane.showOptionDialog(this.f, "Email and Confirm email are not equal. Please check and retype your desired email.", "Change Email Unsuccessful", 0, 0, null, new String[]{"Dismiss"}, "Dismiss");
                        continue;
                    }
                    JOptionPane.showOptionDialog(this.f, "Please enter two identical email addresses.", "Change Email Unsuccessful", 0, 0, null, new String[]{"Dismiss"}, "Dismiss");
                    continue;
                }
                this.editProfileLabel.setText("");
                bl = true;
            }
        } else if (actionEvent.getActionCommand().equals("Change Password")) {
            this.editProfileLabel.setText("Changing Password...");
            JPanel jPanel = (JPanel)this.makeEditPasswordPanel();
            this.options = new String[]{"OK", "Cancel"};
            boolean bl = false;
            while (!bl) {
                int n = JOptionPane.showOptionDialog(this.f, jPanel, "Change Password", 2, -1, null, this.options, null);
                String string = new String(this.oldPassword.getPassword());
                String string2 = new String(this.newPassword.getPassword());
                String string3 = new String(this.confirmPassword.getPassword());
                if (n == 0) {
                    if (!(string.equals("") || string2.equals("") || string3.equals(""))) {
                        if (string2.equals(string3)) {
                            try {
                                int n3 = this.sessionManager.changePassword(string, string2);
                                if (n3 == 0) {
                                    bl = true;
                                    this.editProfileLabel.setText("Password successfully changed.");
                                    continue;
                                }
                                JOptionPane.showOptionDialog(this.f, "There was error in changing your password. You may have entered your old password incorrectly. Please try again.", "Change Password Unsuccessful", 0, 0, null, new String[]{"Dismiss"}, "Dismiss");
                                bl = false;
                            }
                            catch (Exception exception) {
                                logger.error("Password doesn't match.");
                                JOptionPane.showOptionDialog(this.f, "An incorrect password was entered. Please check that you typed your old password correctly", "Password incorrect", 0, 0, null, new String[]{"Dismiss"}, "Dismiss");
                                bl = false;
                            }
                            continue;
                        }
                        JOptionPane.showOptionDialog(this.f, "Password and Confirm Password are not equal. Please check and retype your desired password.", "Change Password Unsuccessful", 0, 0, null, new String[]{"Dismiss"}, "Dismiss");
                        continue;
                    }
                    JOptionPane.showOptionDialog(this.f, "Please enter two identical passwords.", "Change Password Unsuccessful", 0, 0, null, new String[]{"Dismiss"}, "Dismiss");
                    continue;
                }
                this.editProfileLabel.setText("");
                bl = true;
            }
        } else if (actionEvent.getActionCommand().equals("Edit Profile")) {
            if (this.editProfileLabel != null) {
                this.editProfileLabel.setText("");
            }
            this.options = new String[]{"Done"};
            int n = JOptionPane.showOptionDialog(this.f, this.makeEditProfilePanel(), "Edit Profile", 0, -1, null, this.options, null);
        }
    }

    public void setParent(JFrame jFrame) {
        this.f = jFrame;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setEmailLabel() {
        String string = this.sessionManager.getUserName();
        if (string != null) {
            this.userNameLabel.setText(string);
        }
    }

    public void setIsAnApplet(boolean bl) {
        this.isAnApplet = bl;
    }
}

