/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.cpane;

import ca.ucalgary.bluejay.client.TargetAppearance;
import ca.ucalgary.bluejay.client.lineartarget.StraightLinearTarget;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.GeometryListWidget;
import ca.ucalgary.bluejay.gui.comparison.ComparisonPool;
import ca.ucalgary.bluejay.gui.comparison.ComparisonTab;
import ca.ucalgary.bluejay.gui.comparison.GCFunctionWidget;
import ca.ucalgary.bluejay.gui.comparison.GCShapeWidget;
import ca.ucalgary.bluejay.gui.comparison.Genome;
import ca.ucalgary.bluejay.gui.menu.ComparisonMenuManager;
import ca.ucalgary.bluejay.gui.util.CPanel;
import ca.ucalgary.bluejay.gui.util.Debug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;

public class TabbedPane
implements ActionListener {
    private static BluejayDObjectList dlist;
    private static JTabbedPane tabbedPane;
    private static final Icon NO_ICON;
    private static final String NO_TOOL_TIP;

    public TabbedPane(JTabbedPane jTabbedPane, BluejayDObjectList bluejayDObjectList) {
        tabbedPane = jTabbedPane;
        dlist = bluejayDObjectList;
    }

    public JTabbedPane makeTabbedPane(JScrollPane jScrollPane, JScrollPane jScrollPane2) {
        boolean bl = dlist.getInTab();
        tabbedPane = new JTabbedPane();
        CPanel cPanel = new CPanel();
        cPanel.setLayout(new BorderLayout());
        JToolBar jToolBar = null;
        JToolBar jToolBar2 = null;
        JToolBar jToolBar3 = null;
        tabbedPane.setMaximumSize(new Dimension(205, 800));
        tabbedPane.addTab("Notes", null, jScrollPane, null);
        dlist.getOrientationWidget().setEnabledAll(false);
        dlist.getOrientationWidget().getRotateWidget().getApplyButton().addActionListener(this);
        dlist.getOrientationWidget().getRotateWidget().getApplyButton().setActionCommand("rotate");
        dlist.getOrientationWidget().getReverseComplementWidget().getApplyButton().addActionListener(this);
        dlist.getOrientationWidget().getReverseComplementWidget().getApplyButton().setActionCommand("Reverse Complement");
        dlist.getOrientationWidget().getShiftWidget().getApplyButton().addActionListener(this);
        dlist.getOrientationWidget().getShiftWidget().getApplyButton().setActionCommand("Shift");
        dlist.getComparisonTab().getFunctionWidget().getApplyButton().setActionCommand("Comparison");
        dlist.getComparisonTab().getFunctionWidget().getApplyButton().addActionListener(this);
        dlist.getComparisonTab().getShapeWidget().getApplyButton().setActionCommand("Comparison");
        dlist.getComparisonTab().getShapeWidget().getApplyButton().addActionListener(this);
        GeometryListWidget geometryListWidget = dlist.getGeometryWidget();
        geometryListWidget.setEnabledAll(false);
        geometryListWidget.getApplyButton().addActionListener(this);
        geometryListWidget.getApplyButton().setActionCommand("Geometry");
        if (bl) {
            if (Debug.thumbnail) {
                jToolBar2 = dlist.getThumbnailBar();
                tabbedPane.insertTab("Thumbnail", NO_ICON, jToolBar2, NO_TOOL_TIP, 0);
            }
            if (Debug.navigation) {
                jToolBar3 = dlist.getNavigationBar();
                tabbedPane.insertTab("Navigation", NO_ICON, jToolBar3, NO_TOOL_TIP, 0);
            }
            if (Debug.legend) {
                jToolBar = dlist.getLegendBar();
                tabbedPane.insertTab("Legend", NO_ICON, jToolBar, NO_TOOL_TIP, 0);
                tabbedPane.setSelectedComponent(jToolBar);
            }
            if (Debug.legend || Debug.thumbnail || Debug.navigation) {
                tabbedPane.addContainerListener(new ContainerListener(){

                    public void componentAdded(ContainerEvent containerEvent) {
                        Component component = containerEvent.getChild();
                        if (!(component instanceof JToolBar)) {
                            return;
                        }
                        JToolBar jToolBar = (JToolBar)component;
                        String string = jToolBar.getName();
                        boolean bl = "Legend".equals(string);
                        boolean bl2 = "Legend".equals(tabbedPane.getTitleAt(0));
                        System.out.println("docking.... :)");
                        for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
                            if (!tabbedPane.getTitleAt(i).equals("North") && !tabbedPane.getTitleAt(i).equals("South") && !tabbedPane.getTitleAt(i).equals("East") && !tabbedPane.getTitleAt(i).equals("West")) continue;
                            System.out.println("we have a bogus title");
                            tabbedPane.remove(i);
                            int n = !bl && bl2 ? 1 : 0;
                            tabbedPane.insertTab(jToolBar.getName(), NO_ICON, jToolBar, NO_TOOL_TIP, n);
                            tabbedPane.setSelectedIndex(n);
                            jToolBar.revalidate();
                            jToolBar.repaint();
                            break;
                        }
                        if (bl) {
                            dlist.switchLegendBarLayout();
                        } else if ("Thumbnail".equals(string)) {
                            dlist.switchThumbnailBarLayout();
                        } else if ("Navigation".equals(string)) {
                            dlist.switchNavigationBarLayout();
                        }
                    }

                    public void componentRemoved(ContainerEvent containerEvent) {
                        if (!(containerEvent.getChild() instanceof JToolBar)) {
                            return;
                        }
                        String string = ((JToolBar)containerEvent.getChild()).getName();
                        if ("Legend".equals(string)) {
                            dlist.switchLegendBarLayout();
                        } else if ("Thumbnail".equals(string)) {
                            dlist.switchThumbnailBarLayout();
                        } else if ("Navigation".equals(string)) {
                            dlist.switchNavigationBarLayout();
                        }
                        System.out.println("whoooosh undocking:)");
                    }
                });
            }
        } else {
            cPanel.add((Component)jScrollPane2, "Center");
            if (Debug.legend) {
                jToolBar = dlist.getLegendBar();
                cPanel.add((Component)jToolBar, "East");
            }
            if (Debug.thumbnail) {
                jToolBar2 = dlist.getThumbnailBar();
            }
            if (Debug.navigation) {
                jToolBar3 = dlist.getNavigationBar();
            }
        }
        return tabbedPane;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (Debug.DEBUG) {
            System.out.println("action performed " + actionEvent.getSource().toString());
        }
        if (actionEvent.getActionCommand().equals("rotate")) {
            DefaultComboBoxModel defaultComboBoxModel = dlist.getRotateWidget().getModel();
            if (ComparisonMenuManager.isComparison && dlist.getComparisonPool().getPoolSize() > 1) {
                int n = dlist.getRotateWidget().getRotateBox().getSelectedIndex();
                ComparisonPool comparisonPool = dlist.getComparisonPool();
                Vector<Genome> vector = comparisonPool.getSeqsFromPool();
                double d = dlist.getRotateWidget().getRotationAngle();
                if (n > 0) {
                    vector.elementAt(n - 1).setStartAngle(d);
                } else {
                    for (int i = 0; i < vector.size(); ++i) {
                        vector.elementAt(i).resetStartAngle();
                        vector.elementAt(i).setStartAngle(d);
                    }
                }
                dlist.repaint(true);
            } else if (defaultComboBoxModel.getSize() == 1) {
                dlist.rotate(0, dlist.getRotateWidget().getRotationAngle());
                System.out.println("we got into single case rotate");
            } else {
                int n = dlist.getCircularBackbones().indexOf(defaultComboBoxModel.getSelectedItem()) - 1;
                if (n == -1) {
                    System.out.println("special case here baby!!!!");
                    dlist.rotateAll(dlist.getRotateWidget().getRotationAngle());
                } else {
                    dlist.rotate(dlist.getIndexOfCircularTarget(n), dlist.getRotateWidget().getRotationAngle());
                }
            }
        } else if (actionEvent.getActionCommand().equals("Reverse Complement")) {
            dlist.reverseComplement();
        } else if (actionEvent.getActionCommand().equals("Shift")) {
            dlist.shift();
        } else if (actionEvent.getActionCommand().equals("Geometry")) {
            Vector vector = dlist.getAbstractLinearGraphics().getTargetAppearances();
            boolean bl = false;
            if (dlist.getGeometryWidget().isAll()) {
                System.out.println("Doing the all option for apply");
                if (dlist.getGeometryWidget().isCircularSelectedforAll()) {
                    for (int i = 0; i < vector.size(); ++i) {
                        if (((TargetAppearance)vector.elementAt(i)).getShape() == 112) continue;
                        bl = true;
                        ((TargetAppearance)vector.elementAt(i)).setShape(112);
                    }
                } else {
                    for (int i = 0; i < vector.size(); ++i) {
                        if (((TargetAppearance)vector.elementAt(i)).getShape() == 111) continue;
                        bl = true;
                        ((TargetAppearance)vector.elementAt(i)).setShape(111);
                    }
                }
            } else {
                Vector vector2 = dlist.getGeometryWidget().getGeometryPanels();
                for (int i = 0; i < vector2.size(); ++i) {
                    if (dlist.getGeometryWidget().isCircularSelected(i) && ((TargetAppearance)vector.elementAt(i)).getShape() != 112) {
                        bl = true;
                        ((TargetAppearance)vector.elementAt(i)).setShape(112);
                        continue;
                    }
                    if (dlist.getGeometryWidget().isCircularSelected(i) || ((TargetAppearance)vector.elementAt(i)).getShape() == 111) continue;
                    bl = true;
                    ((TargetAppearance)vector.elementAt(i)).setShape(111);
                }
            }
            if (bl) {
                dlist.repaint(true);
            }
        } else if (actionEvent.getActionCommand().equals("Comparison")) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            ComparisonTab comparisonTab = dlist.getComparisonTab();
            GCFunctionWidget gCFunctionWidget = comparisonTab.getFunctionWidget();
            GCShapeWidget gCShapeWidget = comparisonTab.getShapeWidget();
            if (comparisonTab.isFunctionPane()) {
                bl4 = false;
                bl3 = false;
                bl2 = false;
                boolean bl5 = false;
                bl = false;
                if (gCFunctionWidget.isShownInversions()) {
                    bl4 = true;
                    System.out.println("Anguo:: in TabbedPane, show inversions");
                }
                if (gCFunctionWidget.isShownInsertions()) {
                    bl3 = true;
                    System.out.println("Anguo:: in TabbedPane, show insertions");
                }
                if (gCFunctionWidget.isShownDeletions()) {
                    bl2 = true;
                    System.out.println("Anguo:: in TabbedPane, show deletions");
                }
                if (gCFunctionWidget.isShownLines()) {
                    bl5 = true;
                    System.out.println("Anguo:: in TabbedPane, show lines");
                }
                if (gCFunctionWidget.isShownCleavageSites()) {
                    bl = true;
                    System.out.println("Anguo:: in TabbedPane, show cleavageCites");
                }
            }
            if (comparisonTab.isShapePane()) {
                int n;
                int n2;
                bl4 = gCShapeWidget.isVerticalLinear();
                bl3 = gCShapeWidget.isHoriLinear();
                bl2 = gCShapeWidget.isCircular();
                Vector vector = dlist.getAbstractLinearGraphics().getTargetAppearances();
                bl = false;
                if (bl4 || bl3) {
                    StraightLinearTarget.vert = bl4;
                    if (dlist.getGeometryWidget().isAll()) {
                        for (n2 = 0; n2 < vector.size(); ++n2) {
                            bl = true;
                            ((TargetAppearance)vector.elementAt(n2)).setShape(111);
                        }
                    } else {
                        Vector vector3 = dlist.getGeometryWidget().getGeometryPanels();
                        for (n = 0; n < vector3.size(); ++n) {
                            bl = true;
                            ((TargetAppearance)vector.elementAt(n)).setShape(111);
                        }
                    }
                }
                if (bl2) {
                    if (dlist.getGeometryWidget().isAll()) {
                        for (n2 = 0; n2 < vector.size(); ++n2) {
                            bl = true;
                            ((TargetAppearance)vector.elementAt(n2)).setShape(112);
                        }
                    } else {
                        Vector vector4 = dlist.getGeometryWidget().getGeometryPanels();
                        for (n = 0; n < vector4.size(); ++n) {
                            bl = true;
                            ((TargetAppearance)vector.elementAt(n)).setShape(112);
                        }
                    }
                }
                if (bl) {
                    dlist.repaint(true);
                }
            }
        }
    }

    static {
        NO_ICON = null;
        NO_TOOL_TIP = null;
    }
}

