/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.menu;

import ca.ucalgary.bluejay.client.impl.BluejayURLLoader;
import ca.ucalgary.bluejay.gui.BluejayTreeModelListener;
import ca.ucalgary.bluejay.gui.BookmarkInfo;
import ca.ucalgary.bluejay.gui.BookmarkNode;
import ca.ucalgary.bluejay.gui.DnDJTree;
import ca.ucalgary.bluejay.gui.XbelBookmarksGUI;
import ca.ucalgary.bluejay.gui.menu.BluejayMenuManager;
import ca.ucalgary.bluejay.gui.util.Debug;
import ca.ucalgary.bluejay.session.SessionManager;
import ca.ucalgary.bluejay.util.XMLSerializer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class BookmarksMenuManager
implements BluejayMenuManager,
ActionListener,
TreeSelectionListener {
    public static final String NEW_BOOKMARKS = new String("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"yes\"?><!DOCTYPE xbel SYSTEM \"http://www.bioxml.info/dtd/xbel-1.0.dtd\"><xbel version=\"1.0\" xml:lang=\"en\" xmlns:html=\"http://www.w3.org/1999/xhtml\"><folder><title>Bookmark Examples</title><bookmark href=\"http://magpie.ucalgary.ca/data/Sulfolobus_tokodaii.xml.gz\"><title>Sulfolobus tokodaii</title></bookmark><bookmark href=\"http://magpie.ucalgary.ca/data/Mycoplasma_penetrans.xml.gz\"><title>Mycoplasma penetrans</title></bookmark><bookmark href=\"http://magpie.ucalgary.ca/data/Pyrococcus_furiosus.xml.gz\"><title>Pyrococcus furiosus</title></bookmark></folder></xbel>");
    private URL bookmarksfile;
    private BluejayURLLoader urlLoader;
    private JFrame main_frame;
    private DefaultTreeModel treeModel;
    private DnDJTree tree;
    private JButton addButton;
    private JButton removeButton;
    private JMenu magpieBookmarks;
    private JSeparator separator1;
    private JSeparator separator2;
    private JTextArea bookmarkInfoBox;
    private JLabel statusLabel;
    private BookmarkNode root;
    private JPanel bookmarks;
    private JMenu menu;
    private JMenuItem add;
    private JMenuItem manage;
    private JMenu menu2;
    private JMenuItem add2;
    private JMenuItem manage2;
    private JComboBox tf;
    private Document doc;
    private XbelBookmarksGUI xbelBM;
    private SessionManager sessionManager;
    private boolean loggedIn = false;

    public JMenu getMenu() {
        if (Debug.DEBUG) {
            System.err.println("BookmarksMenuManager.getMenu()");
        }
        if (this.loggedIn) {
            this.menu = this.createMenu();
        } else {
            this.menu = this.createMagpieMenu("Bookmarks", this.menu);
            this.menu.setMnemonic(66);
        }
        return this.menu;
    }

    public JMenu createMenu() {
        if (Debug.DEBUG) {
            System.err.println("BookmarksMenuManager.createMenu()");
        }
        if (this.menu != null) {
            this.menu.removeAll();
        } else {
            this.menu = new JMenu("Bookmarks");
            this.menu.setMnemonic(66);
        }
        this.xbelBM.setURLLoader(this.urlLoader);
        this.add = new JMenuItem("Add Bookmark");
        this.add.setActionCommand("Add");
        this.add.addActionListener(this);
        this.add.setEnabled(true);
        this.add.setToolTipText("Bookmark a remote or local file");
        this.menu.add(this.add);
        this.manage = new JMenuItem("Manage Bookmarks...");
        this.manage.setEnabled(true);
        this.manage.addActionListener(this);
        this.manage.setActionCommand("Manage");
        this.manage.setToolTipText("Organize your bookmarks");
        this.menu.add(this.manage);
        this.separator1 = new JSeparator();
        this.menu.add(this.separator1);
        this.magpieBookmarks = this.createMagpieMenu("MAGPIE Bookmarks", this.magpieBookmarks);
        this.magpieBookmarks.setEnabled(true);
        this.magpieBookmarks.setToolTipText("Bookmarks from MAGPIE");
        this.menu.add(this.magpieBookmarks);
        this.separator2 = new JSeparator();
        this.menu.add(this.separator2);
        return this.menu;
    }

    public JMenu getMenu2() {
        if (Debug.DEBUG) {
            System.err.println("BookmarksMenuManager.getMenu2()");
        }
        this.menu2 = this.loggedIn ? this.createMenu2() : this.createMagpieMenu("Bookmarks", this.menu2);
        return this.menu2;
    }

    private JMenu createMenu2() {
        if (Debug.DEBUG) {
            System.err.println("BookmarksMenuManager.createMenu2()");
        }
        JMenu jMenu = new JMenu("Bookmarks");
        this.xbelBM.setURLLoader(this.urlLoader);
        this.add2 = new JMenuItem("Add Bookmark");
        this.add2.setActionCommand("Add");
        this.add2.addActionListener(this);
        this.add2.setEnabled(true);
        this.add2.setToolTipText("Bookmark a remote or local file");
        jMenu.add(this.add2);
        this.manage2 = new JMenuItem("Manage Bookmarks...");
        this.manage2.setEnabled(true);
        this.manage2.addActionListener(this);
        this.manage2.setActionCommand("Manage");
        this.manage2.setToolTipText("Organize your bookmarks");
        jMenu.add(this.manage2);
        jMenu.add(new JSeparator());
        jMenu.add(this.createMagpieMenu("MAGPIE Bookmarks", new JMenu()));
        jMenu.add(new JSeparator());
        try {
            jMenu = this.xbelBM.readFile(this.getStringBookmarksXMLFormat(), jMenu);
        }
        catch (SAXException sAXException) {
            System.err.println("Sax Exception in bookmarksmenumanager:createmenu2");
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            System.err.println("IO Exception in bookmarksmenumanager:createmenu2");
            iOException.printStackTrace();
        }
        return jMenu;
    }

    private JMenu createMagpieMenu(String string, JMenu jMenu) {
        if (Debug.DEBUG) {
            System.err.println("BookmarksMenuManager.createMagpieMenu(string, jmenu)");
        }
        if (jMenu != null) {
            jMenu.removeAll();
        } else {
            jMenu = new JMenu(string);
        }
        jMenu.setText(string);
        try {
            this.bookmarksfile = this.getClass().getClassLoader().getResource("docs/bookmarks.xml");
            this.xbelBM.readFile(this.bookmarksfile, jMenu);
            this.xbelBM.setURLLoader(this.urlLoader);
        }
        catch (SAXException sAXException) {
            System.out.println(sAXException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        return jMenu;
    }

    private JPanel createBookmarksPane() {
        if (Debug.DEBUG) {
            System.err.println("BookmarksMenuManager.createBookmarksPane()");
        }
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.setPreferredSize(new Dimension(270, 200));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add(new JLabel("Bookmarks"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 4;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        jPanel.add(new JLabel(""));
        this.bookmarkInfoBox = new JTextArea(10, 20);
        this.bookmarkInfoBox.setEditable(false);
        this.bookmarkInfoBox.setLineWrap(true);
        JScrollPane jScrollPane2 = new JScrollPane(this.bookmarkInfoBox);
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jScrollPane2, gridBagConstraints);
        this.addButton = new JButton("Add Folder");
        this.addButton.addActionListener(this);
        this.addButton.setActionCommand("Add Folder Button");
        this.addButton.setEnabled(false);
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.addButton, gridBagConstraints);
        this.removeButton = new JButton("Remove");
        this.removeButton.addActionListener(this);
        this.removeButton.setActionCommand("Remove Button");
        this.removeButton.setEnabled(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this.removeButton, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JLabel jLabel = new JLabel("");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.statusLabel = new JLabel("");
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.statusLabel, gridBagConstraints);
        return jPanel;
    }

    private void createTree() {
        if (Debug.DEBUG) {
            System.err.println("BookmarksMenuManager.createTree()");
        }
        BookmarkInfo bookmarkInfo = new BookmarkInfo("Bookmarks");
        this.root = new BookmarkNode(bookmarkInfo);
        this.removeNonBookmarks(this.menu);
        this.createNodes(this.root, this.menu);
        this.addNonBookmarks(this.menu);
        this.treeModel = new DefaultTreeModel(this.root);
        this.treeModel.addTreeModelListener(new BluejayTreeModelListener());
        this.tree = new DnDJTree(this.treeModel, this.main_frame);
        this.tree.addTreeSelectionListener(this);
        this.tree.setEditable(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(true);
        this.tree.addTreeSelectionListener(this);
    }

    private void createNodes(DefaultMutableTreeNode defaultMutableTreeNode, JMenuItem jMenuItem) {
        if (Debug.DEBUG) {
            System.err.println("BookmarksMenuManager.createNodes(defaultmutabletreenode, jmenuitem");
        }
        for (int i = 0; i < ((JMenu)jMenuItem).getItemCount(); ++i) {
            Component component = ((JMenu)jMenuItem).getMenuComponent(i);
            if (component instanceof JSeparator) continue;
            String string = ((JMenuItem)component).getText();
            String string2 = this.xbelBM.getURL(string);
            if (component instanceof JMenu) {
                BookmarkInfo bookmarkInfo = new BookmarkInfo(string);
                BookmarkNode bookmarkNode = new BookmarkNode(bookmarkInfo);
                this.createNodes(bookmarkNode, (JMenuItem)component);
                defaultMutableTreeNode.add(bookmarkNode);
                continue;
            }
            if (!(component instanceof JMenuItem)) continue;
            this.addItem(defaultMutableTreeNode, string, string2);
        }
    }

    private void createXbelDOM() {
        if (Debug.DEBUG) {
            System.err.println("BookmarksMenuManager.createXbelDOM()");
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.doc = documentBuilder.newDocument();
            Element element = this.doc.createElement("xbel");
            Attr attr = this.doc.createAttribute("xmlns:html");
            attr.setValue("http://www.w3.org/1999/xhtml");
            Attr attr2 = this.doc.createAttribute("version");
            attr2.setValue("1.0");
            Attr attr3 = this.doc.createAttribute("xml:lang");
            attr3.setValue("en");
            element.setAttributeNode(attr);
            element.setAttributeNode(attr2);
            element.setAttributeNode(attr3);
            for (int i = 0; i < this.root.getChildCount(); ++i) {
                this.addToDOM((BookmarkNode)this.root.getChildAt(i), this.doc, element);
            }
            this.doc.appendChild(element);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (Exception exception) {
            System.err.println("Strange Exception in BookmarksMenuManager.createXbelDOM()");
            exception.printStackTrace();
        }
    }

    private void addToDOM(BookmarkNode bookmarkNode, Document document, Element element) {
        if (Debug.DEBUG) {
            System.err.println("BookmarksMenuManager.addToDOM(bookmarknode, document, element)");
        }
        if (!bookmarkNode.isLeaf()) {
            Element element2 = document.createElement("folder");
            Element element3 = document.createElement("title");
            element3.appendChild(document.createTextNode(bookmarkNode.getDescription()));
            element2.appendChild(element3);
            element.appendChild(element2);
            for (int i = 0; i < bookmarkNode.getChildCount(); ++i) {
                BookmarkNode bookmarkNode2 = (BookmarkNode)bookmarkNode.getChildAt(i);
                this.addToDOM(bookmarkNode2, document, element2);
            }
        } else {
            Element element4 = document.createElement("bookmark");
            Attr attr = document.createAttribute("href");
            Element element5 = document.createElement("title");
            element5.appendChild(document.createTextNode(bookmarkNode.getDescription()));
            attr.setValue(bookmarkNode.getURL());
            element4.setAttributeNode(attr);
            element4.appendChild(element5);
            element.appendChild(element4);
        }
    }

    private void removeCurrentNode() {
        BookmarkNode bookmarkNode;
        BookmarkNode bookmarkNode2;
        TreePath treePath;
        if (Debug.DEBUG) {
            System.err.println("BookmarksMenuManager.removeCurrentNode()");
        }
        if ((treePath = this.tree.getSelectionPath()) != null && (bookmarkNode2 = (BookmarkNode)(bookmarkNode = (BookmarkNode)treePath.getLastPathComponent()).getParent()) != null) {
            this.treeModel.removeNodeFromParent(bookmarkNode);
            return;
        }
    }

    public BookmarkNode addObject(BookmarkInfo bookmarkInfo) {
        if (Debug.DEBUG) {
            System.err.println("BookmarksMenuManager.addObject(bookmarkinfo)");
        }
        BookmarkNode bookmarkNode = null;
        TreePath treePath = this.tree.getSelectionPath();
        bookmarkNode = treePath == null ? this.root : (BookmarkNode)treePath.getLastPathComponent();
        return this.addObject(bookmarkNode, bookmarkInfo, true);
    }

    public BookmarkNode addObject(BookmarkNode bookmarkNode, BookmarkInfo bookmarkInfo, boolean bl) {
        if (Debug.DEBUG) {
            System.err.println("BookmarksMenuManager.addObject(bookmarknode, bookmarkinfo, boolean)");
        }
        BookmarkNode bookmarkNode2 = new BookmarkNode(bookmarkInfo);
        this.treeModel.insertNodeInto(bookmarkNode2, bookmarkNode, bookmarkNode.getChildCount());
        if (bl) {
            this.tree.scrollPathToVisible(new TreePath(bookmarkNode2.getPath()));
        }
        return bookmarkNode2;
    }

    public void addObject() {
        if (Debug.DEBUG) {
            System.err.println("BookmarksMenuManager.addObject()");
        }
        String string = this.main_frame.getTitle();
        String string2 = string.substring(string.indexOf("/") + 1).trim();
        String string3 = this.tf.getItemAt(0).toString();
        if (string2.trim().equals("")) {
            string2 = new String(string3);
        }
        BookmarkInfo bookmarkInfo = new BookmarkInfo(string2, string3);
        this.addObject(this.root, bookmarkInfo, true);
        this.xbelBM.addBookmark(this.menu, string2, string3);
    }

    private void addItem(DefaultMutableTreeNode defaultMutableTreeNode, String string, String string2) {
        if (Debug.DEBUG) {
            System.err.println("BookmarksMenuManager.addItem(defaultmutabletreenode, string, string)");
        }
        BookmarkInfo bookmarkInfo = new BookmarkInfo(string, string2);
        BookmarkNode bookmarkNode = new BookmarkNode(bookmarkInfo);
        defaultMutableTreeNode.add(bookmarkNode);
    }

    public String getStringBookmarksXMLFormat() {
        if (Debug.DEBUG) {
            System.err.println("BookmarksMenuManager.getStringBookmarksXMLFormat()");
        }
        if (this.loggedIn) {
            if (this.menu.getItemCount() >= 1) {
                this.removeNonBookmarks(this.menu);
            }
            this.createXbelDOM();
            String string = null;
            try {
                XMLSerializer xMLSerializer = new XMLSerializer();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                XMLSerializer.save(this.doc, dataOutputStream, null);
                string = byteArrayOutputStream.toString();
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println("BookmarksMenuManager: Exception in ByteArrayOutputStream. I/O Exception");
            }
            catch (NullPointerException nullPointerException) {
                System.err.println("BookmarksMenuManager: Null Pointer Exception in getStringBookmarksXMLFormat -no bookmarks to save");
            }
            catch (Exception exception) {
                System.err.println("BookmarksMenuManager: Exception in XMLSerializer. Can't write to the specified output stream.");
                exception.printStackTrace();
            }
            this.addNonBookmarks(this.menu);
            return string;
        }
        return "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"yes\"?>\n<!DOCTYPE xbel SYSTEM \"http://www.bioxml.info/dtd/xbel-1.0.dtd\">\n<xbel version=\"1.0\" xml:lang=\"en\" xmlns:html=\"http://www.w3.org/1999/xhtml\"></xbel>";
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (Debug.DEBUG) {
            System.err.println("BookmarksMenuManager.valueChanged(treeselectionevent)");
        }
        if ((defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent()) == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (defaultMutableTreeNode.isLeaf()) {
            this.removeButton.setEnabled(true);
            this.addButton.setEnabled(false);
            this.bookmarkInfoBox.setText("Title: \n" + ((BookmarkNode)defaultMutableTreeNode).getDescription() + "\n\nURL: \n" + ((BookmarkNode)defaultMutableTreeNode).getURL());
        } else {
            this.addButton.setEnabled(true);
            this.removeButton.setEnabled(true);
            this.statusLabel.setText("");
            this.bookmarkInfoBox.setText("");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (Debug.DEBUG) {
            System.err.println("BookmarksMenuManager.actionPerformed(actionevent)");
        }
        if (actionEvent.getActionCommand().equals("Add")) {
            System.err.println("Adding bookmark");
            this.addObject();
        } else if (actionEvent.getActionCommand().equals("Manage")) {
            System.err.println("Managing Bookmarks");
            this.bookmarks = this.createBookmarksPane();
            Object[] objectArray = new String[]{"OK", "Cancel"};
            BookmarkNode bookmarkNode = (BookmarkNode)this.root.clone();
            int n = JOptionPane.showOptionDialog(this.main_frame, this.bookmarks, "Manage Bookmarks", 2, -1, null, objectArray, null);
            if (n == 0) {
                this.menu.removeAll();
                try {
                    this.xbelBM.readFile(this.getStringBookmarksXMLFormat(), this.menu);
                    this.addNonBookmarks(this.menu);
                }
                catch (SAXException sAXException) {
                    System.err.println("SAX Exception in BookmarksMenuManager:actionPerformed");
                }
                catch (IOException iOException) {
                    System.err.println("I/O Exception in BookmarksMenuManager: actionPerformed");
                }
            } else {
                this.root = bookmarkNode;
                this.treeModel = new DefaultTreeModel(this.root);
                this.treeModel.addTreeModelListener(new BluejayTreeModelListener());
                this.tree = new DnDJTree(this.treeModel, this.main_frame);
                this.tree.addTreeSelectionListener(this);
                this.tree.setEditable(true);
                this.tree.getSelectionModel().setSelectionMode(1);
                this.tree.setShowsRootHandles(true);
                this.tree.addTreeSelectionListener(this);
            }
        } else if (actionEvent.getActionCommand().equals("Add Folder Button")) {
            BookmarkInfo bookmarkInfo = new BookmarkInfo("New Folder");
            this.addObject(bookmarkInfo);
        } else if (actionEvent.getActionCommand().equals("Remove Button")) {
            this.removeCurrentNode();
        } else {
            System.err.println("BookmarksMenuManager.actionPerformed:else:Messed up");
        }
    }

    private void removeNonBookmarks(JMenu jMenu) {
        if (Debug.DEBUG) {
            System.err.println("BookmarksMenuManager.removeNonBookmarks(jmenu)");
        }
        jMenu.remove(this.add);
        jMenu.remove(this.manage);
        jMenu.remove(this.separator1);
        jMenu.remove(this.magpieBookmarks);
        jMenu.add(this.separator2);
    }

    private void addNonBookmarks(JMenu jMenu) {
        if (Debug.DEBUG) {
            System.err.println("BookmarksMenuManager.addNonBookmarks(jmenu)");
        }
        jMenu.add((Component)this.add, 0);
        jMenu.add((Component)this.manage, 1);
        jMenu.add((Component)this.separator1, 2);
        jMenu.add((Component)this.magpieBookmarks, 3);
        jMenu.add((Component)this.separator2, 4);
    }

    public void loadBookmarks(String string) {
        if (Debug.DEBUG) {
            System.err.println("BookmarksMenuManager.loadBookmarks(string)");
        }
        try {
            this.menu.removeAll();
            this.menu = this.createMenu();
            this.menu = this.xbelBM.readFile(string, this.menu);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.createTree();
    }

    public void setLoggedIn(boolean bl) {
        if (Debug.DEBUG) {
            System.err.println("BookmarksMenuManager.setLoggedIn(boolean)");
        }
        this.loggedIn = bl;
        this.menu = this.getMenu();
    }

    public void setURLLoader(BluejayURLLoader bluejayURLLoader) {
        if (Debug.DEBUG) {
            System.err.println("BookmarksMenuManager.setURLLoader(bluejayurlloader)");
        }
        this.urlLoader = bluejayURLLoader;
    }

    public void setMainFrame(JFrame jFrame) {
        if (Debug.DEBUG) {
            System.err.println("BookmarksMenuManager.setMainFrame(Jframe)");
        }
        this.main_frame = jFrame;
    }

    public void setTF(JComboBox jComboBox) {
        if (Debug.DEBUG) {
            System.err.println("BookmarksMenuManager.setTF(jcombobox)");
        }
        this.tf = jComboBox;
    }

    public Hashtable getBookmarkHashTable() {
        return this.xbelBM.getBookmarkHashTable();
    }

    public XbelBookmarksGUI getXbelBM() {
        return this.xbelBM;
    }

    public void setXbelBMGUI(XbelBookmarksGUI xbelBookmarksGUI) {
        this.xbelBM = xbelBookmarksGUI;
    }
}

