/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.menu;

import ca.ucalgary.bluejay.client.impl.BluejayURLLoader;
import ca.ucalgary.bluejay.gui.ToolbarWidgets;
import ca.ucalgary.bluejay.gui.menu.BluejayMenuManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public class HistoryMenuManager
implements BluejayMenuManager,
ActionListener {
    private JMenu m;
    private JMenuItem back;
    private JMenuItem forward;
    private int menuListCapacity = 10;
    private JMenuItem[] URLList = new JMenuItem[this.menuListCapacity];
    private ToolbarWidgets tbw;
    private JComboBox list;
    private BluejayURLLoader bl;
    private JSeparator s;
    private static int pos = 0;

    public JMenu createMenu() {
        this.m = new JMenu("History");
        this.m.setMnemonic(72);
        this.back = new JMenuItem("Back");
        this.back.setMnemonic(66);
        this.back.setAccelerator(KeyStroke.getKeyStroke("alt KP_LEFT"));
        this.back.addActionListener(this);
        this.back.setActionCommand("back");
        this.back.setEnabled(false);
        this.m.add(this.back);
        this.forward = new JMenuItem("Forward");
        this.forward.setMnemonic(70);
        this.forward.setAccelerator(KeyStroke.getKeyStroke("alt KP_RIGHT"));
        this.forward.setActionCommand("forward");
        this.forward.addActionListener(this);
        this.forward.setEnabled(false);
        this.m.add(this.forward);
        this.s = new JSeparator();
        this.s.setVisible(false);
        this.m.add(this.s);
        for (int i = this.menuListCapacity - 1; i >= 0; --i) {
            this.URLList[i] = new JMenuItem();
            this.URLList[i].setActionCommand("URLVisited");
            this.URLList[i].addActionListener(this);
            this.URLList[i].setVisible(false);
            this.m.add(this.URLList[i]);
        }
        return this.m;
    }

    public JMenuItem getBack() {
        return this.back;
    }

    public JMenuItem getForward() {
        return this.forward;
    }

    public void setToolbarWidgets(ToolbarWidgets toolbarWidgets) {
        this.tbw = toolbarWidgets;
    }

    public void setHistoryList(JComboBox jComboBox) {
        this.list = jComboBox;
    }

    public void setURLLoader(BluejayURLLoader bluejayURLLoader) {
        this.bl = bluejayURLLoader;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("back") || actionEvent.getActionCommand().equals("forward")) {
            this.tbw.actionPerformed(actionEvent);
        } else {
            try {
                URL uRL = new URL(actionEvent.getActionCommand());
                this.bl.gotoURL(uRL, false);
                this.bl.addComboBoxItem(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println(malformedURLException.getMessage());
            }
        }
    }

    public void addURLtoHisMenu(String string) {
        this.s.setVisible(true);
        if (pos > this.menuListCapacity - 1) {
            for (int i = 0; i < this.menuListCapacity - 1; ++i) {
                this.URLList[i].setText(this.URLList[i + 1].getText());
                this.URLList[i].setActionCommand(this.URLList[i + 1].getActionCommand());
            }
            this.URLList[this.menuListCapacity - 1].setText(string);
            this.URLList[this.menuListCapacity - 1].setActionCommand(string);
            this.m.repaint();
        } else {
            this.URLList[pos].setText(string);
            this.URLList[pos].setActionCommand(string);
            this.URLList[pos].setVisible(true);
            ++pos;
        }
    }
}

