/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.menu;

import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.menu.TableTransferHandler;
import ca.ucalgary.bluejay.gui.painter.AGAVEPainter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class LaneLayoutPanel
extends JPanel {
    private static JFrame frame;
    private static BluejayDObjectList dlist;
    private static final String okString = "OK";
    private static final String cancelString = "Cancel";
    private DefaultTableModel laneTable;

    public LaneLayoutPanel(BluejayDObjectList bluejayDObjectList) {
        super(new BorderLayout());
        dlist = bluejayDObjectList;
        JButton jButton = new JButton(okString);
        OKListener oKListener = new OKListener(jButton);
        jButton.setActionCommand(okString);
        jButton.addActionListener(oKListener);
        jButton.setEnabled(true);
        JButton jButton2 = new JButton(cancelString);
        jButton2.setActionCommand(cancelString);
        jButton2.addActionListener(new CancelListener());
        Dimension dimension = new Dimension(120, 30);
        jButton.setPreferredSize(dimension);
        jButton2.setPreferredSize(dimension);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.createTable(), "Center");
        this.add((Component)jPanel, "Last");
    }

    private JPanel createTable() {
        Object object;
        Object object2;
        Object object32;
        this.laneTable = new DefaultTableModel();
        AGAVEPainter aGAVEPainter = AGAVEPainter.getInstance();
        SortedMap sortedMap = aGAVEPainter.getLaneMap();
        int n = dlist.getAbstractLinearGraphics().getLOD();
        this.laneTable.addColumn("Lane number");
        this.laneTable.addColumn("Lane name");
        this.laneTable.addColumn("Width");
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        for (Object object32 : sortedMap.keySet()) {
            object2 = AGAVEPainter.getLane(n, (String)object32);
            treeMap.put(new Integer(object2[0]), object32);
        }
        int n2 = 0;
        while (treeMap.size() > 0) {
            object32 = (Integer)treeMap.lastKey();
            object2 = (String)treeMap.get(object32);
            treeMap.remove(object32);
            object = AGAVEPainter.getLane(n, (String)object2);
            if (object[1] <= 1) continue;
            this.laneTable.addRow(new String[]{"" + ++n2, object2, "" + (int)object[1]});
        }
        object32 = new JTable(this.laneTable);
        ((JTable)object32).getTableHeader().setReorderingAllowed(false);
        ((JTable)object32).setSelectionMode(1);
        object2 = new JScrollPane((Component)object32);
        ((JComponent)object2).setPreferredSize(new Dimension(400, 400));
        ((JTable)object32).setDragEnabled(true);
        ((JComponent)object32).setTransferHandler(new TableTransferHandler());
        object = new JPanel(new BorderLayout());
        object.add((Component)object2, "Center");
        object.setBorder(BorderFactory.createTitledBorder("Lanes"));
        return object;
    }

    public static void createAndShowGUI(BluejayDObjectList bluejayDObjectList) {
        frame = new JFrame("Lane Layout");
        LaneLayoutPanel laneLayoutPanel = new LaneLayoutPanel(bluejayDObjectList);
        laneLayoutPanel.setOpaque(true);
        frame.setContentPane(laneLayoutPanel);
        frame.pack();
        frame.setVisible(true);
    }

    class OKListener
    implements ActionListener {
        private boolean alreadyEnabled = false;
        private JButton button;

        public OKListener(JButton jButton) {
            this.button = jButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            int n;
            AGAVEPainter aGAVEPainter = AGAVEPainter.getInstance();
            SortedMap sortedMap = aGAVEPainter.getLaneMap();
            int n2 = dlist.getAbstractLinearGraphics().getLOD();
            int n3 = 0;
            int n4 = LaneLayoutPanel.this.laneTable.getRowCount();
            for (n = 0; n < n4; ++n) {
                string = (String)LaneLayoutPanel.this.laneTable.getValueAt(n, 1);
                if (!string.equals("Backbone lane")) continue;
                n3 = n;
                break;
            }
            for (n = 0; n < n4; ++n) {
                string = (String)LaneLayoutPanel.this.laneTable.getValueAt(n, 1);
                String string2 = (String)LaneLayoutPanel.this.laneTable.getValueAt(n, 2);
                int n5 = 1;
                try {
                    n5 = Integer.valueOf(string2.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                int n6 = 1 + (n3 - n) * 10;
                sortedMap.put(string, new int[]{n6, n5});
            }
            n = 1;
            frame.setVisible(false);
            dlist.getLegendManager().buildLegendItemsPublic();
            dlist.repaint(n != 0);
        }
    }

    class CancelListener
    implements ActionListener {
        CancelListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            frame.setVisible(false);
        }
    }
}

