/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.menu;

import ca.ucalgary.bluejay.client.ParseTask;
import ca.ucalgary.bluejay.client.impl.BluejayURLLoader;
import ca.ucalgary.bluejay.gui.menu.BluejayMenuManager;
import ca.ucalgary.bluejay.gui.session.InvestigationCreator;
import ca.ucalgary.bluejay.gui.session.LoadCurrentInvestigation;
import ca.ucalgary.bluejay.gui.session.SessionLogin;
import ca.ucalgary.bluejay.gui.session.SessionSettings;
import ca.ucalgary.bluejay.gui.util.CodeBase;
import ca.ucalgary.bluejay.gui.util.Debug;
import ca.ucalgary.bluejay.session.History;
import ca.ucalgary.bluejay.session.SessionManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class SessionMenuManager
implements BluejayMenuManager,
ActionListener {
    private final String WORK_ONLINE = "Work Online";
    private final String WORK_OFFLINE = "Work Offline";
    private static boolean haveConnection;
    private static boolean isAnApplet;
    private static SessionLogin sessionLogin;
    private static SessionSettings sessionSettings;
    private static JFrame main_frame;
    private static ca.ucalgary.bluejay.gui.util.History localHistory;
    private static SessionManager sessionManager;
    private static History sessionHistory;
    private static InvestigationCreator makeInvestigation;
    private static LoadCurrentInvestigation loadInvestigation;
    private static URL actualURLName;
    private static JComboBox tf;
    private static BluejayURLLoader urlLoader;
    private static JButton back;
    private static JButton forward;
    private static ParseTask task;
    private static CodeBase codeBase;
    private static JMenuItem logIn;
    private static JMenuItem logOut;
    private static JMenuItem settings;
    private static JMenuItem workOffline;
    private static JMenu menu;
    private static boolean usingXLinkFilter;
    private static boolean haveStartupPage;

    public SessionMenuManager() {
        logIn = new JMenuItem("Login");
        logIn.setMnemonic(76);
        logOut = new JMenuItem("Logout");
        logOut.setMnemonic(76);
        settings = new JMenuItem("Settings");
        settings.setMnemonic(83);
        workOffline = new JMenuItem("Work Offline");
        workOffline.setMnemonic(87);
    }

    public JMenu createMenu() {
        JMenu jMenu = new JMenu("Session");
        jMenu.setMnemonic(83);
        jMenu.setEnabled(true);
        menu = jMenu;
        return jMenu;
    }

    public void createSessionMenu(JMenu jMenu) {
        logIn.setEnabled(false);
        if (haveConnection && haveConnection) {
            logIn.setEnabled(true);
            logIn.addActionListener(this);
            logIn.setActionCommand("User Login");
        }
        jMenu.add(logIn);
        logOut.addActionListener(this);
        logOut.setActionCommand("Logout");
        logOut.setEnabled(true);
        JMenuItem jMenuItem = new JMenuItem("New");
        jMenuItem.setEnabled(false);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Create Investigation");
        jMenuItem = new JMenuItem("Resume...");
        jMenuItem.setEnabled(false);
        jMenuItem = new JMenuItem("Destroy...");
        jMenuItem.setEnabled(false);
        settings.setEnabled(false);
        settings.addActionListener(this);
        settings.setActionCommand("Session Settings");
        jMenu.add(settings);
        workOffline.setEnabled(true);
        workOffline.addActionListener(this);
        workOffline.setActionCommand("Work Offline");
        jMenu.add(workOffline);
        menu = jMenu;
    }

    public void updateSessionMenu(JMenuItem jMenuItem, JMenu jMenu) {
        jMenu.add(jMenuItem);
        menu = jMenu;
    }

    public void setSessionMenuEnabled(boolean bl) {
        logIn.setEnabled(bl);
        settings.setEnabled(bl);
    }

    public void setHaveConnection(boolean bl) {
        haveConnection = bl;
    }

    public void setIsAnApplet(boolean bl) {
        isAnApplet = bl;
    }

    public void setMainFrame(JFrame jFrame) {
        main_frame = jFrame;
    }

    public void setLocalHistory(ca.ucalgary.bluejay.gui.util.History history) {
        localHistory = history;
    }

    public void setSessionHistory(History history) {
        sessionHistory = history;
    }

    public void setSessionManager(SessionManager sessionManager) {
        SessionMenuManager.sessionManager = sessionManager;
    }

    public void setLoadCurrentInvestigation(LoadCurrentInvestigation loadCurrentInvestigation) {
        loadInvestigation = loadCurrentInvestigation;
    }

    public void setActualURLName(URL uRL) {
        actualURLName = uRL;
    }

    public void setTF(JComboBox jComboBox) {
        tf = jComboBox;
    }

    public void setURLLoader(BluejayURLLoader bluejayURLLoader) {
        urlLoader = bluejayURLLoader;
    }

    public void setBack(JButton jButton) {
        back = jButton;
    }

    public void setForward(JButton jButton) {
        forward = jButton;
    }

    public void setTask(ParseTask parseTask) {
        task = parseTask;
    }

    public void setCodeBase(CodeBase codeBase) {
        SessionMenuManager.codeBase = codeBase;
    }

    public void setUsingXLinkFilter(boolean bl) {
        usingXLinkFilter = bl;
    }

    public void setHaveStartupPage(boolean bl) {
        haveStartupPage = bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (Debug.DEBUG) {
            System.out.println("action performed " + actionEvent.getSource().toString());
        }
        if (actionEvent.getActionCommand().equals("User Login")) {
            this.setSessionLoginVariables();
            sessionLogin.runLogin(main_frame, isAnApplet);
        } else if (actionEvent.getActionCommand().equals("Create Investigation")) {
            makeInvestigation.createInvestigation(new JFrame());
        } else if (actionEvent.getActionCommand().equals("Session Settings")) {
            System.err.println("MT: Request for User Settings");
            this.setSessionSettingsVariables();
            sessionSettings.runSettings(main_frame, isAnApplet);
        } else if (actionEvent.getActionCommand().equals("Logout")) {
            System.err.println("Logging out");
            sessionManager.saveUserInfo();
            urlLoader.leavingPage();
            sessionManager.logout();
            settings.setEnabled(false);
            menu.insert(logIn, 0);
            menu.remove(logOut);
        } else if (actionEvent.getActionCommand().equals("Work Offline")) {
            if (workOffline.getText().equals("Work Offline")) {
                sessionManager.workOffline(true);
                workOffline.setText("Work Online");
            } else if (workOffline.getText().equals("Work Online")) {
                sessionManager.workOffline(false);
                workOffline.setText("Work Offline");
            }
        }
    }

    public void setSessionLoginVariables() {
        sessionLogin.setBack(back);
        sessionLogin.setCodeBase(codeBase);
        sessionLogin.setForward(forward);
        sessionLogin.setHaveConnection(haveConnection);
        sessionLogin.setHaveStartupPage(haveStartupPage);
        sessionLogin.setLoadCurrentInvestigation(loadInvestigation);
        sessionLogin.setLocalHistory(localHistory);
        sessionLogin.setMainFrame(main_frame);
        sessionLogin.setSessionHistory(sessionHistory);
        sessionLogin.setSessionManager(sessionManager);
        sessionLogin.setTF(tf);
        sessionLogin.setTask(task);
        sessionLogin.setURLLoader(urlLoader);
        sessionLogin.setUsingXLinkFilter(usingXLinkFilter);
        sessionLogin.settActualURLName(actualURLName);
        sessionLogin.setSessionMenuManager(this);
    }

    public void setSessionSettingsVariables() {
        sessionSettings.setSessionManager(sessionManager);
    }

    public void setMakeInvestigationVariables() {
        makeInvestigation.setBack(back);
        makeInvestigation.setHaveConnection(haveConnection);
        makeInvestigation.setHaveStartupPage(haveStartupPage);
        makeInvestigation.setLocalHistory(localHistory);
        makeInvestigation.setSessionHistory(sessionHistory);
        makeInvestigation.setSessionManager(sessionManager);
        makeInvestigation.setTF(tf);
        makeInvestigation.setTask(task);
        makeInvestigation.setURLLoader(urlLoader);
        makeInvestigation.settActualURLName(actualURLName);
        makeInvestigation.setUsingXLinkFilter(usingXLinkFilter);
        makeInvestigation.setLoadCurrentInvestigation(loadInvestigation);
    }

    public void setLogoffMenu(JMenu jMenu) {
        jMenu.insert(logOut, 0);
        jMenu.remove(logIn);
        menu = jMenu;
    }

    static {
        sessionLogin = new SessionLogin();
        sessionSettings = new SessionSettings();
    }
}

