/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.microarray;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.Legend;
import ca.ucalgary.bluejay.gui.LegendItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.tigr.microarray.mev.MultipleArrayViewer;

public class CustomClusterGenerator
extends JFrame
implements Action {
    private DefaultListModel clusterList = new DefaultListModel();
    private BluejayDObjectList dlist = null;
    private MultipleArrayViewer arrayViewer = null;
    private boolean actionEnabled;
    private Map actionMap;
    private boolean disposed;
    private static int[] geneLoc;
    private JButton btnAdd;
    private JButton btnClear;
    private JButton btnDisplayPage;
    private JButton btnRemove;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JList lstCluster;
    private JTextField txtNewGene;

    public CustomClusterGenerator(BluejayDObjectList bluejayDObjectList, MultipleArrayViewer multipleArrayViewer) {
        this.dlist = bluejayDObjectList;
        this.arrayViewer = multipleArrayViewer;
        this.actionEnabled = true;
        this.actionMap = new HashMap();
        this.putValue("command-parameter", "ca.ucalgary.bluejay.gui.microarray.ManualGUI");
        this.initComponents();
        this.disposed = false;
    }

    public void setVisible(boolean bl) {
        if (this.disposed) {
            this.initComponents();
        }
        super.setVisible(bl);
    }

    public int numIDs() {
        return this.clusterList.size();
    }

    public String[] getIDs() {
        Object[] objectArray = this.clusterList.toArray();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        return stringArray;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstCluster = new JList();
        this.btnClear = new JButton();
        this.btnAdd = new JButton();
        this.btnRemove = new JButton();
        this.txtNewGene = new JTextField();
        this.btnDisplayPage = new JButton();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Custom Cluster Generator");
        this.jLabel1.setText("Genes currently in custom cluster:");
        this.lstCluster.setModel(this.clusterList);
        this.jScrollPane1.setViewportView(this.lstCluster);
        this.btnClear.setText("Clear Cluster");
        this.btnClear.setActionCommand("Clear");
        this.btnClear.setName("btnReset");
        this.btnClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomClusterGenerator.this.actionPerformed(actionEvent);
            }
        });
        this.btnAdd.setText("Add");
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomClusterGenerator.this.actionPerformed(actionEvent);
            }
        });
        this.btnRemove.setText("Remove Selected");
        this.btnRemove.setActionCommand("Remove_Selected");
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomClusterGenerator.this.actionPerformed(actionEvent);
            }
        });
        this.txtNewGene.setText("Enter a GeneID");
        this.txtNewGene.setToolTipText("A gene ID or alias in the currently loaded Bluejay document");
        this.txtNewGene.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomClusterGenerator.this.checkForEnterKey(actionEvent);
            }
        });
        this.txtNewGene.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                CustomClusterGenerator.this.txtNewGeneFocusGained(focusEvent);
            }
        });
        this.btnDisplayPage.setText("Create Cluster");
        this.btnDisplayPage.setActionCommand("Create_Cluster");
        this.btnDisplayPage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomClusterGenerator.this.actionPerformed(actionEvent);
            }
        });
        this.jButton1.setText("Import from file...");
        this.jButton1.setToolTipText("A tab delimited gene list, such as generated by TIGR's \"Save Cluster\" function");
        this.jButton1.setActionCommand("import");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomClusterGenerator.this.jButton1ActionPerformed(actionEvent);
            }
        });
        this.jButton2.setText("Checked In Legend");
        this.jButton2.setToolTipText("All genes visible (but not ghosted) in the legend tab (bottom left of main screen)");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomClusterGenerator.this.jButton2ActionPerformed(actionEvent);
            }
        });
        this.jButton3.setText("Text Search Results");
        this.jButton3.setToolTipText("All genes found by the latest text search (text box at bottom of main window)");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomClusterGenerator.this.jButton3ActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(1).add(1, groupLayout.createSequentialGroup().addContainerGap().add(groupLayout.createParallelGroup(1).add(1, groupLayout.createSequentialGroup().add(groupLayout.createParallelGroup(1).add(this.jScrollPane1, -1, 200, Short.MAX_VALUE).add(2, this.txtNewGene, -1, 200, Short.MAX_VALUE)).addPreferredGap(0).add(groupLayout.createParallelGroup(2).add(this.jButton3, -1, 156, Short.MAX_VALUE).add(1, this.jButton2, -2, 154, -2).add(1, this.btnRemove, -1, 156, Short.MAX_VALUE).add(1, this.btnClear, -1, 156, Short.MAX_VALUE).add(this.btnAdd, -1, 156, Short.MAX_VALUE).add(1, this.btnDisplayPage, -1, 156, Short.MAX_VALUE).add(1, this.jButton1, -1, 156, Short.MAX_VALUE))).add(this.jLabel1)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(1).add(1, groupLayout.createSequentialGroup().add(this.jLabel1, -2, 26, -2).addPreferredGap(0).add(groupLayout.createParallelGroup(2, false).add(2, groupLayout.createSequentialGroup().add(this.jButton1).addPreferredGap(0).add(this.jButton2).addPreferredGap(0).add(this.jButton3).addPreferredGap(0, 21, Short.MAX_VALUE).add(this.btnRemove).addPreferredGap(0).add(this.btnClear).addPreferredGap(0).add(this.btnDisplayPage)).add(1, this.jScrollPane1, -2, 201, -2)).add(7, 7, 7).add(groupLayout.createParallelGroup(1, false).add(this.txtNewGene).add(2, this.btnAdd, -1, 26, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void checkForEnterKey(ActionEvent actionEvent) {
        this.addID();
    }

    private void jButton3ActionPerformed(ActionEvent actionEvent) {
        Vector vector;
        if (this.dlist.getSearcher() == null) {
            JOptionPane.showConfirmDialog(this, "I am unaware of any text search function in this software: please contact the developer", "No Text Search Function Available", 0, 0);
        }
        if ((vector = this.dlist.getSearcher().getResults()) == null || vector.size() == 0) {
            JOptionPane.showConfirmDialog(this, "There are currently no text search results.\nPlease perform a search (text box at bottom of main screen), then try again.", "No Text Search Results Available", 0, 2);
            this.dlist.getSearcher().requestFocusInWindow();
            return;
        }
        this.populateClusterListFromTextSearch();
    }

    private void jButton2ActionPerformed(ActionEvent actionEvent) {
        int n = JOptionPane.showConfirmDialog(this, "This will add ALL items checked (but not ghosted) from the legend.\nAre you sure you'd like to do this?", "Cluster List from Legend Groupings", 0, 3);
        if (n != 0) {
            return;
        }
        this.populateClusterListFromLegend();
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showOpenDialog(this);
        if (n != 0) {
            return;
        }
        this.populateClusterListFromFile(jFileChooser.getSelectedFile());
    }

    private void txtNewGeneFocusGained(FocusEvent focusEvent) {
        this.txtNewGene.selectAll();
    }

    public void addID() {
        this.clusterList.addElement(this.txtNewGene.getText().toString());
        this.txtNewGene.setText("");
    }

    public void addID(String string) {
        this.clusterList.addElement(string);
    }

    public void removeID(String string) {
        this.clusterList.removeElement(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Remove_Selected")) {
            int[] nArray = this.lstCluster.getSelectedIndices();
            Arrays.sort(nArray);
            for (int i = 0; i < nArray.length; ++i) {
                this.clusterList.remove(nArray[i] - i);
            }
        } else if (actionEvent.getActionCommand().equals("Clear")) {
            this.clusterList.removeAllElements();
        } else if (actionEvent.getActionCommand().equals("Add")) {
            this.addID();
        } else if (actionEvent.getActionCommand().equals("Create_Cluster")) {
            int n;
            int n2 = this.lstCluster.getModel().getSize();
            String[] stringArray = new String[n2];
            for (n = 0; n < n2; ++n) {
                stringArray[n] = (String)this.lstCluster.getModel().getElementAt(n);
            }
            geneLoc = new int[n2];
            n = 1;
            String string = "N/A";
            boolean bl = false;
            Vector<Integer> vector = new Vector<Integer>();
            TreeMap treeMap = this.arrayViewer.getGBToLocMap();
            for (int i = 0; i < n2; ++i) {
                if (treeMap.containsKey(stringArray[i])) {
                    CustomClusterGenerator.geneLoc[i] = (Integer)this.arrayViewer.getGBToLocMap().get(stringArray[i]);
                    continue;
                }
                AbstractLinearGraphics abstractLinearGraphics = this.dlist.getAbstractLinearGraphics();
                if (abstractLinearGraphics == null) {
                    System.err.println("Warning: No AbstractLinearGraphics instance exists (" + this.getClass().getName() + "), cannot find non-primary IDs");
                    continue;
                }
                TreeMap treeMap2 = abstractLinearGraphics.getGBToXPtrMap();
                if (treeMap2 == null) {
                    System.err.println("Warning: No GB to Gene Map exists (" + this.getClass().getName() + ", cannot find non-primary IDs");
                    continue;
                }
                if (!treeMap2.containsKey(stringArray[i])) {
                    vector.add(new Integer(i));
                    continue;
                }
                String string2 = (String)treeMap2.get(stringArray[i]);
                TreeMap treeMap3 = abstractLinearGraphics.getxPtrToGBMap();
                if (treeMap3 == null) {
                    System.err.println("Warning: No Gene to GB Map exists (" + this.getClass().getName() + ", cannot find corresponding primary ID for XPointer " + string2);
                    continue;
                }
                if (!treeMap3.containsKey(string2)) {
                    vector.add(new Integer(i));
                    continue;
                }
                String string3 = (String)treeMap3.get(string2);
                if (treeMap.containsKey(string3)) {
                    CustomClusterGenerator.geneLoc[i] = (Integer)this.arrayViewer.getGBToLocMap().get(string3);
                    continue;
                }
                vector.add(new Integer(i));
            }
            if (vector.size() == 0) {
                ActionEvent actionEvent2 = new ActionEvent(this, 0, "analysis-command");
                this.arrayViewer.getActionListener().actionPerformed(actionEvent2);
                this.dispose();
            } else if (vector.size() == this.clusterList.size()) {
                JOptionPane.showMessageDialog(null, "None of the specified IDs are found in the loaded sequence data.\nPlease ensure you have the correct data loaded (note: IDs are case sensitive).", "Error", 0);
            } else {
                int[] nArray = new int[vector.size()];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = (Integer)vector.elementAt(i);
                }
                this.lstCluster.setSelectedIndices(nArray);
                JOptionPane.showMessageDialog(null, "" + vector.size() + " gene ID" + (vector.size() == 1 ? " is" : "s are") + " not found in the loaded sequence data.\n" + "Please ensure all geneIDs are correct.\n" + "Note that IDs are " + "case sensitive.\nThe offending ID" + (vector.size() == 1 ? " is" : "s are") + " highlighted and should be deleted.", "Warning", 2);
            }
        }
    }

    public void dispose() {
        this.disposed = true;
        this.setVisible(false);
        super.dispose();
        this.clusterList.clear();
    }

    public static Vector getClusters() {
        Vector<int[]> vector = new Vector<int[]>();
        vector.add(geneLoc);
        return vector;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public Object getValue(String string) {
        return this.actionMap.get(string);
    }

    public boolean isEnabled() {
        return this.actionEnabled;
    }

    public void putValue(String string, Object object) {
        this.actionMap.put(string, object);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void setEnabled(boolean bl) {
        this.actionEnabled = bl;
    }

    private void populateClusterListFromTextSearch() {
        Vector vector = this.dlist.getSearcher().getResults();
        if (vector == null || vector.size() == 0) {
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string;
            DTDElementInstance dTDElementInstance = (DTDElementInstance)enumeration.nextElement();
            if (dTDElementInstance == null || dTDElementInstance.getPainter() == null || (string = dTDElementInstance.getPainter().getPrimaryID(dTDElementInstance)) == null || string.length() == 0 || this.clusterList.contains(string)) continue;
            this.clusterList.addElement(string);
        }
    }

    private void populateClusterListFromLegend() {
        Legend legend = this.dlist.getLegend();
        Object[] objectArray = legend.getLegendItems();
        for (int i = 0; i < objectArray.length; ++i) {
            Vector vector;
            LegendItem legendItem;
            if (!(objectArray[i] instanceof LegendItem) || (legendItem = (LegendItem)objectArray[i]).getVisibleState() == null || !legendItem.getVisibleState().booleanValue() || legendItem.getTotalCount() == 0 || (vector = legendItem.getXPointers()) == null || vector.size() == 0) continue;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string;
                DTDElementInstance dTDElementInstance;
                String string2 = (String)enumeration.nextElement();
                if (string2 == null || (dTDElementInstance = this.dlist.getDTDElementInstance(string2)) == null || dTDElementInstance.getPainter() == null || (string = dTDElementInstance.getPainter().getPrimaryID(dTDElementInstance)) == null || string.length() == 0 || this.clusterList.contains(string)) continue;
                this.clusterList.addElement(string);
            }
        }
    }

    private void populateClusterListFromFile(File file) {
        try {
            LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
            String string = "\\A\\s*(\\S+).*\\Z";
            String string2 = lineNumberReader.readLine();
            if (string2 != null && string2.indexOf("Original row") != -1) {
                string = "\\A\\s*\\d+\\s+(\\S+).*\\Z";
                string2 = lineNumberReader.readLine();
            }
            while (string2 != null) {
                String string3 = string2.replaceFirst(string, "$1");
                if (!(string3 == null || string3.length() == 0 || string3.equals("id") || string3.equals("ID") || string3.equals("GB") || this.clusterList.contains(string3))) {
                    this.clusterList.addElement(string3);
                }
                string2 = lineNumberReader.readLine();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

