/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.microarray;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.microarray.HTMLWriter;
import com.simonstl.sax.xlink.Link;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.CharBuffer;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.tigr.microarray.mev.MultipleArrayViewer;

public class MicroArrayClusterHTMLWriter
implements HTMLWriter {
    private static BluejayDObjectList dlist;
    private static String bufferedBody;
    public static final String LINK_POINTING = "   >   ";
    private static int currNumber;
    private static int numberOfGenesWithoutInformation;
    private static FileWriter outFileWriter;
    private static int colOne;
    private static int colTwo;
    private static int colThree;
    private static int colFour;
    private static int colFive;
    private static String geneID;
    private static URI clusterImageReference;
    private File temp;
    private DecimalFormat ratioFormat;

    public MicroArrayClusterHTMLWriter(String string) {
        geneID = string;
        try {
            this.temp = File.createTempFile("list", ".tmp");
            this.temp.deleteOnExit();
        }
        catch (Exception exception) {
            System.err.println("ERROR: Could not create temporary file: " + exception);
        }
        this.ratioFormat = new DecimalFormat("#,##0.00");
    }

    public void setClusterImage(URI uRI) {
        clusterImageReference = uRI;
    }

    public MicroArrayClusterHTMLWriter() {
        clusterImageReference = null;
        geneID = "Custom Cluster";
        this.ratioFormat = new DecimalFormat("#,##0.00");
    }

    public void moveTemporaryFile(String string, URL uRL) {
        try {
            File file = new File(uRL.getFile());
            File file2 = new File(string);
            this.copy(file, file2);
            this.moveClusterImageFile(string);
            file = null;
            file2 = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void moveClusterImageFile(String string) {
        try {
            File file = new File(clusterImageReference);
            File file2 = new File(string);
            String string2 = file2.getParent();
            File file3 = new File(string2 + File.separator + file.getName());
            this.copy(file, file3);
            this.uncommentImageRef(file2);
            file = null;
            file2 = null;
            file3 = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void uncommentImageRef(File file) throws Exception {
        if (clusterImageReference == null) {
            System.err.println("There was no image reference provided to insert in " + file);
            return;
        }
        CharBuffer charBuffer = CharBuffer.allocate((int)file.length());
        FileReader fileReader = new FileReader(file);
        if (!charBuffer.hasArray()) {
            System.err.println("Sorry, your version of Java doesn't support CharBuffer arrays!");
            return;
        }
        fileReader.read(charBuffer.array());
        File file2 = null;
        file2 = new File(clusterImageReference);
        String string = charBuffer.toString().replaceAll("<!--<img src=\"\">-->", "<img src=\"" + file2.getName() + "\">");
        fileReader.close();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(string.getBytes());
        fileOutputStream.close();
    }

    private void copy(File file, File file2) throws IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[1024];
        while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        ((InputStream)fileInputStream).close();
        ((OutputStream)fileOutputStream).close();
    }

    public URI createHTMLFile() {
        return null;
    }

    public URI createHTMLFile(int[] nArray) {
        MultipleArrayViewer multipleArrayViewer = dlist.getAbstractLinearGraphics().getArrayViewer();
        int n = multipleArrayViewer.getData().getFeaturesCount();
        int n2 = colOne + colTwo + colFour * n + colFive;
        try {
            outFileWriter = new FileWriter(this.temp);
            this.writeHeader(outFileWriter, n, n2, nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                Object object;
                String string = (String)multipleArrayViewer.getLocToGbMap().get(new Integer(nArray[i]));
                String string2 = (String)dlist.getAbstractLinearGraphics().getGBToXPtrMap().get(string);
                if (string2 == null) {
                    object = string.replaceFirst("[_\\.]\\d\\Z", "");
                    string2 = (String)dlist.getAbstractLinearGraphics().getGBToXPtrMap().get(object);
                }
                if (string2 != null) {
                    object = dlist.getDTDElementInstance(string2 = string2.substring(0, string2.lastIndexOf(47)));
                    if (object != null) {
                        String string3 = object.getPainter().getDescription((DTDElementInstance)object);
                        String[] stringArray = object.getPainter().getIDs((DTDElementInstance)object);
                        outFileWriter.write(this.addToBody(string, stringArray, string2, string3));
                        continue;
                    }
                    outFileWriter.write(this.addToBody(string, null, string2, string2));
                    continue;
                }
                outFileWriter.write(this.addToBody(string, null, null, null));
            }
            this.writeFooter(outFileWriter);
            outFileWriter.close();
            currNumber = 0;
            numberOfGenesWithoutInformation = 0;
            return this.temp.toURI();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void writeHeader(FileWriter fileWriter, int n, int n2, int n3) {
        try {
            String string = "<html>\n<head><title>Microarray Expression List - generated by Bluejay</title></head>\n";
            int n4 = dlist.getAbstractLinearGraphics().getArrayViewer().getCurrentSlide();
            String string2 = dlist.getAbstractLinearGraphics().getArrayViewer().getData().getFullSampleName(n4);
            String string3 = dlist.getAbstractLinearGraphics().getArrayViewer().getExperimentName();
            string = string + "<body>";
            string = string + "\n<h2>Microarray Expression List - generated by Bluejay</h2>";
            string = string + "\n<h3>Experiment Name = " + string3 + "</h3>";
            string = string + "\n<h3>Genes (" + n3 + " total) in the same cluster as " + geneID + "</h3>";
            string = string + "\n<!--<img src=\"\">-->";
            string = string + "\n<table border=\"1\" width=\"" + n2 + "\" >";
            string = string + "\n   <tr bordercolor=\"#999999\" bgcolor=\"#E0DFE3\">";
            string = string + "\n     <th width=\"" + colOne + "\">#</th>";
            string = string + "\n     <th width=\"" + colTwo + "\">Gene ID</th>";
            string = string + "\n     <th width=\"" + colTwo + "\">Gene Aliases</th>";
            Map map = dlist.getAbstractLinearGraphics().getArrayViewer().getSlideNames();
            for (int i = 0; i < n; ++i) {
                String string4 = "Ratio";
                if (map != null && map.containsKey(new Integer(i))) {
                    string4 = (String)map.get(new Integer(i));
                }
                string = string + "\n     <th width=\"" + colFour + "\">" + string4 + "</th>";
            }
            string = string + "\n     <th width=\"" + colFive + "\">Description/Links</th>";
            string = string + "\n   </tr>";
            fileWriter.write(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String addToBody(String string, String[] stringArray, String string2, String string3) {
        int n;
        MultipleArrayViewer multipleArrayViewer = dlist.getAbstractLinearGraphics().getArrayViewer();
        if (string2 != null && !dlist.getAnalysisMonitor().isMicroArrayElementPaintable(string2)) {
            ++numberOfGenesWithoutInformation;
            return "";
        }
        int n2 = (Integer)multipleArrayViewer.getGBToLocMap().get(string);
        bufferedBody = "\n   <tr bordercolor=\"#999999\" bgcolor=\"#E0DFE3\">";
        bufferedBody = bufferedBody + "\n     <td width=\"" + colOne + "\">" + ++currNumber + "  </td>";
        bufferedBody = string == null ? bufferedBody + "\n     <td width=\"" + colTwo + "\">&nbsp;</td>" : bufferedBody + "\n     <td width=\"" + colTwo + "\"><a href=\"#" + string2 + "\">" + string + "</a></td>";
        if (stringArray == null || stringArray.length == 0) {
            bufferedBody = bufferedBody + "\n     <td width=\"" + colThree + "\">&nbsp</td>";
        } else {
            bufferedBody = bufferedBody + "\n     <td width=\"" + colThree + "\">";
            Arrays.sort(stringArray);
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n] == null || stringArray[n].equals(string) || stringArray[n].indexOf(string) != -1) continue;
                bufferedBody = bufferedBody + stringArray[n] + "<br>";
            }
            bufferedBody = bufferedBody + "  </td>";
        }
        for (n = 0; n < multipleArrayViewer.getData().getFeaturesCount(); ++n) {
            Color color = multipleArrayViewer.getColorForSlideElement(n2, n);
            String string4 = "#" + Integer.toHexString(color.getRed()) + Integer.toHexString(color.getGreen()) + Integer.toHexString(color.getBlue());
            float f = multipleArrayViewer.getLogRatio(n2, n);
            String string5 = f == Float.NaN ? "N/A" : this.ratioFormat.format(f);
            bufferedBody = bufferedBody + "\n     <td width=\"" + colFour + "\" bgcolor=\"" + string4 + "\"><font color=\"" + string4 + "\"><nobr>" + string5 + "</nobr></font></td>";
        }
        if (string2 != null) {
            this.findXLinks(string2, string3);
        }
        bufferedBody = bufferedBody + "\n   </tr>";
        return bufferedBody;
    }

    private void writeFooter(FileWriter fileWriter) {
        try {
            int n = dlist.getAbstractLinearGraphics().getArrayViewer().getGbToRatioMap().size();
            String string = "</table> \n ";
            string = string + "\n</body>";
            string = string + "\n</html>";
            fileWriter.write(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void findXLinks(String string, String string2) {
        try {
            List list = dlist.getDataManager().getHyperlinks(string);
            if (list.size() == 0) {
                bufferedBody = bufferedBody + "\n     <td width=\"" + colFive + "\">N/A " + string2 + "</td>";
                return;
            }
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                String string3;
                Link link = (Link)list.get(i);
                String string4 = link.getInfo().getLinkTitle();
                String string5 = link.getToNode().getURL().toString();
                String string6 = string3 = "".equals(string4) ? string5 : string4 + LINK_POINTING + string5;
                if ("embed".equals(link.getArc().getShow().toLowerCase())) continue;
                bufferedBody = string2 != null ? bufferedBody + "\n     <td width=\"" + colFive + "\"><a href= \"" + string3 + "\">" + string2 + "</a></td>" : bufferedBody + "\n     <td width=\"" + colFive + "\"><a href= \"" + string3 + "\">" + "Click Here" + "</a></td>";
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setDList(BluejayDObjectList bluejayDObjectList) {
        dlist = bluejayDObjectList;
    }

    static {
        currNumber = 0;
        numberOfGenesWithoutInformation = 0;
        colOne = 25;
        colTwo = 150;
        colThree = 100;
        colFour = 6;
        colFive = 600;
    }
}

