/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.microarray;

import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.microarray.HTMLWriter;
import ca.ucalgary.bluejay.gui.microarray.MicroArrayClusterHTMLWriter;
import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class MicroArrayRatioGUI
extends JFrame
implements HyperlinkListener,
MouseListener,
ActionListener {
    public static final String DEFAULT_STATUS_MSG = "Click a hyperlink to connect to Gene Card information";
    private static BluejayDObjectList dlist;
    private static JEditorPane editorPane;
    private static JLabel status;
    private static JButton saveButton;
    private static JButton closeButton;
    private static JToolBar toolbar;
    private static boolean isClusterFile;
    private static HTMLWriter writer;
    private static URI clusterImageFile;

    public MicroArrayRatioGUI(HTMLWriter hTMLWriter, BluejayDObjectList bluejayDObjectList) {
        this.setTitle("Microarray Ratio List");
        this.setSize(900, 900);
        writer = hTMLWriter;
        this.setDList(bluejayDObjectList);
        this.buildGUIElements();
    }

    private void buildGUIElements() {
        editorPane = new JEditorPane();
        editorPane.setEditable(false);
        editorPane.addMouseListener(this);
        editorPane.addHyperlinkListener(this);
        editorPane.setContentType("text/html");
        JScrollPane jScrollPane = new JScrollPane(editorPane);
        this.getContentPane().add((Component)jScrollPane, "Center");
        toolbar = new JToolBar();
        saveButton = new JButton("Save Values");
        saveButton.setActionCommand("Save");
        saveButton.addActionListener(this);
        toolbar.add(saveButton);
        toolbar.addSeparator();
        closeButton = new JButton("Close");
        closeButton.setActionCommand("Close");
        closeButton.addActionListener(this);
        toolbar.add(closeButton);
        this.getContentPane().add((Component)toolbar, "North");
        status = new JLabel(DEFAULT_STATUS_MSG);
        this.getContentPane().add((Component)status, "South");
        this.setDefaultCloseOperation(1);
    }

    public void displayPage(URI uRI) {
        try {
            editorPane.setPage(uRI.toURL());
            editorPane.scrollToReference("start");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL uRL = hyperlinkEvent.getURL();
            if (uRL == null) {
                status.setText("Failed: could not parse hyperlink: " + hyperlinkEvent.getDescription());
                System.err.println("Failed: could not parse hyperlink: " + hyperlinkEvent.getDescription());
            } else {
                status.setText("Launching Web browser for external link...");
                try {
                    BrowserLauncher.openURL(uRL.toString());
                }
                catch (IOException iOException) {
                    status.setText("Couldn't launch external browser");
                    System.err.println("Couldn't launch external browser for " + uRL + " because of I/O exception: " + iOException);
                }
            }
        }
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            status.setText("Click to find out more");
        }
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
            status.setText(DEFAULT_STATUS_MSG);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Save")) {
            JFileChooser jFileChooser = new JFileChooser();
            int n = jFileChooser.showSaveDialog(null);
            if (n == 0) {
                String string = jFileChooser.getSelectedFile().toString();
                string = string + ".html";
                writer.setDList(dlist);
                writer.moveTemporaryFile(string, editorPane.getPage());
                if (writer instanceof MicroArrayClusterHTMLWriter) {
                    ((MicroArrayClusterHTMLWriter)writer).moveClusterImageFile(string);
                }
                try {
                    URL uRL = new URL("file://" + string);
                    try {
                        BrowserLauncher.openURL(uRL.toString());
                    }
                    catch (IOException iOException) {
                        System.err.println("Cannot make BrowserLauncher to launch url " + uRL + ", " + iOException.getMessage());
                        iOException.printStackTrace();
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            }
        } else if (actionEvent.getActionCommand().equals("Close")) {
            this.dispose();
        }
    }

    public void setDList(BluejayDObjectList bluejayDObjectList) {
        dlist = bluejayDObjectList;
        writer.setDList(dlist);
    }

    static {
        isClusterFile = false;
    }
}

