/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.microarray;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.DataManager;
import ca.ucalgary.bluejay.gui.ExpressionSliderWidget;
import ca.ucalgary.bluejay.gui.Legend;
import ca.ucalgary.bluejay.gui.LegendItem;
import ca.ucalgary.bluejay.gui.menu.MicroArrayMenuManager;
import ca.ucalgary.bluejay.gui.microarray.AnalysisMonitor;
import ca.ucalgary.bluejay.gui.microarray.DistanceSliderWidget;
import ca.ucalgary.bluejay.gui.microarray.player.ExperimentSelectorWidget;
import ca.ucalgary.bluejay.gui.util.ColorGenerator;
import ca.ucalgary.bluejay.gui.util.Debug;
import com.simonstl.sax.xlink.Link;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.apache.batik.gvt.CompositeShapePainter;
import org.apache.batik.gvt.FillShapePainter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ShapeNode;
import org.apache.log4j.Logger;
import org.tigr.microarray.mev.MultipleArrayViewer;

public class MicroarrayFunctions
implements PropertyChangeListener {
    private static final boolean ADD_LEGEND_ITEM = true;
    private static final int NUM_COLORS = 256;
    private BluejayDObjectList dlist;
    private AbstractLinearGraphics alg;
    private DataManager dataManager;
    private MultipleArrayViewer arrayViewer;
    private ExpressionSliderWidget arrayPanel;
    private double highExpressionBoundary = 0.0;
    private double lowExpressionBoundary = 0.0;
    private DistanceSliderWidget distancePanel;
    private ExperimentSelectorWidget experimentSelectorPanel;
    private static AnalysisMonitor analysisMonitor;
    private ColorGenerator clusterColorGenerator;
    private static Hashtable classColorMapping;
    private static Hashtable legendSwatches;
    private static final Color colorNoType;
    private static int numberOfClusters;
    public static final String LINK_POINTING = "   >   ";
    public MicroArrayMenuManager arrayMenu;
    private static Logger logger;
    private int currNumber = 0;

    public MicroarrayFunctions(BluejayDObjectList bluejayDObjectList, AbstractLinearGraphics abstractLinearGraphics, DataManager dataManager) {
        this.dlist = bluejayDObjectList;
        this.alg = abstractLinearGraphics;
        this.dataManager = dataManager;
        this.arrayPanel = new ExpressionSliderWidget();
        this.arrayPanel.addPropertyChangeListener(this);
        this.distancePanel = new DistanceSliderWidget();
        this.distancePanel.addPropertyChangeListener(this);
        this.distancePanel.setALG(this.alg);
        this.distancePanel.setDList(this.dlist);
        this.experimentSelectorPanel = new ExperimentSelectorWidget(this.dlist, this.alg, this);
        analysisMonitor = new AnalysisMonitor();
        analysisMonitor.setALG(this.alg);
        analysisMonitor.setDList(this.dlist);
        analysisMonitor.setMicroArrayFunctions(this);
        this.clusterColorGenerator = new ColorGenerator();
    }

    public void updateLogBoundaries() {
        this.dlist.changeExpressionLanes();
        Object[] objectArray = this.alg.getGBToXPtrMap().values().toArray();
        if (objectArray != null) {
            for (int i = 0; i < this.alg.getGBToXPtrMap().size(); ++i) {
                Vector vector = (Vector)this.dataManager.getXPtrToGVTMap().get(objectArray[i]);
                String string = (String)this.alg.getxPtrToGBMap().get(objectArray[i]);
                Integer n = (Integer)this.arrayViewer.getGBToLocMap().get(string);
                if (n == null) continue;
                float f = this.arrayViewer.getLogRatio(n, this.alg.getArrayViewer().getCurrentSlide());
                if (vector == null) continue;
                int n2 = vector.size();
                for (int j = 0; j < n2; ++j) {
                    GraphicsNode graphicsNode = (GraphicsNode)vector.elementAt(j);
                    if ((double)f < this.highExpressionBoundary && (double)f > this.lowExpressionBoundary) {
                        this.dlist.setVisibilityForNode((String)objectArray[i], 113);
                        continue;
                    }
                    if (graphicsNode.getDataVisibility() == 112) continue;
                    this.dlist.setVisibilityForNode((String)objectArray[i], 112);
                }
            }
            this.dlist.refreshDisplay();
        }
    }

    public void performDistanceAnalysis(float f) {
        this.distancePanel.performDistanceAnalysis(f);
        this.dlist.refreshDisplay();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.arrayPanel && propertyChangeEvent.getPropertyName() == "topSlide") {
            this.highExpressionBoundary = (Double)propertyChangeEvent.getNewValue() / 1000.0;
            this.arrayViewer.setHighExpressionBoundary(this.highExpressionBoundary);
            this.updateLogBoundaries();
        } else if (propertyChangeEvent.getSource() == this.arrayPanel && propertyChangeEvent.getPropertyName() == "bottomSlide") {
            this.lowExpressionBoundary = (Double)propertyChangeEvent.getNewValue() / 1000.0;
            this.arrayViewer.setLowExpressionBoundary(this.lowExpressionBoundary);
            this.updateLogBoundaries();
        } else if (propertyChangeEvent.getSource() == this.arrayPanel && propertyChangeEvent.getPropertyName() == "bothSlides") {
            this.highExpressionBoundary = (Double)propertyChangeEvent.getNewValue() / 1000.0;
            this.lowExpressionBoundary = (Double)propertyChangeEvent.getNewValue() / 1000.0;
            this.arrayViewer.setHighExpressionBoundary(this.highExpressionBoundary);
            this.arrayViewer.setLowExpressionBoundary(this.lowExpressionBoundary);
            this.updateLogBoundaries();
        } else if (propertyChangeEvent.getSource() == this.distancePanel && propertyChangeEvent.getPropertyName() == "distanceSlider") {
            double d = (Double)propertyChangeEvent.getNewValue() / 1000.0;
            this.performDistanceAnalysis(new Float(d).floatValue());
        }
    }

    public void updateColorSchema() {
        Object[] objectArray = this.alg.getGBToXPtrMap().values().toArray();
        if (objectArray != null) {
            for (int i = 0; i < this.alg.getGBToXPtrMap().size(); ++i) {
                Vector vector = (Vector)this.dataManager.getXPtrToGVTMap().get(objectArray[i]);
                String string = (String)this.alg.getxPtrToGBMap().get(objectArray[i]);
                Integer n = (Integer)this.arrayViewer.getGBToLocMap().get(string);
                if (vector == null) continue;
                int n2 = vector.size();
                for (int j = 0; j < n2; ++j) {
                    GraphicsNode graphicsNode = (GraphicsNode)vector.elementAt(j);
                    if (!(graphicsNode instanceof ShapeNode)) continue;
                    Color color = this.arrayViewer.getSpotBufferedImageColor(n, this.alg.getArrayViewer().getCurrentSlide());
                    if (!(((ShapeNode)graphicsNode).getShapePainter() instanceof CompositeShapePainter)) continue;
                    CompositeShapePainter compositeShapePainter = (CompositeShapePainter)((ShapeNode)graphicsNode).getShapePainter();
                    boolean bl = true;
                    int n3 = 0;
                    while (bl) {
                        if (n3 == compositeShapePainter.getShapePainterCount()) {
                            bl = false;
                        } else if (compositeShapePainter.getShapePainter(n3) instanceof FillShapePainter) {
                            ((FillShapePainter)compositeShapePainter.getShapePainter(n3)).setPaint(color);
                            bl = false;
                        }
                        ++n3;
                    }
                }
            }
            if (!analysisMonitor.isClusterDataShown()) {
                this.dlist.refreshDisplay();
            }
        }
        this.checkMicroarrayCluster();
    }

    public void ghostMicroArray() {
        Object[] objectArray = null;
        objectArray = this.arrayViewer.isPlayerSelected() ? ((Map)this.alg.getSlideToXPtrMap().get(this.arrayViewer.getCurrentSlide())).keySet().toArray() : this.alg.getGBToXPtrMap().values().toArray();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.dlist.setVisibilityForNode(objectArray[i], 113);
            }
        }
    }

    public Hashtable getClassColorMappingTable() {
        return classColorMapping;
    }

    public void setClassColorMappingTable(Hashtable hashtable) {
        classColorMapping = hashtable;
    }

    public void setLegendSwatchesTable(Hashtable hashtable) {
        legendSwatches = hashtable;
    }

    public void resetMicroArrayLegendHashTables() {
        classColorMapping = new Hashtable(256, 0.95f);
        legendSwatches = new Hashtable(256, 0.95f);
    }

    public void addMicroarrayClustersToLegend(int[][] nArray, final int n) {
        boolean bl = true;
        numberOfClusters = nArray.length;
        for (int i = 0; i < nArray.length; ++i) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            bl = true;
            for (int j = 0; j < nArray[i].length; ++j) {
                object4 = (String)this.arrayViewer.getLocToGbMap().get(new Integer(nArray[i][j]));
                if (object4 == null || (object3 = (String)this.alg.getGBToXPtrMap().get(object4)) == null || (object2 = (Vector)this.dataManager.getXPtrToGVTMap().get(object3)) == null) continue;
                int n2 = ((Vector)object2).size();
                for (int k = 0; k < n2; ++k) {
                    object = (GraphicsNode)((Vector)object2).elementAt(k);
                    if (!(object instanceof ShapeNode)) continue;
                    Color color = ColorGenerator.getColor(256, i);
                    if (!(((ShapeNode)object).getShapePainter() instanceof CompositeShapePainter)) continue;
                    CompositeShapePainter compositeShapePainter = (CompositeShapePainter)((ShapeNode)object).getShapePainter();
                    boolean bl2 = true;
                    int n3 = 0;
                    while (bl2) {
                        if (n3 == compositeShapePainter.getShapePainterCount()) {
                            bl2 = false;
                        } else if (compositeShapePainter.getShapePainter(n3) instanceof FillShapePainter) {
                            ((FillShapePainter)compositeShapePainter.getShapePainter(n3)).setPaint(color);
                            bl2 = false;
                            String string = "Cluster " + (i + 1);
                            Color color2 = colorNoType;
                            Image image = null;
                            String string2 = string;
                            if (string != null) {
                                color2 = (Color)classColorMapping.get(string);
                                if (color2 == null) {
                                    int n4 = classColorMapping.size() + 1;
                                    try {
                                        color2 = color;
                                        classColorMapping.put(string, color2);
                                        image = this.alg.getLegend().createImage(Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
                                        Graphics graphics = image.getGraphics();
                                        graphics.setColor(color2);
                                        graphics.fillRect(0, 0, Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
                                        legendSwatches.put(string, image);
                                    }
                                    catch (Exception exception) {
                                        logger.warn(exception.getMessage());
                                    }
                                } else {
                                    image = (Image)legendSwatches.get(string);
                                }
                                if (Debug.legend && string2 != null) {
                                    String string3 = string2.replaceAll("'", "&apos;");
                                    this.alg.getLegend().addItem(image, string2, "//agave:gene[.//agave:classification/agave:description = '" + string3 + "']", (String)object3, color2);
                                }
                                bl = false;
                            }
                        }
                        ++n3;
                    }
                }
            }
            if (!bl) continue;
            String string = "Cluster " + (i + 1) + " (empty cluster)";
            object4 = new Color(Color.WHITE.getRGB());
            object3 = null;
            object = string;
            classColorMapping.put(string, object4);
            object3 = this.alg.getLegend().createImage(Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
            object2 = ((Image)object3).getGraphics();
            ((Graphics)object2).setColor((Color)object4);
            ((Graphics)object2).fillRect(0, 0, Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
            legendSwatches.put(string, object3);
            if (!Debug.legend || object == null) continue;
            String string4 = ((String)object).replaceAll("'", "&apos;");
            this.alg.getLegend().addItem((Image)object3, (String)object, "//agave:gene[.//agave:classification/agave:description = '" + string4 + "']", null, (Color)object4);
        }
        analysisMonitor.setClustersInLegend(true);
        this.alg.getLegend().sort(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LegendItem legendItem = MicroarrayFunctions.this.alg.getLegend().getLegendItem("Cluster " + (n + 1));
                if (legendItem != null) {
                    MicroarrayFunctions.this.alg;
                    legendItem.setSelectionState(112);
                }
            }
        });
    }

    public void renderSingleCluster(int[] nArray, int n) {
        Object object;
        int n2;
        analysisMonitor.setClusterDataShown(true, nArray);
        this.ghostMicroArray();
        Map map = null;
        if (this.arrayViewer.isPlayerSelected()) {
            map = (Map)this.alg.getSlideToXPtrMap().get(this.arrayViewer.getCurrentSlide());
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            Vector vector;
            object = (String)this.arrayViewer.getLocToGbMap().get(new Integer(nArray[n2]));
            if (object == null) continue;
            String string = null;
            if (map != null) {
                if (!map.containsKey(object)) continue;
                string = (String)map.get(object);
            } else {
                string = (String)this.alg.getGBToXPtrMap().get(object);
            }
            if (string == null || (vector = (Vector)this.dataManager.getXPtrToGVTMap().get(string)) == null) continue;
            int n3 = vector.size();
            for (int i = 0; i < n3; ++i) {
                GraphicsNode graphicsNode = (GraphicsNode)vector.elementAt(i);
                if (!(graphicsNode instanceof ShapeNode)) continue;
                Color color = ColorGenerator.getColor(256, n);
                if (!(((ShapeNode)graphicsNode).getShapePainter() instanceof CompositeShapePainter)) continue;
                CompositeShapePainter compositeShapePainter = (CompositeShapePainter)((ShapeNode)graphicsNode).getShapePainter();
                boolean bl = true;
                int n4 = 0;
                while (bl) {
                    if (n4 == compositeShapePainter.getShapePainterCount()) {
                        bl = false;
                    } else if (compositeShapePainter.getShapePainter(n4) instanceof FillShapePainter) {
                        ((FillShapePainter)compositeShapePainter.getShapePainter(n4)).setPaint(color);
                        if (analysisMonitor.isMicroArrayElementPaintable(string)) {
                            graphicsNode.setDataVisibility(112);
                        }
                        bl = false;
                    }
                    ++n4;
                }
            }
        }
        this.dlist.refreshDisplay();
        try {
            for (n2 = 1; n2 <= numberOfClusters; ++n2) {
                object = this.alg.getLegend().getLegendItem("Cluster " + n2);
                if (object == null) continue;
                if (n2 == n + 1) {
                    ((LegendItem)object).setSelectionState(112);
                    continue;
                }
                ((LegendItem)object).setSelectionState(113);
            }
        }
        catch (Exception exception) {
            logger.warn(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void renderAllClusters(int[][] nArray) {
        analysisMonitor.setClusterDataShown(true, nArray);
        this.ghostMicroArray();
        Map map = null;
        if (this.arrayViewer.isPlayerSelected()) {
            map = (Map)this.alg.getSlideToXPtrMap().get(this.arrayViewer.getCurrentSlide());
        }
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                Vector vector;
                String string = (String)this.arrayViewer.getLocToGbMap().get(new Integer(nArray[i][j]));
                if (string == null) continue;
                String string2 = null;
                if (map != null) {
                    if (!map.containsKey(string)) continue;
                    string2 = (String)map.get(string);
                } else {
                    string2 = (String)this.alg.getGBToXPtrMap().get(string);
                }
                if (string2 == null || (vector = (Vector)this.dataManager.getXPtrToGVTMap().get(string2)) == null) continue;
                int n = vector.size();
                for (int k = 0; k < n; ++k) {
                    GraphicsNode graphicsNode = (GraphicsNode)vector.elementAt(k);
                    if (!(graphicsNode instanceof ShapeNode)) continue;
                    Color color = ColorGenerator.getColor(256, i);
                    if (!(((ShapeNode)graphicsNode).getShapePainter() instanceof CompositeShapePainter)) continue;
                    CompositeShapePainter compositeShapePainter = (CompositeShapePainter)((ShapeNode)graphicsNode).getShapePainter();
                    boolean bl = true;
                    int n2 = 0;
                    while (bl) {
                        if (n2 == compositeShapePainter.getShapePainterCount()) {
                            bl = false;
                        } else if (compositeShapePainter.getShapePainter(n2) instanceof FillShapePainter) {
                            ((FillShapePainter)compositeShapePainter.getShapePainter(n2)).setPaint(color);
                            if (analysisMonitor.isMicroArrayElementPaintable(string2)) {
                                graphicsNode.setDataVisibility(112);
                            }
                            bl = false;
                        }
                        ++n2;
                    }
                }
            }
            LegendItem legendItem = this.alg.getLegend().getLegendItem("Cluster " + (i + 1));
            if (legendItem == null) continue;
            legendItem.setSelectionState(112);
        }
        this.dlist.refreshDisplay();
    }

    public void restoreMicroArrayInfo() {
        if (!this.alg.getArrayViewer().isDataLoaded()) {
            return;
        }
        try {
            Object[] objectArray = null;
            objectArray = this.arrayViewer.isPlayerSelected() ? ((Map)this.alg.getSlideToXPtrMap().get(this.arrayViewer.getCurrentSlide())).keySet().toArray() : this.alg.getGBToXPtrMap().values().toArray();
            boolean bl = false;
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    boolean bl2 = this.dlist.setVisibilityForNode(objectArray[i], 112);
                    if (bl || !bl2) continue;
                    bl = true;
                }
            }
            if (bl) {
                this.dlist.refreshDisplay();
            }
        }
        catch (Exception exception) {
            logger.warn(exception.getMessage());
        }
    }

    public void checkMicroarrayCluster() {
        analysisMonitor.setClustersInLegend(false);
        if (this.arrayViewer.performClusterCheck()) {
            this.arrayViewer.showClusterInfo();
        } else {
            analysisMonitor.setClusterDataShown(false, (int[])null);
            this.restoreMicroArrayInfo();
        }
    }

    public void disableSaveRatioValues() {
        this.arrayMenu.getSaveRatioItem().setEnabled(false);
    }

    public void enableSaveRatioValues() {
        this.arrayMenu.getSaveRatioItem().setEnabled(true);
    }

    public Vector createExpressionMatrix() {
        this.currNumber = 0;
        Vector<Vector> vector = new Vector<Vector>();
        TreeMap treeMap = this.arrayViewer.getRatioToGbMap();
        Iterator iterator = treeMap.keySet().iterator();
        Vector<Float> vector2 = new Vector<Float>(10, 1);
        boolean bl = false;
        while (iterator.hasNext()) {
            vector2.addElement((Float)iterator.next());
        }
        for (int i = vector2.capacity() - 1; i >= 0; --i) {
            Float f = (Float)vector2.elementAt(i);
            if (f.isNaN()) continue;
            Vector vector3 = (Vector)treeMap.get(f);
            int n = vector3.size();
            for (int j = 0; j < n; ++j) {
                String string = (String)vector3.elementAt(j);
                String string2 = (String)this.dlist.getAbstractLinearGraphics().getGBToXPtrMap().get(string);
                if (string2 == null) continue;
                while (string2.charAt(string2.length() - 1) != '/') {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                string2 = string2.substring(0, string2.length() - 1);
                DTDElementInstance dTDElementInstance = this.dlist.getDTDElementInstance(string2);
                String string3 = null;
                if (dTDElementInstance != null) {
                    string3 = dTDElementInstance.getPainter().getToolTip(dTDElementInstance);
                }
                vector.addElement(this.createDataRow(string, f, string3));
            }
        }
        return vector;
    }

    private Vector createDataRow(String string, Float f, String string2) {
        Vector<Object> vector = new Vector<Object>();
        String string3 = (String)this.dlist.getAbstractLinearGraphics().getGBToXPtrMap().get(string);
        if (string3 != null && this.dlist.getAnalysisMonitor().isMicroArrayElementPaintable(string3)) {
            ++this.currNumber;
            vector.addElement(new Integer(this.currNumber));
            vector.addElement(string);
            vector.addElement(f);
            string3 = string3.substring(0, string3.lastIndexOf(47));
            vector.addElement(string2);
        }
        return vector;
    }

    private String findXLinks(String string, String string2) {
        String string3 = null;
        try {
            List list = this.dlist.getDataManager().getHyperlinks(string);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                String string4;
                Link link = (Link)list.get(i);
                String string5 = link.getInfo().getLinkTitle();
                String string6 = link.getToNode().getURL().toString();
                String string7 = string4 = "".equals(string5) ? string6 : string5 + LINK_POINTING + string6;
                if ("embed".equals(link.getArc().getShow().toLowerCase())) continue;
                string3 = string2 != null ? "<a href= \"" + string4 + "\">" + string2 + "</a></td>" : "<a href= \"" + string4 + "\">" + "Click Here" + "</a></td>";
            }
        }
        catch (Exception exception) {
            logger.warn(exception.getMessage());
            exception.printStackTrace();
        }
        return string3;
    }

    public void setArrayViewer(MultipleArrayViewer multipleArrayViewer) {
        this.arrayViewer = multipleArrayViewer;
    }

    public ExpressionSliderWidget getExpressionWidget() {
        return this.arrayPanel;
    }

    public DistanceSliderWidget getDistanceWidget() {
        return this.distancePanel;
    }

    public ExperimentSelectorWidget getExperimentSelector() {
        return this.experimentSelectorPanel;
    }

    public AnalysisMonitor getAnalysisMonitor() {
        return analysisMonitor;
    }

    public void setArrayMenu(MicroArrayMenuManager microArrayMenuManager) {
        this.arrayMenu = microArrayMenuManager;
    }

    public MicroArrayMenuManager getArrayMenu() {
        return this.arrayMenu;
    }

    public void enableMicroArrayMenu() {
        this.arrayMenu.enableAll();
    }

    static {
        classColorMapping = new Hashtable(256, 0.95f);
        legendSwatches = new Hashtable(256, 0.95f);
        colorNoType = Color.gray;
        numberOfClusters = 0;
        logger = Logger.getLogger(MicroarrayFunctions.class);
    }
}

