/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.microarray;

import java.util.NoSuchElementException;

public class StringSplitter {
    private String str;
    private char delimiter;
    private int curPosition;
    private int maxPosition;

    public StringSplitter(char c) {
        this.init("", c);
    }

    public void init(String string) {
        this.init(string, this.delimiter);
    }

    private void init(String string, char c) {
        this.str = string;
        this.delimiter = c;
        this.curPosition = 0;
        this.maxPosition = string.length();
    }

    private int scanToken(int n) {
        char c;
        int n2;
        for (n2 = n; n2 < this.maxPosition && (c = this.str.charAt(n2)) != this.delimiter; ++n2) {
        }
        return n2;
    }

    public boolean hasMoreTokens() {
        return this.curPosition < this.maxPosition;
    }

    public String nextToken() {
        if (this.curPosition >= this.maxPosition) {
            throw new NoSuchElementException("There are no more tokens!");
        }
        int n = this.curPosition;
        this.curPosition = this.scanToken(this.curPosition);
        String string = this.str.substring(n, this.curPosition);
        ++this.curPosition;
        return string;
    }

    public int countTokens() {
        int n = 0;
        for (int i = 0; i < this.maxPosition; ++i) {
            if (this.str.charAt(i) != this.delimiter) continue;
            ++n;
        }
        return n;
    }

    public final void passTokens(int n) {
        int n2 = n;
        while (--n2 >= 0) {
            this.curPosition = this.scanToken(this.curPosition);
            ++this.curPosition;
        }
    }

    public final int nextIntToken() {
        return this.nextIntToken(0);
    }

    public final int nextIntToken(int n) {
        String string = this.nextToken();
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public final long nextLongToken() {
        return this.nextLongToken(0L);
    }

    public final long nextLongToken(boolean bl) {
        return Math.round(this.nextDoubleToken(0.0));
    }

    public final long nextLongToken(long l) {
        String string = this.nextToken();
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    public final double nextDoubleToken(double d) {
        String string = this.nextToken();
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    public final float nextFloatToken(float f) {
        String string = this.nextToken();
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            return f;
        }
    }
}

