/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.microarray.player;

import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.microarray.player.MutableList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.batik.gvt.GraphicsNode;

public class ComparisonModeGUI
extends JPanel
implements MouseListener,
ListSelectionListener {
    private static final int BUTTON_WIDTH = 60;
    private static final int BUTTON_HEIGHT = 40;
    private static Timer sliderTimer;
    private static JSlider slider;
    private static MutableList mlist;
    private static JList list;
    private static DefaultListModel listModel;
    private static AbstractLinearGraphics alg;
    private static BluejayDObjectList dlist;
    private GridBagConstraints c;
    private Hashtable xPointersToSlide;
    private int[] indeces;

    public ComparisonModeGUI() {
        mlist = new MutableList();
        this.xPointersToSlide = new Hashtable();
        this.setToolTipText("Select 3 or less datasets (CTRL-Left Click)");
        this.setPreferredSize(new Dimension(200, 150));
        this.setLayout(new GridBagLayout());
        this.c = new GridBagConstraints();
        this.c.fill = 1;
        this.c.weightx = 1.0;
        this.c.weighty = 2.0;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 7;
        mlist.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(mlist);
        this.add((Component)jScrollPane, this.c);
        JPanel jPanel = new JPanel();
        this.c.gridy = 1;
        jPanel.setPreferredSize(new Dimension(200, 20));
        jPanel.setMinimumSize(new Dimension(200, 20));
        this.add((Component)jPanel, this.c);
    }

    public JList getList() {
        return list;
    }

    public void setDList(BluejayDObjectList bluejayDObjectList) {
        dlist = bluejayDObjectList;
    }

    public void setALG(AbstractLinearGraphics abstractLinearGraphics) {
        alg = abstractLinearGraphics;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.makeList();
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.makeList();
    }

    public void disableGUI() {
        list.setEnabled(false);
    }

    public void enableGUI(int n) {
        list.setEnabled(true);
        System.out.println("weeee");
        this.resetGUI();
    }

    public void resetGUI() {
        this.makeList();
    }

    public void makeList() {
        mlist.getContents().clear();
        Vector vector = new Vector();
        for (int i = 0; i < dlist.getArrayViewer().getData().getFeaturesCount(); ++i) {
            String string = dlist.getArrayViewer().getData().getFullSampleName(i);
            mlist.getContents().addElement(string);
            System.out.println(string);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        dlist.getArrayViewer().setComparisonSelected(true);
        MutableList mutableList = (MutableList)listSelectionEvent.getSource();
        if (!mutableList.isSelectionEmpty()) {
            if (mutableList.getSelectedIndices().length > 6) {
                int[] nArray = mutableList.getSelectedIndices();
                int[] nArray2 = new int[]{nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5]};
                mutableList.setSelectedIndices(nArray2);
            }
            this.indeces = mutableList.getSelectedIndices();
            dlist.repaint(true);
        }
    }

    public void refreshScreen(int n) {
        dlist.getAbstractLinearGraphics().setDoubleBuffering(true);
        for (int i = 0; i <= dlist.getArrayViewer().getNumSlides(); ++i) {
            Map map = (Map)alg.getSlideToXPtrMap().get(new Integer(i));
            if (map == null) continue;
            for (String string : map.keySet()) {
                Vector vector = (Vector)dlist.getDataManager().getXPtrToGVTMapValue(string);
                if (vector == null) continue;
                int n2 = vector.size();
                for (int j = 0; j < n2; ++j) {
                    GraphicsNode graphicsNode = (GraphicsNode)vector.elementAt(j);
                    if (i == n) {
                        boolean bl = alg.getAnalysisMonitor().isMicroArrayElementPaintable(string, i);
                        if (!bl) {
                            graphicsNode.setDataVisibility(113);
                            continue;
                        }
                        graphicsNode.setDataVisibility(112);
                        continue;
                    }
                    graphicsNode.setDataVisibility(114);
                }
            }
        }
        dlist.refreshDisplay();
    }

    public int[] getIndecesSelected() {
        return this.indeces;
    }

    public Hashtable getXPointerToSlide() {
        return this.xPointersToSlide;
    }

    public void setXPointerToSlide(Hashtable hashtable) {
        this.xPointersToSlide = hashtable;
    }
}

