/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.painter;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.MaskPainter;
import ca.ucalgary.bluejay.gui.painter.AGAVEPainter;
import ca.ucalgary.bluejay.gui.painter.BasicSequencePainter;
import ca.ucalgary.bluejay.gui.painter.LaneManager;
import org.apache.log4j.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class AGAVESequencePainter
extends BasicSequencePainter {
    private String sequence;
    private static Logger logger = Logger.getLogger(AGAVESequencePainter.class);

    public AGAVESequencePainter(LaneManager laneManager) {
        super(laneManager);
    }

    public String getSequence(DTDElementInstance dTDElementInstance) {
        return this.sequence;
    }

    public void setSequence(String string) {
        this.sequence = string;
    }

    public void preProcess(AbstractLinearGraphics abstractLinearGraphics, MaskPainter maskPainter, DTDElementInstance dTDElementInstance) {
        this.normalizeText(dTDElementInstance);
        for (Node node = dTDElementInstance.getFirstChild(); node != null; node = node.getNextSibling()) {
            logger.debug(">>>>>>>>>>>Found a child node " + node);
            if (!(node instanceof Text) && !(node instanceof CDATASection)) continue;
            String string = node.getNodeValue();
            logger.debug(">>>>>>>>>>>>>>Found text section (assuming sequence) of length " + string.length());
            this.setSequence(string);
            break;
        }
        super.preProcess(abstractLinearGraphics, maskPainter, dTDElementInstance);
    }

    public void updateLegendItem(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        int n = abstractLinearGraphics.getLOD();
        int n2 = dTDElementInstance.getSlaveNum();
        if (abstractLinearGraphics.getLOD() == 80) {
            String[] stringArray;
            if (abstractLinearGraphics.isGCLevelShown()) {
                if (n2 != 0) {
                    stringArray = new String[]{"slave_gc_location" + Integer.toString(n2)};
                    AGAVESequencePainter.requestLanes(this.getLaneManager(), AGAVEPainter.getInstance(), n, stringArray);
                } else {
                    stringArray = new String[]{"GCLocation"};
                    AGAVESequencePainter.requestLanes(this.getLaneManager(), AGAVEPainter.getInstance(), n, stringArray);
                }
            }
            if (abstractLinearGraphics.isAGLevelShown()) {
                if (n2 != 0) {
                    stringArray = new String[]{"slave_ag_location" + Integer.toString(n2)};
                    AGAVESequencePainter.requestLanes(this.getLaneManager(), AGAVEPainter.getInstance(), n, stringArray);
                } else {
                    stringArray = new String[]{"AGLocation"};
                    AGAVESequencePainter.requestLanes(this.getLaneManager(), AGAVEPainter.getInstance(), n, stringArray);
                }
            }
            if (abstractLinearGraphics.isGCSkewShown()) {
                if (n2 != 0) {
                    stringArray = new String[]{"slave_gcskew_location" + Integer.toString(n2)};
                    AGAVESequencePainter.requestLanes(this.getLaneManager(), AGAVEPainter.getInstance(), n, stringArray);
                } else {
                    stringArray = new String[]{"GCSkewLocation"};
                    AGAVESequencePainter.requestLanes(this.getLaneManager(), AGAVEPainter.getInstance(), n, stringArray);
                }
            }
        }
        super.updateLegendItem(abstractLinearGraphics, dTDElementInstance);
    }
}

