/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.painter;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.Legend;
import ca.ucalgary.bluejay.gui.MaskPainter;
import ca.ucalgary.bluejay.gui.painter.AGAVEPainter;
import ca.ucalgary.bluejay.gui.painter.AbstractLinearPainter;
import ca.ucalgary.bluejay.gui.painter.LaneManager;
import ca.ucalgary.bluejay.gui.util.Debug;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import org.tigr.microarray.mev.MultipleArrayData;

public class BluejayMicroArrayComparisonPainter
extends AGAVEPainter {
    private static final Color colorNoType = Color.gray;
    private static final boolean ADD_LEGEND_ITEM = true;
    private static final int NUM_COLORS = 256;
    private Hashtable classColorMapping = new Hashtable(256, 0.95f);
    private Hashtable legendSwatches = new Hashtable(256, 0.95f);
    private AbstractLinearGraphics algSaved = null;
    private boolean[] laneDrawn;
    private DecimalFormat ratioFormat = new DecimalFormat("#,##0.00");
    private LaneManager laneMgr;
    private String drawnLanes = "";
    private int currentSlide;
    private Hashtable xNSlide;
    public static final int MAX_NUM_TARGETS = 255;
    public static final int DEFAULT_TARGET = 1;

    public BluejayMicroArrayComparisonPainter() {
        this.laneDrawn = new boolean[255];
        this.xNSlide = new Hashtable();
        for (int i = 0; i < 255; ++i) {
            this.laneDrawn[i] = true;
        }
    }

    public String getToolTip(DTDElementInstance dTDElementInstance) {
        String string = "";
        AbstractLinearPainter abstractLinearPainter = dTDElementInstance.getPainter();
        if (abstractLinearPainter == null) {
            return null;
        }
        String string2 = abstractLinearPainter.getPrimaryID(dTDElementInstance);
        Integer n = this.getDataRow(this.algSaved, dTDElementInstance);
        String[] stringArray = abstractLinearPainter.getIDs(dTDElementInstance);
        for (int i = 0; i < this.algSaved.getArrayViewer().getSelectedIndeces().length; ++i) {
            int n2 = this.algSaved.getArrayViewer().getSelectedIndeces()[i];
            for (int j = 0; j < stringArray.length; ++j) {
                String string3;
                if (!this.algSaved.getArrayViewer().getGbToColumnLocMap().containsKey(stringArray[j]) || !(string3 = (String)this.algSaved.getArrayViewer().getGbToColumnLocMap().get(stringArray[j])).contains(n2 + ",")) continue;
                string = string + this.algSaved.getArrayViewer().getSlideNames().get(n2) + "  Ratio :" + this.ratioFormat.format(this.algSaved.getArrayViewer().getLogRatio(n, n2)) + "<br>";
            }
        }
        if (n == null || this.algSaved == null) {
            return "No Ratio Found: " + super.getToolTip(dTDElementInstance);
        }
        return "<html>" + string + super.getToolTip(dTDElementInstance);
    }

    private Integer getDataRow(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) {
        AbstractLinearPainter abstractLinearPainter = dTDElementInstance.getPainter();
        if (abstractLinearPainter == null || abstractLinearGraphics == null || abstractLinearGraphics.getArrayViewer() == null) {
            return null;
        }
        String[] stringArray = abstractLinearPainter.getIDs(dTDElementInstance);
        TreeMap treeMap = abstractLinearGraphics.getArrayViewer().getGBToLocMap();
        if (treeMap == null) {
            return null;
        }
        Integer n = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || !treeMap.containsKey(stringArray[i])) continue;
            n = (Integer)treeMap.get(stringArray[i]);
            break;
        }
        return n;
    }

    public void paint(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance, LaneManager laneManager) throws Exception {
        int n;
        int n2;
        AbstractLinearPainter abstractLinearPainter;
        if (this.laneMgr == null) {
            this.laneMgr = laneManager;
        }
        if ((abstractLinearPainter = dTDElementInstance.getPainter()) == null) {
            return;
        }
        String string = abstractLinearPainter.getPrimaryID(dTDElementInstance);
        String[] stringArray = abstractLinearPainter.getIDs(dTDElementInstance);
        MultipleArrayData multipleArrayData = (MultipleArrayData)abstractLinearGraphics.getArrayViewer().getData();
        TreeMap treeMap = abstractLinearGraphics.getArrayViewer().getGBToLocMap();
        Integer n3 = this.getDataRow(abstractLinearGraphics, dTDElementInstance);
        if (n3 == null) {
            return;
        }
        TreeMap treeMap2 = abstractLinearGraphics.getArrayViewer().getGbToColumnLocMap();
        int n4 = dTDElementInstance.getChildNodes().getLength();
        int[] nArray = abstractLinearPainter.getFeatureRange(dTDElementInstance);
        if (nArray == null) {
            return;
        }
        nArray[0] = nArray[0];
        nArray[1] = nArray[1];
        if (nArray[1] < nArray[0]) {
            n2 = nArray[1];
            n = nArray[0];
        } else {
            n2 = nArray[0];
            n = nArray[1];
        }
        int n5 = dTDElementInstance.getVisibility();
        String string2 = dTDElementInstance.getXPointer();
        Color color = abstractLinearGraphics.getColor();
        int n6 = dTDElementInstance.getTarget();
        int n7 = abstractLinearGraphics.getArrayViewer().getExpressionSliderMax();
        int n8 = abstractLinearGraphics.getArrayViewer().getExpressionSliderMin();
        for (int i = 0; i < abstractLinearGraphics.getArrayViewer().getSelectedIndeces().length; ++i) {
            Map<String, String> map;
            int n9;
            int n10;
            int n11 = 0;
            double[] dArray = laneManager.getLane("Positive microarray lane", abstractLinearGraphics.getLOD());
            double[] dArray2 = laneManager.getLane("Negative microarray lane", abstractLinearGraphics.getLOD());
            int n12 = abstractLinearGraphics.getArrayViewer().getSelectedIndeces()[i];
            boolean bl = false;
            for (n10 = 0; n10 < stringArray.length; ++n10) {
                if (!treeMap2.containsKey(stringArray[n10])) continue;
                String string3 = (String)treeMap2.get(stringArray[n10]);
                if (!string3.contains(n12 + ",") && n10 == stringArray.length) {
                    return;
                }
                if (string3.contains(n12 + ",")) continue;
                bl = true;
            }
            if (bl) continue;
            n10 = 0;
            for (n9 = 0; n9 < stringArray.length; ++n9) {
                if (!treeMap2.containsKey(stringArray[n9])) continue;
                n10 = 1;
            }
            if (n10 == 0) {
                return;
            }
            this.currentSlide = n12;
            dTDElementInstance.setXPointer(string2 + "/" + (n4 + 1));
            if (i > 0) {
                dArray = laneManager.getLane("Positive microarray lane" + i, abstractLinearGraphics.getLOD());
                dArray2 = laneManager.getLane("Negative microarray lane" + i, abstractLinearGraphics.getLOD());
            }
            if (abstractLinearGraphics.getVisibilityManager().getDList().getComparisonPool().getPoolSize() > 0 && dTDElementInstance.getSlaveNum() != 0) {
                dArray = laneManager.getLane("slave_positive_microarray_lane" + i + dTDElementInstance.getSlaveNum(), abstractLinearGraphics.getLOD());
                dArray2 = laneManager.getLane("slave_negative_microarray_lane" + i + dTDElementInstance.getSlaveNum(), abstractLinearGraphics.getLOD());
                n11 = dTDElementInstance.getSlaveNum();
            }
            if ((n9 = abstractLinearGraphics.getArrayViewer().getSizeOfDataColumn(n12)) <= n3) {
                return;
            }
            float f = abstractLinearGraphics.getArrayViewer().getLogRatio(n3, n12);
            float f2 = 0.0f;
            f2 = Math.abs(n8) > n7 ? f / (float)Math.abs(n8) : f / (float)n7;
            if (abstractLinearGraphics.getArrayViewer().getCurrentSlide() != n12) {
                dTDElementInstance.setVisibility(112);
            } else {
                boolean bl2 = abstractLinearGraphics.getAnalysisMonitor().isMicroArrayElementPaintable(dTDElementInstance.getXPointer(), n12);
                if (!bl2) {
                    dTDElementInstance.setVisibility(113);
                } else {
                    dTDElementInstance.setVisibility(112);
                }
            }
            abstractLinearGraphics.setDTDElementInstance(dTDElementInstance);
            f2 = Math.abs(f2);
            double d = (dArray[0] - dArray[1]) * (double)f2 + dArray[1];
            double d2 = dArray2[0] - (dArray2[0] - dArray2[1]) * (double)f2;
            if (f > 0.0f) {
                abstractLinearGraphics.setColor(abstractLinearGraphics.getArrayViewer().getSpotBufferedImageColor(n3, n12));
                abstractLinearGraphics.fillRect(n6, n2, n, d, dArray[1]);
            } else if (f < 0.0f) {
                abstractLinearGraphics.setColor(abstractLinearGraphics.getArrayViewer().getSpotBufferedImageColor(n3, n12));
                abstractLinearGraphics.fillRect(n6, n2, n, dArray2[0], d2);
            }
            String string4 = dTDElementInstance.getXPointer();
            int n13 = n12;
            if (abstractLinearGraphics.getSlideToXPtrMap().containsKey(new Integer(n12))) {
                map = (Map)abstractLinearGraphics.getSlideToXPtrMap().get(new Integer(n12));
                map.put(string4, string);
                map.put(string, string4);
            } else {
                map = new HashMap<String, String>();
                map.put(string4, string);
                abstractLinearGraphics.getSlideToXPtrMap().put(new Integer(n12), map);
            }
            abstractLinearGraphics.getxPtrToGBMap().put(string4, string);
            if (!this.xNSlide.containsKey(string4) || !this.xNSlide.get(string4).equals(n12)) {
                this.xNSlide.put(string4, n12);
            }
            if (this.drawnLanes.contains(Double.toString(dArray[0]))) continue;
            abstractLinearGraphics.setColor(Color.BLACK);
            this.drawLaneLine(abstractLinearGraphics, dTDElementInstance.getTarget(), dArray[1]);
            this.drawnLanes = this.drawnLanes + "," + Double.toString(dArray[0]);
        }
        dTDElementInstance.setXPointer(string2);
        dTDElementInstance.setVisibility(n5);
        abstractLinearGraphics.setColor(color);
        abstractLinearGraphics.setDTDElementInstance(dTDElementInstance);
        this.algSaved = abstractLinearGraphics;
    }

    public void preProcess(AbstractLinearGraphics abstractLinearGraphics, MaskPainter maskPainter, DTDElementInstance dTDElementInstance) {
        AbstractLinearPainter abstractLinearPainter = dTDElementInstance.getPainter();
        if (abstractLinearPainter == null) {
            return;
        }
        String[] stringArray = abstractLinearPainter.getIDs(dTDElementInstance);
        String string = dTDElementInstance.getXPointer() + "/" + (dTDElementInstance.getChildNodes().getLength() + 1);
        String string2 = abstractLinearPainter.getPrimaryID(dTDElementInstance);
        abstractLinearGraphics.getxPtrToGBMap().put(string, string2);
        for (int i = 0; i < stringArray.length; ++i) {
            abstractLinearGraphics.getGBToXPtrMap().put(stringArray[i], string);
        }
    }

    public void updateLegendItem(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) {
    }

    public void updateLegendItem(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance, LaneManager laneManager) throws Exception {
        int n;
        String string;
        int n2;
        String[] stringArray;
        int n3;
        int n4 = dTDElementInstance.getTarget();
        AbstractLinearPainter abstractLinearPainter = dTDElementInstance.getPainter();
        if (abstractLinearPainter == null) {
            return;
        }
        String string2 = abstractLinearPainter.getPrimaryID(dTDElementInstance);
        String[] stringArray2 = abstractLinearPainter.getIDs(dTDElementInstance);
        TreeMap treeMap = abstractLinearGraphics.getArrayViewer().getGBToLocMap();
        boolean bl = false;
        for (n3 = 0; n3 < stringArray2.length; ++n3) {
            if (stringArray2[n3] != null && treeMap.containsKey(stringArray2[n3])) {
                bl = true;
            }
            if (!abstractLinearGraphics.getArrayViewer().getGbToColumnLocMap().containsKey(stringArray2[n3]) || (stringArray = (String[])abstractLinearGraphics.getArrayViewer().getGbToColumnLocMap().get(stringArray2[n3])).contains((n2 = abstractLinearGraphics.getArrayViewer().getSelectedIndeces()[0]) + ",")) continue;
            bl = false;
        }
        if (n4 < 0) {
            n4 = 1;
        }
        if (abstractLinearGraphics.getVisibilityManager().getDList().getComparisonPool().getPoolSize() > 0) {
            for (n3 = 0; n3 < abstractLinearGraphics.getArrayViewer().getSelectedIndeces().length; ++n3) {
                stringArray = new String[]{"slave_positive_microarray_lane" + n3 + dTDElementInstance.getSlaveNum(), "slave_negative_microarray_lane" + n3 + dTDElementInstance.getSlaveNum()};
                for (n2 = 0; n2 < stringArray2.length; ++n2) {
                    if (stringArray2[n2] != null && treeMap.containsKey(stringArray2[n2])) {
                        bl = true;
                    }
                    if (!abstractLinearGraphics.getArrayViewer().getGbToColumnLocMap().containsKey(stringArray2[n2]) || (string = (String)abstractLinearGraphics.getArrayViewer().getGbToColumnLocMap().get(stringArray2[n2])).contains((n = abstractLinearGraphics.getArrayViewer().getSelectedIndeces()[n3]) + ",")) continue;
                    bl = false;
                }
                if (dTDElementInstance.getSlaveNum() == 0 || !bl) continue;
                BluejayMicroArrayComparisonPainter.requestLanes(laneManager, this, abstractLinearGraphics.getLOD(), stringArray);
            }
        }
        for (n3 = 0; n3 < stringArray2.length; ++n3) {
            if (stringArray2[n3] != null && treeMap.containsKey(stringArray2[n3])) {
                bl = true;
            }
            if (!abstractLinearGraphics.getArrayViewer().getGbToColumnLocMap().containsKey(stringArray2[n3]) || (stringArray = (String)abstractLinearGraphics.getArrayViewer().getGbToColumnLocMap().get(stringArray2[n3])).contains((n2 = abstractLinearGraphics.getArrayViewer().getSelectedIndeces()[0]) + ",")) continue;
            bl = false;
        }
        if (this.laneDrawn[n4]) {
            String[] stringArray3 = new String[]{"Positive microarray lane", "Negative microarray lane"};
            if (dTDElementInstance.getSlaveNum() == 0 && bl) {
                BluejayMicroArrayComparisonPainter.requestLanes(laneManager, this, abstractLinearGraphics.getLOD(), stringArray3);
            }
            if (abstractLinearGraphics.getArrayViewer().getSelectedIndeces().length > 1) {
                for (int i = 1; i < abstractLinearGraphics.getArrayViewer().getSelectedIndeces().length; ++i) {
                    for (n2 = 0; n2 < stringArray2.length; ++n2) {
                        if (stringArray2[n2] != null && treeMap.containsKey(stringArray2[n2])) {
                            bl = true;
                        }
                        if (!abstractLinearGraphics.getArrayViewer().getGbToColumnLocMap().containsKey(stringArray2[n2]) || (string = (String)abstractLinearGraphics.getArrayViewer().getGbToColumnLocMap().get(stringArray2[n2])).contains((n = abstractLinearGraphics.getArrayViewer().getSelectedIndeces()[i]) + ",")) continue;
                        bl = false;
                    }
                    stringArray3 = new String[]{"Positive microarray lane" + i, "Negative microarray lane" + i};
                    if (dTDElementInstance.getSlaveNum() != 0 || !bl) continue;
                    BluejayMicroArrayComparisonPainter.requestLanes(laneManager, this, abstractLinearGraphics.getLOD(), stringArray3);
                }
            }
            this.laneDrawn[n4] = true;
            this.drawnLanes = "";
        }
    }

    private Color requestLegendItem(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance, Integer n, String string, boolean bl) {
        Color color = colorNoType;
        Image image = null;
        String string2 = string;
        if (string != null) {
            color = (Color)this.classColorMapping.get(string);
            if (color == null) {
                int n2 = this.classColorMapping.size() + 1;
                try {
                    color = abstractLinearGraphics.getArrayViewer().getSpotBufferedImageColor(n, abstractLinearGraphics.getArrayViewer().getCurrentSlide());
                    this.classColorMapping.put(string, color);
                    image = abstractLinearGraphics.getLegend().createImage(Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
                    Graphics graphics = image.getGraphics();
                    graphics.setColor(color);
                    graphics.fillRect(0, 0, Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
                    this.legendSwatches.put(string, image);
                }
                catch (Exception exception) {}
            } else {
                image = (Image)this.legendSwatches.get(string);
            }
        }
        if (Debug.legend && bl && string2 != null) {
            String string3 = string2.replaceAll("'", "&apos;");
            abstractLinearGraphics.getLegend().addItem(image, string2, "//agave:gene[.//agave:classification/agave:description = '" + string3 + "']", dTDElementInstance.getXPointer(), color);
        }
        return color;
    }

    public LaneManager getLaneManager() {
        return this.laneMgr;
    }
}

