/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.painter;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.Legend;
import ca.ucalgary.bluejay.gui.MaskPainter;
import ca.ucalgary.bluejay.gui.painter.AGAVEPainter;
import ca.ucalgary.bluejay.gui.painter.AbstractLinearPainter;
import ca.ucalgary.bluejay.gui.painter.LaneManager;
import ca.ucalgary.bluejay.gui.util.Debug;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.TreeMap;

public class BluejayMicroArrayElementPainter
extends AGAVEPainter {
    private static final Color colorNoType = Color.gray;
    private static final boolean ADD_LEGEND_ITEM = true;
    private static final int NUM_COLORS = 256;
    private Hashtable classColorMapping = new Hashtable(256, 0.95f);
    private Hashtable legendSwatches = new Hashtable(256, 0.95f);
    private AbstractLinearGraphics algSaved = null;
    private boolean[] laneDrawn;
    private DecimalFormat ratioFormat = new DecimalFormat("#,##0.00");
    private boolean singleLaneDrawn;
    public static final int MAX_NUM_TARGETS = 255;
    public static final int DEFAULT_TARGET = 1;

    public BluejayMicroArrayElementPainter() {
        this.laneDrawn = new boolean[255];
        for (int i = 0; i < 255; ++i) {
            this.laneDrawn[i] = true;
        }
        this.singleLaneDrawn = false;
    }

    public String getToolTip(DTDElementInstance dTDElementInstance) {
        Integer n = this.getDataRow(this.algSaved, dTDElementInstance);
        if (n == null || this.algSaved == null) {
            return "No Ratio Found: " + super.getToolTip(dTDElementInstance);
        }
        float f = this.algSaved.getArrayViewer().getLogRatio(n, this.algSaved.getArrayViewer().getCurrentSlide());
        return "Ratio " + this.ratioFormat.format(f) + ": " + super.getToolTip(dTDElementInstance);
    }

    private Integer getDataRow(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) {
        AbstractLinearPainter abstractLinearPainter = dTDElementInstance.getPainter();
        if (abstractLinearPainter == null || abstractLinearGraphics == null || abstractLinearGraphics.getArrayViewer() == null) {
            return null;
        }
        String[] stringArray = abstractLinearPainter.getIDs(dTDElementInstance);
        TreeMap treeMap = abstractLinearGraphics.getArrayViewer().getGBToLocMap();
        if (treeMap == null) {
            return null;
        }
        Integer n = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || !treeMap.containsKey(stringArray[i])) continue;
            n = (Integer)treeMap.get(stringArray[i]);
            break;
        }
        return n;
    }

    public void paint(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance, LaneManager laneManager) throws Exception {
        int n;
        int n2;
        AbstractLinearPainter abstractLinearPainter = dTDElementInstance.getPainter();
        if (abstractLinearPainter == null) {
            return;
        }
        String[] stringArray = abstractLinearPainter.getIDs(dTDElementInstance);
        Integer n3 = this.getDataRow(abstractLinearGraphics, dTDElementInstance);
        if (n3 == null) {
            return;
        }
        int n4 = dTDElementInstance.getChildNodes().getLength();
        int[] nArray = abstractLinearPainter.getFeatureRange(dTDElementInstance);
        if (nArray == null) {
            return;
        }
        if (nArray[1] < nArray[0]) {
            n2 = nArray[1];
            n = nArray[0];
        } else {
            n2 = nArray[0];
            n = nArray[1];
        }
        int n5 = dTDElementInstance.getVisibility();
        String string = dTDElementInstance.getXPointer();
        Color color = abstractLinearGraphics.getColor();
        double[] dArray = laneManager.getLane("Positive microarray lane", abstractLinearGraphics.getLOD());
        double[] dArray2 = laneManager.getLane("Negative microarray lane", abstractLinearGraphics.getLOD());
        int n6 = dTDElementInstance.getTarget();
        if (!this.singleLaneDrawn && dArray != null) {
            abstractLinearGraphics.setColor(Color.BLACK);
            this.drawLaneLine(abstractLinearGraphics, n6, dArray[1]);
            this.laneDrawn[1] = true;
            this.singleLaneDrawn = true;
        }
        dTDElementInstance.setXPointer(string + "/" + (n4 + 1));
        float f = abstractLinearGraphics.getArrayViewer().getLogRatio(n3, abstractLinearGraphics.getArrayViewer().getCurrentSlide());
        int n7 = abstractLinearGraphics.getArrayViewer().getExpressionSliderMax();
        int n8 = abstractLinearGraphics.getArrayViewer().getExpressionSliderMin();
        float f2 = 0.0f;
        f2 = Math.abs(n8) > n7 ? f / (float)Math.abs(n8) : f / (float)n7;
        boolean bl = abstractLinearGraphics.getAnalysisMonitor().isMicroArrayElementPaintable(dTDElementInstance.getXPointer());
        if (!bl) {
            dTDElementInstance.setVisibility(113);
        } else {
            dTDElementInstance.setVisibility(112);
        }
        abstractLinearGraphics.setDTDElementInstance(dTDElementInstance);
        f2 = Math.abs(f2);
        double d = (dArray[0] - dArray[1]) * (double)f2 + dArray[1];
        double d2 = dArray2[0] - (dArray2[0] - dArray2[1]) * (double)f2;
        if (f > 0.0f) {
            abstractLinearGraphics.setColor(abstractLinearGraphics.getArrayViewer().getSpotBufferedImageColor(n3, abstractLinearGraphics.getArrayViewer().getCurrentSlide()));
            abstractLinearGraphics.fillRect(n6, n2, n, d, dArray[1]);
            Color color2 = this.requestLegendItem(abstractLinearGraphics, dTDElementInstance, n3, "high expression", true);
        } else if (f < 0.0f) {
            abstractLinearGraphics.setColor(abstractLinearGraphics.getArrayViewer().getSpotBufferedImageColor(n3, abstractLinearGraphics.getArrayViewer().getCurrentSlide()));
            abstractLinearGraphics.fillRect(n6, n2, n, dArray2[0], d2);
            Color color3 = this.requestLegendItem(abstractLinearGraphics, dTDElementInstance, n3, "low expression", true);
        }
        dTDElementInstance.setXPointer(string);
        dTDElementInstance.setVisibility(n5);
        abstractLinearGraphics.setColor(color);
        abstractLinearGraphics.setDTDElementInstance(dTDElementInstance);
        if (abstractLinearGraphics != this.algSaved) {
            this.algSaved = abstractLinearGraphics;
        }
    }

    public void preProcess(AbstractLinearGraphics abstractLinearGraphics, MaskPainter maskPainter, DTDElementInstance dTDElementInstance) {
        AbstractLinearPainter abstractLinearPainter = dTDElementInstance.getPainter();
        if (abstractLinearPainter == null) {
            return;
        }
        String[] stringArray = abstractLinearPainter.getIDs(dTDElementInstance);
        String string = dTDElementInstance.getXPointer() + "/" + (dTDElementInstance.getChildNodes().getLength() + 1);
        String string2 = abstractLinearPainter.getPrimaryID(dTDElementInstance);
        abstractLinearGraphics.getxPtrToGBMap().put(string, string2);
        for (int i = 0; i < stringArray.length; ++i) {
            abstractLinearGraphics.getGBToXPtrMap().put(stringArray[i], string);
        }
    }

    public void updateLegendItem(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) {
    }

    public void updateLegendItem(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance, LaneManager laneManager) throws Exception {
        int n = 1;
        if (this.laneDrawn[n]) {
            String[] stringArray = new String[]{"Positive microarray lane", "Negative microarray lane"};
            BluejayMicroArrayElementPainter.requestLanes(laneManager, this, abstractLinearGraphics.getLOD(), stringArray);
            this.singleLaneDrawn = false;
        }
    }

    private Color requestLegendItem(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance, Integer n, String string, boolean bl) {
        Color color = colorNoType;
        Image image = null;
        String string2 = string;
        if (string != null) {
            color = (Color)this.classColorMapping.get(string);
            if (color == null) {
                int n2 = this.classColorMapping.size() + 1;
                try {
                    color = abstractLinearGraphics.getArrayViewer().getSpotBufferedImageColor(n, abstractLinearGraphics.getArrayViewer().getCurrentSlide());
                    this.classColorMapping.put(string, color);
                    image = abstractLinearGraphics.getLegend().createImage(Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
                    Graphics graphics = image.getGraphics();
                    graphics.setColor(color);
                    graphics.fillRect(0, 0, Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
                    this.legendSwatches.put(string, image);
                }
                catch (Exception exception) {}
            } else {
                image = (Image)this.legendSwatches.get(string);
            }
        }
        if (Debug.legend && bl && string2 != null) {
            String string3 = string2.replaceAll("'", "&apos;");
            abstractLinearGraphics.getLegend().addItem(image, string2, "//agave:gene[.//agave:classification/agave:description = '" + string3 + "']", dTDElementInstance.getXPointer(), color);
        }
        return color;
    }
}

