/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.painter;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.painter.AGAVEPainter;
import ca.ucalgary.bluejay.gui.painter.AbstractLinearPainter;
import ca.ucalgary.bluejay.gui.painter.LaneManager;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class BluejayMicroArrayPlayerPainter
extends AGAVEPainter {
    private int target;
    private Integer row;
    private boolean[] laneDrawn = new boolean[255];
    private static Logger logger = Logger.getLogger(BluejayMicroArrayPlayerPainter.class);

    public BluejayMicroArrayPlayerPainter() {
        for (int i = 0; i < 255; ++i) {
            this.laneDrawn[i] = true;
        }
    }

    public void paint(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance, LaneManager laneManager) throws Exception {
        int n;
        int n2;
        AbstractLinearPainter abstractLinearPainter = dTDElementInstance.getPainter();
        if (abstractLinearPainter == null) {
            return;
        }
        String string = abstractLinearPainter.getPrimaryID(dTDElementInstance);
        Integer n3 = this.getDataRow(abstractLinearGraphics, dTDElementInstance);
        if (n3 == null) {
            return;
        }
        int n4 = dTDElementInstance.getChildNodes().getLength();
        int[] nArray = abstractLinearPainter.getFeatureRange(dTDElementInstance);
        if (nArray == null) {
            return;
        }
        if (nArray[1] < nArray[0]) {
            n2 = nArray[1];
            n = nArray[0];
        } else {
            n2 = nArray[0];
            n = nArray[1];
        }
        int n5 = dTDElementInstance.getVisibility();
        String string2 = dTDElementInstance.getXPointer();
        Color color = abstractLinearGraphics.getColor();
        double[] dArray = laneManager.getLane("Positive microarray lane", abstractLinearGraphics.getLOD());
        double[] dArray2 = laneManager.getLane("Negative microarray lane", abstractLinearGraphics.getLOD());
        int n6 = dTDElementInstance.getTarget();
        if (!this.laneDrawn[1] && dArray != null) {
            abstractLinearGraphics.setColor(Color.BLACK);
            this.drawLaneLine(abstractLinearGraphics, n6, dArray[1]);
            this.laneDrawn[1] = true;
        }
        int n7 = abstractLinearGraphics.getArrayViewer().getExpressionSliderMax();
        int n8 = abstractLinearGraphics.getArrayViewer().getExpressionSliderMin();
        for (int i = 0; i <= abstractLinearGraphics.getArrayViewer().getNumSlides(); ++i) {
            Map<String, String> map;
            dTDElementInstance.setXPointer(string2 + "/" + (n4 + i + 1));
            float f = abstractLinearGraphics.getArrayViewer().getLogRatio(n3, i);
            float f2 = 0.0f;
            f2 = Math.abs(n8) > n7 ? f / (float)Math.abs(n8) : f / (float)n7;
            if (abstractLinearGraphics.getArrayViewer().getCurrentSlide() != i) {
                dTDElementInstance.setVisibility(114);
            } else {
                boolean bl = abstractLinearGraphics.getAnalysisMonitor().isMicroArrayElementPaintable(dTDElementInstance.getXPointer(), i);
                if (!bl) {
                    dTDElementInstance.setVisibility(113);
                } else {
                    dTDElementInstance.setVisibility(112);
                }
            }
            abstractLinearGraphics.setDTDElementInstance(dTDElementInstance);
            f2 = Math.abs(f2);
            double d = (dArray[0] - dArray[1]) * (double)f2 + dArray[1];
            double d2 = dArray2[0] - (dArray2[0] - dArray2[1]) * (double)f2;
            if (f > 0.0f) {
                abstractLinearGraphics.setColor(abstractLinearGraphics.getArrayViewer().getSpotBufferedImageColor(n3, i));
                abstractLinearGraphics.fillRect(n6, n2, n, d, dArray[1]);
            } else if (f < 0.0f) {
                abstractLinearGraphics.setColor(abstractLinearGraphics.getArrayViewer().getSpotBufferedImageColor(n3, i));
                abstractLinearGraphics.fillRect(n6, n2, n, dArray2[0], d2);
            }
            String string3 = dTDElementInstance.getXPointer();
            int n9 = i;
            if (abstractLinearGraphics.getSlideToXPtrMap().containsKey(new Integer(i))) {
                map = (Map)abstractLinearGraphics.getSlideToXPtrMap().get(new Integer(i));
                map.put(string3, string);
                map.put(string, string3);
            } else {
                map = new HashMap<String, String>();
                map.put(string3, string);
                abstractLinearGraphics.getSlideToXPtrMap().put(new Integer(i), map);
            }
            abstractLinearGraphics.getxPtrToGBMap().put(string3, string);
            dTDElementInstance.setXPointer(string2);
            dTDElementInstance.setVisibility(n5);
            abstractLinearGraphics.setColor(color);
            abstractLinearGraphics.setDTDElementInstance(dTDElementInstance);
        }
    }

    public void updateLegendItem(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) {
    }

    public void updateLegendItem(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance, LaneManager laneManager) throws Exception {
        int n = 1;
        if (this.laneDrawn[n]) {
            String[] stringArray = new String[]{"Positive microarray lane", "Negative microarray lane"};
            BluejayMicroArrayPlayerPainter.requestLanes(laneManager, this, abstractLinearGraphics.getLOD(), stringArray);
            this.laneDrawn[n] = false;
        }
    }

    private Integer getDataRow(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) {
        AbstractLinearPainter abstractLinearPainter = dTDElementInstance.getPainter();
        if (abstractLinearPainter == null || abstractLinearGraphics == null || abstractLinearGraphics.getArrayViewer() == null) {
            return null;
        }
        String[] stringArray = abstractLinearPainter.getIDs(dTDElementInstance);
        TreeMap treeMap = abstractLinearGraphics.getArrayViewer().getGBToLocMap();
        if (treeMap == null) {
            return null;
        }
        Integer n = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || !treeMap.containsKey(stringArray[i])) continue;
            n = (Integer)treeMap.get(stringArray[i]);
            break;
        }
        return n;
    }
}

