/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.painter;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.client.TargetAppearance;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.Legend;
import ca.ucalgary.bluejay.gui.painter.BasicPainter;
import ca.ucalgary.bluejay.gui.painter.GBSeqPainter;
import ca.ucalgary.bluejay.gui.painter.LaneManager;
import ca.ucalgary.bluejay.gui.util.Debug;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class GBSeqFeaturePainter
extends BasicPainter {
    private static final Color darkerGreen = new Color(102, 102, 0);
    private static final Color lighterGreen = new Color(204, 255, 204);
    private LaneManager laneMgr;
    private String element_label = new String();
    private double geneTop = 0.0;
    private double posOneFrameTop = 0.0;
    private double posTwoFrameTop = 0.0;
    private double posThreeFrameTop = 0.0;
    private double negOneFrameTop = 0.0;
    private double negTwoFrameTop = 0.0;
    private double negThreeFrameTop = 0.0;
    private double exonPosTop = 0.0;
    private double exonNegTop = 0.0;
    private double geneBot = 0.0;
    private double posOneFrameBot = 0.0;
    private double posTwoFrameBot = 0.0;
    private double posThreeFrameBot = 0.0;
    private double negOneFrameBot = 0.0;
    private double negTwoFrameBot = 0.0;
    private double negThreeFrameBot = 0.0;
    private double exonPosBot = 0.0;
    private double exonNegBot = 0.0;
    private static Logger logger = Logger.getLogger(GBSeqFeaturePainter.class);

    public GBSeqFeaturePainter(LaneManager laneManager) {
        this.laneMgr = laneManager;
    }

    public void paint(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        if (!dTDElementInstance.isModelVisible()) {
            return;
        }
        int n = dTDElementInstance.getTarget();
        if (n == -1) {
            System.err.println("Ooops.  parent of " + dTDElementInstance.getLocalName() + "was not a target");
            return;
        }
        String string = "";
        String string2 = new String();
        String string3 = new String();
        Vector vector = new Vector();
        for (Node node = dTDElementInstance.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string4;
            StringTokenizer stringTokenizer;
            String string5;
            Object object;
            Object object2;
            Object object3;
            boolean bl = false;
            if (((DTDElementInstance)node).getLocalName().equals("GBFeature_key")) {
                for (object3 = node.getFirstChild(); object3 != null; object3 = object3.getNextSibling()) {
                    if (!(object3 instanceof Text)) continue;
                    string = string + ((Text)object3).getData();
                }
                continue;
            }
            if (((DTDElementInstance)node).getLocalName().equals("GBFeature_quals") && string.startsWith("CDS")) {
                boolean bl2 = false;
                for (object2 = node.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
                    if (!((DTDElementInstance)object2).getLocalName().equals("GBQualifier")) continue;
                    for (object = object2.getFirstChild(); object != null; object = object.getNextSibling()) {
                        if (((DTDElementInstance)object).getLocalName().equals("GBQualifier_name")) {
                            if (!((Text)object.getFirstChild()).getData().equals("locus_tag")) continue;
                            bl2 = true;
                            continue;
                        }
                        if (!((DTDElementInstance)object).getLocalName().equals("GBQualifier_value") || !bl2) continue;
                        this.element_label = ((Text)object.getFirstChild()).getData();
                        System.out.println("label: " + this.element_label);
                        bl2 = false;
                    }
                }
                continue;
            }
            if (!(node instanceof DTDElementInstance) || !((DTDElementInstance)node).getLocalName().equals("GBFeature_location")) continue;
            object3 = ((Object)((DTDElementInstance)node)).toString();
            object = new Vector();
            int n2 = ((String)object3).indexOf("..");
            int n3 = ((String)object3).indexOf("(");
            int n4 = ((String)object3).indexOf(")");
            if (n2 <= 0) continue;
            if (((String)object3).startsWith("complement")) {
                bl = true;
                if (((String)object3).indexOf("join") >= 0) {
                    object2 = new StringTokenizer(((String)object3).substring(((String)object3).indexOf("join") + 5, ((String)object3).length() - 2), ",");
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        string5 = ((StringTokenizer)object2).nextToken(",");
                        stringTokenizer = new StringTokenizer(string5, "..");
                        while (stringTokenizer.hasMoreTokens()) {
                            string4 = stringTokenizer.nextToken("..");
                            ((Vector)object).addElement(string4);
                        }
                    }
                } else {
                    string2 = ((String)object3).substring(n3 + 1, n2);
                    string3 = ((String)object3).substring(n2 + 2, n4);
                    ((Vector)object).addElement(string2);
                    ((Vector)object).addElement(string3);
                }
                if (!string.startsWith("CDS")) continue;
                this.draw(abstractLinearGraphics, dTDElementInstance, n, (Vector)object, bl, string, this.element_label);
                continue;
            }
            if (((String)object3).startsWith("join")) {
                if (((String)object3).indexOf("complement") >= 0) {
                    object2 = new StringTokenizer(((String)object3).substring(((String)object3).indexOf("join") + 5, ((String)object3).length() - 1), ",");
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        string5 = ((StringTokenizer)object2).nextToken(",");
                        stringTokenizer = new StringTokenizer(string5, "..");
                        while (stringTokenizer.hasMoreTokens()) {
                            bl = false;
                            string4 = stringTokenizer.nextToken("..");
                            if (string4.startsWith("complement")) {
                                string2 = string4 = string4.substring(11);
                                continue;
                            }
                            if (string4.endsWith(")")) {
                                string3 = string4 = string4.substring(0, string4.length() - 1);
                                bl = true;
                                if (!string.startsWith("CDS")) continue;
                                vector = this.setFeaturePars("gene");
                                this.draw(abstractLinearGraphics, dTDElementInstance, vector, n, string2, string3, bl, this.element_label);
                                vector = this.setFeaturePars(string);
                                this.draw(abstractLinearGraphics, dTDElementInstance, vector, n, string2, string3, bl, this.element_label);
                                continue;
                            }
                            ((Vector)object).addElement(string4);
                        }
                    }
                } else {
                    object2 = new StringTokenizer(((String)object3).substring(((String)object3).indexOf("join") + 5, ((String)object3).length() - 1), ",");
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        string5 = ((StringTokenizer)object2).nextToken(",");
                        stringTokenizer = new StringTokenizer(string5, "..");
                        while (stringTokenizer.hasMoreTokens()) {
                            string4 = stringTokenizer.nextToken("..");
                            ((Vector)object).addElement(string4);
                        }
                    }
                }
                if (!string.startsWith("CDS")) continue;
                this.draw(abstractLinearGraphics, dTDElementInstance, n, (Vector)object, bl, string, this.element_label);
                continue;
            }
            string2 = ((String)object3).substring(0, n2);
            string3 = ((String)object3).substring(n2 + 2);
            if (!string.startsWith("CDS")) continue;
            vector = this.setFeaturePars(string);
            this.draw(abstractLinearGraphics, dTDElementInstance, vector, n, string2, string3, bl, this.element_label);
            vector = this.setFeaturePars("gene");
            this.draw(abstractLinearGraphics, dTDElementInstance, vector, n, string2, string3, bl, this.element_label);
        }
    }

    private Vector setFeaturePars(String string) {
        Vector<Object> vector = new Vector<Object>();
        Color color = null;
        String string2 = "";
        String string3 = "";
        if (string.startsWith("gene")) {
            color = Color.white;
            string2 = "gene";
            string3 = "//GBSeq:gene";
        } else if (string.equals("intron")) {
            color = lighterGreen;
            string2 = "intron";
            string3 = "//GBSeq:intron";
        } else if (string.startsWith("CDS")) {
            color = darkerGreen;
            string2 = "exon";
            string3 = "//GBSeq:exon";
        }
        vector.addElement(color);
        vector.addElement(string2);
        vector.addElement(string3);
        return vector;
    }

    private void draw(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance, int n, Vector vector, boolean bl, String string, String string2) throws Exception {
        boolean bl2 = bl;
        String string3 = new String();
        String string4 = new String();
        String string5 = new String();
        String string6 = new String();
        Vector vector2 = new Vector();
        int n2 = vector.size();
        Vector vector3 = new Vector();
        vector2 = (Vector)vector.clone();
        Collections.sort(vector2);
        vector3 = this.setFeaturePars("gene");
        if (Integer.parseInt(vector2.firstElement().toString()) > Integer.parseInt(vector2.lastElement().toString())) {
            this.draw(abstractLinearGraphics, dTDElementInstance, vector3, n, vector2.lastElement().toString(), vector2.firstElement().toString(), bl2, string2);
        } else {
            this.draw(abstractLinearGraphics, dTDElementInstance, vector3, n, vector2.firstElement().toString(), vector2.lastElement().toString(), bl2, string2);
        }
        if (n2 > 2 && string.startsWith("CDS")) {
            vector2.removeElement(vector2.firstElement());
            vector2.removeElement(vector2.lastElement());
            while (!vector2.isEmpty()) {
                string5 = vector2.firstElement().toString();
                vector2.removeElementAt(0);
                string6 = vector2.firstElement().toString();
                vector2.removeElementAt(0);
                vector3 = this.setFeaturePars("intron");
                this.draw(abstractLinearGraphics, dTDElementInstance, vector3, n, string5, string6, bl2, string2);
            }
        }
        while (!vector.isEmpty()) {
            string3 = vector.firstElement().toString();
            vector.removeElementAt(0);
            string4 = vector.firstElement().toString();
            vector.removeElementAt(0);
            vector3 = this.setFeaturePars(string);
            this.draw(abstractLinearGraphics, dTDElementInstance, vector3, n, string3, string4, bl2, string2);
        }
    }

    private void draw(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance, Vector vector, int n, String string, String string2, boolean bl, String string3) throws Exception {
        boolean bl2;
        Color color = abstractLinearGraphics.getColor();
        int n2 = Integer.parseInt(string);
        int n3 = Integer.parseInt(string2);
        Color color2 = (Color)vector.firstElement();
        String string4 = vector.elementAt(1).toString();
        String string5 = vector.lastElement().toString();
        boolean bl3 = bl;
        double d = abstractLinearGraphics.getFeatureFactor();
        double d2 = 0.0;
        double d3 = 0.0;
        boolean bl4 = ((TargetAppearance)abstractLinearGraphics.getTargetAppearances().elementAt(n)).isReverseComplement();
        boolean bl5 = bl2 = bl3 == bl4;
        if (bl2) {
            if (!abstractLinearGraphics.isSixFrameMode()) {
                if (string4.equals("gene")) {
                    d3 = this.geneTop;
                    d2 = this.geneBot;
                    abstractLinearGraphics.drawRect(n, n2, n3, d3, d2);
                } else {
                    d3 = this.exonPosTop;
                    d2 = this.exonPosBot;
                }
            } else if (string4.equals("gene")) {
                d3 = this.geneTop;
                d2 = this.geneBot;
                abstractLinearGraphics.drawRect(n, n2, n3, d3, d2);
            } else if (n2 % 3 == 1) {
                d3 = this.posOneFrameTop;
                d2 = this.posOneFrameBot;
            } else if (n2 % 3 == 2) {
                d3 = this.posTwoFrameTop;
                d2 = this.posTwoFrameBot;
            } else {
                d3 = this.posThreeFrameTop;
                d2 = this.posThreeFrameBot;
            }
        } else if (!abstractLinearGraphics.isSixFrameMode()) {
            if (string4.equals("gene")) {
                d3 = this.geneTop;
                d2 = this.geneBot;
                abstractLinearGraphics.drawRect(n, n2, n3, d3, d2);
            } else {
                d3 = this.exonNegTop;
                d2 = this.exonNegBot;
            }
        } else if (string4.equals("gene")) {
            d3 = this.geneTop;
            d2 = this.geneBot;
            abstractLinearGraphics.drawRect(n, n2, n3, d3, d2);
        } else if (n2 % 3 == 1) {
            d3 = this.negOneFrameTop;
            d2 = this.negOneFrameBot;
        } else if (n2 % 3 == 2) {
            d3 = this.negTwoFrameTop;
            d2 = this.negTwoFrameBot;
        } else {
            d3 = this.negThreeFrameTop;
            d2 = this.negThreeFrameBot;
        }
        if (Debug.legend && abstractLinearGraphics.getLegend().isAddingItems()) {
            Image image = abstractLinearGraphics.getLegend().createImage(Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
            Graphics graphics = image.getGraphics();
            if (string4.equals("gene")) {
                graphics.setColor(abstractLinearGraphics.getDisplayOptions().getBackgroundColor());
                graphics.fillRect(1, 1, Legend.SWATCH_WIDTH - 2, Legend.SWATCH_HEIGHT - 2);
                graphics.setColor(Color.black);
                graphics.drawRect(0, 0, Legend.SWATCH_WIDTH - 1, Legend.SWATCH_HEIGHT - 1);
            } else {
                graphics.setColor(color2);
                graphics.fillRect(0, 0, Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
            }
            abstractLinearGraphics.getLegend().addItem(image, string4, string5, dTDElementInstance.getXPointer(), color2);
        }
        if (!string4.equals("gene")) {
            abstractLinearGraphics.startHyperlink(dTDElementInstance, true);
            abstractLinearGraphics.setColor(color2);
            abstractLinearGraphics.fillRect(n, n2, n3, d3, d2);
            abstractLinearGraphics.updateHyperlink(abstractLinearGraphics.getPoint(n, n2, d3 > 0.0 ? d3 : d2));
            abstractLinearGraphics.endHyperlink();
            abstractLinearGraphics.setColor(color);
        }
        double d4 = abstractLinearGraphics.getTarget(n).getScale();
        int n4 = abstractLinearGraphics.getLOD();
        if (n4 == 80 && d4 <= 1.0) {
            double[] dArray = this.laneMgr.getLane(bl3 ? GBSeqPainter.TranscriptNegLabelLocation : GBSeqPainter.TranscriptPosLabelLocation, n4);
            if (dArray == null) {
                logger.debug("Whoa!!!!!!! No lane for transcript label!");
            } else {
                int n5;
                int n6 = n2 + (n3 - n2) / 2;
                int n7 = n5 = bl3 ? 40 : 30;
                if (abstractLinearGraphics.isLabelSpaceAvailable(n, string3, null, n6, dArray[0], dArray[1], n5)) {
                    abstractLinearGraphics.drawString(n, string3, null, n6, dArray[0], dArray[1], n5);
                }
            }
        }
    }

    public void updateLegendItem(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        Object object;
        Object object2;
        if (!dTDElementInstance.isModelVisible()) {
            return;
        }
        String string = "";
        String string2 = new String();
        String string3 = new String();
        Vector vector = new Vector();
        Color color = null;
        String string4 = "";
        String string5 = "";
        int n = abstractLinearGraphics.getLOD();
        double[] dArray = this.laneMgr.getLane(GBSeqPainter.TranscriptPosLocation, n);
        if (dArray == null) {
            this.laneMgr.addLane(GBSeqPainter.TranscriptPosLocation, n, GBSeqPainter.getLane(n, GBSeqPainter.TranscriptPosLocation));
        } else {
            this.geneTop = dArray[0];
        }
        dArray = this.laneMgr.getLane(GBSeqPainter.TranscriptNegLocation, n);
        if (dArray == null) {
            this.laneMgr.addLane(GBSeqPainter.TranscriptNegLocation, n, GBSeqPainter.getLane(n, GBSeqPainter.TranscriptNegLocation));
        } else {
            this.geneBot = dArray[1];
        }
        dArray = this.laneMgr.getLane(GBSeqPainter.ExonPosLocation, n);
        if (dArray == null) {
            this.laneMgr.addLane(GBSeqPainter.ExonPosLocation, n, GBSeqPainter.getLane(n, GBSeqPainter.ExonPosLocation));
        } else {
            this.exonPosTop = dArray[0];
            this.exonPosBot = dArray[1];
        }
        dArray = this.laneMgr.getLane(GBSeqPainter.ExonNegLocation, n);
        if (dArray == null) {
            this.laneMgr.addLane(GBSeqPainter.ExonNegLocation, n, GBSeqPainter.getLane(n, GBSeqPainter.ExonNegLocation));
        } else {
            this.exonNegTop = dArray[0];
            this.exonNegBot = dArray[1];
        }
        if (n != 60) {
            dArray = this.laneMgr.getLane(GBSeqPainter.TranscriptPosLabelLocation, n);
            if (dArray == null) {
                this.laneMgr.addLane(GBSeqPainter.TranscriptPosLabelLocation, n, GBSeqPainter.getLane(n, GBSeqPainter.TranscriptPosLabelLocation));
            }
            if ((dArray = this.laneMgr.getLane(GBSeqPainter.TranscriptNegLabelLocation, n)) == null) {
                this.laneMgr.addLane(GBSeqPainter.TranscriptNegLabelLocation, n, GBSeqPainter.getLane(n, GBSeqPainter.TranscriptNegLabelLocation));
            }
        }
        if (abstractLinearGraphics.isSixFrameMode()) {
            dArray = this.laneMgr.getLane("Positive 3rd frame lane", n);
            this.posThreeFrameTop = dArray[0];
            this.posThreeFrameBot = dArray[1];
            dArray = this.laneMgr.getLane("Negative 3rd frame lane", n);
            this.negThreeFrameTop = dArray[0];
            this.negThreeFrameBot = dArray[1];
            dArray = this.laneMgr.getLane("Positive 2nd frame lane", n);
            this.posTwoFrameTop = dArray[0];
            this.posTwoFrameBot = dArray[1];
            dArray = this.laneMgr.getLane("Positive 1st frame lane", n);
            this.posOneFrameTop = dArray[0];
            this.posOneFrameBot = dArray[1];
            dArray = this.laneMgr.getLane("Negative 2nd frame lane", n);
            this.negTwoFrameTop = dArray[0];
            this.negTwoFrameBot = dArray[1];
            dArray = this.laneMgr.getLane("Negative 1st frame lane", n);
            this.negOneFrameTop = dArray[0];
            this.negOneFrameBot = dArray[1];
        }
        for (object2 = dTDElementInstance.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
            if (((DTDElementInstance)object2).getLocalName().equals("GBFeature_key")) {
                for (object = object2.getFirstChild(); object != null; object = object.getNextSibling()) {
                    if (!(object instanceof Text)) continue;
                    string = string + ((Text)object).getData();
                }
                continue;
            }
            if (!(object2 instanceof DTDElementInstance) || !((DTDElementInstance)object2).getLocalName().equals("GBFeature_location") || !string.startsWith("CDS")) continue;
            vector = this.setFeaturePars(string);
        }
        if (!vector.isEmpty()) {
            color = (Color)vector.firstElement();
            string4 = vector.elementAt(1).toString();
            string5 = vector.lastElement().toString();
            if (Debug.legend) {
                object2 = abstractLinearGraphics.getLegend().createImage(Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
                object = ((Image)object2).getGraphics();
                ((Graphics)object).setColor(color);
                ((Graphics)object).fillRect(0, 0, Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
                abstractLinearGraphics.getLegend().addItem((Image)object2, string4, string5, dTDElementInstance.getXPointer(), color);
            }
        }
    }

    public String getLegendLabel(DTDElementInstance dTDElementInstance) {
        return dTDElementInstance.getLocalName();
    }

    public String getToolTip(DTDElementInstance dTDElementInstance) {
        return null;
    }
}

