/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.painter;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.painter.BasicPainter;
import ca.ucalgary.bluejay.gui.painter.LaneManager;
import java.awt.Color;
import java.text.NumberFormat;
import org.apache.log4j.Logger;

public class LinePlotPainter
extends BasicPainter {
    public static final int DEFAULT_MAXIMUM_FRACTION_DIGITS = 1;
    public static final Color DEFAULT_COLOR = Color.black;
    public static final Color DEFAULT_OUTSIDE_RANGE_COLOR = Color.red;
    public static final Color DEFAULT_RANGELINES_COLOR = Color.gray;
    public static final double DOUBLE_NOT_DEFINED = Double.MAX_VALUE;
    public static final int INT_NOT_DEFINED = Integer.MAX_VALUE;
    public static final int LOD_EXTREME_VALUE = -3;
    public static final int LOD_AVERAGE_VALUE = -3;
    public static final int LOD_HIGH_LOW_VALUES = -3;
    private int[] int_data;
    private double[] double_data;
    private int interval_start;
    private int interval_end;
    private int sample_interval;
    private double range_min;
    private double range_max;
    private double baseline_value;
    private double avg;
    private NumberFormat nf;
    private double y_min;
    private double y_max;
    private int lod_mode;
    private boolean draw_avg;
    private boolean draw_baseline;
    private boolean fill_graph;
    private boolean draw_range_labels;
    private boolean draw_range_lines;
    private boolean draw_avg_label;
    private boolean draw_baseline_label;
    private Color avg_line_color;
    private Color graph_line_color;
    private Color fill_graph_color;
    private Color base_line_color;
    private Color outside_range_color;
    private Color range_lines_color;
    private LaneManager laneMgr;
    private static Logger logger = Logger.getLogger(LinePlotPainter.class);

    public LinePlotPainter(LaneManager laneManager) {
        this.laneMgr = laneManager;
        this.int_data = null;
        this.double_data = null;
        this.sample_interval = Integer.MAX_VALUE;
        this.interval_end = Integer.MAX_VALUE;
        this.interval_start = Integer.MAX_VALUE;
        this.y_max = Double.MAX_VALUE;
        this.y_min = Double.MAX_VALUE;
        this.range_max = Double.MAX_VALUE;
        this.range_min = Double.MAX_VALUE;
        this.avg = Double.MAX_VALUE;
        this.baseline_value = Double.MAX_VALUE;
        this.nf = NumberFormat.getInstance();
        this.nf.setMaximumFractionDigits(1);
        this.draw_avg = false;
        this.draw_baseline = false;
        this.draw_avg_label = false;
        this.draw_baseline_label = false;
        this.draw_range_labels = true;
        this.draw_range_lines = true;
        this.graph_line_color = DEFAULT_COLOR;
        this.outside_range_color = DEFAULT_OUTSIDE_RANGE_COLOR;
        this.range_lines_color = DEFAULT_RANGELINES_COLOR;
        this.avg_line_color = null;
        this.fill_graph_color = null;
        this.base_line_color = null;
    }

    public void setData(int[] nArray, int n, int n2, double d, double d2) throws IllegalArgumentException {
        this.setDataParameters(nArray.length, n, n2, d, d2);
        this.int_data = nArray;
        this.double_data = null;
        if (this.draw_avg) {
            this.calculateAverage();
        }
    }

    public void setData(double[] dArray, int n, int n2, double d, double d2) throws IllegalArgumentException {
        this.setDataParameters(dArray.length, n, n2, d, d2);
        this.double_data = dArray;
        this.int_data = null;
        if (this.draw_avg) {
            this.calculateAverage();
        }
    }

    public boolean isDataSet() {
        return this.double_data != null || this.int_data != null;
    }

    protected void setLaneManager(LaneManager laneManager) {
        if (laneManager == this.laneMgr) {
            return;
        }
        this.laneMgr = laneManager;
    }

    protected LaneManager getLaneManager() {
        return this.laneMgr;
    }

    protected void calculateAverage() {
        double d = 0.0;
        if (this.int_data != null) {
            for (int i = 0; i < this.int_data.length; ++i) {
                d += (double)this.int_data[i];
            }
            this.avg = d / (double)this.int_data.length;
        } else if (this.double_data != null) {
            for (int i = 0; i < this.double_data.length; ++i) {
                d += this.double_data[i];
            }
            this.avg = d / (double)this.double_data.length;
        } else {
            logger.debug("Attempted to calculate average before any data was set, ignoring");
        }
    }

    protected void setDataParameters(int n, int n2, int n3, double d, double d2) throws IllegalArgumentException {
        double d3;
        if (n2 < 1) {
            throw new IllegalArgumentException("While setting data samples, sample interval parameter was less than 1: " + n2);
        }
        if (n3 < 1) {
            throw new IllegalArgumentException("While setting data samples, data interval start parameter was less than 1: " + n3);
        }
        if (d >= d2) {
            throw new IllegalArgumentException("While setting data samples, specified range minimum " + d + " was greater than or equal to specified range maximum " + d2);
        }
        this.interval_start = n3;
        this.sample_interval = n2;
        this.interval_end = this.interval_start + this.sample_interval * n;
        this.range_min = d;
        this.range_max = d2;
        double d4 = this.range_max - this.range_min;
        for (d3 = Double.MIN_VALUE; d3 < d4; d3 *= 10.0) {
        }
        if (d3 <= 100.0) {
            d3 /= 1000.0;
            int n4 = 1;
            for (double d5 = 0.1; d5 > d3; d5 /= 10.0) {
                ++n4;
            }
            this.nf.setMaximumFractionDigits(n4);
        } else {
            this.nf.setMaximumFractionDigits(0);
        }
    }

    public int getSampleInterval() {
        return this.sample_interval;
    }

    public double getRangeMin() {
        return this.range_min;
    }

    public double getRangeMax() {
        return this.range_max;
    }

    public void setRangeLinesEnabled(boolean bl) {
        this.draw_range_labels = bl;
    }

    public boolean getRangeLinesEnabled() {
        return this.draw_range_labels;
    }

    public void setRangeLinesColor(Color color) {
        this.range_lines_color = color == null ? DEFAULT_RANGELINES_COLOR : color;
    }

    public Color getRangeLinesColor() {
        return this.range_lines_color;
    }

    public void setRangeLabelsEnabled(boolean bl) {
        this.draw_range_lines = bl;
    }

    public boolean getRangeLabelsEnabled() {
        return this.draw_range_lines;
    }

    public void setAverageLabelEnabled(boolean bl) {
        this.draw_avg_label = bl;
    }

    public boolean getAverageLabelEnabled() {
        return this.draw_avg_label;
    }

    public void setBaseLineLabelEnabled(boolean bl) {
        this.draw_baseline_label = bl;
    }

    public boolean getBaseLineLabelEnabled() {
        return this.draw_baseline_label;
    }

    public void setAverageLineEnabled(boolean bl) {
        if (bl && !this.draw_avg) {
            this.calculateAverage();
        }
        this.draw_avg = bl;
    }

    public boolean getAverageLineEnabled() {
        return this.draw_avg;
    }

    public double getAverage() {
        return this.avg;
    }

    public void setFillGraphEnabled(boolean bl) {
        this.fill_graph = bl;
    }

    public boolean getFillGraphEnabled() {
        return this.fill_graph;
    }

    public void setFillGraphColor(Color color) {
        this.fill_graph_color = color == null ? this.getBaseLineColor() : color;
    }

    public Color getFillGraphColor() {
        return this.fill_graph_color;
    }

    public void setBaseLineEnabled(boolean bl) {
        this.draw_baseline = bl;
    }

    public boolean getBaseLineEnabled() {
        return this.draw_baseline;
    }

    public void setBaseLineValue(double d) {
        this.baseline_value = d;
    }

    public double getBaseLineValue() {
        return this.baseline_value;
    }

    public void setBaseLineColor(Color color) {
        this.base_line_color = color == null ? this.getAverageLineColor() : color;
    }

    public Color getBaseLineColor() {
        return this.base_line_color;
    }

    public void setAverageLineColor(Color color) {
        this.avg_line_color = color == null ? this.getGraphLineColor() : color;
    }

    public Color getAverageLineColor() {
        return this.avg_line_color;
    }

    public void setGraphLineColor(Color color) {
        this.graph_line_color = color == null ? DEFAULT_COLOR : color;
    }

    public Color getGraphLineColor() {
        return this.graph_line_color;
    }

    public void setOutsideRangeColor(Color color) {
        this.outside_range_color = color == null ? DEFAULT_OUTSIDE_RANGE_COLOR : color;
    }

    public void setLODGraphingMethod(int n) throws IllegalArgumentException {
        if (n != -3 && n != -3 && n != -3) {
            throw new IllegalArgumentException("setLODGraphingMethod received an illegal mode value (" + n + ")");
        }
        this.lod_mode = n;
    }

    public Color getOutsideRangeColor() {
        return this.outside_range_color;
    }

    public NumberFormat getNumberFormat() {
        return this.nf;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        if (this.nf == null) {
            logger.debug("Scale.setNumberFormat was passed null, ignoring");
            return;
        }
        this.nf = numberFormat;
    }

    public void setLane(double d, double d2) {
        this.y_min = d;
        this.y_max = d2;
    }

    public void updateLegendItem(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
    }

    public String getLegendLabel() {
        return null;
    }

    public void paint(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        System.err.println("ANGUO::: LinePlotPainter.paint() y_min=" + this.y_min + ", y_max=" + this.y_max);
        int n = dTDElementInstance.getTarget();
        int n2 = abstractLinearGraphics.getLOD();
        if (n == -1) {
            System.err.println("Ooops. Parent of " + dTDElementInstance.getLocalName() + " was not a target, cannot graph");
            return;
        }
        if (this.y_min == Double.MAX_VALUE || this.y_max == Double.MAX_VALUE) {
            logger.debug("The drawing lane for the dataset is not yet defined (by calling the setLane method), not painting line graph");
            return;
        }
        int n3 = this.interval_start;
        int n4 = this.interval_end;
        if (n3 < abstractLinearGraphics.getTarget(n).getMinPosition()) {
            logger.debug("Truncated line graph plot start from specified " + n3 + " to minimum target position " + abstractLinearGraphics.getTarget(n).getMinPosition());
            n3 = abstractLinearGraphics.getTarget(n).getMinPosition();
        }
        if (n4 > abstractLinearGraphics.getTarget(n).getMaxPosition()) {
            logger.debug("Truncated line graph plot end from specified " + n4 + " to maximum target position " + abstractLinearGraphics.getTarget(n).getMaxPosition());
            n4 = abstractLinearGraphics.getTarget(n).getMaxPosition();
        }
        double d = abstractLinearGraphics.getScale();
        boolean bl = false;
        if (d > (double)this.sample_interval) {
            bl = true;
        } else {
            logger.debug("LOD drawing is not yet implemented for graphs");
        }
        double d2 = Double.MAX_VALUE;
        double d3 = this.y_max - this.y_min;
        double d4 = this.range_max - this.range_min;
        double d5 = this.range_min;
        if (this.draw_avg) {
            d5 = this.avg;
            logger.debug("<<<<<<<<<<<<<<Drawing relative to average value of " + this.avg + " (unless baseline overrides)");
        }
        if (this.draw_baseline) {
            if (this.baseline_value != Double.MAX_VALUE) {
                d5 = this.baseline_value;
                logger.debug("<<<<<<<<<<<<<<<Drawing relative to baseline value of " + this.baseline_value);
            } else {
                logger.debug("Attempted to draw baseline, but no baseline value was defined");
            }
        }
        d5 = this.y_min + d3 * ((d5 - this.range_min) / d4);
        int n5 = n4 / this.sample_interval;
        if (this.double_data != null) {
            System.out.println("<<<<<<<<<<<<<Printing data for " + this);
            if (this.fill_graph) {
                abstractLinearGraphics.setColor(this.fill_graph_color);
            }
            for (int i = (n3 - this.interval_start) / this.sample_interval; i <= n5; ++i) {
                int n6;
                double d6 = this.double_data[i];
                boolean bl2 = false;
                if (d6 > this.range_max) {
                    d6 = this.range_max;
                    bl2 = true;
                }
                if (d6 < this.range_min) {
                    d6 = this.range_min;
                    bl2 = true;
                }
                int n7 = this.interval_start + i * this.sample_interval;
                double d7 = this.y_min + d3 * ((d6 - this.range_min) / d4);
                if (this.fill_graph) {
                    n6 = n7 + this.sample_interval;
                    if (n6 > n4) {
                        n6 = n4;
                    }
                    if (d7 < d5) {
                        abstractLinearGraphics.fillRect(n, n7, n6, d5, d7);
                    } else {
                        abstractLinearGraphics.fillRect(n, n7, n6, d7, d5);
                    }
                    if (!bl2) continue;
                    abstractLinearGraphics.setColor(this.outside_range_color);
                    abstractLinearGraphics.drawLine(n, n7, n6, d7, d7);
                    abstractLinearGraphics.setColor(this.fill_graph_color);
                    continue;
                }
                if (d2 != Double.MAX_VALUE) {
                    n6 = n7 + this.sample_interval / 2;
                    if (n6 > n4) {
                        n6 = n4;
                    }
                    if (bl2) {
                        abstractLinearGraphics.setColor(this.outside_range_color);
                        abstractLinearGraphics.drawLine(n, n7 - this.sample_interval / 2, n6, d7, d2);
                        abstractLinearGraphics.setColor(this.graph_line_color);
                    } else {
                        abstractLinearGraphics.drawLine(n, n7 - this.sample_interval / 2, n6, d7, d2);
                    }
                }
                d2 = d7;
            }
        } else if (this.int_data == null) {
            logger.debug("No dataset was available use in line graph");
            return;
        }
        if (this.draw_baseline && this.baseline_value != Double.MAX_VALUE) {
            double d8 = this.y_min + d3 * ((this.baseline_value - this.range_min) / d4);
            System.err.println("### LinePlotPainter.paint()  alg.drawLine(" + n + ", " + n3 + ", " + n4 + ", " + d8 + ", " + d8 + ")" + ", baseline_value=" + this.baseline_value + ", base_line_color=" + this.base_line_color);
            abstractLinearGraphics.setColor(this.base_line_color);
            abstractLinearGraphics.drawLine(n, n3, n4, d8, d8);
        }
        if (this.draw_avg) {
            double d9 = this.y_min + d3 * ((this.avg - this.range_min) / d4);
            System.err.println("### LinePlotPainter.paint()  alg.drawLine(" + n + ", " + n3 + ", " + n4 + ", " + d9 + ", " + d9 + ")" + ", avg=" + this.avg + ", avg_line_color=" + this.avg_line_color);
            abstractLinearGraphics.setColor(this.avg_line_color);
            abstractLinearGraphics.drawLine(n, n3, n4, d9, d9);
        }
        if (this.draw_avg_label) {
            // empty if block
        }
        if (this.draw_range_labels) {
            // empty if block
        }
        if (this.draw_range_lines) {
            abstractLinearGraphics.setColor(this.range_lines_color);
            abstractLinearGraphics.drawLine(n, n3, n4, this.y_max, this.y_max);
            abstractLinearGraphics.drawLine(n, n3, n4, this.y_min, this.y_min);
        }
    }
}

