/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.painter;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.Legend;
import ca.ucalgary.bluejay.gui.painter.LaneManager;
import ca.ucalgary.bluejay.gui.painter.TIGRPainter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import org.apache.log4j.Logger;

public class TIGRExonPainter
extends TIGRPainter {
    private LaneManager laneMgr;
    private boolean isPosLinePresent = false;
    private boolean isNegLinePresent = false;
    private static Logger logger = Logger.getLogger(TIGRExonPainter.class);

    public TIGRExonPainter(LaneManager laneManager) {
        this.laneMgr = laneManager;
    }

    public void paint(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        int n = abstractLinearGraphics.getLOD();
        if (!dTDElementInstance.isModelVisible() || n != 80) {
            return;
        }
        int[] nArray = this.getFeatureRange(dTDElementInstance);
        if (nArray == null) {
            System.err.println("No coords for exon available yet");
            return;
        }
        int n2 = nArray[0];
        int n3 = nArray[1];
        Color color = abstractLinearGraphics.getColor();
        double[] dArray = this.laneMgr.getLane(n2 > n3 ? TIGRPainter.ExonNegLocation : TIGRPainter.ExonPosLocation, n);
        if (dArray == null) {
            logger.debug("Whoa!!!!!!! No lane for exon!");
        }
        int n4 = dTDElementInstance.getTarget();
        double d = abstractLinearGraphics.getTarget(n4).getScale();
        if (!abstractLinearGraphics.isSixFrameMode()) {
            abstractLinearGraphics.setColor(Color.gray);
            if (!this.isPosLinePresent || !this.isNegLinePresent) {
                if (n2 > n3) {
                    this.drawLaneLine(abstractLinearGraphics, n4, dArray[0]);
                    this.isNegLinePresent = true;
                } else {
                    this.drawLaneLine(abstractLinearGraphics, n4, dArray[1]);
                    this.isPosLinePresent = true;
                }
            }
            abstractLinearGraphics.setColor(Color.black);
            if (n2 > n3) {
                abstractLinearGraphics.fillRect(n4, n3, n2, dArray[0], dArray[1]);
            } else {
                abstractLinearGraphics.fillRect(n4, n2, n3, dArray[0], dArray[1]);
            }
        } else {
            abstractLinearGraphics.setColor(Color.black);
            if (n2 < n3) {
                if (n2 % 3 == 1) {
                    System.out.println("start % 3 == 1");
                    double[] dArray2 = this.laneMgr.getLane("Positive 1st frame lane", n);
                    abstractLinearGraphics.fillRect(n4, n2, n3, dArray2[0] + dArray[0] - dArray[1], dArray2[0]);
                } else if (n2 % 3 == 2) {
                    System.out.println("start % 3 == 2");
                    double[] dArray3 = this.laneMgr.getLane("Positive 2nd frame lane", n);
                    abstractLinearGraphics.fillRect(n4, n2, n3, dArray3[0] + dArray[0] - dArray[1], dArray3[0]);
                } else {
                    System.out.println("start % 3 == 0");
                    double[] dArray4 = this.laneMgr.getLane("Positive 3rd frame lane", n);
                    abstractLinearGraphics.fillRect(n4, n2, n3, dArray4[0] + dArray[0] - dArray[1], dArray4[0]);
                }
            } else if (n2 % 3 == 1) {
                System.out.println("start % 3 == 1");
                double[] dArray5 = this.laneMgr.getLane("Negative 1st frame lane", n);
                abstractLinearGraphics.fillRect(n4, n3, n2, dArray5[1], dArray5[1] - dArray[0] + dArray[1]);
            } else if (n2 % 3 == 2) {
                System.out.println("start % 3 == 2");
                double[] dArray6 = this.laneMgr.getLane("Negative 2nd frame lane", n);
                abstractLinearGraphics.fillRect(n4, n3, n2, dArray6[1], dArray6[1] - dArray[0] + dArray[1]);
            } else {
                System.out.println("start % 3 == 0");
                double[] dArray7 = this.laneMgr.getLane("Negative 3rd frame lane", n);
                abstractLinearGraphics.fillRect(n4, n3, n2, dArray7[1], dArray7[1] - dArray[0] + dArray[1]);
            }
        }
        abstractLinearGraphics.setColor(color);
    }

    public void updateLegendItem(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        Object object;
        this.isPosLinePresent = false;
        this.isNegLinePresent = false;
        int n = abstractLinearGraphics.getLOD();
        if (n == 80) {
            object = this.laneMgr.getLane(TIGRPainter.ExonPosLocation, n);
            if (object == null) {
                this.laneMgr.addLane(TIGRPainter.ExonPosLocation, n, TIGRPainter.getLane(n, TIGRPainter.ExonPosLocation));
            }
            if ((object = (Object)this.laneMgr.getLane(TIGRPainter.ExonNegLocation, n)) == null) {
                this.laneMgr.addLane(TIGRPainter.ExonNegLocation, n, TIGRPainter.getLane(n, TIGRPainter.ExonNegLocation));
            }
        }
        object = "EXON";
        String string = "//tigr:EXON";
        Color color = Color.black;
        Image image = abstractLinearGraphics.getLegend().createImage(Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
        Graphics graphics = image.getGraphics();
        graphics.setColor(Color.black);
        graphics.fillRect(1, 1, Legend.SWATCH_WIDTH - 2, Legend.SWATCH_HEIGHT - 2);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, Legend.SWATCH_WIDTH - 1, Legend.SWATCH_HEIGHT - 1);
        abstractLinearGraphics.getLegend().addItem(image, (String)object, string, dTDElementInstance.getXPointer(), color);
    }

    public String getLegendLabel(DTDElementInstance dTDElementInstance) {
        return "Exon";
    }
}

