/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.painter;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.gui.painter.LaneGetter;
import ca.ucalgary.bluejay.gui.painter.TIGRExonPainter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class TIGRPainter
extends LaneGetter {
    public static String TranscriptPosLocation = "TIGR + Strand Transcript";
    public static String TranscriptNegLocation = "TIGR - Strand Transcript";
    public static String TranscriptPosLabelLocation = "TIGR + Strand Transcript Label";
    public static String TranscriptNegLabelLocation = "TIGR - Strand Transcript Label";
    public static String TranscriptPosSpacer = "TIGR + Strand Transcript Spacer";
    public static String TranscriptNegSpacer = "TIGR - Strand Transcript Spacer";
    public static String CDSPosLocation = "TIGR + Strand CDS";
    public static String CDSNegLocation = "TIGR - Strand CDS";
    public static String ExonPosLocation = "TIGR + Strand Exon";
    public static String ExonNegLocation = "TIGR - Strand Exon";
    public static String ProteinLocation = "TIGR Protein";
    public static String RNALocation = "TIGR RNA";
    public static String ScaffoldLocation = "TIGR Scaffold";
    public static String ModelPosLocation = "TIGR + Strand Model";
    public static String ModelNegLocation = "TIGR - Strand Model";
    public static String ModelPosLocation_2 = "TIGR + Strand Model 2";
    public static String ModelNegLocation_2 = "TIGR - Strand Model 2";
    public static String ModelPosLocation_3 = "TIGR + Strand Model 3";
    public static String ModelNegLocation_3 = "TIGR - Strand Model 3";
    public static String ModelPosLocation_4 = "TIGR + Strand Model 4";
    public static String ModelNegLocation_4 = "TIGR - Strand Model 4";
    public static String ModelPosLocation_5 = "TIGR + Strand Model 5";
    public static String ModelNegLocation_5 = "TIGR - Strand Model 5";
    private static final TIGRPainter instance = new TIGRExonPainter(null);

    public static int getTargetLane(int n) {
        return 10;
    }

    public int[] getFeatureRange(DTDElementInstance dTDElementInstance) {
        Object object;
        Element element = this.getElementByTagName(dTDElementInstance, "COORDSET");
        if (element == null) {
            for (object = dTDElementInstance.getFirstChild(); object != null; object = object.getNextSibling()) {
                object.normalize();
                if (!(object instanceof Element)) continue;
                element = this.getElementByTagName((Element)object, "COORDSET");
                break;
            }
        }
        if (element == null) {
            System.err.println("Warning: TIGR element did not contain COORDSET element");
            return null;
        }
        object = element.getElementsByTagName("END5");
        if (object == null || object.getLength() == 0) {
            System.err.println("Warning: TIGR COORDSET element did not contain a END5 element");
            return null;
        }
        Element element2 = (Element)object.item(0);
        element2.normalize();
        int[] nArray = new int[2];
        Node node = element2.getFirstChild();
        if (node == null) {
            return null;
        }
        nArray[0] = Integer.parseInt(node.getNodeValue());
        object = element.getElementsByTagName("END3");
        if (object == null || object.getLength() == 0) {
            return null;
        }
        element2 = (Element)object.item(0);
        element2.normalize();
        node = element2.getFirstChild();
        if (node == null) {
            System.err.println("Warning: END3 element did not contain a number");
            return null;
        }
        nArray[1] = Integer.parseInt(node.getNodeValue());
        return nArray;
    }

    public static int[] getLane(int n, String string) {
        System.err.println("Trying to get lane for " + string + " at LOD " + n);
        if (string == null) {
            return null;
        }
        int[] nArray = (int[])laneMap.get(string);
        if (n != 80 && (string.equals(CDSPosLocation) || string.equals(CDSNegLocation) || string.equals(ExonPosLocation) || string.equals(ExonNegLocation))) {
            return null;
        }
        if (n == 60 && (string.equals(ProteinLocation) || string.equals(ModelPosLocation) || string.equals(ModelNegLocation))) {
            return null;
        }
        if (nArray == null) {
            nArray = LaneGetter.getLane(n, string);
        }
        return nArray;
    }

    public static TIGRPainter getInstance() {
        return instance;
    }

    public int[] getLaneNonStatic(int n, String string) {
        return TIGRPainter.getLane(n, string);
    }

    static {
        laneMap.put("Backbone lane", new int[]{1, 5});
        laneMap.put("Waypoint line lane", new int[]{100, 30});
        laneMap.put(TranscriptPosLabelLocation, new int[]{57, 100});
        laneMap.put(TranscriptNegLabelLocation, new int[]{-57, 100});
        laneMap.put(TranscriptPosSpacer, new int[]{56, 15});
        laneMap.put(TranscriptNegSpacer, new int[]{-56, 15});
        laneMap.put(TranscriptPosLocation, new int[]{55, 15});
        laneMap.put(TranscriptNegLocation, new int[]{-55, 15});
        laneMap.put(CDSPosLocation, new int[]{37, 10});
        laneMap.put(CDSNegLocation, new int[]{-37, 10});
        laneMap.put(ExonPosLocation, new int[]{30, 10});
        laneMap.put(ExonNegLocation, new int[]{-30, 10});
        laneMap.put(ProteinLocation, new int[]{49, 10});
        laneMap.put(RNALocation, new int[]{53, 10});
        laneMap.put(ScaffoldLocation, new int[]{54, 10});
        laneMap.put(ModelPosLocation, new int[]{47, 10});
        laneMap.put(ModelNegLocation, new int[]{-47, 10});
        laneMap.put(ModelPosLocation_2, new int[]{48, 10});
        laneMap.put(ModelNegLocation_2, new int[]{-48, 10});
        laneMap.put(ModelPosLocation_3, new int[]{49, 10});
        laneMap.put(ModelNegLocation_3, new int[]{-49, 10});
        laneMap.put(ModelPosLocation_4, new int[]{50, 10});
        laneMap.put(ModelNegLocation_4, new int[]{-50, 10});
        laneMap.put(ModelPosLocation_5, new int[]{51, 10});
        laneMap.put(ModelNegLocation_5, new int[]{-51, 10});
    }
}

