/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.painter;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.Legend;
import ca.ucalgary.bluejay.gui.painter.ClassifiedPainter;
import ca.ucalgary.bluejay.gui.painter.LaneManager;
import ca.ucalgary.bluejay.gui.painter.TIGRExonPainter;
import ca.ucalgary.bluejay.gui.painter.TIGRPainter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TIGRTranscriptPainter
extends ClassifiedPainter {
    private LaneManager laneMgr;
    private static final int NUM_COLORS = 512;
    private static final Color colorNoType = Color.gray;
    private static final String DEFAULT_LEGEND_LABEL = "No assigned type";
    private TIGRPainter tigrPainterInstance = new TIGRExonPainter(null);
    private double top = 0.0;
    private double bottom = 0.0;
    private double backboneTop = 0.0;
    private double backboneBottom = 0.0;
    private static Logger logger = Logger.getLogger(TIGRTranscriptPainter.class);

    public TIGRTranscriptPainter(LaneManager laneManager) {
        super(512, colorNoType, DEFAULT_LEGEND_LABEL);
        this.laneMgr = laneManager;
    }

    public int getPriority() {
        return 60;
    }

    public int[] getFeatureRange(DTDElementInstance dTDElementInstance) {
        return this.tigrPainterInstance.getFeatureRange(dTDElementInstance);
    }

    public void drawGlyph(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        int n;
        int n2 = abstractLinearGraphics.getLOD();
        int[] nArray = this.tigrPainterInstance.getFeatureRange(dTDElementInstance);
        int n3 = nArray[0];
        double[] dArray = this.laneMgr.getLane(n3 > (n = nArray[1]) ? TIGRPainter.TranscriptNegLocation : TIGRPainter.TranscriptPosLocation, n2);
        if (dArray == null) {
            logger.debug("Whoa!!!!!!! No lane for transcript!");
        }
        int n4 = dTDElementInstance.getTarget();
        double d = abstractLinearGraphics.getTarget(n4).getScale();
        if (n3 > n) {
            abstractLinearGraphics.drawRect(n4, n, n3, this.backboneBottom, this.bottom);
        } else {
            abstractLinearGraphics.drawRect(n4, n3, n, this.top, this.backboneTop);
        }
        if (n2 != 60) {
            String string = null;
            try {
                string = ((Element)dTDElementInstance.getElementsByTagName("GENE_INFO").item(0)).getElementsByTagName("COM_NAME").item(0).getFirstChild().getNodeValue();
            }
            catch (NullPointerException nullPointerException) {
                logger.warn(nullPointerException.getMessage());
            }
            if (string == null || string.length() == 0) {
                return;
            }
            double[] dArray2 = this.laneMgr.getLane(n3 > n ? TIGRPainter.TranscriptNegLabelLocation : TIGRPainter.TranscriptPosLabelLocation, n2);
            if (dArray2 == null) {
                logger.debug("Whoa!!!!!!! No lane for transcript label!");
            } else {
                int n5;
                int n6 = n3 + (n - n3) / 2;
                if (n < n3) {
                    n6 = n + (n3 - n) / 2;
                }
                int n7 = n5 = n3 > n ? 40 : 30;
                if (abstractLinearGraphics.isLabelSpaceAvailable(n4, string, null, n6, dArray2[0], dArray2[1], n5)) {
                    abstractLinearGraphics.drawString(n4, string, null, n6, dArray2[0], dArray2[1], n5);
                }
            }
        }
    }

    public String getDataClass(DTDElementInstance dTDElementInstance) throws Exception {
        NodeList nodeList = dTDElementInstance.getElementsByTagName("GENE_INFO");
        if (nodeList.getLength() == 0) {
            return null;
        }
        NodeList nodeList2 = ((Element)nodeList.item(0)).getElementsByTagName("GENE_ONTOLOGY");
        if (nodeList2.getLength() == 0) {
            return null;
        }
        NodeList nodeList3 = ((Element)nodeList2.item(0)).getElementsByTagName("GO_ID");
        if (nodeList3.getLength() == 0) {
            return null;
        }
        NodeList nodeList4 = ((Element)nodeList3.item(0)).getElementsByTagName("GO_TERM");
        if (nodeList4.getLength() == 0) {
            return null;
        }
        NodeList nodeList5 = ((Element)nodeList3.item(0)).getElementsByTagName("GO_TYPE");
        String string = "";
        String string2 = "";
        if (nodeList3.getLength() > 1) {
            for (int i = 0; i < nodeList3.getLength(); ++i) {
                ((Element)nodeList3.item(i)).getElementsByTagName("GO_TERM").item(0).normalize();
                string = ((Element)nodeList3.item(i)).getElementsByTagName("GO_TERM").item(0).getFirstChild().getNodeValue();
                string2 = ((Element)nodeList3.item(i)).getElementsByTagName("GO_TYPE").item(0).getFirstChild().getNodeValue();
                if (!string2.equals("function")) {
                    continue;
                }
                break;
            }
        } else {
            ((Element)nodeList4.item(0)).normalize();
            string = nodeList4.item(0).getFirstChild().getNodeValue();
            string2 = nodeList5.item(0).getFirstChild().getNodeValue();
        }
        if (!string2.equals("function")) {
            string = "molecular_function unknown";
        }
        return string.replaceAll("'", "&apos;");
    }

    public String getClassXPath(DTDElementInstance dTDElementInstance) throws Exception {
        return "//tigr:TU[tigr:GENE_INFO/tigr:GENE_ONTOLOGY/tigr:GO_TERM/text() = '" + this.getDataClass(dTDElementInstance) + "']";
    }

    public String getNullXPath(DTDElementInstance dTDElementInstance) throws Exception {
        return "//tigr:TU[not(tigr:GENE_INFO/tigr:GENE_ONTOLOGY)]";
    }

    public void updateLegendItem(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        int n = abstractLinearGraphics.getLOD();
        double[] dArray = this.laneMgr.getLane(TIGRPainter.TranscriptPosLocation, n);
        if (dArray == null) {
            this.laneMgr.addLane(TIGRPainter.TranscriptPosLocation, n, TIGRPainter.getLane(n, TIGRPainter.TranscriptPosLocation));
        } else {
            this.top = dArray[0];
        }
        dArray = this.laneMgr.getLane(TIGRPainter.TranscriptNegLocation, n);
        if (dArray == null) {
            this.laneMgr.addLane(TIGRPainter.TranscriptNegLocation, n, TIGRPainter.getLane(n, TIGRPainter.TranscriptNegLocation));
        } else {
            this.bottom = dArray[1];
        }
        dArray = this.laneMgr.getLane(TIGRPainter.TranscriptPosSpacer, n);
        if (dArray == null) {
            this.laneMgr.addLane(TIGRPainter.TranscriptPosSpacer, n, TIGRPainter.getLane(n, TIGRPainter.TranscriptPosSpacer));
        }
        if ((dArray = this.laneMgr.getLane(TIGRPainter.TranscriptNegSpacer, n)) == null) {
            this.laneMgr.addLane(TIGRPainter.TranscriptNegSpacer, n, TIGRPainter.getLane(n, TIGRPainter.TranscriptNegSpacer));
        }
        if ((dArray = this.laneMgr.getLane("Backbone lane", n)) == null) {
            this.laneMgr.addLane("Backbone lane", n, TIGRPainter.getLane(n, "Backbone lane"));
        } else {
            this.backboneTop = dArray[0];
            this.backboneBottom = dArray[1];
        }
        if (n != 60) {
            dArray = this.laneMgr.getLane(TIGRPainter.TranscriptPosLabelLocation, n);
            if (dArray == null) {
                this.laneMgr.addLane(TIGRPainter.TranscriptPosLabelLocation, n, TIGRPainter.getLane(n, TIGRPainter.TranscriptPosLabelLocation));
            }
            if ((dArray = this.laneMgr.getLane(TIGRPainter.TranscriptNegLabelLocation, n)) == null) {
                this.laneMgr.addLane(TIGRPainter.TranscriptNegLabelLocation, n, TIGRPainter.getLane(n, TIGRPainter.TranscriptNegLabelLocation));
            }
        }
        super.updateLegendItem(abstractLinearGraphics, dTDElementInstance);
        String string = "gene";
        Image image = abstractLinearGraphics.getLegend().createImage(Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
        Graphics graphics = image.getGraphics();
        Color color = Color.black;
        graphics.setColor(abstractLinearGraphics.getDisplayOptions().getBackgroundColor());
        graphics.fillRect(1, 1, Legend.SWATCH_WIDTH - 2, Legend.SWATCH_HEIGHT - 2);
        graphics.setColor(color);
        graphics.drawRect(0, 0, Legend.SWATCH_WIDTH - 1, Legend.SWATCH_HEIGHT - 1);
        if (abstractLinearGraphics.getLegend().isAddingItems()) {
            String string2 = string.replaceAll("'", "&apos;");
            abstractLinearGraphics.getLegend().addItem(image, string, this.getClassXPath(dTDElementInstance), dTDElementInstance.getXPointer(), color);
        }
    }

    public String getLegendLabel(DTDElementInstance dTDElementInstance) {
        try {
            String string = this.getDataClass(dTDElementInstance);
            if (string == null) {
                string = DEFAULT_LEGEND_LABEL;
            }
            return "GO: " + string;
        }
        catch (Exception exception) {
            logger.warn("GO: unparseable" + exception.getMessage());
            return "GO: unparseable";
        }
    }

    public String getToolTip(DTDElementInstance dTDElementInstance) {
        String string = "GENE";
        if (dTDElementInstance != null) {
            String string2 = null;
            Element element = (Element)((Element)dTDElementInstance.getElementsByTagName("GENE_INFO").item(0)).getElementsByTagName("PUB_COMMENT").item(0);
            if (element != null) {
                element.normalize();
                string2 = element.getFirstChild().getNodeValue();
            }
            if (string2 != null && string2.length() != 0) {
                string = string + ": " + string2;
            }
        }
        return string;
    }
}

