/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.util;

import java.applet.AppletContext;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.apache.log4j.Logger;

public class AppletLinkListener
implements HyperlinkListener {
    private JEditorPane pane;
    private AppletContext appletContext;
    private static Logger logger = Logger.getLogger(AppletLinkListener.class);

    public AppletLinkListener(JEditorPane jEditorPane, AppletContext appletContext) {
        this.pane = jEditorPane;
        this.appletContext = appletContext;
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        HyperlinkEvent.EventType eventType = hyperlinkEvent.getEventType();
        if (eventType == HyperlinkEvent.EventType.ENTERED) {
            logger.debug("Encountered HyperlinkEvent.EventType.ENTERED");
        } else if (eventType == HyperlinkEvent.EventType.EXITED) {
            logger.debug("Encountered HyperlinkEvent.EventType.EXITED");
        } else if (eventType == HyperlinkEvent.EventType.ACTIVATED) {
            logger.debug("Encountered HyperlinkEvent.EventType.ACTIVATED");
            if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                logger.debug("doing a frame event~~~~~~~~~~~~~~~~~~~~~~");
                HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                HTMLDocument hTMLDocument = (HTMLDocument)this.pane.getDocument();
                hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
            } else {
                logger.debug("doing a regular hyperlink event........................");
                this.appletContext.showDocument(hyperlinkEvent.getURL(), "_blank");
            }
        }
    }
}

